/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.entity;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class DamageFailToClient {
    private int attackerID;
    private int targetID;
    private boolean isValid;

    public DamageFailToClient(int attackerID, int targetID) {
        this.attackerID = attackerID;
        this.targetID = targetID;
        this.isValid = true;
    }

    private DamageFailToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.attackerID);
            b.writeInt(this.targetID);
        }
    }

    public static DamageFailToClient read(FriendlyByteBuf b) {
        DamageFailToClient msg = new DamageFailToClient();
        msg.attackerID = b.readInt();
        msg.targetID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(DamageFailToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("Level could not be found.");
                return;
            }
            ctx.enqueueWork(() -> {
                Player player = (Player)((Level)world.get()).m_6815_(msg.attackerID);
                if (player == null || !player.m_6084_()) {
                    Nightfall.LOGGER.warn("Player is null or dead.");
                    return;
                }
                IActionTracker capA = ActionTracker.get((Entity)player);
                if (capA.getHitEntities().contains(msg.targetID)) {
                    capA.getHitEntities().remove((Object)msg.targetID);
                }
                if (((Level)world.get()).m_6815_(msg.targetID) instanceof LivingEntity) {
                    capA.setLivingEntitiesHit(capA.getLivingEntitiesHit() - 1);
                }
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("DamageFailToClient received on server.");
        }
    }
}

