/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.entity;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.util.AnimationUtil;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class DodgeToClient {
    private int entityID;
    private int dir;
    private boolean isValid;

    public DodgeToClient(int direction, int entityID) {
        this.dir = direction;
        this.entityID = entityID;
        this.isValid = true;
    }

    private DodgeToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.dir);
            b.writeInt(this.entityID);
        }
    }

    public static DodgeToClient read(FriendlyByteBuf b) {
        DodgeToClient msg = new DodgeToClient();
        msg.dir = b.readInt();
        msg.entityID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(DodgeToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("ClientLevel could not be found.");
                return;
            }
            ctx.enqueueWork(() -> DodgeToClient.doClientWork(msg, (Level)world.get()));
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("DodgeToClient received on server.");
        }
    }

    private static void doClientWork(DodgeToClient msg, Level world) {
        Entity entity = world.m_6815_(msg.entityID);
        if (!(entity instanceof Player)) {
            Nightfall.LOGGER.warn("Entity is invalid.");
            return;
        }
        Player player = (Player)entity;
        if (!player.m_6084_()) {
            Nightfall.LOGGER.warn("LocalPlayer is null or dead.");
            return;
        }
        IPlayerData capP = PlayerData.get(player);
        capP.setLastDodgeTick(player.f_19797_);
        capP.setDodgeDirection(msg.dir);
        AnimationUtil.createDodgeParticles(player);
    }
}

