/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.entity;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.entity.DodgeToClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class DodgeToServer {
    private int dir;
    private boolean isValid;

    public DodgeToServer(int direction) {
        this.dir = direction;
        this.isValid = true;
    }

    public DodgeToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.dir);
        }
    }

    public static DodgeToServer read(FriendlyByteBuf b) {
        DodgeToServer msg = new DodgeToServer();
        msg.dir = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(DodgeToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn("DodgeToServer received on client.");
        } else if (sideReceived.isServer()) {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                if (player.m_6084_()) {
                    ctx.enqueueWork(() -> DodgeToServer.doServerWork(msg, player));
                }
            } else {
                Nightfall.LOGGER.warn("ServerPlayer is null or dead.");
            }
        }
    }

    private static void doServerWork(DodgeToServer msg, ServerPlayer player) {
        IPlayerData capP = PlayerData.get((Player)player);
        if (capP.getStamina() <= 0.0 || player.m_6117_() || player.f_19797_ - capP.getLastDodgeTick() < 4 || player.m_20069_() || player.m_20077_() || player.m_20089_() == Pose.SWIMMING) {
            Nightfall.LOGGER.warn("Player {} dodged incorrectly.", (Object)player.m_7755_().m_6111_());
        }
        if (player.f_19797_ - capP.getLastDodgeTick() < 10) {
            capP.addStamina(-50.0);
        } else {
            capP.addStamina(-25.0);
        }
        capP.setLastDodgeTick(player.f_19797_);
        capP.setDodgeDirection(msg.dir);
        NetworkHandler.toAllTracking((Entity)player, new DodgeToClient(msg.dir, player.m_142049_()));
    }
}

