/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.entity;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.entity.IHungerEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class EatItemToClient {
    private int entityID;
    private ItemStack item;
    private boolean isValid;

    public EatItemToClient(ItemStack item, int entityID) {
        this.item = item;
        this.entityID = entityID;
        this.isValid = true;
    }

    private EatItemToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130055_(this.item);
            b.writeInt(this.entityID);
        }
    }

    public static EatItemToClient read(FriendlyByteBuf b) {
        EatItemToClient msg = new EatItemToClient();
        msg.item = b.m_130267_();
        msg.entityID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(EatItemToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("ClientLevel could not be found.");
                return;
            }
            ctx.enqueueWork(() -> EatItemToClient.doClientWork(msg, (Level)world.get()));
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn(EatItemToClient.class.getSimpleName() + " received on server.");
        }
    }

    private static void doClientWork(EatItemToClient msg, Level world) {
        Entity entity = world.m_6815_(msg.entityID);
        if (!(entity instanceof IHungerEntity)) {
            Nightfall.LOGGER.warn("Invalid entity in " + EatItemToClient.class.getSimpleName());
            return;
        }
        IHungerEntity hungerEntity = (IHungerEntity)entity;
        hungerEntity.doEatClient(msg.item);
    }
}

