/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.entity;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class HitParticlesToClient {
    private int entityID;
    private float damage;
    private float x;
    private float y;
    private float z;
    private float xDir;
    private float zDir;
    private boolean isValid;

    public HitParticlesToClient(int entityID, float damage, float x, float y, float z, float xDir, float zDir) {
        this.damage = damage;
        this.entityID = entityID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xDir = xDir;
        this.zDir = zDir;
        this.isValid = true;
    }

    private HitParticlesToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.entityID);
            b.writeFloat(this.damage);
            b.writeFloat(this.x);
            b.writeFloat(this.y);
            b.writeFloat(this.z);
            b.writeFloat(this.xDir);
            b.writeFloat(this.zDir);
        }
    }

    public static HitParticlesToClient read(FriendlyByteBuf b) {
        HitParticlesToClient msg = new HitParticlesToClient();
        msg.entityID = b.readInt();
        msg.damage = b.readFloat();
        msg.x = b.readFloat();
        msg.y = b.readFloat();
        msg.z = b.readFloat();
        msg.xDir = b.readFloat();
        msg.zDir = b.readFloat();
        msg.isValid = true;
        return msg;
    }

    public static void handle(HitParticlesToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("ClientLevel could not be found.");
                return;
            }
            ctx.enqueueWork(() -> HitParticlesToClient.doClientWork(msg, (Level)world.get()));
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("HitParticlesToClient received on server.");
        }
    }

    private static void doClientWork(HitParticlesToClient msg, Level world) {
        ParticleOptions particle;
        Entity entity = world.m_6815_(msg.entityID);
        if (!(entity instanceof LivingEntity)) {
            Nightfall.LOGGER.warn("Entity is invalid.");
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (!entity2.m_6084_()) {
            Nightfall.LOGGER.warn("Entity is null or dead.");
            return;
        }
        Vec3 motion = entity2.m_20184_();
        double x = entity2.m_20185_() + motion.f_82479_ + (double)msg.x;
        double y = entity2.m_20186_() + motion.f_82480_ + (double)msg.y;
        double z = entity2.m_20189_() + motion.f_82481_ + (double)msg.z;
        boolean noFluid = world.m_8055_(new BlockPos(x, y, z)).m_60819_().m_76178_();
        if (entity2 instanceof ActionableEntity) {
            ActionableEntity actEntity = (ActionableEntity)entity2;
            particle = actEntity.getHurtParticle();
        } else {
            particle = (ParticleOptions)ParticleTypesNF.BLOOD_RED.get();
        }
        if (particle != null) {
            int i = 0;
            while ((double)i < Math.min(Math.ceil(msg.damage / 5.0f), 20.0)) {
                double yVelocity = noFluid ? world.f_46441_.nextDouble() + 0.2 : 0.0;
                world.m_7106_(particle, x, y, z, ((double)msg.xDir + ((double)world.f_46441_.nextFloat() - 0.5) * 0.4) * 50.0 * world.f_46441_.nextDouble(), yVelocity * 20.0, ((double)msg.zDir + ((double)world.f_46441_.nextFloat() - 0.5) * 0.4) * 50.0 * world.f_46441_.nextDouble());
                ++i;
            }
        }
    }
}

