/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.entity;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.action.Attack;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.HitData;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.entity.IOrientedHitBoxes;
import frostnox.nightfall.entity.entity.ArmorStandDummyEntity;
import frostnox.nightfall.item.IActionableItem;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.network.message.capability.ActionTrackerToClient;
import frostnox.nightfall.network.message.entity.DamageFailToClient;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.vanilla.GameEventsNF;
import frostnox.nightfall.util.data.Vec3f;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class HitTargetToServer {
    private boolean isValid;
    private int entityID;
    private int boxIndex;
    private float x;
    private float y;
    private float z;
    private Vec3f force;

    public HitTargetToServer(HitData hitData) {
        this(hitData.hitEntity.m_142049_(), hitData.x, hitData.y, hitData.z, hitData.force, hitData.boxIndex);
    }

    public HitTargetToServer(int entityID, float x, float y, float z, Vec3f force, int boxIndex) {
        this.entityID = entityID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.force = force;
        this.boxIndex = boxIndex;
        this.isValid = true;
    }

    private HitTargetToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.entityID);
            b.writeFloat(this.x);
            b.writeFloat(this.y);
            b.writeFloat(this.z);
            b.writeFloat(this.force.x());
            b.writeFloat(this.force.y());
            b.writeFloat(this.force.z());
            b.m_130130_(this.boxIndex);
        }
    }

    public static HitTargetToServer read(FriendlyByteBuf b) {
        HitTargetToServer msg = new HitTargetToServer();
        msg.entityID = b.readInt();
        msg.x = b.readFloat();
        msg.y = b.readFloat();
        msg.z = b.readFloat();
        msg.force = new Vec3f(b.readFloat(), b.readFloat(), b.readFloat());
        msg.boxIndex = b.m_130242_();
        msg.isValid = true;
        return msg;
    }

    public static void handle(HitTargetToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn("DamageToServer received on client.");
        } else if (sideReceived.isServer()) {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                ctx.enqueueWork(() -> HitTargetToServer.doWork(msg, player));
            } else {
                Nightfall.LOGGER.warn("ServerPlayer is null.");
            }
        }
    }

    private static void doWork(HitTargetToServer msg, ServerPlayer player) {
        if (!player.m_6084_()) {
            return;
        }
        IActionTracker capA = ActionTracker.get((Entity)player);
        if (capA.isDamaging()) {
            IPlayerData capP = PlayerData.get((Player)player);
            InteractionHand hand = capP.getActiveHand();
            ItemStack stack = player.m_21120_(capP.getActiveHand());
            if (stack.m_41619_()) {
                Nightfall.LOGGER.warn("Player {} tried to attack but has no item in hand.", (Object)player.m_7755_().getString());
                NetworkHandler.toClient(player, new DamageFailToClient(player.m_142049_(), msg.entityID));
                return;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof IActionableItem)) {
                Nightfall.LOGGER.warn("Player {} tried to attack but is not carrying an actionable item.", (Object)player.m_7755_().getString());
                NetworkHandler.toClient(player, new DamageFailToClient(player.m_142049_(), msg.entityID));
                return;
            }
            IActionableItem item2 = (IActionableItem)item;
            if (!item2.hasAction(capA.getActionID(), (Player)player)) {
                Nightfall.LOGGER.warn("Player {} tried to attack with {} but it is not allowed by {}.", (Object)player.m_7755_().getString(), (Object)capA.getActionID(), (Object)item2.toString());
                NetworkHandler.toClient(player, new DamageFailToClient(player.m_142049_(), msg.entityID));
                return;
            }
            Attack attack = (Attack)capA.getAction();
            int amountHit = 0;
            if (capA.getLivingEntitiesHit() >= attack.getMaxTargets()) {
                return;
            }
            Entity target = player.f_19853_.m_6815_(msg.entityID);
            if (target != null) {
                if (target instanceof ItemEntity || target instanceof ExperienceOrb || target instanceof AbstractArrow || target == player) {
                    player.f_8906_.m_9942_((Component)new TranslatableComponent("multiplayer.disconnect.invalid_entity_attacked"));
                    Nightfall.LOGGER.warn("Player {} tried to attack an invalid entity", (Object)player.m_7755_().getString());
                    return;
                }
                if (!capA.getHitEntities().contains(target.m_142049_())) {
                    AABB box;
                    if (target instanceof IOrientedHitBoxes) {
                        IOrientedHitBoxes hitBoxesEntity = (IOrientedHitBoxes)target;
                        v0 = hitBoxesEntity.getEnclosingAABB();
                    } else {
                        v0 = box = target.m_142469_();
                    }
                    if (box.m_82386_(-target.m_20185_(), -target.m_20186_(), -target.m_20189_()).m_82400_(0.01).m_82393_((double)msg.x, (double)msg.y, (double)msg.z)) {
                        double z;
                        double y;
                        Vec3 t = target.m_142469_().m_82399_();
                        Vec3 p = player.m_20299_(1.0f);
                        double x = Math.max(Math.abs(p.f_82479_ - t.f_82479_) - target.m_142469_().m_82362_() / 2.0, 0.0);
                        double dist = x * x + (y = Math.max(Math.abs(p.f_82480_ - t.f_82480_) - target.m_142469_().m_82376_() / 2.0, 0.0)) * y + (z = Math.max(Math.abs(p.f_82481_ - t.f_82481_) - target.m_142469_().m_82385_() / 2.0, 0.0)) * z;
                        if (dist < 25.0) {
                            if (target instanceof LivingEntity) {
                                LivingEntity livingEntity = (LivingEntity)target;
                                if (livingEntity.m_21224_()) {
                                    return;
                                }
                                livingEntity.m_6703_((LivingEntity)player);
                                capA.setLivingEntitiesHit(capA.getLivingEntitiesHit() + 1);
                            }
                            if (capA.getHitEntities().isEmpty()) {
                                capA.setHitPause(0.0f);
                                NetworkHandler.toAllTracking((Entity)player, new GenericEntityToClient(NetworkHandler.Type.HIT_PAUSE_CLIENT, player.m_142049_()));
                            }
                            ++amountHit;
                            capA.getHitEntities().add(msg.entityID);
                            DamageTypeSource source = DamageTypeSource.createAttackSource((LivingEntity)player, attack, new HitData(target, msg.x, msg.y, msg.z, msg.force.normalize(), msg.boxIndex));
                            if (capP.getTicksSinceHit() > 1) {
                                source.setImpactSoundType(attack.getImpactSoundType((LivingEntity)player), target);
                                capP.setTicksSinceHit(0);
                            }
                            target.m_6469_((DamageSource)source, attack.getDamage((LivingEntity)player) * capA.getChargeAttackMultiplier());
                            if (!player.m_7500_()) {
                                player.m_21120_(hand).m_41622_(amountHit, (LivingEntity)player, p_219998_1_ -> p_219998_1_.m_21190_(hand));
                            }
                        }
                    }
                }
            }
        } else {
            if (!capA.isInactive()) {
                NetworkHandler.toClient(player, new DamageFailToClient(player.m_142049_(), msg.entityID));
            } else {
                Entity target = player.f_19853_.m_6815_(msg.entityID);
                if (target != null) {
                    if (target instanceof ItemEntity || target instanceof ExperienceOrb || target instanceof AbstractArrow || target == player) {
                        player.f_8906_.m_9942_((Component)new TranslatableComponent("multiplayer.disconnect.invalid_entity_attacked"));
                        Nightfall.LOGGER.warn("Player {} tried to attack an invalid entity", (Object)player.m_7755_().getString());
                        return;
                    }
                    if (target.m_6097_()) {
                        AABB box;
                        if (target instanceof IOrientedHitBoxes) {
                            IOrientedHitBoxes hitBoxesEntity = (IOrientedHitBoxes)target;
                            v1 = hitBoxesEntity.getEnclosingAABB();
                        } else {
                            v1 = box = target.m_142469_();
                        }
                        if (box.m_82386_(-target.m_20185_(), -target.m_20186_(), -target.m_20189_()).m_82400_(0.01).m_82393_((double)msg.x, (double)msg.y, (double)msg.z)) {
                            double z;
                            double y;
                            Vec3 t = target.m_142469_().m_82399_();
                            Vec3 p = player.m_20299_(1.0f);
                            double x = Math.max(Math.abs(p.f_82479_ - t.f_82479_) - target.m_142469_().m_82362_() / 2.0, 0.0);
                            double dist = x * x + (y = Math.max(Math.abs(p.f_82480_ - t.f_82480_) - target.m_142469_().m_82376_() / 2.0, 0.0)) * y + (z = Math.max(Math.abs(p.f_82481_ - t.f_82481_) - target.m_142469_().m_82385_() / 2.0, 0.0)) * z;
                            if (dist < 25.0) {
                                boolean notLiving;
                                if (target instanceof LivingEntity) {
                                    LivingEntity livingEntity = (LivingEntity)target;
                                    if (livingEntity.m_21224_()) {
                                        return;
                                    }
                                    livingEntity.m_6703_((LivingEntity)player);
                                }
                                player.m_20256_(player.m_20184_().m_82542_(0.6, 1.0, 0.6));
                                player.m_6858_(false);
                                boolean bl = notLiving = !(target instanceof LivingEntity) || target instanceof ArmorStandDummyEntity || target instanceof ArmorStand;
                                if (!target.m_7313_((Entity)player) && (notLiving || PlayerData.get((Player)player).getPunchTicks() <= 0)) {
                                    player.m_146850_(GameEventsNF.PLAYER_PUNCH);
                                    PlayerData.get((Player)player).setPunchTicks(8);
                                    DamageSource source = notLiving ? DamageTypeSource.m_19344_((Player)player) : DamageTypeSource.createPlayerSource((Player)player, DamageType.STRIKING, new HitData(target, msg.x, msg.y, msg.z, msg.force.normalize(), msg.boxIndex)).setSound(() -> SoundEvents.f_12318_);
                                    target.m_6469_(source, (float)player.m_21133_(Attributes.f_22281_) * AttributesNF.getStrengthMultiplier((LivingEntity)player));
                                    if (!player.m_7500_()) {
                                        player.m_21205_().m_41622_(1, (LivingEntity)player, p_219998_1_ -> p_219998_1_.m_21190_(InteractionHand.MAIN_HAND));
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (!capA.getAction().isStateDamaging(capA.getState() + 1)) {
                NetworkHandler.toClient(player, new ActionTrackerToClient(capA.writeNBT(), player.m_142049_()));
            }
        }
    }
}

