/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.entity;

import frostnox.nightfall.Nightfall;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class HurtDirToClient {
    private float hurtDir;
    private int entityID;
    private boolean isValid;

    public HurtDirToClient(float hurtDir, int entityID) {
        this.hurtDir = hurtDir;
        this.entityID = entityID;
        this.isValid = true;
    }

    private HurtDirToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeFloat(this.hurtDir);
            b.writeInt(this.entityID);
        }
    }

    public static HurtDirToClient read(FriendlyByteBuf b) {
        HurtDirToClient msg = new HurtDirToClient();
        msg.hurtDir = b.readFloat();
        msg.entityID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(HurtDirToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("Level could not be found.");
                return;
            }
            ctx.enqueueWork(() -> {
                LivingEntity entity = (LivingEntity)((Level)world.get()).m_6815_(msg.entityID);
                if (entity == null || !entity.m_6084_()) {
                    Nightfall.LOGGER.warn("Player is null or dead.");
                    return;
                }
                entity.f_20918_ = msg.hurtDir;
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("HurtDirToClient received on server.");
        }
    }
}

