/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.entity;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.entity.entity.MovingBlockEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MovingBlockToClient {
    private int slideTime;
    private int entityID;
    private Direction slideDir;
    private boolean resetVelocity;
    private boolean isValid;

    public MovingBlockToClient(int slideTime, Direction slideDir, boolean resetVelocity, int entityID) {
        this.slideTime = slideTime;
        this.slideDir = slideDir;
        this.resetVelocity = resetVelocity;
        this.entityID = entityID;
        this.isValid = true;
    }

    private MovingBlockToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.slideTime);
            b.m_130068_((Enum)this.slideDir);
            b.writeBoolean(this.resetVelocity);
            b.writeInt(this.entityID);
        }
    }

    public static MovingBlockToClient read(FriendlyByteBuf b) {
        MovingBlockToClient msg = new MovingBlockToClient();
        msg.slideTime = b.readInt();
        msg.slideDir = (Direction)b.m_130066_(Direction.class);
        msg.resetVelocity = b.readBoolean();
        msg.entityID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(MovingBlockToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("ClientLevel could not be found.");
                return;
            }
            ctx.enqueueWork(() -> MovingBlockToClient.doClientWork(msg, (Level)world.get()));
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("MovingBlockToClient received on server.");
        }
    }

    private static void doClientWork(MovingBlockToClient msg, Level world) {
        Entity entity = world.m_6815_(msg.entityID);
        if (!(entity instanceof MovingBlockEntity)) {
            Nightfall.LOGGER.warn("MovingBlockEntity is invalid.");
            return;
        }
        MovingBlockEntity entity2 = (MovingBlockEntity)entity;
        entity2.slideDir = msg.slideDir;
        entity2.setSlideTime(msg.slideTime);
        if (msg.resetVelocity) {
            entity2.m_20334_(0.0, 0.0, 0.0);
            entity2.m_6034_((double)entity2.m_146903_() + 0.5, entity2.m_146904_(), (double)entity2.m_146907_() + 0.5);
        }
    }
}

