/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.entity;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.entity.entity.ActionableEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SetAllyToClient {
    private int allyID;
    private int entityID;
    private boolean isValid;

    public SetAllyToClient(int allyID, int entityID) {
        this.allyID = allyID;
        this.entityID = entityID;
        this.isValid = true;
    }

    private SetAllyToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.allyID);
            b.writeInt(this.entityID);
        }
    }

    public static SetAllyToClient read(FriendlyByteBuf b) {
        SetAllyToClient msg = new SetAllyToClient();
        msg.allyID = b.readInt();
        msg.entityID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(SetAllyToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("ClientLevel could not be found.");
                return;
            }
            ctx.enqueueWork(() -> SetAllyToClient.doClientWork(msg, (Level)world.get()));
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("SetAllyToClient received on server.");
        }
    }

    private static void doClientWork(SetAllyToClient msg, Level world) {
        Entity entity = world.m_6815_(msg.entityID);
        if (!(entity instanceof ActionableEntity)) {
            Nightfall.LOGGER.warn("Entity is invalid.");
            return;
        }
        ActionableEntity entity2 = (ActionableEntity)entity;
        if (!entity2.m_6084_()) {
            Nightfall.LOGGER.warn("Entity is null or dead.");
            return;
        }
        Entity entity3 = world.m_6815_(msg.allyID);
        if (!(entity3 instanceof ActionableEntity)) {
            Entity ally = world.m_6815_(msg.allyID);
            if (ally != null && !ally.m_146910_()) {
                Nightfall.LOGGER.warn("Ally " + world.m_6815_(msg.allyID) + " is invalid.");
            }
            return;
        }
        ActionableEntity ally = (ActionableEntity)entity3;
        entity2.setAlly(ally);
    }
}

