/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.entity;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.entity.entity.projectile.ThrownWeaponEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ThrownWeaponToClient {
    private int entityID;
    private ItemStack item;
    private ResourceLocation actionID;
    private boolean isValid;

    public ThrownWeaponToClient(ItemStack item, ResourceLocation actionID, int entityID) {
        this.item = item;
        this.actionID = actionID;
        this.entityID = entityID;
        this.isValid = true;
    }

    private ThrownWeaponToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130055_(this.item);
            b.m_130085_(this.actionID);
            b.writeInt(this.entityID);
        }
    }

    public static ThrownWeaponToClient read(FriendlyByteBuf b) {
        ThrownWeaponToClient msg = new ThrownWeaponToClient();
        msg.item = b.m_130267_();
        msg.actionID = b.m_130281_();
        msg.entityID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(ThrownWeaponToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("ClientLevel could not be found.");
                return;
            }
            ctx.enqueueWork(() -> ThrownWeaponToClient.doClientWork(msg, (Level)world.get()));
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("ThrownWeaponToClient received on server.");
        }
    }

    private static void doClientWork(ThrownWeaponToClient msg, Level world) {
        Entity entity = world.m_6815_(msg.entityID);
        if (!(entity instanceof ThrownWeaponEntity)) {
            Nightfall.LOGGER.warn("Entity is invalid, expected ThrownWeaponEntity.");
            return;
        }
        ThrownWeaponEntity thrownWeapon = (ThrownWeaponEntity)entity;
        thrownWeapon.setItem(msg.item);
        thrownWeapon.setAction(msg.actionID, (LivingEntity)thrownWeapon.m_37282_());
    }
}

