/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.block.IMicroGrid;
import frostnox.nightfall.block.block.anvil.TieredAnvilBlockEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class AnvilSlagToClient {
    private boolean isValid;
    private BlockPos blockEntityPos;
    private CompoundTag gridData;

    public AnvilSlagToClient(BlockPos blockEntityPos, CompoundTag gridData) {
        this.blockEntityPos = blockEntityPos;
        this.gridData = gridData;
        this.isValid = true;
    }

    private AnvilSlagToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130064_(this.blockEntityPos);
            b.m_130079_(this.gridData);
        }
    }

    public static AnvilSlagToClient read(FriendlyByteBuf b) {
        AnvilSlagToClient msg = new AnvilSlagToClient();
        msg.blockEntityPos = b.m_130135_();
        msg.gridData = b.m_130260_();
        msg.isValid = true;
        return msg;
    }

    public static void handle(AnvilSlagToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            ctx.enqueueWork(() -> {
                BlockEntity patt2226$temp;
                if (!world.isPresent()) {
                    Nightfall.LOGGER.warn("ClientLevel does not exist.");
                    return;
                }
                if (!((Level)world.get()).m_46749_(msg.blockEntityPos) || !((patt2226$temp = ((Level)world.get()).m_7702_(msg.blockEntityPos)) instanceof TieredAnvilBlockEntity)) {
                    return;
                }
                TieredAnvilBlockEntity anvil = (TieredAnvilBlockEntity)patt2226$temp;
                for (int x = 0; x < anvil.getGridXSize(); ++x) {
                    for (int y = 0; y < anvil.getGridYSize(); ++y) {
                        for (int z = 0; z < anvil.getGridZSize(); ++z) {
                            String id = IMicroGrid.idFromPos(x, y, z);
                            if (!msg.gridData.m_128431_().contains(id)) continue;
                            anvil.slag[x][y][z] = msg.gridData.m_128471_(id);
                        }
                    }
                }
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("AnvilSlagToClient received on server.");
        }
    }
}

