/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ChunkClimateToClient {
    private static final int SIZE = 16;
    private static final int SIZE_SQR = 256;
    private int chunkX;
    private int chunkZ;
    private final float[] temperature = new float[16];
    private final float[] humidity = new float[16];
    private boolean isValid;

    public ChunkClimateToClient(LevelChunk chunk, float[] temperature, float[] humidity) {
        this.chunkX = chunk.m_7697_().f_45578_;
        this.chunkZ = chunk.m_7697_().f_45579_;
        boolean bl = this.isValid = temperature.length == 256 && humidity.length == 256;
        if (this.isValid) {
            int newI = 0;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (x % 5 != 0 || z % 5 != 0) continue;
                    int i = x * 16 + z;
                    this.temperature[newI] = temperature[i];
                    this.humidity[newI] = humidity[i];
                    ++newI;
                }
            }
        } else {
            Nightfall.LOGGER.error("Invalid parameter array size in " + this.getClass().getSimpleName());
        }
    }

    private ChunkClimateToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.chunkX);
            b.writeInt(this.chunkZ);
            for (int i = 0; i < 16; ++i) {
                b.writeFloat(this.temperature[i]);
                b.writeFloat(this.humidity[i]);
            }
        }
    }

    public static ChunkClimateToClient read(FriendlyByteBuf b) {
        ChunkClimateToClient msg = new ChunkClimateToClient();
        msg.chunkX = b.readInt();
        msg.chunkZ = b.readInt();
        for (int i = 0; i < 16; ++i) {
            msg.temperature[i] = b.readFloat();
            msg.humidity[i] = b.readFloat();
        }
        msg.isValid = msg.temperature.length == 16 && msg.humidity.length == 16;
        return msg;
    }

    public static void handle(ChunkClimateToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            ctx.enqueueWork(() -> {
                if (!world.isPresent()) {
                    Nightfall.LOGGER.warn("ClientLevel could not be found.");
                    return;
                }
                IChunkData capC = ChunkData.get(((Level)world.get()).m_6325_(msg.chunkX, msg.chunkZ));
                int i = 0;
                for (int x = 0; x < 16; x += 5) {
                    for (int z = 0; z < 16; z += 5) {
                        capC.setTemperature(x, z, msg.temperature[i]);
                        capC.setHumidity(x, z, msg.humidity[i]);
                        ++i;
                    }
                }
                capC.setOld();
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("ChunkClimateToClient received on server.");
        }
    }
}

