/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.network.NetworkHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ChunkClimateToServer {
    private int chunkX;
    private int chunkZ;
    private boolean isValid;

    public ChunkClimateToServer(LevelChunk chunk) {
        this.chunkX = chunk.m_7697_().f_45578_;
        this.chunkZ = chunk.m_7697_().f_45579_;
        this.isValid = true;
    }

    private ChunkClimateToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.chunkX);
            b.writeInt(this.chunkZ);
        }
    }

    public static ChunkClimateToServer read(FriendlyByteBuf b) {
        ChunkClimateToServer msg = new ChunkClimateToServer();
        msg.chunkX = b.readInt();
        msg.chunkZ = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(ChunkClimateToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn("ChunkClimateToServer received on client.");
        } else if (sideReceived.isServer() && ctx.getSender() != null) {
            ServerLevel level = (ServerLevel)ctx.getSender().f_19853_;
            if (!LevelData.isPresent((Level)level) || !level.m_7232_(msg.chunkX, msg.chunkZ)) {
                return;
            }
            LevelChunk chunk = level.m_6325_(msg.chunkX, msg.chunkZ);
            if (!level.m_7726_().f_8325_.m_183262_(chunk.m_7697_(), false).contains(ctx.getSender())) {
                return;
            }
            IChunkData capC = ChunkData.get(chunk);
            NetworkHandler.toClient(ctx.getSender(), capC.createClimateMessageToClient());
        }
    }
}

