/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.GlobalChunkData;
import frostnox.nightfall.capability.IGlobalChunkData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.util.DataUtil;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ChunkDigProgressToClient {
    private int chunkX;
    private int chunkZ;
    private int[] packedPositions;
    private float[] progress;
    private boolean isValid;

    public ChunkDigProgressToClient(int chunkX, int chunkZ, int[] packedPositions, float[] progress) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.packedPositions = packedPositions;
        this.progress = progress;
        this.isValid = packedPositions.length == progress.length && progress.length <= 2000;
    }

    private ChunkDigProgressToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130130_(this.chunkX);
            b.m_130130_(this.chunkZ);
            b.m_130089_(this.packedPositions);
            b.m_130130_(this.progress.length);
            for (float f : this.progress) {
                b.writeFloat(f);
            }
        }
    }

    public static ChunkDigProgressToClient read(FriendlyByteBuf b) {
        ChunkDigProgressToClient msg = new ChunkDigProgressToClient();
        msg.chunkX = b.m_130242_();
        msg.chunkZ = b.m_130242_();
        msg.packedPositions = b.m_130100_();
        msg.progress = new float[b.m_130242_()];
        for (int i = 0; i < msg.progress.length; ++i) {
            msg.progress[i] = b.readFloat();
        }
        msg.isValid = true;
        return msg;
    }

    public static void handle(ChunkDigProgressToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            ctx.enqueueWork(() -> {
                if (!world.isPresent()) {
                    Nightfall.LOGGER.warn("ClientLevel could not be found.");
                    return;
                }
                Level level = (Level)world.get();
                if (!level.m_7232_(msg.chunkX, msg.chunkZ)) {
                    Nightfall.LOGGER.warn("Cannot update dig progress at unloaded chunk [" + msg.chunkX + ", " + msg.chunkZ + "].");
                    return;
                }
                LevelChunk chunk = level.m_6325_(msg.chunkX, msg.chunkZ);
                IGlobalChunkData chunkData = GlobalChunkData.get(chunk);
                ChunkPos chunkPos = chunk.m_7697_();
                int chunkX = chunkPos.m_45604_();
                int chunkZ = chunkPos.m_45605_();
                for (int i = 0; i < msg.packedPositions.length; ++i) {
                    BlockPos pos = DataUtil.unpackChunkPos(chunkX, chunkZ, msg.packedPositions[i]);
                    BlockState block = chunk.m_8055_(pos);
                    float progress = msg.progress[i];
                    if (progress >= 1.0f) {
                        level.m_5898_(null, 2001, pos, Block.m_49956_((BlockState)block));
                        ClientEngine.get().visuallyDestroyBlock(pos, -1);
                        chunkData.removeBreakProgress(pos);
                        continue;
                    }
                    ClientEngine.get().visuallyDestroyBlock(pos, (int)(progress * 10.0f) - 1);
                    chunkData.setBreakProgress(pos, progress);
                }
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn(ChunkDigProgressToClient.class.getSimpleName() + " received on server.");
        }
    }
}

