/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.GlobalChunkData;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.world.ChunkDigProgressToClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ChunkDigProgressToServer {
    private int chunkX;
    private int chunkZ;
    private boolean isValid;

    public ChunkDigProgressToServer(LevelChunk chunk) {
        this.chunkX = chunk.m_7697_().f_45578_;
        this.chunkZ = chunk.m_7697_().f_45579_;
        this.isValid = true;
    }

    private ChunkDigProgressToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.chunkX);
            b.writeInt(this.chunkZ);
        }
    }

    public static ChunkDigProgressToServer read(FriendlyByteBuf b) {
        ChunkDigProgressToServer msg = new ChunkDigProgressToServer();
        msg.chunkX = b.readInt();
        msg.chunkZ = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(ChunkDigProgressToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn("ChunkDigProgressToServer received on client.");
        } else if (sideReceived.isServer() && ctx.getSender() != null) {
            ServerLevel level = (ServerLevel)ctx.getSender().f_19853_;
            if (!level.m_7232_(msg.chunkX, msg.chunkZ)) {
                return;
            }
            LevelChunk chunk = level.m_6325_(msg.chunkX, msg.chunkZ);
            if (!level.m_7726_().f_8325_.m_183262_(chunk.m_7697_(), false).contains(ctx.getSender())) {
                return;
            }
            ChunkDigProgressToClient message = GlobalChunkData.get(chunk).getBreakProgressMessage();
            if (message != null) {
                NetworkHandler.toClient(ctx.getSender(), message);
            }
        }
    }
}

