/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import com.mojang.math.Vector3d;
import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ClimbPositionToClient {
    private int entityID;
    private double x;
    private double y;
    private double z;
    private boolean isValid;

    public ClimbPositionToClient(Vector3d position, int entityID) {
        this.x = position.f_86214_;
        this.y = position.f_86215_;
        this.z = position.f_86216_;
        this.entityID = entityID;
        this.isValid = true;
    }

    private ClimbPositionToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeFloat((float)this.x);
            b.writeFloat((float)this.y);
            b.writeFloat((float)this.z);
            b.writeInt(this.entityID);
        }
    }

    public static ClimbPositionToClient read(FriendlyByteBuf b) {
        ClimbPositionToClient msg = new ClimbPositionToClient();
        msg.x = b.readFloat();
        msg.y = b.readFloat();
        msg.z = b.readFloat();
        msg.entityID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(ClimbPositionToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            ctx.enqueueWork(() -> {
                if (!world.isPresent()) {
                    Nightfall.LOGGER.warn("ClientLevel could not be found.");
                    return;
                }
                Entity patt2258$temp = ((Level)world.get()).m_6815_(msg.entityID);
                if (!(patt2258$temp instanceof Player)) {
                    Nightfall.LOGGER.warn("Entity is invalid.");
                    return;
                }
                Player player = (Player)patt2258$temp;
                if (!player.m_6084_()) {
                    Nightfall.LOGGER.warn("LocalPlayer is null or dead.");
                    return;
                }
                IPlayerData capP = PlayerData.get(player);
                capP.setClimbPosition(new Vector3d(msg.x, msg.y, msg.z));
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("ClimbPositionToClient received on server.");
        }
    }
}

