/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import com.mojang.math.Vector3d;
import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.world.ClimbPositionToClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ClimbPositionToServer {
    private boolean isValid;
    private double x;
    private double y;
    private double z;

    public ClimbPositionToServer(Vector3d position) {
        this.x = position.f_86214_;
        this.y = position.f_86215_;
        this.z = position.f_86216_;
        this.isValid = true;
    }

    private ClimbPositionToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeFloat((float)this.x);
            b.writeFloat((float)this.y);
            b.writeFloat((float)this.z);
        }
    }

    public static ClimbPositionToServer read(FriendlyByteBuf b) {
        ClimbPositionToServer msg = new ClimbPositionToServer();
        msg.x = b.readFloat();
        msg.y = b.readFloat();
        msg.z = b.readFloat();
        msg.isValid = true;
        return msg;
    }

    public static void handle(ClimbPositionToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn("ClimbPositionToServer received on client.");
        } else if (sideReceived.isServer()) {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                ctx.enqueueWork(() -> ClimbPositionToServer.doWork(msg, player));
            } else {
                Nightfall.LOGGER.warn("ServerPlayer is null.");
            }
        }
    }

    private static void doWork(ClimbPositionToServer msg, ServerPlayer player) {
        IPlayerData capP = PlayerData.get((Player)player);
        capP.setClimbPosition(new Vector3d(msg.x, msg.y, msg.z));
        NetworkHandler.toAllTracking((Entity)player, new ClimbPositionToClient(capP.getClimbPosition(), player.m_142049_()));
    }
}

