/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import frostnox.nightfall.Nightfall;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class DestroyBlockNoSoundToClient {
    private BlockPos pos;
    private int blockID;
    private boolean isValid;

    public DestroyBlockNoSoundToClient(BlockPos pos, int blockID) {
        this.pos = pos;
        this.blockID = blockID;
        this.isValid = true;
    }

    private DestroyBlockNoSoundToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130064_(this.pos);
            b.writeInt(this.blockID);
        }
    }

    public static DestroyBlockNoSoundToClient read(FriendlyByteBuf b) {
        DestroyBlockNoSoundToClient msg = new DestroyBlockNoSoundToClient();
        msg.pos = b.m_130135_();
        msg.blockID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(DestroyBlockNoSoundToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            ctx.enqueueWork(() -> {
                if (!world.isPresent()) {
                    Nightfall.LOGGER.warn("ClientLevel could not be found.");
                    return;
                }
                ((Level)world.get()).m_142052_(msg.pos, Block.m_49803_((int)msg.blockID));
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn(DestroyBlockNoSoundToClient.class.getSimpleName() + " received on server.");
        }
    }
}

