/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.GlobalChunkData;
import frostnox.nightfall.capability.IGlobalChunkData;
import frostnox.nightfall.client.ClientEngine;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class DigBlockToClient {
    private int x;
    private int y;
    private int z;
    private float progress;
    private boolean isValid;

    public DigBlockToClient(int x, int y, int z, float progress) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.progress = progress;
        this.isValid = true;
    }

    private DigBlockToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.x);
            b.writeInt(this.y);
            b.writeInt(this.z);
            b.writeFloat(this.progress);
        }
    }

    public static DigBlockToClient read(FriendlyByteBuf b) {
        DigBlockToClient msg = new DigBlockToClient();
        msg.x = b.readInt();
        msg.y = b.readInt();
        msg.z = b.readInt();
        msg.progress = b.readFloat();
        msg.isValid = true;
        return msg;
    }

    public static void handle(DigBlockToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            ctx.enqueueWork(() -> {
                if (!world.isPresent()) {
                    Nightfall.LOGGER.warn("ClientLevel could not be found.");
                    return;
                }
                BlockPos pos = new BlockPos(msg.x, msg.y, msg.z);
                BlockState block = ((Level)world.get()).m_8055_(pos);
                IGlobalChunkData chunkData = GlobalChunkData.get(((Level)world.get()).m_46745_(pos));
                if (msg.progress >= 1.0f) {
                    ((Level)world.get()).m_5898_(null, 2001, pos, Block.m_49956_((BlockState)block));
                    ClientEngine.get().visuallyDestroyBlock(pos, -1);
                    chunkData.removeBreakProgress(pos);
                } else {
                    ClientEngine.get().visuallyDestroyBlock(pos, (int)(msg.progress * 10.0f) - 1);
                    chunkData.setBreakProgress(pos, msg.progress);
                }
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn(DigBlockToClient.class.getSimpleName() + " received on server.");
        }
    }
}

