/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.GlobalChunkData;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IGlobalChunkData;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.network.message.world.DigBlockToClient;
import frostnox.nightfall.registry.forge.AttributesNF;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class DigBlockToServer {
    private boolean isValid;
    private int x;
    private int y;
    private int z;

    public DigBlockToServer(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.isValid = true;
    }

    private DigBlockToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.x);
            b.writeInt(this.y);
            b.writeInt(this.z);
        }
    }

    public static DigBlockToServer read(FriendlyByteBuf b) {
        DigBlockToServer msg = new DigBlockToServer();
        msg.x = b.readInt();
        msg.y = b.readInt();
        msg.z = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(DigBlockToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn("DigBlockToServer received on client.");
        } else if (sideReceived.isServer()) {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                ctx.enqueueWork(() -> DigBlockToServer.doWork(msg, player));
            } else {
                Nightfall.LOGGER.warn("ServerPlayer is null.");
            }
        }
    }

    private static void doWork(DigBlockToServer msg, ServerPlayer player) {
        boolean failed = false;
        if (!player.m_6084_()) {
            Nightfall.LOGGER.warn("Player {} tried to dig but was not alive.", (Object)player.m_7755_().getString());
        }
        IActionTracker capA = ActionTracker.get((Entity)player);
        IPlayerData capP = PlayerData.get((Player)player);
        BlockPos center = new BlockPos(msg.x, msg.y, msg.z);
        Action action = capA.getAction();
        if (player.m_20275_((double)msg.x, (double)msg.y, (double)msg.z) > 64.0) {
            Nightfall.LOGGER.warn("Player {} tried to dig a block at {} but was too far away.", (Object)player.m_7755_().getString(), (Object)center.m_123344_());
            failed = true;
        } else if (capP.hasDugBlock()) {
            Nightfall.LOGGER.warn("Player {} tried to dig twice during the same state.", (Object)player.m_7755_().getString());
            failed = true;
        } else if (!action.canHarvest()) {
            Nightfall.LOGGER.warn("Player {} tried to dig but action '{}' does not allow harvesting.", (Object)player.m_7755_().getString(), (Object)capA.getAction().toString());
            failed = true;
        } else if (!capA.isInactive()) {
            boolean canMineAny;
            ItemStack stack = player.m_21120_(capP.getActiveHand());
            int hits = 0;
            boolean bl = canMineAny = !action.harvestableBlocks.equals(TagsNF.MINEABLE_WITH_SICKLE) && !action.harvestableBlocks.equals(TagsNF.MINEABLE_WITH_DAGGER) && !action.harvestableBlocks.equals((Object)BlockTags.f_144280_);
            if (canMineAny || action.canHarvest(player.f_19853_.m_8055_(center))) {
                boolean facingX = player.m_6350_().m_122434_().equals((Object)Direction.Axis.X);
                int xRange = stack.m_204117_(TagsNF.SICKLE) && (!action.isChargeable() || !facingX) ? 1 : 0;
                int zRange = stack.m_204117_(TagsNF.SICKLE) && (!action.isChargeable() || facingX) ? 1 : 0;
                int yRange = stack.m_204117_(TagsNF.SICKLE) && action.isChargeable() ? 1 : 0;
                ItemStack tempStack = player.m_21205_();
                player.m_21008_(InteractionHand.MAIN_HAND, stack);
                for (BlockPos pos : BlockPos.m_121976_((int)(center.m_123341_() - xRange), (int)(center.m_123342_() - yRange), (int)(center.m_123343_() - zRange), (int)(center.m_123341_() + xRange), (int)(center.m_123342_() + yRange), (int)(center.m_123343_() + zRange))) {
                    int exp;
                    BlockState block = player.f_19853_.m_8055_(pos);
                    if (!canMineAny && !action.canHarvest(block)) continue;
                    IGlobalChunkData chunkData = GlobalChunkData.get(player.f_19853_.m_46745_(pos));
                    float progress = block.m_60625_((Player)player, (BlockGetter)player.f_19853_, pos) * AttributesNF.getStrengthMultiplier((LivingEntity)player) * capA.getChargeDestroyProgressMultiplier() + chunkData.getBreakProgress(pos);
                    BlockEntity blockEntity = player.f_19853_.m_7702_(pos);
                    block.m_60686_(player.f_19853_, pos, (Player)player);
                    if (progress >= 1.0f && (exp = ForgeHooks.onBlockBreakEvent((Level)player.f_19853_, (GameType)player.f_8941_.m_9290_(), (ServerPlayer)player, (BlockPos)pos.m_7949_())) == -1) {
                        NetworkHandler.toClient(player, new DigBlockToClient(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), progress));
                        continue;
                    }
                    ++hits;
                    boolean isCenter = pos.equals((Object)center);
                    if (progress >= 1.0f) {
                        boolean canHarvest = block.canHarvestBlock((BlockGetter)player.f_19853_, pos, (Player)player);
                        if (block.onDestroyedByPlayer(player.f_19853_, pos, (Player)player, canHarvest, block.m_60819_())) {
                            block.m_60734_().m_6786_((LevelAccessor)player.f_19853_, pos, block);
                            if (canHarvest) {
                                block.m_60734_().m_6240_(player.f_19853_, (Player)player, pos, block, blockEntity, stack);
                            }
                            chunkData.removeBreakProgress(pos);
                        }
                    } else {
                        if (isCenter && !block.m_60767_().m_76336_() && !stack.m_204117_(TagsNF.NO_HITSTOP)) {
                            capP.setHitStopFrame(capA.getFrame());
                            NetworkHandler.toAllTracking((Entity)player, new GenericEntityToClient(NetworkHandler.Type.HITSTOP_CLIENT, player.m_142049_()));
                        }
                        chunkData.setBreakProgress(pos.m_7949_(), progress);
                    }
                    if (isCenter) {
                        SoundType sound = block.getSoundType((LevelReader)player.f_19853_, pos, (Entity)player);
                        player.f_19853_.m_5594_((Player)player, pos, sound.m_56778_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.75f);
                    }
                    NetworkHandler.toAllTrackingAndSelf((Entity)player, new DigBlockToClient(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), progress));
                }
                player.m_21008_(InteractionHand.MAIN_HAND, tempStack);
                capP.setDugBlock(true);
                if (!player.m_7500_()) {
                    stack.m_41622_(hits, (LivingEntity)player, p -> p.m_21190_(capP.getActiveHand()));
                }
            }
        } else {
            Nightfall.LOGGER.warn("Player {} tried to dig but is idling.", (Object)player.m_7755_().getString());
            failed = true;
        }
        if (failed) {
            NetworkHandler.toClient(player, new DigBlockToClient(center.m_123341_(), center.m_123342_(), center.m_123343_(), GlobalChunkData.get(player.f_19853_.m_46745_(center)).getBreakProgress(center)));
        }
    }
}

