/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.block.IMicroGrid;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class GridUseToClient {
    private boolean isValid;
    private BlockPos blockEntityPos;
    private CompoundTag gridData;

    public GridUseToClient(BlockPos blockEntityPos, CompoundTag gridData) {
        this.blockEntityPos = blockEntityPos;
        this.gridData = gridData;
        this.isValid = true;
    }

    private GridUseToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130064_(this.blockEntityPos);
            b.m_130079_(this.gridData);
        }
    }

    public static GridUseToClient read(FriendlyByteBuf b) {
        GridUseToClient msg = new GridUseToClient();
        msg.blockEntityPos = b.m_130135_();
        msg.gridData = b.m_130260_();
        msg.isValid = true;
        return msg;
    }

    public static void handle(GridUseToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            ctx.enqueueWork(() -> {
                BlockEntity patt2143$temp;
                if (!world.isPresent()) {
                    Nightfall.LOGGER.warn("ClientLevel does not exist.");
                    return;
                }
                if (!((Level)world.get()).m_46749_(msg.blockEntityPos) || !((patt2143$temp = ((Level)world.get()).m_7702_(msg.blockEntityPos)) instanceof IMicroGrid)) {
                    return;
                }
                IMicroGrid gridEntity = (IMicroGrid)patt2143$temp;
                for (int x = 0; x < gridEntity.getGridXSize(); ++x) {
                    for (int y = 0; y < gridEntity.getGridYSize(); ++y) {
                        for (int z = 0; z < gridEntity.getGridZSize(); ++z) {
                            String id = IMicroGrid.idFromPos(x, y, z);
                            if (!msg.gridData.m_128431_().contains(id)) continue;
                            gridEntity.getGrid()[x][y][z] = msg.gridData.m_128471_(id);
                        }
                    }
                }
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("GridUseToClient received on server.");
        }
    }
}

