/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.block.IMicroGrid;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.item.IActionableItem;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class GridUseToServer {
    private boolean isValid;
    private int type;
    private int x;
    private int y;
    private int z;
    private BlockPos blockEntityPos;

    public GridUseToServer(int type, Vec3i gridPos, BlockPos blockEntityPos) {
        this.type = type;
        this.x = gridPos.m_123341_();
        this.y = gridPos.m_123342_();
        this.z = gridPos.m_123343_();
        this.blockEntityPos = blockEntityPos;
        this.isValid = true;
    }

    private GridUseToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.type);
            b.writeInt(this.x);
            b.writeInt(this.y);
            b.writeInt(this.z);
            b.m_130064_(this.blockEntityPos);
        }
    }

    public static GridUseToServer read(FriendlyByteBuf b) {
        GridUseToServer msg = new GridUseToServer();
        msg.type = b.readInt();
        msg.x = b.readInt();
        msg.y = b.readInt();
        msg.z = b.readInt();
        msg.blockEntityPos = b.m_130135_();
        msg.isValid = true;
        return msg;
    }

    public static void handle(GridUseToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn("SmithHitToServer received on client.");
        } else if (sideReceived.isServer()) {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                ctx.enqueueWork(() -> GridUseToServer.doWork(msg, player));
            } else {
                Nightfall.LOGGER.warn("ServerPlayer is null.");
            }
        }
    }

    private static void doWork(GridUseToServer msg, ServerPlayer player) {
        IActionTracker capA = ActionTracker.get((Entity)player);
        IPlayerData capP = PlayerData.get((Player)player);
        BlockPos pos = msg.blockEntityPos;
        if (!player.m_6084_()) {
            Nightfall.LOGGER.warn("Player {} tried to use grid but is not alive.", (Object)player.m_7755_().getString());
        } else if (pos.m_203198_(player.m_20185_(), player.m_20186_(), player.m_20189_()) > 9.0 || !player.f_19853_.m_46749_(pos)) {
            Nightfall.LOGGER.warn("Player {} tried to use grid but is not within reach.", (Object)player.m_7755_().getString());
        } else {
            BlockEntity blockEntity = player.f_19853_.m_7702_(pos);
            if (!(blockEntity instanceof IMicroGrid)) {
                Nightfall.LOGGER.warn("Player {} tried to use grid on an invalid block entity.", (Object)player.m_7755_().getString());
            } else {
                IMicroGrid gridEntity = (IMicroGrid)blockEntity;
                if (!gridEntity.canUseGrid(capA.getAction())) {
                    Nightfall.LOGGER.warn("Player {} tried to use grid while performing an invalid action.", (Object)player.m_7755_().getString());
                } else {
                    IActionableItem item;
                    blockEntity = player.m_21120_(capP.getActiveHand()).m_41720_();
                    if (!(blockEntity instanceof IActionableItem) || !(item = (IActionableItem)blockEntity).hasAction(capA.getActionID(), (Player)player)) {
                        Nightfall.LOGGER.warn("Player {} tried to use grid with an invalid item.", (Object)player.m_7755_().getString());
                    } else if (capP.hasInteracted()) {
                        Nightfall.LOGGER.warn("Player {} tried to use grid multiple times during one action.", (Object)player.m_7755_().getString());
                    } else if (!gridEntity.isValidActionType(msg.type)) {
                        Nightfall.LOGGER.warn("Player {} tried to use grid with invalid action type.", (Object)player.m_7755_().getString());
                    } else {
                        capP.setInteracted(true);
                        Vec3i hitPos = new Vec3i(msg.x, msg.y, msg.z);
                        gridEntity.useGrid(msg.type, hitPos, (Player)player, player.m_21120_(capP.getActiveHand()));
                        capP.setHitStopFrame(capA.getFrame());
                        NetworkHandler.toAllTracking((Entity)player, new GenericEntityToClient(NetworkHandler.Type.HITSTOP_CLIENT, player.m_142049_()));
                    }
                }
            }
        }
    }
}

