/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.registry.ActionsNF;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class TakeHoldableToClient {
    private int playerID;
    private CompoundTag heldContents;
    private boolean isValid;

    public TakeHoldableToClient(CompoundTag heldContents, int playerID) {
        this.playerID = playerID;
        this.heldContents = heldContents;
        this.isValid = true;
    }

    private TakeHoldableToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.playerID);
            b.m_130079_(this.heldContents);
        }
    }

    public static TakeHoldableToClient read(FriendlyByteBuf b) {
        TakeHoldableToClient msg = new TakeHoldableToClient();
        msg.playerID = b.readInt();
        msg.heldContents = b.m_130260_();
        msg.isValid = true;
        return msg;
    }

    public static void handle(TakeHoldableToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("Level could not be found.");
                return;
            }
            ctx.enqueueWork(() -> {
                Player player = (Player)((Level)world.get()).m_6815_(msg.playerID);
                if (player == null || !player.m_6084_()) {
                    Nightfall.LOGGER.warn("Player is null or dead.");
                    return;
                }
                IActionTracker capA = ActionTracker.get((Entity)player);
                capA.startAction(ActionsNF.HOLD_ENTITY.getId());
                IPlayerData capP = PlayerData.get(player);
                capP.setHeldContents(msg.heldContents);
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("TakeHoldableToClient received on server.");
        }
    }
}

