/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.world;

import frostnox.nightfall.Nightfall;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class UpdateBlockToClient {
    private BlockPos pos;
    private boolean isValid;

    public UpdateBlockToClient(BlockPos pos) {
        this.pos = pos;
        this.isValid = true;
    }

    private UpdateBlockToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130064_(this.pos);
        }
    }

    public static UpdateBlockToClient read(FriendlyByteBuf b) {
        UpdateBlockToClient msg = new UpdateBlockToClient();
        msg.pos = b.m_130135_();
        msg.isValid = true;
        return msg;
    }

    public static void handle(UpdateBlockToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            ctx.enqueueWork(() -> {
                if (!world.isPresent()) {
                    Nightfall.LOGGER.warn("ClientLevel could not be found.");
                    return;
                }
                BlockState block = ((Level)world.get()).m_8055_(msg.pos);
                ((Level)world.get()).m_7260_(msg.pos, block, block, 3);
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("UpdateBlockToClient received on server.");
        }
    }
}

