/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.registry;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.block.IMetal;
import frostnox.nightfall.block.INaturalVegetation;
import frostnox.nightfall.block.ISoil;
import frostnox.nightfall.block.IStone;
import frostnox.nightfall.block.ITree;
import frostnox.nightfall.block.Metal;
import frostnox.nightfall.block.Soil;
import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.data.recipe.IEncyclopediaRecipe;
import frostnox.nightfall.encyclopedia.Entry;
import frostnox.nightfall.encyclopedia.knowledge.Knowledge;
import frostnox.nightfall.item.Armament;
import frostnox.nightfall.item.Dye;
import frostnox.nightfall.item.IArmament;
import frostnox.nightfall.item.IDye;
import frostnox.nightfall.item.IStyle;
import frostnox.nightfall.item.ITieredArmorMaterial;
import frostnox.nightfall.item.Style;
import frostnox.nightfall.item.TieredArmorMaterial;
import frostnox.nightfall.world.condition.WorldCondition;
import frostnox.nightfall.world.spawngroup.SpawnGroup;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistriesNF {
    public static final ResourceKey<Registry<Action>> ACTIONS_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"actions"));
    private static IForgeRegistryModifiable<Action> ACTIONS;
    public static final ResourceKey<Registry<Entry>> ENTRIES_KEY;
    private static IForgeRegistryModifiable<Entry> ENTRIES;
    public static final ResourceKey<Registry<Knowledge>> KNOWLEDGE_KEY;
    private static IForgeRegistryModifiable<Knowledge> KNOWLEDGE;
    public static final ResourceKey<Registry<WorldCondition>> WORLD_CONDITIONS_KEY;
    private static IForgeRegistryModifiable<WorldCondition> WORLD_CONDITIONS;
    public static final ResourceKey<Registry<SpawnGroup>> SPAWN_GROUPS_KEY;
    private static IForgeRegistryModifiable<SpawnGroup> SPAWN_GROUPS;
    public static final ResourceKey<Registry<IArmament.Entry>> ARMAMENTS_KEY;
    private static IForgeRegistryModifiable<IArmament.Entry> ARMAMENTS;
    public static final ResourceKey<Registry<IDye.Entry>> DYES_KEY;
    private static IForgeRegistryModifiable<IDye.Entry> DYES;
    public static final ResourceKey<Registry<IMetal.Entry>> METALS_KEY;
    private static IForgeRegistryModifiable<IMetal.Entry> METALS;
    public static final ResourceKey<Registry<ISoil.Entry>> SOILS_KEY;
    private static IForgeRegistryModifiable<ISoil.Entry> SOILS;
    public static final ResourceKey<Registry<IStone.Entry>> STONES_KEY;
    private static IForgeRegistryModifiable<IStone.Entry> STONES;
    public static final ResourceKey<Registry<IStyle.Entry>> STYLES_KEY;
    private static IForgeRegistryModifiable<IStyle.Entry> STYLES;
    public static final ResourceKey<Registry<ITieredArmorMaterial.Entry>> TIERED_ARMOR_MATERIALS_KEY;
    private static IForgeRegistryModifiable<ITieredArmorMaterial.Entry> TIERED_ARMOR_MATERIALS;
    public static final ResourceKey<Registry<ITree.Entry>> TREES_KEY;
    private static IForgeRegistryModifiable<ITree.Entry> TREES;
    private static ObjectSet<Knowledge> ACTIVE_KNOWLEDGE;
    private static ObjectSet<INaturalVegetation> NATURAL_VEGETATION;

    public static IForgeRegistryModifiable<Action> getActions() {
        if (ACTIONS == null) {
            ACTIONS = RegistryManager.ACTIVE.getRegistry(ACTIONS_KEY);
        }
        return ACTIONS;
    }

    public static IForgeRegistryModifiable<Entry> getEntries() {
        if (ENTRIES == null) {
            ENTRIES = RegistryManager.ACTIVE.getRegistry(ENTRIES_KEY);
        }
        return ENTRIES;
    }

    public static IForgeRegistryModifiable<Knowledge> getKnowledge() {
        if (KNOWLEDGE == null) {
            KNOWLEDGE = RegistryManager.ACTIVE.getRegistry(KNOWLEDGE_KEY);
        }
        return KNOWLEDGE;
    }

    public static void buildActiveKnowledge(ServerLevel level) {
        ObjectOpenHashSet activeKnowledge = new ObjectOpenHashSet(RegistriesNF.getKnowledge().getEntries().size());
        for (Recipe recipe : level.m_7465_().m_44051_()) {
            if (!(recipe instanceof IEncyclopediaRecipe)) continue;
            IEncyclopediaRecipe encyclopediaRecipe = (IEncyclopediaRecipe)recipe;
            for (Ingredient ingredient : encyclopediaRecipe.getUnlockIngredients()) {
                for (ItemStack item : ingredient.m_43908_()) {
                    Knowledge knowledge = (Knowledge)RegistriesNF.getKnowledge().getValue(ResourceLocation.parse((String)(item.m_41720_().getRegistryName().toString() + "_item")));
                    if (knowledge == null) continue;
                    activeKnowledge.add((Object)knowledge);
                }
            }
            Knowledge requiredKnowledge = (Knowledge)RegistriesNF.getKnowledge().getValue(encyclopediaRecipe.getRequirementId());
            if (requiredKnowledge == null) continue;
            activeKnowledge.add((Object)requiredKnowledge);
        }
        for (Entry entry : RegistriesNF.getEntries()) {
            for (RegistryObject<? extends Knowledge> knowledge : entry.getAssociatedKnowledge()) {
                activeKnowledge.add((Object)((Knowledge)((Object)knowledge.get())));
            }
        }
        ACTIVE_KNOWLEDGE = ObjectSets.unmodifiable((ObjectSet)activeKnowledge);
    }

    public static ObjectSet<Knowledge> getActiveServerKnowledge() {
        return ACTIVE_KNOWLEDGE;
    }

    public static void buildNaturalVegetation() {
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            if (!(block instanceof INaturalVegetation)) continue;
            INaturalVegetation vegetation = (INaturalVegetation)block;
            set.add((Object)vegetation);
        }
        NATURAL_VEGETATION = ObjectSets.unmodifiable((ObjectSet)set);
    }

    public static ObjectSet<INaturalVegetation> getNaturalVegetation() {
        return NATURAL_VEGETATION;
    }

    public static IForgeRegistryModifiable<WorldCondition> getWorldConditions() {
        if (WORLD_CONDITIONS == null) {
            WORLD_CONDITIONS = RegistryManager.ACTIVE.getRegistry(WORLD_CONDITIONS_KEY);
        }
        return WORLD_CONDITIONS;
    }

    public static IForgeRegistryModifiable<SpawnGroup> getSpawnGroups() {
        if (SPAWN_GROUPS == null) {
            SPAWN_GROUPS = RegistryManager.ACTIVE.getRegistry(SPAWN_GROUPS_KEY);
        }
        return SPAWN_GROUPS;
    }

    public static IForgeRegistryModifiable<IArmament.Entry> getArmaments() {
        if (ARMAMENTS == null) {
            ARMAMENTS = RegistryManager.ACTIVE.getRegistry(ARMAMENTS_KEY);
        }
        return ARMAMENTS;
    }

    public static IForgeRegistryModifiable<IDye.Entry> getDyes() {
        if (DYES == null) {
            DYES = RegistryManager.ACTIVE.getRegistry(DYES_KEY);
        }
        return DYES;
    }

    public static IForgeRegistryModifiable<IMetal.Entry> getMetals() {
        if (METALS == null) {
            METALS = RegistryManager.ACTIVE.getRegistry(METALS_KEY);
        }
        return METALS;
    }

    public static IForgeRegistryModifiable<ISoil.Entry> getSoils() {
        if (SOILS == null) {
            SOILS = RegistryManager.ACTIVE.getRegistry(SOILS_KEY);
        }
        return SOILS;
    }

    public static IForgeRegistryModifiable<IStone.Entry> getStones() {
        if (STONES == null) {
            STONES = RegistryManager.ACTIVE.getRegistry(STONES_KEY);
        }
        return STONES;
    }

    public static IForgeRegistryModifiable<IStyle.Entry> getStyles() {
        if (STYLES == null) {
            STYLES = RegistryManager.ACTIVE.getRegistry(STYLES_KEY);
        }
        return STYLES;
    }

    public static IForgeRegistryModifiable<ITieredArmorMaterial.Entry> getTieredArmorMaterials() {
        if (TIERED_ARMOR_MATERIALS == null) {
            TIERED_ARMOR_MATERIALS = RegistryManager.ACTIVE.getRegistry(TIERED_ARMOR_MATERIALS_KEY);
        }
        return TIERED_ARMOR_MATERIALS;
    }

    public static IForgeRegistryModifiable<ITree.Entry> getTrees() {
        if (TREES == null) {
            TREES = RegistryManager.ACTIVE.getRegistry(TREES_KEY);
        }
        return TREES;
    }

    @SubscribeEvent
    public static void onRegisterArmamentsEvent(RegistryEvent.Register<IArmament.Entry> event) {
        for (Armament value : Armament.values()) {
            event.getRegistry().register((IForgeRegistryEntry)((IArmament.Entry)new IArmament.Entry(value).setRegistryName("nightfall", value.getName())));
        }
    }

    @SubscribeEvent
    public static void onRegisterDyesEvent(RegistryEvent.Register<IDye.Entry> event) {
        for (Dye value : Dye.values()) {
            event.getRegistry().register((IForgeRegistryEntry)((IDye.Entry)new IDye.Entry(value).setRegistryName("nightfall", value.getName())));
        }
    }

    @SubscribeEvent
    public static void onRegisterMetalsEvent(RegistryEvent.Register<IMetal.Entry> event) {
        for (Metal value : Metal.values()) {
            event.getRegistry().register((IForgeRegistryEntry)((IMetal.Entry)new IMetal.Entry(value).setRegistryName("nightfall", value.getName())));
        }
    }

    @SubscribeEvent
    public static void onRegisterSoilsEvent(RegistryEvent.Register<ISoil.Entry> event) {
        for (Soil value : Soil.values()) {
            event.getRegistry().register((IForgeRegistryEntry)((ISoil.Entry)new ISoil.Entry(value).setRegistryName("nightfall", value.getName())));
        }
    }

    @SubscribeEvent
    public static void onRegisterStonesEvent(RegistryEvent.Register<IStone.Entry> event) {
        for (Stone value : Stone.values()) {
            event.getRegistry().register((IForgeRegistryEntry)((IStone.Entry)new IStone.Entry(value).setRegistryName("nightfall", value.getName())));
        }
    }

    @SubscribeEvent
    public static void onRegisterStylesEvent(RegistryEvent.Register<IStyle.Entry> event) {
        for (Style value : Style.values()) {
            event.getRegistry().register((IForgeRegistryEntry)((IStyle.Entry)new IStyle.Entry(value).setRegistryName("nightfall", value.getName())));
        }
    }

    @SubscribeEvent
    public static void onRegisterTieredArmorMaterialsEvent(RegistryEvent.Register<ITieredArmorMaterial.Entry> event) {
        for (TieredArmorMaterial value : TieredArmorMaterial.values()) {
            event.getRegistry().register((IForgeRegistryEntry)((ITieredArmorMaterial.Entry)new ITieredArmorMaterial.Entry(value).setRegistryName("nightfall", value.getName())));
        }
    }

    @SubscribeEvent
    public static void onRegisterTreesEvent(RegistryEvent.Register<ITree.Entry> event) {
        for (Tree value : Tree.values()) {
            event.getRegistry().register((IForgeRegistryEntry)((ITree.Entry)new ITree.Entry(value).setRegistryName("nightfall", value.getName())));
        }
    }

    static {
        ENTRIES_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"entries"));
        KNOWLEDGE_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"knowledge"));
        WORLD_CONDITIONS_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"world_conditions"));
        SPAWN_GROUPS_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"spawn_groups"));
        ARMAMENTS_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"armaments"));
        DYES_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"dyes"));
        METALS_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"metals"));
        SOILS_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"soils"));
        STONES_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"stones"));
        STYLES_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"styles"));
        TIERED_ARMOR_MATERIALS_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"tiered_armor_materials"));
        TREES_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"trees"));
    }
}

