/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.registry;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.registry.RegistriesNF;
import frostnox.nightfall.registry.forge.BiomesNF;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.world.spawngroup.DrakefowlSpawnGroup;
import frostnox.nightfall.world.spawngroup.JellyfishSpawnGroup;
import frostnox.nightfall.world.spawngroup.LandBiomeSpawnGroup;
import frostnox.nightfall.world.spawngroup.LandBiomeTagSpawnGroup;
import frostnox.nightfall.world.spawngroup.LandSpawnGroup;
import frostnox.nightfall.world.spawngroup.SpawnGroup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class SpawnGroupsNF {
    public static final DeferredRegister<SpawnGroup> GROUPS = DeferredRegister.create(RegistriesNF.SPAWN_GROUPS_KEY, (String)"nightfall");
    public static final RegistryObject<SpawnGroup> COCKATRICE = GROUPS.register("cockatrice", () -> new LandSpawnGroup(2, false, (EntityType)EntitiesNF.COCKATRICE.get(), 416, Integer.MAX_VALUE, 1, 15, 1, 1, 0.45f, 1.0f, 0.0f, 1.0f, TagsNF.COCKATRICE_SPAWN_BLOCK));
    public static final RegistryObject<SpawnGroup> DEER = GROUPS.register("deer", () -> new LandSpawnGroup(7, true, (EntityType)EntitiesNF.DEER.get(), 416, 624, 1, 15, 1, 4, 0.05f, 1.0f, 0.0f, 1.0f, TagsNF.DEER_SPAWN_BLOCK));
    public static final RegistryObject<SpawnGroup> RABBIT = GROUPS.register("rabbit", () -> new LandSpawnGroup(2, true, (EntityType)EntitiesNF.RABBIT.get(), 416, 728, 1, 15, 1, 1, 0.05f, 1.0f, 0.0f, 1.0f, TagsNF.RABBIT_SPAWN_BLOCK));
    public static final RegistryObject<SpawnGroup> DRAKEFOWL = GROUPS.register("drakefowl", () -> new DrakefowlSpawnGroup(3, true, 416, Integer.MAX_VALUE, 1, 15, 0.55f, 1.0f, 0.65f, 1.0f, TagsNF.NATURAL_SOIL));
    public static final RegistryObject<SpawnGroup> CREEPER = GROUPS.register("creeper", () -> new LandSpawnGroup(1, false, (EntityType)EntitiesNF.CREEPER.get(), 416, Integer.MAX_VALUE, 0, 15, 1, 1, 0.1f, 1.0f, 0.4f, 1.0f, TagsNF.CREEPER_SPAWN_BLOCK));
    public static final RegistryObject<SpawnGroup> JELLYFISH = GROUPS.register("jellyfish", () -> new JellyfishSpawnGroup(2, true, (EntityType)EntitiesNF.JELLYFISH.get(), 352, Integer.MAX_VALUE, 0, 15, 5, 13, 0.35f, 1.0f, 0.0f, 1.0f));
    public static final RegistryObject<SpawnGroup> PIT_DEVIL_SURFACE = GROUPS.register("pit_devil_surface", () -> new LandSpawnGroup(1, false, (EntityType)EntitiesNF.PIT_DEVIL.get(), 416, Integer.MAX_VALUE, 0, 15, 1, 1, 0.7f, 0.9f, 0.35f, 0.65f, TagsNF.NATURAL_TERRAIN));
    public static final RegistryObject<SpawnGroup> PIT_DEVIL_CAVES = GROUPS.register("pit_devil_caves", () -> new LandBiomeSpawnGroup(5, false, (EntityType)EntitiesNF.PIT_DEVIL.get(), 300, Integer.MAX_VALUE, 0, 0, 1, 1, BiomesNF.TUNNELS, TagsNF.NATURAL_TERRAIN));
    public static final RegistryObject<SpawnGroup> ECTOPLASM_LARGE = GROUPS.register("ectoplasm_large", () -> new LandBiomeTagSpawnGroup(2, false, (EntityType)EntitiesNF.ECTOPLASM_LARGE.get(), Integer.MIN_VALUE, Integer.MAX_VALUE, 0, 0, 1, 1, TagsNF.CAVE, TagsNF.NATURAL_TERRAIN));
    public static final RegistryObject<SpawnGroup> ECTOPLASM_MEDIUM = GROUPS.register("ectoplasm_medium", () -> new LandBiomeTagSpawnGroup(1, false, (EntityType)EntitiesNF.ECTOPLASM_MEDIUM.get(), Integer.MIN_VALUE, Integer.MAX_VALUE, 0, 0, 1, 1, TagsNF.CAVE, TagsNF.NATURAL_TERRAIN));

    public static void register() {
        GROUPS.register(Nightfall.MOD_EVENT_BUS);
    }

    public static SpawnGroup get(ResourceLocation id) {
        return (SpawnGroup)RegistriesNF.getSpawnGroups().getValue(id);
    }

    public static boolean contains(ResourceLocation id) {
        return RegistriesNF.getSpawnGroups().containsKey(id);
    }
}

