/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.registry;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.block.IHeatSource;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.registry.RegistriesNF;
import frostnox.nightfall.world.condition.WorldCondition;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class WorldConditionsNF {
    public static final ResourceLocation SATISFIED_CONDITION_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"gui/icon/satisfied_condition");
    public static final ResourceLocation UNSATISFIED_CONDITION_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"gui/icon/unsatisfied_condition");
    public static final DeferredRegister<WorldCondition> CONDITIONS = DeferredRegister.create(RegistriesNF.WORLD_CONDITIONS_KEY, (String)"nightfall");
    public static final RegistryObject<WorldCondition> HEAT_SOURCE = CONDITIONS.register("heat_source", () -> new WorldCondition(){

        @Override
        public boolean test(Player player) {
            BlockPos pos = new BlockPos(player.m_146892_());
            for (BlockPos searchPos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-3, -2, -3), (BlockPos)pos.m_142082_(3, 2, 3))) {
                IHeatSource heatSource;
                BlockState state = player.f_19853_.m_8055_(searchPos);
                Block block = state.m_60734_();
                if (!(block instanceof IHeatSource) || (heatSource = (IHeatSource)block).getHeat(player.f_19853_, searchPos, state) == TieredHeat.NONE) continue;
                return true;
            }
            return false;
        }
    });
    public static final RegistryObject<WorldCondition> WATER_SOURCE = CONDITIONS.register("water_source", () -> new WorldCondition(){

        @Override
        public boolean test(Player player) {
            BlockPos pos = new BlockPos(player.m_146892_());
            for (BlockPos searchPos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-3, -2, -3), (BlockPos)pos.m_142082_(3, 2, 3))) {
                if (!player.f_19853_.m_6425_(searchPos).m_205070_(FluidTags.f_13131_)) continue;
                return true;
            }
            return false;
        }
    });

    public static void register() {
        CONDITIONS.register(Nightfall.MOD_EVENT_BUS);
    }

    public static WorldCondition get(ResourceLocation id) {
        return (WorldCondition)RegistriesNF.getWorldConditions().getValue(id);
    }

    public static boolean contains(ResourceLocation id) {
        return RegistriesNF.getWorldConditions().containsKey(id);
    }
}

