/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.registry.forge;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.entity.PlayerAttribute;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class AttributesNF {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"nightfall");
    public static final RegistryObject<Attribute> INVENTORY_CAPACITY = ATTRIBUTES.register("inventory_capacity", () -> new RangedAttribute("attribute.name.nightfall.inventory_capacity", 0.0, 0.0, 12.0).m_22084_(true));
    public static final RegistryObject<Attribute> ACTION_SPEED = ATTRIBUTES.register("action_speed", () -> new RangedAttribute("attribute.name.nightfall.action_speed", 1.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> STAMINA_REDUCTION = ATTRIBUTES.register("stamina_reduction", () -> new RangedAttribute("attribute.name.nightfall.stamina_reduction", 1.0, 0.0, 1.0).m_22084_(true));
    public static final RegistryObject<Attribute> HEARING_RANGE = ATTRIBUTES.register("hearing_range", () -> new RangedAttribute("attribute.name.nightfall.hearing_range", 15.0, 0.0, 1024.0));
    public static final RegistryObject<Attribute> ENDURANCE = ATTRIBUTES.register("endurance", () -> new RangedAttribute("attribute.name.nightfall.endurance", 10.0, 1.0, 20.0).m_22084_(true));
    public static final RegistryObject<Attribute> WILLPOWER = ATTRIBUTES.register("willpower", () -> new RangedAttribute("attribute.name.nightfall.willpower", 10.0, 1.0, 20.0).m_22084_(true));
    public static final RegistryObject<Attribute> STRENGTH = ATTRIBUTES.register("strength", () -> new RangedAttribute("attribute.name.nightfall.strength", 10.0, 1.0, 20.0).m_22084_(true));
    public static final RegistryObject<Attribute> PERCEPTION = ATTRIBUTES.register("perception", () -> new RangedAttribute("attribute.name.nightfall.perception", 10.0, 1.0, 20.0).m_22084_(true));
    public static final RegistryObject<Attribute> STRIKING_DEFENSE = ATTRIBUTES.register("striking_defense", () -> new RangedAttribute("attribute.name.nightfall.striking_defense", 0.0, -1.0, 1.0).m_22084_(true));
    public static final RegistryObject<Attribute> SLASHING_DEFENSE = ATTRIBUTES.register("slashing_defense", () -> new RangedAttribute("attribute.name.nightfall.slashing_defense", 0.0, -1.0, 1.0).m_22084_(true));
    public static final RegistryObject<Attribute> PIERCING_DEFENSE = ATTRIBUTES.register("piercing_defense", () -> new RangedAttribute("attribute.name.nightfall.piercing_defense", 0.0, -1.0, 1.0).m_22084_(true));
    public static final RegistryObject<Attribute> FIRE_DEFENSE = ATTRIBUTES.register("fire_defense", () -> new RangedAttribute("attribute.name.nightfall.fire_defense", 0.0, -1.0, 1.0).m_22084_(true));
    public static final RegistryObject<Attribute> FROST_DEFENSE = ATTRIBUTES.register("frost_defense", () -> new RangedAttribute("attribute.name.nightfall.frost_defense", 0.0, -1.0, 1.0).m_22084_(true));
    public static final RegistryObject<Attribute> ELECTRIC_DEFENSE = ATTRIBUTES.register("electric_defense", () -> new RangedAttribute("attribute.name.nightfall.electric_defense", 0.0, -1.0, 1.0).m_22084_(true));
    public static final RegistryObject<Attribute> WITHER_DEFENSE = ATTRIBUTES.register("wither_defense", () -> new RangedAttribute("attribute.name.nightfall.wither_defense", 0.0, -1.0, 1.0));
    public static final RegistryObject<Attribute> POISE = ATTRIBUTES.register("poise", () -> new RangedAttribute("attribute.name.nightfall.poise", 0.0, 0.0, (double)(Poise.values().length - 1)).m_22084_(true));
    public static final RegistryObject<Attribute> BLEEDING_RESISTANCE = ATTRIBUTES.register("bleeding_resistance", () -> new RangedAttribute("attribute.name.nightfall.bleeding_resistance", 0.0, -1.0, 1.0).m_22084_(true));
    public static final RegistryObject<Attribute> POISON_RESISTANCE = ATTRIBUTES.register("poison_resistance", () -> new RangedAttribute("attribute.name.nightfall.poison_resistance", 0.0, -1.0, 1.0).m_22084_(true));

    public static void register() {
        ATTRIBUTES.register(Nightfall.MOD_EVENT_BUS);
    }

    public static int getInventoryCapacity(Player player) {
        if (player.m_7500_() || player.m_5833_()) {
            return 12;
        }
        return (int)Math.round(player.m_21051_((Attribute)INVENTORY_CAPACITY.get()).m_22135_());
    }

    public static int getValue(Player player, PlayerAttribute attribute) {
        return switch (attribute) {
            default -> throw new IncompatibleClassChangeError();
            case PlayerAttribute.VITALITY -> AttributesNF.getVitality((LivingEntity)player);
            case PlayerAttribute.ENDURANCE -> AttributesNF.getEndurance((LivingEntity)player);
            case PlayerAttribute.WILLPOWER -> 10;
            case PlayerAttribute.STRENGTH -> AttributesNF.getStrength((LivingEntity)player);
            case PlayerAttribute.AGILITY -> AttributesNF.getAgility((LivingEntity)player);
            case PlayerAttribute.PERCEPTION -> AttributesNF.getPerception((LivingEntity)player);
        };
    }

    public static int getVitality(LivingEntity entity) {
        return (int)Math.round(entity.m_21051_(Attributes.f_22276_).m_22135_() / 10.0);
    }

    public static int getEndurance(LivingEntity entity) {
        return (int)Math.round(entity.m_21051_((Attribute)ENDURANCE.get()).m_22135_());
    }

    public static int getStrength(LivingEntity entity) {
        return (int)Math.round(entity.m_21051_((Attribute)STRENGTH.get()).m_22135_());
    }

    public static int getAgility(LivingEntity entity) {
        AttributeInstance attribute = entity.m_21051_(Attributes.f_22279_);
        double modifiers = 0.0;
        for (AttributeModifier modifier : attribute.m_22104_(AttributeModifier.Operation.MULTIPLY_BASE)) {
            modifiers += modifier.m_22218_();
        }
        return (int)Math.round(10.0 + (attribute.m_22115_() - 0.1) / 0.005 + modifiers / 0.03);
    }

    public static int getPerception(LivingEntity entity) {
        return (int)Math.round(entity.m_21051_((Attribute)PERCEPTION.get()).m_22135_());
    }

    @Nullable
    public static Attribute getDefense(DamageType type) {
        return switch (type) {
            case DamageType.STRIKING -> (Attribute)STRIKING_DEFENSE.get();
            case DamageType.SLASHING -> (Attribute)SLASHING_DEFENSE.get();
            case DamageType.PIERCING -> (Attribute)PIERCING_DEFENSE.get();
            case DamageType.FIRE -> (Attribute)FIRE_DEFENSE.get();
            case DamageType.FROST -> (Attribute)FROST_DEFENSE.get();
            case DamageType.ELECTRIC -> (Attribute)ELECTRIC_DEFENSE.get();
            case DamageType.WITHER -> (Attribute)WITHER_DEFENSE.get();
            default -> null;
        };
    }

    public static double getMaxStamina(Player player) {
        return player.m_21051_((Attribute)ENDURANCE.get()).m_22135_() * 10.0;
    }

    public static double getMaxEssence(LivingEntity entity) {
        if (entity.m_21051_((Attribute)WILLPOWER.get()) != null) {
            return entity.m_21051_((Attribute)WILLPOWER.get()).m_22135_() * 10.0;
        }
        return 0.0;
    }

    public static double getStaminaRegenMultiplier(Player player) {
        return 1.0 + (player.m_21051_((Attribute)ENDURANCE.get()).m_22135_() - ((Attribute)ENDURANCE.get()).m_22082_()) * 0.05;
    }

    public static float getStrengthMultiplier(LivingEntity entity) {
        if (entity.m_21051_((Attribute)STRENGTH.get()) != null) {
            return (float)(1.0 + (entity.m_21051_((Attribute)STRENGTH.get()).m_22135_() - ((Attribute)STRENGTH.get()).m_22082_()) * 0.05);
        }
        return 1.0f;
    }

    public static int getPerceptionInfluence(LivingEntity entity) {
        AttributeInstance perception = entity.m_21051_((Attribute)PERCEPTION.get());
        if (perception != null) {
            return (int)(perception.m_22135_() - ((Attribute)PERCEPTION.get()).m_22082_());
        }
        return 0;
    }

    public static Poise getPoise(LivingEntity entity) {
        AttributeInstance poise = entity.m_21051_((Attribute)POISE.get());
        if (poise == null) {
            return Poise.NONE;
        }
        double maxPoise = poise.m_22115_();
        for (AttributeModifier modifier : poise.m_22122_()) {
            if (!(modifier.m_22218_() > maxPoise)) continue;
            maxPoise = modifier.m_22218_();
        }
        return Poise.values()[(int)maxPoise];
    }
}

