/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.registry.forge;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.block.Fertility;
import frostnox.nightfall.block.IMetal;
import frostnox.nightfall.block.ISoil;
import frostnox.nightfall.block.IStone;
import frostnox.nightfall.block.ITree;
import frostnox.nightfall.block.Metal;
import frostnox.nightfall.block.Soil;
import frostnox.nightfall.block.SoilCover;
import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.StoneType;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.block.block.BlockNF;
import frostnox.nightfall.block.block.BushBlockNF;
import frostnox.nightfall.block.block.ChairBlock;
import frostnox.nightfall.block.block.ClusterBlock;
import frostnox.nightfall.block.block.CoveredSoilBlock;
import frostnox.nightfall.block.block.DirtBlock;
import frostnox.nightfall.block.block.DoorBlockNF;
import frostnox.nightfall.block.block.DryingUnstableBlock;
import frostnox.nightfall.block.block.FenceBlockNF;
import frostnox.nightfall.block.block.FenceGateBlockNF;
import frostnox.nightfall.block.block.FireBlockNF;
import frostnox.nightfall.block.block.FrazilBlock;
import frostnox.nightfall.block.block.FruitBushBlock;
import frostnox.nightfall.block.block.GlassBlockNF;
import frostnox.nightfall.block.block.GroundItemBlock;
import frostnox.nightfall.block.block.HatchBlock;
import frostnox.nightfall.block.block.HorizontalAxisBlock;
import frostnox.nightfall.block.block.IceBlock;
import frostnox.nightfall.block.block.LadderBlockNF;
import frostnox.nightfall.block.block.LanternBlockNF;
import frostnox.nightfall.block.block.LogBlock;
import frostnox.nightfall.block.block.MeltableBlock;
import frostnox.nightfall.block.block.MoonEssenceBlock;
import frostnox.nightfall.block.block.RopeBlock;
import frostnox.nightfall.block.block.SidingBlock;
import frostnox.nightfall.block.block.SlabBlockNF;
import frostnox.nightfall.block.block.SnowBlock;
import frostnox.nightfall.block.block.SoftFallBlock;
import frostnox.nightfall.block.block.SoilBlock;
import frostnox.nightfall.block.block.SpiderWebBlock;
import frostnox.nightfall.block.block.StairBlockNF;
import frostnox.nightfall.block.block.StoneBlock;
import frostnox.nightfall.block.block.TilledSoilBlock;
import frostnox.nightfall.block.block.TorchBlockNF;
import frostnox.nightfall.block.block.TrapdoorBlockNF;
import frostnox.nightfall.block.block.TroughBlock;
import frostnox.nightfall.block.block.UnstableBlock;
import frostnox.nightfall.block.block.VegetationBlock;
import frostnox.nightfall.block.block.VinesBlockNF;
import frostnox.nightfall.block.block.WallTorchBlockNF;
import frostnox.nightfall.block.block.WardingEffigyBlock;
import frostnox.nightfall.block.block.anvil.MetalAnvilBlock;
import frostnox.nightfall.block.block.anvil.TieredAnvilBlock;
import frostnox.nightfall.block.block.barrel.BarrelBlockNF;
import frostnox.nightfall.block.block.bowl.BowlBlock;
import frostnox.nightfall.block.block.campfire.CampfireBlockNF;
import frostnox.nightfall.block.block.cauldron.CauldronBlockNF;
import frostnox.nightfall.block.block.chest.ChestBlockNF;
import frostnox.nightfall.block.block.crop.CropBlockNF;
import frostnox.nightfall.block.block.crop.DeadCropBlock;
import frostnox.nightfall.block.block.crop.FoodCropBlock;
import frostnox.nightfall.block.block.crucible.CrucibleBlock;
import frostnox.nightfall.block.block.eggnest.DrakefowlEggNestBlock;
import frostnox.nightfall.block.block.fireable.FireableAxisBlock;
import frostnox.nightfall.block.block.fireable.FireableAxisPartialBlock;
import frostnox.nightfall.block.block.fireable.FireableBlock;
import frostnox.nightfall.block.block.fireable.FireableFacingPartialBlock;
import frostnox.nightfall.block.block.fireable.FireablePartialBlock;
import frostnox.nightfall.block.block.fireable.SimpleFireableBlock;
import frostnox.nightfall.block.block.fuel.BurningFuelBlock;
import frostnox.nightfall.block.block.fuel.BurningHorizontalFuelBlock;
import frostnox.nightfall.block.block.fuel.FuelBlock;
import frostnox.nightfall.block.block.fuel.HorizontalFuelBlock;
import frostnox.nightfall.block.block.itemframe.ItemFrameBlock;
import frostnox.nightfall.block.block.liquid.LavaLiquidBlock;
import frostnox.nightfall.block.block.liquid.SizedLiquidBlock;
import frostnox.nightfall.block.block.mold.ItemMoldBlock;
import frostnox.nightfall.block.block.nest.AnchoringResinBlock;
import frostnox.nightfall.block.block.nest.RabbitBurrowBlock;
import frostnox.nightfall.block.block.nest.SkaraNestBlock;
import frostnox.nightfall.block.block.nest.SpiderNestBlock;
import frostnox.nightfall.block.block.pot.PotBlock;
import frostnox.nightfall.block.block.rack.RackBlock;
import frostnox.nightfall.block.block.shelf.ShelfBlock;
import frostnox.nightfall.block.block.sign.StandingSignBlockNF;
import frostnox.nightfall.block.block.sign.WallSignBlockNF;
import frostnox.nightfall.block.block.strangesoil.StrangeSoilBlock;
import frostnox.nightfall.block.block.tree.TreeAquaticSeedBlock;
import frostnox.nightfall.block.block.tree.TreeBranchesBlock;
import frostnox.nightfall.block.block.tree.TreeLeavesBlock;
import frostnox.nightfall.block.block.tree.TreeSeedBlock;
import frostnox.nightfall.block.block.tree.TreeStemBlock;
import frostnox.nightfall.block.block.tree.TreeTrunkBlock;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.item.Armament;
import frostnox.nightfall.registry.forge.FluidsNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.DataUtil;
import frostnox.nightfall.util.LevelUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.IBlockRenderProperties;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlocksNF {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"nightfall");
    public static final Material SOLID_DECORATION = new Material(MaterialColor.f_76398_, false, true, true, false, false, false, PushReaction.NORMAL);
    public static final Material SOLID_NO_COLLISION_DECORATION = new Material(MaterialColor.f_76398_, false, true, false, false, false, false, PushReaction.NORMAL);
    public static final Material SOLID_FLAMMABLE_DECORATION = new Material(MaterialColor.f_76398_, false, true, true, false, true, false, PushReaction.NORMAL);
    public static final Material SOLID_FLAMMABLE_NO_COLLISION_DECORATION = new Material(MaterialColor.f_76398_, false, true, false, false, true, false, PushReaction.NORMAL);
    public static final Material FLAMMABLE_DECORATION = new Material(MaterialColor.f_76398_, false, false, false, false, true, false, PushReaction.NORMAL);
    public static final Material REPLACEABLE_DECORATION = new Material(MaterialColor.f_76398_, false, false, false, false, false, true, PushReaction.DESTROY);
    public static final IBlockRenderProperties NO_BREAK_PARTICLES = new IBlockRenderProperties(){

        public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
            return true;
        }

        public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
            return true;
        }
    };
    public static final Map<SoilCover, RegistryObject<? extends CoveredSoilBlock>> COVERED_SILT = DataUtil.mapEnum(SoilCover.class, cover -> BlocksNF.register(cover.prefix + "_silt", () -> new CoveredSoilBlock((RegistryObject<? extends SoilBlock>)SILT, (RegistryObject<? extends TilledSoilBlock>)TILLED_SILT, Soil.SILT, (SoilCover)((Object)cover), BlockBehaviour.Properties.m_60944_((Material)Material.f_76315_, (MaterialColor)cover.color).m_60913_(Soil.SILT.getStrength() + 0.25f, Soil.SILT.getExplosionResistance()).m_60918_(cover.sound).m_60977_())));
    public static final Map<SoilCover, RegistryObject<? extends CoveredSoilBlock>> COVERED_DIRT = DataUtil.mapEnum(SoilCover.class, cover -> BlocksNF.register(cover.prefix + "_dirt", () -> new CoveredSoilBlock((RegistryObject<? extends SoilBlock>)DIRT, (RegistryObject<? extends TilledSoilBlock>)TILLED_DIRT, Soil.DIRT, (SoilCover)((Object)cover), BlockBehaviour.Properties.m_60944_((Material)Material.f_76315_, (MaterialColor)cover.color).m_60913_(Soil.DIRT.getStrength() + 0.25f, Soil.DIRT.getExplosionResistance()).m_60918_(cover.sound).m_60977_())));
    public static final Map<SoilCover, RegistryObject<? extends CoveredSoilBlock>> COVERED_LOAM = DataUtil.mapEnum(SoilCover.class, cover -> BlocksNF.register(cover.prefix + "_loam", () -> new CoveredSoilBlock((RegistryObject<? extends SoilBlock>)LOAM, (RegistryObject<? extends TilledSoilBlock>)TILLED_LOAM, Soil.LOAM, (SoilCover)((Object)cover), BlockBehaviour.Properties.m_60944_((Material)Material.f_76315_, (MaterialColor)cover.color).m_60913_(Soil.LOAM.getStrength() + 0.25f, Soil.LOAM.getExplosionResistance()).m_60918_(cover.sound).m_60977_())));
    public static final RegistryObject<SoilBlock> SILT = BlocksNF.register(Soil.SILT.getName() + "_block", () -> new SoilBlock(Soil.SILT.getSlideSound(), COVERED_SILT, TILLED_SILT, BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)Soil.SILT.getBaseColor()).m_60913_(Soil.SILT.getStrength(), Soil.SILT.getExplosionResistance()).m_60977_().m_60918_(Soil.SILT.getSound())));
    public static final RegistryObject<DirtBlock> DIRT = BlocksNF.register(Soil.DIRT.getName() + "_block", () -> new DirtBlock(Soil.DIRT.getSlideSound(), COVERED_DIRT, TILLED_DIRT, BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)Soil.DIRT.getBaseColor()).m_60913_(Soil.DIRT.getStrength(), Soil.DIRT.getExplosionResistance()).m_60977_().m_60918_(Soil.DIRT.getSound())));
    public static final RegistryObject<SoilBlock> LOAM = BlocksNF.register(Soil.LOAM.getName() + "_block", () -> new SoilBlock(Soil.LOAM.getSlideSound(), COVERED_LOAM, TILLED_LOAM, BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)Soil.LOAM.getBaseColor()).m_60913_(Soil.LOAM.getStrength(), Soil.LOAM.getExplosionResistance()).m_60977_().m_60918_(Soil.LOAM.getSound())));
    public static final RegistryObject<UnstableBlock> ASH = BlocksNF.soil(Soil.ASH);
    public static final RegistryObject<UnstableBlock> GRAVEL = BlocksNF.soil(Soil.GRAVEL);
    public static final RegistryObject<UnstableBlock> BLUE_GRAVEL = BlocksNF.soil(Soil.BLUE_GRAVEL);
    public static final RegistryObject<UnstableBlock> BLACK_GRAVEL = BlocksNF.soil(Soil.BLACK_GRAVEL);
    public static final RegistryObject<UnstableBlock> SAND = BlocksNF.soil(Soil.SAND);
    public static final RegistryObject<UnstableBlock> RED_SAND = BlocksNF.soil(Soil.RED_SAND);
    public static final RegistryObject<UnstableBlock> WHITE_SAND = BlocksNF.soil(Soil.WHITE_SAND);
    public static final RegistryObject<TilledSoilBlock> TILLED_SILT = BlocksNF.tilledSoil(Soil.SILT, 0.0f, 0.5f, 1.0f, SILT);
    public static final RegistryObject<TilledSoilBlock> TILLED_DIRT = BlocksNF.tilledSoil(Soil.DIRT, 0.125f, 0.5f, 1.0f, DIRT);
    public static final RegistryObject<TilledSoilBlock> TILLED_LOAM = BlocksNF.tilledSoil(Soil.LOAM, 0.25f, 0.5f, 1.0f, LOAM);
    public static final Map<Soil, RegistryObject<StrangeSoilBlock>> STRANGE_SOILS = DataUtil.mapEnum(Soil.class, soil -> BlocksNF.register("strange_" + soil.getName(), () -> new StrangeSoilBlock(soil.getSlideSound(), (Supplier<? extends Block>)Soil.getBlock(soil), BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)soil.getBaseColor()).m_60913_(soil.getStrength(), soil.getExplosionResistance()).m_60918_(soil.getSound()))));
    public static final RegistryObject<SnowBlock> SNOW = BLOCKS.register("snow", () -> new SnowBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76308_).m_60978_(0.1f).m_60910_().m_60999_().m_60977_().m_60918_(SoundType.f_56747_)));
    public static final RegistryObject<MeltableBlock> PACKED_SNOW = BLOCKS.register("packed_snow", () -> new MeltableBlock((Supplier<? extends Block>)WATER, 0.3f, BlockBehaviour.Properties.m_60939_((Material)Material.f_76280_).m_60978_(2.0f).m_60999_().m_60977_().m_60918_(SoundType.f_56747_)));
    public static final RegistryObject<UnstableBlock> MUD = BLOCKS.register("mud_block", () -> new UnstableBlock((Supplier<SoundEvent>)SoundsNF.WET_SOIL_FALL, BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)MaterialColor.f_76384_).m_60978_(Soil.DIRT.getStrength() + 0.2f).m_60956_(0.6f).m_60967_(0.6f).m_60918_(SoundsNF.MUD_TYPE)));
    public static final RegistryObject<SimpleFireableBlock> CLAY = BLOCKS.register("clay_block", () -> new SimpleFireableBlock(9600, TieredHeat.ORANGE, TERRACOTTA, BlockBehaviour.Properties.m_60939_((Material)Material.f_76313_).m_60978_(1.5f).m_60918_(SoundsNF.MUD_TYPE)));
    public static final RegistryObject<Block> FIRE_CLAY = BLOCKS.register("fire_clay_block", () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76313_, (MaterialColor)MaterialColor.f_76386_).m_60978_(1.5f).m_60918_(SoundType.f_56739_)));
    public static final RegistryObject<Block> BEDROCK = BLOCKS.register("bedrock", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60913_(-1.0f, 3600000.0f).m_60993_()));
    public static final RegistryObject<IceBlock> ICE = BLOCKS.register("ice", () -> new IceBlock((Supplier<? extends Block>)WATER, 0.22f, BlockBehaviour.Properties.m_60939_((Material)Material.f_76276_).m_60978_(1.5f).m_60993_().m_60955_().m_60911_(0.96f).m_60977_().m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<IceBlock> SEA_ICE = BLOCKS.register("sea_ice", () -> new IceBlock((Supplier<? extends Block>)SEAWATER, 0.07f, BlockBehaviour.Properties.m_60939_((Material)Material.f_76316_).m_60978_(2.0f).m_60993_().m_60911_(0.96f).m_60977_().m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<FrazilBlock> FRAZIL = BLOCKS.register("frazil", () -> new FrazilBlock(0.22f, BlockBehaviour.Properties.m_60939_((Material)REPLACEABLE_DECORATION).m_60993_().m_60955_().m_60910_().m_60966_().m_60977_().m_60918_(SoundType.f_56747_)));
    public static final RegistryObject<FrazilBlock> SEA_FRAZIL = BLOCKS.register("sea_frazil", () -> new FrazilBlock(0.07f, BlockBehaviour.Properties.m_60939_((Material)REPLACEABLE_DECORATION).m_60993_().m_60955_().m_60910_().m_60966_().m_60977_().m_60918_(SoundType.f_56747_)));
    public static final RegistryObject<GroundItemBlock> SEASHELL = BLOCKS.register("seashell", () -> new GroundItemBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_().m_60918_(SoundsNF.SEASHELL_TYPE)));
    public static final RegistryObject<FireBlockNF> FIRE = BLOCKS.register("fire", () -> new FireBlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76309_, (MaterialColor)MaterialColor.f_76402_).m_60910_().m_60966_().m_60993_().m_60953_(state -> 15).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<SizedLiquidBlock> WATER = BLOCKS.register("water", () -> new SizedLiquidBlock((Supplier<? extends FlowingFluid>)FluidsNF.WATER, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_60993_()));
    public static final RegistryObject<SizedLiquidBlock> SEAWATER = BLOCKS.register("seawater", () -> new SizedLiquidBlock((Supplier<? extends FlowingFluid>)FluidsNF.SEAWATER, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_60993_()));
    public static final RegistryObject<LavaLiquidBlock> LAVA = BLOCKS.register("lava", () -> new LavaLiquidBlock((Supplier<? extends FlowingFluid>)FluidsNF.LAVA, BlockBehaviour.Properties.m_60939_((Material)Material.f_76307_).m_60910_().m_60978_(100.0f).m_60993_().m_60977_().m_60953_(state -> 15)));
    public static final RegistryObject<VegetationBlock> SHORT_GRASS = BLOCKS.register("short_grass", () -> new VegetationBlock(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), 3000, 0.0f, 1.0f, 0.0f, 1.0f, false, BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60978_(0.6f).m_60910_().m_60918_(SoundType.f_154674_)));
    public static final RegistryObject<VegetationBlock> GRASS = BLOCKS.register("grass", () -> new VegetationBlock(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), 3000, 0.0f, 1.0f, 0.03f, 1.0f, false, BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60978_(0.7f).m_60910_().m_60918_(SoundType.f_154674_)));
    public static final RegistryObject<VegetationBlock> TALL_GRASS = BLOCKS.register("tall_grass", () -> new VegetationBlock(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), 3000, 0.42f, 0.58f, 0.05f, 0.3f, false, BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60978_(0.8f).m_60910_().m_60918_(SoundType.f_154674_)));
    public static final RegistryObject<VegetationBlock> SMALL_FERN = BLOCKS.register("small_fern", () -> new VegetationBlock(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), 200, 0.05f, 0.95f, 0.68f, 1.0f, true, BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60978_(0.6f).m_60910_().m_60918_(SoundType.f_154674_)));
    public static final RegistryObject<VegetationBlock> FERN = BLOCKS.register("fern", () -> new VegetationBlock(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), 150, 0.05f, 0.95f, 0.72f, 1.0f, true, BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60978_(0.7f).m_60910_().m_60918_(SoundType.f_154674_)));
    public static final RegistryObject<VegetationBlock> LARGE_FERN = BLOCKS.register("large_fern", () -> new VegetationBlock(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), 90, 0.05f, 0.95f, 0.75f, 1.0f, true, BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60978_(0.8f).m_60910_().m_60918_(SoundType.f_154674_)));
    public static final RegistryObject<VinesBlockNF> VINES = BLOCKS.register("vines", () -> new VinesBlockNF(BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60978_(0.6f).m_60910_().m_60977_().m_60918_(SoundType.f_56760_)));
    public static final RegistryObject<BushBlockNF> DEAD_BUSH = BLOCKS.register("dead_bush", () -> new BushBlockNF(Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_154673_)));
    public static final RegistryObject<BushBlockNF> DEAD_PLANT = BLOCKS.register("dead_plant", () -> new BushBlockNF(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60993_().m_60978_(0.6f).m_60918_(SoundType.f_154673_)));
    public static final RegistryObject<DeadCropBlock> DEAD_CROP = BLOCKS.register("dead_crop", () -> new DeadCropBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60993_().m_60978_(0.6f).m_60918_(SoundType.f_154673_)));
    public static final RegistryObject<CropBlockNF> POTATOES = BLOCKS.register("potatoes", () -> new CropBlockNF(Fertility.FAIR, 0.375f, 1.0f, 0.35f, 0.9f, 11, 21000, (Supplier<? extends Item>)ItemsNF.POTATO_SEEDS, false, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60978_(0.6f).m_60918_(SoundType.f_56758_)));
    public static final RegistryObject<FoodCropBlock> CARROTS = BLOCKS.register("carrots", () -> new FoodCropBlock(Fertility.POOR, 0.25f, 1.0f, 0.2f, 0.85f, 8, 18000, (Supplier<? extends Item>)ItemsNF.CARROT_SEEDS, false, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60978_(0.6f).m_60918_(SoundType.f_56758_)));
    public static final RegistryObject<CropBlockNF> FLAX = BLOCKS.register("flax", () -> new CropBlockNF(Fertility.POOR, 0.05f, 0.85f, 0.1f, 1.0f, 13, 24000, (Supplier<? extends Item>)ItemsNF.FLAX_SEEDS, false, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60978_(0.6f).m_60918_(SoundType.f_56758_)));
    public static final RegistryObject<CropBlockNF> YARROW = BLOCKS.register("yarrow", () -> new CropBlockNF(Fertility.POOR, 0.1f, 0.8f, 0.1f, 1.0f, 11, 18000, (Supplier<? extends Item>)ItemsNF.YARROW_SEEDS, true, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60978_(0.6f).m_60918_(SoundType.f_56758_)));
    public static final RegistryObject<FruitBushBlock> BERRY_BUSH = BLOCKS.register("berry_bush", () -> new FruitBushBlock(0.1f, 0.9f, 0.1f, 0.9f, 8, 96000, (Supplier<? extends Item>)ItemsNF.BERRIES, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60978_(3.0f).m_60956_(0.8f).m_60967_(0.9f).m_60918_(SoundType.f_56757_)));
    public static final Map<Stone, RegistryObject<StoneBlock>> STONE_BLOCKS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.register(stone.getName(), () -> new StoneBlock((IStone)stone, (RegistryObject<? extends TieredAnvilBlock>)ANVILS_STONE.get(stone), BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)stone.getBaseColor()).m_60999_().m_60913_(stone.getStrength(), stone.getExplosionResistance()).m_60918_(stone.getSound()))));
    private static final VoxelShape ROCK_SHAPE_12 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    private static final VoxelShape ROCK_SHAPE_34 = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);
    public static final Map<Stone, RegistryObject<ClusterBlock>> ROCK_CLUSTERS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.register(stone.getName() + "_rocks", () -> new ClusterBlock((Supplier)ItemsNF.ROCKS.get(stone), BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56742_), ROCK_SHAPE_12, ROCK_SHAPE_12, ROCK_SHAPE_34, ROCK_SHAPE_34)));
    public static final RegistryObject<ClusterBlock> FLINT_CLUSTER = BlocksNF.register("flint_rocks", () -> new ClusterBlock((Supplier<? extends Item>)ItemsNF.FLINT, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56742_), ROCK_SHAPE_12, ROCK_SHAPE_12, ROCK_SHAPE_34, ROCK_SHAPE_34));
    public static final Map<Stone, RegistryObject<Block>> TIN_ORES = DataUtil.mapEnum(Stone.class, stone -> stone == Stone.PUMICE || stone == Stone.MOONSTONE, stone -> BlocksNF.register(stone.getName() + "_tin_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)STONE_BLOCKS.get(stone).get())))));
    public static final Map<Stone, RegistryObject<Block>> COPPER_ORES = DataUtil.mapEnum(Stone.class, stone -> stone == Stone.PUMICE || stone == Stone.MOONSTONE, stone -> BlocksNF.register(stone.getName() + "_copper_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)STONE_BLOCKS.get(stone).get())))));
    public static final Map<Stone, RegistryObject<Block>> AZURITE_ORES = DataUtil.mapEnum(Stone.class, stone -> stone == Stone.PUMICE || stone == Stone.MOONSTONE, stone -> BlocksNF.register(stone.getName() + "_azurite_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)STONE_BLOCKS.get(stone).get())))));
    public static final Map<Stone, RegistryObject<Block>> HEMATITE_ORES = DataUtil.mapEnum(Stone.class, stone -> stone == Stone.PUMICE || stone == Stone.MOONSTONE, stone -> BlocksNF.register(stone.getName() + "_hematite_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)STONE_BLOCKS.get(stone).get())))));
    public static final Map<Stone, RegistryObject<Block>> COAL_ORES = DataUtil.mapEnum(Stone.class, stone -> stone == Stone.PUMICE || stone == Stone.MOONSTONE, stone -> BlocksNF.register(stone.getName() + "_coal_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)STONE_BLOCKS.get(stone).get())))));
    public static final Map<Stone, RegistryObject<Block>> HALITE_ORES = DataUtil.mapEnum(Stone.class, stone -> stone.getType() != StoneType.SEDIMENTARY, stone -> BlocksNF.register(stone.getName() + "_halite_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)STONE_BLOCKS.get(stone).get())))));
    public static final RegistryObject<Block> METEORITE_ORE = BLOCKS.register("meteorite_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)STONE_BLOCKS.get(Stone.MOONSTONE).get()))));
    public static final RegistryObject<Block> OBSIDIAN = BLOCKS.register("obsidian", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60999_().m_60913_(55.0f, 1200.0f)));
    public static final Map<Tree, RegistryObject<LogBlock>> LOGS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_log", () -> new LogBlock(STRIPPED_LOGS.get(tree), ANVILS_LOG.get(tree), BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, state -> state.m_61143_((Property)LogBlock.f_55923_) == Direction.Axis.Y ? tree.getBaseColor() : tree.getBarkColor()).m_60913_(tree.getStrength(), tree.getExplosionResistance()).m_60918_(tree.getSound()))));
    public static final Map<Tree, RegistryObject<TreeStemBlock>> STEMS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_stem", () -> new TreeStemBlock((ITree)tree, BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, state -> state.m_61143_(TreeStemBlock.TYPE) != TreeStemBlock.Type.TOP && state.m_61143_(TreeStemBlock.TYPE) != TreeStemBlock.Type.ROTATED_TOP ? tree.getBarkColor() : (state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? tree.getBaseColor() : tree.getBarkColor())).m_60913_(tree.getStrength(), tree.getExplosionResistance()).m_60918_(tree.getSound())){

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    }));
    public static final Map<Tree, RegistryObject<RotatedPillarBlock>> STRIPPED_LOGS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register("stripped_" + tree.getName() + "_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)tree.getBaseColor()).m_60913_(tree.getStrength(), tree.getExplosionResistance()).m_60918_(tree.getSound())){

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    }));
    public static final Map<Tree, RegistryObject<TreeLeavesBlock>> LEAVES = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_leaves", () -> new TreeLeavesBlock((ITree)tree, BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60978_(1.0f).m_60956_(0.6f).m_60967_(0.9f).m_60918_(SoundType.f_154674_).m_60988_().m_60955_().m_60960_(BlocksNF::never).m_60971_(BlocksNF::never))));
    public static final Map<Tree, RegistryObject<TreeLeavesBlock>> FRUIT_LEAVES = DataUtil.mapEnum(Tree.class, tree -> tree != Tree.JUNGLE && tree != Tree.OAK && tree != Tree.PALM, tree -> BlocksNF.register(tree.getName() + "_fruit_leaves", () -> new TreeLeavesBlock((ITree)tree, BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60978_(1.0f).m_60956_(0.6f).m_60967_(0.9f).m_60918_(SoundType.f_154674_).m_60988_().m_60955_().m_60960_(BlocksNF::never).m_60971_(BlocksNF::never))));
    public static final Map<Tree, RegistryObject<TreeBranchesBlock>> BRANCHES = DataUtil.mapEnum(Tree.class, tree -> !tree.isDeciduous(), tree -> BlocksNF.register(tree.getName() + "_branches", () -> new TreeBranchesBlock((ITree)tree, BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60978_(1.0f).m_60956_(0.6f).m_60967_(0.9f).m_60918_(SoundType.f_154674_).m_60988_().m_60955_().m_60960_(BlocksNF::never).m_60971_(BlocksNF::never))));
    public static final Map<Tree, RegistryObject<TreeTrunkBlock>> TRUNKS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_trunk", () -> new TreeTrunkBlock((TreeStemBlock)((Object)((Object)((Object)STEMS.get(tree).get()))), (TreeLeavesBlock)LEAVES.get(tree).get(), BRANCHES.containsKey(tree) ? (TreeBranchesBlock)BRANCHES.get(tree).get() : null, FRUIT_LEAVES.containsKey(tree) ? (TreeLeavesBlock)FRUIT_LEAVES.get(tree).get() : null, tree.getGenerator(), BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)tree.getBaseColor()).m_60913_(tree.getStrength(), tree.getExplosionResistance()).m_60918_(SoundType.f_56736_).m_60977_())));
    public static final Map<Tree, RegistryObject<TreeSeedBlock>> TREE_SEEDS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_seed", () -> tree != Tree.CAEDTAR ? new TreeSeedBlock((TreeTrunkBlock)TRUNKS.get(tree).get(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60978_(0.4f).m_60910_().m_60977_().m_60918_(SoundType.f_154674_)) : new TreeAquaticSeedBlock((TreeTrunkBlock)TRUNKS.get(tree).get(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60978_(0.4f).m_60910_().m_60977_().m_60918_(SoundType.f_154674_))));
    public static final Map<Tree, RegistryObject<Block>> PLANK_BLOCKS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_planks", () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)tree.getBaseColor()).m_60913_(tree.getStrength() * 0.8f, tree.getExplosionResistance() * 0.8f).m_60918_(SoundType.f_56736_)){

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }
    }));
    public static final Map<Tree, RegistryObject<StairBlockNF>> PLANK_STAIRS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.stairs(tree.getName(), PLANK_BLOCKS.get(tree)));
    public static final Map<Tree, RegistryObject<SlabBlockNF>> PLANK_SLABS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.slab(tree.getName(), PLANK_BLOCKS.get(tree)));
    public static final Map<Tree, RegistryObject<SidingBlock>> PLANK_SIDINGS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.siding(tree.getName(), PLANK_BLOCKS.get(tree)));
    public static final Map<Tree, RegistryObject<FenceBlockNF>> PLANK_FENCES = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_fence", () -> new FenceBlockNF(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PLANK_BLOCKS.get(tree).get()))){

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }
    }));
    public static final Map<Tree, RegistryObject<FenceGateBlockNF>> PLANK_FENCE_GATES = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_fence_gate", () -> new FenceGateBlockNF(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PLANK_BLOCKS.get(tree).get()))){

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }
    }));
    public static final Map<Tree, RegistryObject<DoorBlockNF>> PLANK_DOORS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_door", () -> new DoorBlockNF(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PLANK_BLOCKS.get(tree).get())).m_60955_(), () -> SoundEvents.f_12627_, () -> SoundEvents.f_12626_){

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }
    }));
    public static final Map<Tree, RegistryObject<TrapdoorBlockNF>> PLANK_TRAPDOORS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_trapdoor", () -> new TrapdoorBlockNF(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PLANK_BLOCKS.get(tree).get())).m_60955_(), () -> SoundEvents.f_12629_, () -> SoundEvents.f_12628_){

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }
    }));
    public static final Map<Tree, RegistryObject<HatchBlock>> PLANK_HATCHES = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_hatch", () -> new HatchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PLANK_BLOCKS.get(tree).get())).m_60955_(), () -> SoundEvents.f_12629_, () -> SoundEvents.f_12628_){

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }
    }));
    public static final Map<Tree, RegistryObject<LadderBlockNF>> PLANK_LADDERS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_ladder", () -> new LadderBlockNF(BlockBehaviour.Properties.m_60939_((Material)SOLID_FLAMMABLE_DECORATION).m_60978_(0.4f).m_60918_(SoundType.f_56748_).m_60955_()){

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }
    }));
    public static final Map<Tree, RegistryObject<StandingSignBlockNF>> PLANK_STANDING_SIGNS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_standing_sign", () -> new StandingSignBlockNF(BlockBehaviour.Properties.m_60944_((Material)SOLID_FLAMMABLE_NO_COLLISION_DECORATION, (MaterialColor)tree.getBaseColor()).m_60910_().m_60978_(1.5f).m_60918_(SoundType.f_56736_), (ITree)tree)));
    public static final Map<Tree, RegistryObject<WallSignBlockNF>> PLANK_WALL_SIGNS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_wall_sign", () -> new WallSignBlockNF(BlockBehaviour.Properties.m_60944_((Material)SOLID_FLAMMABLE_NO_COLLISION_DECORATION, (MaterialColor)tree.getBaseColor()).m_60910_().m_60978_(1.5f).m_60918_(SoundType.f_56736_), (ITree)tree)));
    public static final Map<Tree, RegistryObject<ItemFrameBlock>> WOODEN_ITEM_FRAMES = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_item_frame", () -> new ItemFrameBlock(BlockBehaviour.Properties.m_60939_((Material)SOLID_FLAMMABLE_NO_COLLISION_DECORATION).m_60910_().m_60913_(tree.getStrength() * 0.5f, tree.getExplosionResistance() * 0.5f).m_60918_(SoundType.f_56736_)){

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }
    }));
    public static final Map<Stone, RegistryObject<Block>> TILED_STONE = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.register("tiled_" + stone.getName(), () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)stone.getBaseColor()).m_60913_(stone.getStrength(), stone.getExplosionResistance()).m_60918_(stone.getSound()))));
    public static final Map<Stone, RegistryObject<Block>> POLISHED_STONE = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.register("polished_" + stone.getName(), () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)stone.getBaseColor()).m_60913_(stone.getStrength(), stone.getExplosionResistance()).m_60918_(stone.getSound()))));
    public static final Map<Stone, RegistryObject<StairBlockNF>> POLISHED_STONE_STAIRS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.stairs("polished_" + stone.getName(), POLISHED_STONE.get(stone)));
    public static final Map<Stone, RegistryObject<SlabBlockNF>> POLISHED_STONE_SLABS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.slab("polished_" + stone.getName(), POLISHED_STONE.get(stone)));
    public static final Map<Stone, RegistryObject<SidingBlock>> POLISHED_STONE_SIDINGS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.siding("polished_" + stone.getName(), POLISHED_STONE.get(stone)));
    public static final Map<Stone, RegistryObject<Block>> STACKED_STONE = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.register("stacked_" + stone.getName(), () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)stone.getBaseColor()).m_60913_(stone.getStrength() * 0.8f, stone.getExplosionResistance() * 0.8f).m_60918_(stone.getSound()))));
    public static final Map<Stone, RegistryObject<StairBlockNF>> STACKED_STONE_STAIRS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.stairs("stacked_" + stone.getName(), STACKED_STONE.get(stone)));
    public static final Map<Stone, RegistryObject<SlabBlockNF>> STACKED_STONE_SLABS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.slab("stacked_" + stone.getName(), STACKED_STONE.get(stone)));
    public static final Map<Stone, RegistryObject<SidingBlock>> STACKED_STONE_SIDINGS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.siding("stacked_" + stone.getName(), STACKED_STONE.get(stone)));
    public static final Map<Stone, RegistryObject<Block>> COBBLED_STONE = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.register("cobbled_" + stone.getName(), () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)stone.getBaseColor()).m_60913_(stone.getStrength() * 0.8f, stone.getExplosionResistance() * 0.8f).m_60918_(stone.getSound()))));
    public static final Map<Stone, RegistryObject<StairBlockNF>> COBBLED_STONE_STAIRS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.stairs("cobbled_" + stone.getName(), COBBLED_STONE.get(stone)));
    public static final Map<Stone, RegistryObject<SlabBlockNF>> COBBLED_STONE_SLABS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.slab("cobbled_" + stone.getName(), COBBLED_STONE.get(stone)));
    public static final Map<Stone, RegistryObject<SidingBlock>> COBBLED_STONE_SIDINGS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.siding("cobbled_" + stone.getName(), COBBLED_STONE.get(stone)));
    public static final Map<Stone, RegistryObject<Block>> STONE_BRICK_BLOCKS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.register(stone.getName() + "_bricks", () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)stone.getBaseColor()).m_60913_(stone.getStrength() * 1.5f, stone.getExplosionResistance() * 1.5f).m_60918_(stone.getSound()))));
    public static final Map<Stone, RegistryObject<StairBlockNF>> STONE_BRICK_STAIRS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.stairs(stone.getName() + "_brick", STONE_BRICK_BLOCKS.get(stone)));
    public static final Map<Stone, RegistryObject<SlabBlockNF>> STONE_BRICK_SLABS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.slab(stone.getName() + "_brick", STONE_BRICK_BLOCKS.get(stone)));
    public static final Map<Stone, RegistryObject<SidingBlock>> STONE_BRICK_SIDINGS = DataUtil.mapEnum(Stone.class, stone -> BlocksNF.siding(stone.getName() + "_brick", STONE_BRICK_BLOCKS.get(stone)));
    public static final RegistryObject<Block> TERRACOTTA = BLOCKS.register("terracotta", () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76373_).m_60913_(2.0f, 3.0f).m_60918_(SoundsNF.TERRACOTTA_TYPE)));
    public static final RegistryObject<Block> TERRACOTTA_TILES = BLOCKS.register("terracotta_tiles", () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76373_).m_60913_(1.6f, 2.4f).m_60918_(SoundsNF.CERAMIC_TYPE)));
    public static final RegistryObject<StairBlockNF> TERRACOTTA_TILE_STAIRS = BlocksNF.stairs("terracotta_tile", TERRACOTTA_TILES);
    public static final RegistryObject<SlabBlockNF> TERRACOTTA_TILE_SLAB = BlocksNF.slab("terracotta_tile", TERRACOTTA_TILES);
    public static final RegistryObject<SidingBlock> TERRACOTTA_TILE_SIDING = BlocksNF.siding("terracotta_tile", TERRACOTTA_TILES);
    public static final RegistryObject<Block> TERRACOTTA_MOSAIC = BLOCKS.register("terracotta_mosaic", () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76373_).m_60913_(1.6f, 2.4f).m_60918_(SoundsNF.CERAMIC_TYPE)));
    public static final RegistryObject<StairBlockNF> TERRACOTTA_MOSAIC_STAIRS = BlocksNF.stairs(TERRACOTTA_MOSAIC);
    public static final RegistryObject<SlabBlockNF> TERRACOTTA_MOSAIC_SLAB = BlocksNF.slab(TERRACOTTA_MOSAIC);
    public static final RegistryObject<SidingBlock> TERRACOTTA_MOSAIC_SIDING = BlocksNF.siding(TERRACOTTA_MOSAIC);
    public static final RegistryObject<Block> MUD_BRICKS = BLOCKS.register("mud_bricks", () -> new BlockNF(BlockBehaviour.Properties.m_60939_((Material)Material.f_76314_).m_60978_(5.0f).m_60918_(SoundType.f_154661_)));
    public static final RegistryObject<StairBlockNF> MUD_BRICK_STAIRS = BlocksNF.stairs("mud_brick", MUD_BRICKS);
    public static final RegistryObject<SlabBlockNF> MUD_BRICK_SLAB = BlocksNF.slab("mud_brick", MUD_BRICKS);
    public static final RegistryObject<SidingBlock> MUD_BRICK_SIDING = BlocksNF.siding("mud_brick", MUD_BRICKS);
    public static final RegistryObject<Block> BRICKS = BLOCKS.register("bricks", () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76386_).m_60978_(8.0f).m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<StairBlockNF> BRICK_STAIRS = BlocksNF.stairs("brick", BRICKS);
    public static final RegistryObject<SlabBlockNF> BRICK_SLAB = BlocksNF.slab("brick", BRICKS);
    public static final RegistryObject<SidingBlock> BRICK_SIDING = BlocksNF.siding("brick", BRICKS);
    public static final RegistryObject<Block> FIRE_BRICKS = BLOCKS.register("fire_bricks", () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76391_).m_60978_(10.0f).m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<StairBlockNF> FIRE_BRICK_STAIRS = BlocksNF.stairs("fire_brick", FIRE_BRICKS);
    public static final RegistryObject<SlabBlockNF> FIRE_BRICK_SLAB = BlocksNF.slab("fire_brick", FIRE_BRICKS);
    public static final RegistryObject<SidingBlock> FIRE_BRICK_SIDING = BlocksNF.siding("fire_brick", FIRE_BRICKS);
    public static final RegistryObject<SoftFallBlock> THATCH = BLOCKS.register("thatch", () -> new SoftFallBlock(3.0f, 1.0f, BlockBehaviour.Properties.m_60944_((Material)Material.f_76315_, (MaterialColor)MaterialColor.f_76366_).m_60978_(2.0f).m_60956_(0.8f).m_60918_(SoundType.f_56740_)){

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }
    });
    public static final RegistryObject<StairBlockNF> THATCH_STAIRS = BlocksNF.stairs(THATCH);
    public static final RegistryObject<SlabBlockNF> THATCH_SLAB = BlocksNF.slab(THATCH);
    public static final RegistryObject<SidingBlock> THATCH_SIDING = BlocksNF.siding(THATCH);
    public static final RegistryObject<GlassBlockNF> GLASS_BLOCK = BLOCKS.register("glass_block", () -> new GlassBlockNF(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(1.5f, 1.0f).m_60993_().m_60955_().m_60971_(BlocksNF::never).m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<SlabBlockNF> GLASS_SLAB = BlocksNF.slab("glass", GLASS_BLOCK);
    public static final RegistryObject<SidingBlock> GLASS_SIDING = BlocksNF.siding("glass", GLASS_BLOCK);
    public static final RegistryObject<DryingUnstableBlock> WET_MUD_BRICKS = BLOCKS.register("wet_mud_bricks", () -> new DryingUnstableBlock((Supplier<? extends Block>)MUD_BRICKS, 48000, 10, (Supplier<SoundEvent>)SoundsNF.WET_SOIL_FALL, BlocksNF.fullCopy((Block)MUD.get()).m_60956_(1.0f).m_60967_(1.0f)));
    public static final RegistryObject<FireableBlock> CLAY_BRICKS = BLOCKS.register("clay_bricks", () -> new SimpleFireableBlock(9600, TieredHeat.ORANGE, BRICKS, BlocksNF.fullCopy((Block)CLAY.get())));
    public static final RegistryObject<FireableBlock> FIRE_CLAY_BRICKS = BLOCKS.register("fire_clay_bricks", () -> new SimpleFireableBlock(9600, TieredHeat.YELLOW, FIRE_BRICKS, BlocksNF.fullCopy((Block)FIRE_CLAY.get())));
    public static final RegistryObject<TorchBlockNF> TORCH = BLOCKS.register("torch", () -> new TorchBlockNF(true, (Supplier<? extends Block>)TORCH_UNLIT, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_().m_60977_().m_60953_(state -> 15).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<TorchBlockNF> TORCH_UNLIT = BLOCKS.register("torch_unlit", () -> new TorchBlockNF(false, (Supplier<? extends Block>)TORCH, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_().m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<WallTorchBlockNF> WALL_TORCH = BLOCKS.register("wall_torch", () -> new WallTorchBlockNF(true, (Supplier<? extends Block>)WALL_TORCH_UNLIT, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().lootFrom(TORCH).m_60966_().m_60977_().m_60953_(state -> 15).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<WallTorchBlockNF> WALL_TORCH_UNLIT = BLOCKS.register("wall_torch_unlit", () -> new WallTorchBlockNF(false, (Supplier<? extends Block>)WALL_TORCH, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().lootFrom(TORCH_UNLIT).m_60966_().m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<RopeBlock> ROPE = BLOCKS.register("rope", () -> new RopeBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.2f).m_60910_().m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<BowlBlock> WOODEN_BOWL = BLOCKS.register("wooden_bowl", () -> new BowlBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.2f).m_60910_().m_60955_().m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<CampfireBlockNF> CAMPFIRE = BLOCKS.register("campfire", () -> new CampfireBlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76370_).m_60966_().m_60953_(BlocksNF.litBlockEmission(15)).m_60955_().m_60988_().m_60918_(SoundsNF.FIREWOOD_TYPE)));
    public static final RegistryObject<CauldronBlockNF> CAULDRON = BLOCKS.register("cauldron", () -> new CauldronBlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76384_).m_60978_(2.0f).m_60918_(SoundsNF.CERAMIC_VESSEL_TYPE)));
    public static final RegistryObject<FireableAxisPartialBlock> UNFIRED_CAULDRON = BLOCKS.register("unfired_cauldron", () -> new FireableAxisPartialBlock(9600, TieredHeat.ORANGE, CAULDRON, 0, BlockBehaviour.Properties.m_60939_((Material)Material.f_76313_).m_60913_(1.0f, 1.0f).m_60918_(SoundType.f_56739_)));
    public static final RegistryObject<PotBlock> POT = BLOCKS.register("pot", () -> new PotBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76384_).m_60978_(2.5f).m_60918_(SoundsNF.CERAMIC_VESSEL_TYPE)));
    public static final RegistryObject<FireablePartialBlock> UNFIRED_POT = BLOCKS.register("unfired_pot", () -> new FireablePartialBlock(9600, TieredHeat.ORANGE, POT, 0, BlockBehaviour.Properties.m_60939_((Material)Material.f_76313_).m_60913_(1.0f, 1.0f).m_60918_(SoundType.f_56739_)));
    public static final RegistryObject<WardingEffigyBlock> WARDING_EFFIGY = BLOCKS.register("warding_effigy", () -> new WardingEffigyBlock(BlockBehaviour.Properties.m_60939_((Material)SOLID_DECORATION).m_60978_(1.0f).m_60918_(SoundType.f_56720_)));
    public static final Map<Tree, RegistryObject<BarrelBlockNF>> BARRELS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_barrel", () -> new BarrelBlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)tree.getBaseColor()).m_60913_(tree.getStrength() * 2.0f, tree.getExplosionResistance() * 2.0f).m_60918_(SoundType.f_56736_))));
    public static final Map<Tree, RegistryObject<ChestBlockNF>> CHESTS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_chest", () -> new ChestBlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)tree.getBaseColor()).m_60913_(tree.getStrength(), tree.getExplosionResistance()).m_60918_(SoundType.f_56736_), (ITree)tree)));
    public static final Map<Tree, RegistryObject<RackBlock>> RACKS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_rack", () -> new RackBlock(BlockBehaviour.Properties.m_60939_((Material)SOLID_FLAMMABLE_DECORATION).m_60955_().m_60910_().m_60913_(tree.getStrength() * 0.5f, tree.getExplosionResistance() * 0.5f).m_60918_(SoundType.f_56736_))));
    public static final Map<Tree, RegistryObject<ShelfBlock>> SHELVES = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_shelf", () -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)SOLID_FLAMMABLE_DECORATION).m_60913_(tree.getStrength() * 0.5f, tree.getExplosionResistance() * 0.5f).m_60918_(SoundType.f_56736_))));
    public static final Map<Tree, RegistryObject<ChairBlock>> CHAIRS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_chair", () -> new ChairBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)tree.getBaseColor()).m_60913_(tree.getStrength() * 0.5f, tree.getExplosionResistance() * 0.5f).m_60918_(SoundType.f_56736_))));
    public static final Map<Tree, RegistryObject<TroughBlock>> TROUGHS = DataUtil.mapEnum(Tree.class, tree -> BlocksNF.register(tree.getName() + "_trough", () -> new TroughBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)tree.getBaseColor()).m_60913_(tree.getStrength() * 0.5f, tree.getExplosionResistance() * 0.5f).m_60918_(SoundType.f_56736_))));
    public static final Map<Metal, RegistryObject<Block>> METAL_BLOCKS = DataUtil.mapEnum(Metal.class, metal -> BlocksNF.register(metal.getName() + "_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)metal.getBaseColor()).m_60913_(metal.getStrength() / 2.0f, metal.getExplosionResistance() / 2.0f).m_60918_(metal.getSound()))));
    public static final Map<Metal, RegistryObject<Block>> INGOT_PILES = DataUtil.mapEnum(Metal.class, metal -> BlocksNF.register(metal.getName() + "_ingot_pile", metal == Metal.IRON ? () -> new FireableAxisBlock(9600, TieredHeat.WHITE, BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)metal.getBaseColor()).m_60913_(metal.getStrength() / 8.0f, metal.getExplosionResistance() / 2.0f).m_60918_(metal.getSound())){

        @Override
        public BlockState getFiredBlock(Level level, BlockPos pos, BlockState state) {
            BlockState above = level.m_8055_(pos.m_7494_());
            BlockState below = level.m_8055_(pos.m_7495_());
            if (above.m_60713_((Block)COAL_BURNING.get()) || below.m_60713_((Block)COAL_BURNING.get())) {
                return ((HorizontalAxisBlock)((Object)STEEL_INGOT_PILE_POOR.get())).m_49966_();
            }
            if (above.m_60713_((Block)CHARCOAL_BURNING.get()) || below.m_60713_((Block)CHARCOAL_BURNING.get())) {
                return ((HorizontalAxisBlock)((Object)STEEL_INGOT_PILE_FAIR.get())).m_49966_();
            }
            return state.m_60734_().m_49966_();
        }

        @Override
        public boolean isStructureValid(Level level, BlockPos pos, BlockState state) {
            return LevelUtil.isBlockBurningCarbon(level.m_8055_(pos.m_7495_())) && LevelUtil.isBlockBurningCarbon(level.m_8055_(pos.m_7494_())) && LevelUtil.getNearbySmelterTier(level, pos) >= 3;
        }
    } : () -> new HorizontalAxisBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)metal.getBaseColor()).m_60913_(metal.getStrength() / 8.0f, metal.getExplosionResistance() / 2.0f).m_60918_(metal.getSound()))));
    public static final RegistryObject<HorizontalAxisBlock> STEEL_INGOT_PILE_POOR = BlocksNF.register("poor_steel_ingot_pile", () -> new HorizontalAxisBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)Metal.STEEL.getBaseColor()).m_60913_(Metal.STEEL.getStrength() / 8.0f, Metal.STEEL.getExplosionResistance() / 2.0f).m_60918_(Metal.STEEL.getSound())));
    public static final RegistryObject<HorizontalAxisBlock> STEEL_INGOT_PILE_FAIR = BlocksNF.register("fair_steel_ingot_pile", () -> new HorizontalAxisBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)Metal.STEEL.getBaseColor()).m_60913_(Metal.STEEL.getStrength() / 8.0f, Metal.STEEL.getExplosionResistance() / 2.0f).m_60918_(Metal.STEEL.getSound())));
    public static final Map<Metal, RegistryObject<LanternBlockNF>> LANTERNS = DataUtil.mapEnum(Metal.class, metal -> BlocksNF.register(metal.getName() + "_lantern", () -> new LanternBlockNF(true, (Supplier)LANTERNS_UNLIT.get(metal), BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)metal.getBaseColor()).m_60978_(1.0f).m_60953_(state -> 15).m_60955_().m_60918_(SoundType.f_56762_))));
    public static final Map<Metal, RegistryObject<LanternBlockNF>> LANTERNS_UNLIT = DataUtil.mapEnum(Metal.class, metal -> BlocksNF.register("extinguished_" + metal.getName() + "_lantern", () -> new LanternBlockNF(false, (Supplier)LANTERNS.get(metal), BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)metal.getBaseColor()).m_60978_(1.0f).m_60955_().m_60918_(SoundType.f_56762_))));
    public static final Map<Tree, RegistryObject<TieredAnvilBlock>> ANVILS_LOG = DataUtil.mapEnum(Tree.class, tree -> tree.getHardness() < 2.0f, tree -> BlocksNF.register(tree.getName() + "_anvil", () -> new TieredAnvilBlock(1, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)tree.getBaseColor()).m_60913_(tree.getStrength(), tree.getExplosionResistance()).m_60918_(tree.getSound()))));
    public static final Map<Stone, RegistryObject<TieredAnvilBlock>> ANVILS_STONE = DataUtil.mapEnum(Stone.class, stone -> stone.getExplosionResistance() < 12.5f, stone -> BlocksNF.register(stone.getName() + "_anvil", () -> new TieredAnvilBlock(1, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)stone.getBaseColor()).m_60913_(stone.getStrength(), stone.getExplosionResistance()).m_60918_(stone.getSound()))));
    public static final Map<Metal, RegistryObject<MetalAnvilBlock>> ANVILS_METAL = DataUtil.mapEnum(Metal.class, metal -> metal.getCategory() != IMetal.Category.HARD, metal -> BlocksNF.register(metal.getName() + "_anvil", () -> new MetalAnvilBlock(metal.getTier() + 1, BlockBehaviour.Properties.m_60944_((Material)Material.f_76281_, (MaterialColor)metal.getBaseColor()).m_60999_().m_60913_(metal.getStrength(), metal.getExplosionResistance()).m_60918_(SoundType.f_56725_))));
    public static final Map<Armament, RegistryObject<ItemMoldBlock>> ARMAMENT_MOLDS = DataUtil.mapEnum(Armament.class, a -> a == Armament.ADZE || a == Armament.HAMMER || a == Armament.MACE || a == Armament.SABRE || a == Armament.SWORD, armament -> BlocksNF.register(armament.getName() + "_mold", () -> new ItemMoldBlock(switch (armament) {
        case Armament.AXE -> Block.m_49796_((double)3.5, (double)0.0, (double)4.0, (double)12.5, (double)2.0, (double)12.0);
        case Armament.CHISEL -> Block.m_49796_((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)2.0, (double)11.0);
        case Armament.DAGGER -> Block.m_49796_((double)1.5, (double)0.0, (double)5.0, (double)14.5, (double)2.0, (double)11.0);
        case Armament.PICKAXE -> Block.m_49796_((double)0.0, (double)0.0, (double)4.5, (double)16.0, (double)2.0, (double)11.5);
        case Armament.SHOVEL -> Block.m_49796_((double)3.5, (double)0.0, (double)4.0, (double)12.5, (double)2.0, (double)12.0);
        case Armament.SICKLE -> Block.m_49796_((double)0.0, (double)0.0, (double)3.5, (double)16.0, (double)2.0, (double)12.5);
        case Armament.SPEAR -> Block.m_49796_((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)2.0, (double)11.0);
        default -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    }, switch (armament) {
        case Armament.AXE -> TagsNF.AXE_HEAD;
        case Armament.CHISEL -> TagsNF.CHISEL_HEAD;
        case Armament.DAGGER -> TagsNF.DAGGER_HEAD;
        case Armament.PICKAXE -> TagsNF.PICKAXE_HEAD;
        case Armament.SHOVEL -> TagsNF.SHOVEL_HEAD;
        case Armament.SICKLE -> TagsNF.SICKLE_HEAD;
        case Armament.SPEAR -> TagsNF.SPEAR_HEAD;
        default -> throw new IllegalArgumentException("Missing matching tag for armament mold.");
    }, 100, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.3f).m_60918_(SoundsNF.CERAMIC_SMALL_TYPE).m_60910_())));
    public static final RegistryObject<ItemMoldBlock> INGOT_MOLD = BlocksNF.register("ingot_mold", () -> new ItemMoldBlock(Block.m_49796_((double)3.0, (double)0.0, (double)4.5, (double)13.0, (double)3.0, (double)11.5), (TagKey<Item>)Tags.Items.INGOTS, 100, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.3f).m_60918_(SoundsNF.CERAMIC_SMALL_TYPE).m_60910_()));
    public static final RegistryObject<ItemMoldBlock> ARROWHEAD_MOLD = BlocksNF.register("arrowhead_mold", () -> new ItemMoldBlock(Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), TagsNF.ARROWHEAD, 10, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.3f).m_60918_(SoundsNF.CERAMIC_SMALL_TYPE).m_60910_()));
    public static final Map<Armament, RegistryObject<FireableFacingPartialBlock>> UNFIRED_ARMAMENT_MOLDS = DataUtil.mapEnum(Armament.class, armament -> !ARMAMENT_MOLDS.containsKey(armament), armament -> BlocksNF.register("unfired_" + armament.getName() + "_mold", () -> new FireableFacingPartialBlock(9600, TieredHeat.ORANGE, ARMAMENT_MOLDS.get(armament), 0, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.3f).m_60918_(SoundType.f_56739_).m_60910_())));
    public static final RegistryObject<FireableFacingPartialBlock> UNFIRED_INGOT_MOLD = BlocksNF.register("unfired_ingot_mold", () -> new FireableFacingPartialBlock(9600, TieredHeat.ORANGE, INGOT_MOLD, 0, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.3f).m_60918_(SoundType.f_56739_).m_60910_()));
    public static final RegistryObject<FireableFacingPartialBlock> UNFIRED_ARROWHEAD_MOLD = BlocksNF.register("unfired_arrowhead_mold", () -> new FireableFacingPartialBlock(9600, TieredHeat.ORANGE, ARROWHEAD_MOLD, 0, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.3f).m_60918_(SoundType.f_56739_).m_60910_()));
    public static final RegistryObject<FuelBlock> COKE = BLOCKS.register("coke_block", () -> new FuelBlock((Supplier<? extends BurningFuelBlock>)COKE_BURNING, BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76419_).m_60913_(2.4f, 2.0f).m_60918_(SoundType.f_56721_)));
    public static final RegistryObject<BurningFuelBlock> COKE_BURNING = BLOCKS.register("burning_coke_block", () -> new BurningFuelBlock(10800, 1200.0f, (Supplier<? extends Block>)COKE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)COKE.get())).m_60953_(state -> 15)));
    public static final RegistryObject<FuelBlock> COAL = BLOCKS.register("coal_block", () -> new FuelBlock((Supplier<? extends BurningFuelBlock>)COAL_BURNING, BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60913_(2.4f, 2.0f).m_60918_(SoundType.f_56721_)));
    public static final RegistryObject<BurningFuelBlock> COAL_BURNING = BLOCKS.register("burning_coal_block", () -> new BurningFuelBlock(12000, 1000.0f, (level, blockPos) -> LevelUtil.isBlockSmothered(level, blockPos) ? (Block)COKE.get() : null, (Supplier<? extends Block>)COAL, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)COAL.get())).m_60953_(state -> 15)));
    public static final RegistryObject<HorizontalFuelBlock> CHARCOAL = BLOCKS.register("charcoal_block", () -> new HorizontalFuelBlock((Supplier<? extends BurningFuelBlock>)CHARCOAL_BURNING, BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60913_(2.0f, 2.0f).m_60918_(SoundType.f_56721_)));
    public static final RegistryObject<BurningHorizontalFuelBlock> CHARCOAL_BURNING = BLOCKS.register("burning_charcoal_block", () -> new BurningHorizontalFuelBlock(12000, 1000.0f, (Supplier<? extends Block>)CHARCOAL, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CHARCOAL.get())).m_60953_(state -> 15)));
    public static final RegistryObject<HorizontalFuelBlock> FIREWOOD = BLOCKS.register("firewood_block", () -> new HorizontalFuelBlock((Supplier<? extends BurningFuelBlock>)FIREWOOD_BURNING, BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60966_().m_60918_(SoundsNF.FIREWOOD_TYPE)));
    public static final RegistryObject<BurningHorizontalFuelBlock> FIREWOOD_BURNING = BLOCKS.register("burning_firewood_block", () -> new BurningHorizontalFuelBlock(12000, 800.0f, (level, blockPos) -> LevelUtil.isBlockSmothered(level, blockPos) ? (Block)CHARCOAL.get() : null, (Supplier<? extends Block>)FIREWOOD, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)FIREWOOD.get())).m_60953_(state -> 15)));
    public static final RegistryObject<BlockNF> SLAG = BLOCKS.register("slag_block", () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(12.0f, 20.0f).m_60918_(SoundType.f_56726_)));
    public static final RegistryObject<FireableBlock> AZURITE = BLOCKS.register("azurite_block", () -> new SimpleFireableBlock(9600, TieredHeat.ORANGE, SMELTED_AZURITE, BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76368_).m_60913_(8.0f, 2000.0f).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<FireableBlock> HEMATITE = BLOCKS.register("hematite_block", () -> new SimpleFireableBlock(9600, TieredHeat.WHITE, SMELTED_HEMATITE, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(8.0f, 2000.0f).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<BlockNF> SMELTED_AZURITE = BLOCKS.register("smelted_azurite", () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(8.0f, 16.0f).m_60918_(SoundType.f_56726_)));
    public static final RegistryObject<BlockNF> SMELTED_HEMATITE = BLOCKS.register("smelted_hematite", () -> new BlockNF(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(8.0f, 16.0f).m_60918_(SoundType.f_56726_).m_60991_(BlocksNF::always).m_60953_(state -> 3)));
    public static final RegistryObject<CrucibleBlock> CRUCIBLE = BLOCKS.register("crucible", () -> new CrucibleBlock(200, TieredHeat.WHITE.getBaseTemp() - 0.1f, BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76384_).m_60913_(1.0f, 1.0f).m_60918_(SoundsNF.CERAMIC_VESSEL_TYPE).m_60991_((state, level, pos) -> (Integer)state.m_61143_((Property)CrucibleBlock.HEAT) != 0).m_60953_(state -> (Integer)state.m_61143_((Property)CrucibleBlock.HEAT) != 0 ? 2 : 0)));
    public static final RegistryObject<FireableAxisPartialBlock> UNFIRED_CRUCIBLE = BLOCKS.register("unfired_crucible", () -> new FireableAxisPartialBlock(9600, TieredHeat.ORANGE, CRUCIBLE, 0, BlockBehaviour.Properties.m_60939_((Material)Material.f_76313_).m_60913_(1.0f, 20.0f).m_60918_(SoundType.f_56739_)));
    public static final RegistryObject<MoonEssenceBlock> MOON_ESSENCE = BLOCKS.register("moon_essence", () -> new MoonEssenceBlock(ParticleTypesNF.ESSENCE_MOON, BlockBehaviour.Properties.m_60944_((Material)SOLID_DECORATION, (MaterialColor)MaterialColor.f_76367_).m_60918_(SoundsNF.MOON_ESSENCE_TYPE).m_60971_(BlocksNF::never).m_60960_(BlocksNF::never).m_60991_(BlocksNF::always).m_60978_(1.0f).m_60993_().m_60955_().m_60977_()));
    public static final RegistryObject<RabbitBurrowBlock> RABBIT_BURROW = BLOCKS.register("rabbit_burrow", () -> new RabbitBurrowBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60955_().m_60910_().m_60977_().m_60993_().m_60918_(SoundsNF.SILENT_TYPE)));
    public static final RegistryObject<SpiderWebBlock> SPIDER_WEB = BLOCKS.register("spider_web", () -> new SpiderWebBlock(BlockBehaviour.Properties.m_60939_((Material)FLAMMABLE_DECORATION).m_60978_(1.0f).m_60910_().m_60955_().m_60956_(0.5f).m_60967_(0.6f).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<SpiderNestBlock> SPIDER_NEST = BLOCKS.register("spider_nest", () -> new SpiderNestBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60977_().m_60978_(8.0f).m_60956_(0.5f).m_60967_(0.6f).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<AnchoringResinBlock> ANCHORING_RESIN = BLOCKS.register("anchoring_resin_block", () -> new AnchoringResinBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76376_).m_60978_(16.0f).m_60956_(0.05f).m_60918_(SoundType.f_154660_)));
    public static final Map<Stone, RegistryObject<RotatedPillarBlock>> STONE_TUNNELS = DataUtil.mapEnum(Stone.class, stone -> stone == Stone.PUMICE || stone == Stone.MOONSTONE, stone -> BlocksNF.register(stone.getName() + "_tunnel", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)STONE_BLOCKS.get(stone).get())))));
    public static final Map<Stone, RegistryObject<SkaraNestBlock>> SKARA_ROCK_CLUSTERS = DataUtil.mapEnum(Stone.class, stone -> stone == Stone.PUMICE || stone == Stone.MOONSTONE, stone -> BlocksNF.register(stone.getName() + "_skara_rocks", () -> new SkaraNestBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56742_))));
    public static final RegistryObject<DrakefowlEggNestBlock> DRAKEFOWL_NEST = BLOCKS.register("drakefowl_nest", () -> new DrakefowlEggNestBlock((Supplier<? extends Item>)ItemsNF.DRAKEFOWL_EGG, 144000, 0.4f, 1.0f, BlockBehaviour.Properties.m_60939_((Material)FLAMMABLE_DECORATION).m_60978_(2.0f).m_60910_().m_60918_(SoundType.f_56740_)));

    public static void register() {
        BLOCKS.register(Nightfall.MOD_EVENT_BUS);
    }

    public static Set<RegistryObject<? extends CoveredSoilBlock>> getCoveredSoils() {
        return Stream.of(COVERED_SILT.values(), COVERED_DIRT.values(), COVERED_LOAM.values()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Set<RegistryObject<? extends Block>> getOres() {
        return Stream.of(TIN_ORES.values(), COPPER_ORES.values(), AZURITE_ORES.values(), HEMATITE_ORES.values(), COAL_ORES.values(), HALITE_ORES.values(), List.of(METEORITE_ORE)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static RegistryObject<UnstableBlock> soil(ISoil soil) {
        return BLOCKS.register(soil.getName() + "_block", () -> new UnstableBlock(soil.getSlideSound(), BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)soil.getBaseColor()).m_60913_(soil.getStrength(), soil.getExplosionResistance()).m_60918_(soil.getSound())));
    }

    private static RegistryObject<TilledSoilBlock> tilledSoil(ISoil soil, float dryHumidity, float moistHumidity, float irrigatedHumidity, RegistryObject<? extends Block> untilledBlock) {
        return BLOCKS.register("tilled_" + soil.getName(), () -> new TilledSoilBlock(soil.getFertility(), dryHumidity, moistHumidity, irrigatedHumidity, (Supplier<? extends Block>)untilledBlock, soil.getSlideSound(), BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)soil.getBaseColor()).m_60977_().m_60913_(soil.getStrength(), soil.getExplosionResistance()).m_60918_(soil.getSound())));
    }

    private static RegistryObject<StairBlockNF> stairs(String name, RegistryObject<? extends Block> base) {
        return BLOCKS.register(name + "_stairs", () -> new StairBlockNF((Supplier<? extends Block>)base, BlocksNF.copyWithSuffocation((Block)base.get()).m_60913_(((Block)base.get()).m_155943_() * 0.75f, ((Block)base.get()).m_7325_() * 0.75f)));
    }

    private static RegistryObject<StairBlockNF> stairs(RegistryObject<? extends Block> base) {
        return BlocksNF.stairs(base.getId().m_135815_(), base);
    }

    private static RegistryObject<SlabBlockNF> slab(String name, RegistryObject<? extends Block> base) {
        return BLOCKS.register(name + "_slab", () -> new SlabBlockNF((Supplier<? extends Block>)base, BlocksNF.copyWithSuffocation((Block)base.get()).m_60913_(((Block)base.get()).m_155943_() * 0.5f, ((Block)base.get()).m_7325_() * 0.5f)));
    }

    private static RegistryObject<SlabBlockNF> slab(RegistryObject<? extends Block> base) {
        return BlocksNF.slab(base.getId().m_135815_(), base);
    }

    private static RegistryObject<SidingBlock> siding(String name, RegistryObject<? extends Block> base) {
        return BLOCKS.register(name + "_siding", () -> new SidingBlock((Supplier<? extends Block>)base, BlocksNF.copyWithSuffocation((Block)base.get()).m_60913_(((Block)base.get()).m_155943_() * 0.5f, ((Block)base.get()).m_7325_() * 0.5f)));
    }

    private static RegistryObject<SidingBlock> siding(RegistryObject<? extends Block> base) {
        return BlocksNF.siding(base.getId().m_135815_(), base);
    }

    protected static BlockBehaviour.Properties fullCopy(Block block) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)block);
        if (block.m_60589_().equals((Object)BuiltInLootTables.f_78712_)) {
            properties.m_60993_();
        }
        return properties;
    }

    protected static BlockBehaviour.Properties copyWithSuffocation(Block block) {
        return BlocksNF.fullCopy(block).m_60960_(BlocksNF::blocksMotion).m_60971_(BlocksNF::blocksMotion);
    }

    protected static ToIntFunction<BlockState> litBlockEmission(int light) {
        return blockState -> (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false ? light : 0;
    }

    private static boolean always(BlockState p_50775_, BlockGetter p_50776_, BlockPos p_50777_) {
        return true;
    }

    private static boolean never(BlockState p_50806_, BlockGetter p_50807_, BlockPos p_50808_) {
        return false;
    }

    private static boolean blocksMotion(BlockState p_61036_, BlockGetter p_61037_, BlockPos p_61038_) {
        return p_61036_.m_60767_().m_76334_();
    }
}

