/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.registry.forge;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.entity.effect.DamageEffect;
import frostnox.nightfall.entity.effect.StarvationEffect;
import frostnox.nightfall.registry.forge.AttributesNF;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class EffectsNF {
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"nightfall");
    public static final RegistryObject<MobEffect> DESPAIR = EFFECTS.register("despair", () -> new MobEffect(MobEffectCategory.NEUTRAL, 0){}.m_19472_(Attributes.f_22276_, "3eb0c333-e6d2-46ed-acfb-b12fa5ae7e7a", -10.0, AttributeModifier.Operation.ADDITION).m_19472_((Attribute)AttributesNF.ENDURANCE.get(), "8dee21aa-5d0c-4bae-b2b4-0c6f09b5fe5e", -1.0, AttributeModifier.Operation.ADDITION).m_19472_((Attribute)AttributesNF.WILLPOWER.get(), "be42557c-0db3-43c8-b708-eecb422f3e34", -1.0, AttributeModifier.Operation.ADDITION).m_19472_((Attribute)AttributesNF.STRENGTH.get(), "9e944581-840d-432a-a48a-5576314f09c1", -1.0, AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22279_, "b5f3fc7d-16f3-4867-b7c5-9973ddcbcb49", -0.03, AttributeModifier.Operation.MULTIPLY_BASE).m_19472_((Attribute)AttributesNF.PERCEPTION.get(), "c23eca0f-114f-47f5-9442-26fc14a12788", -1.0, AttributeModifier.Operation.ADDITION));
    public static final RegistryObject<MobEffect> STARVATION_1 = EFFECTS.register("starvation_1", () -> new StarvationEffect(){

        @Override
        public void onTickUp(LivingEntity entity, int amplifier, int duration) {
            if (entity.f_19853_.f_46443_) {
                return;
            }
            if (duration > 12000) {
                entity.m_21195_((MobEffect)this);
                entity.m_7292_(new MobEffectInstance((MobEffect)STARVATION.get(), duration, amplifier));
            }
        }
    }.m_19472_((Attribute)AttributesNF.ENDURANCE.get(), "8d9d96b6-8df3-461a-8ae7-1c7cf42351a8", -2.0, AttributeModifier.Operation.ADDITION));
    private static final UUID STARVATION_ENDURANCE_UUID = UUID.fromString("995a05cb-0eaf-4ec8-99e6-ecb751531794");
    public static final RegistryObject<MobEffect> STARVATION = EFFECTS.register("starvation", () -> new StarvationEffect(){

        @Override
        public void onTickUp(LivingEntity entity, int amplifier, int duration) {
            if (entity.f_19853_.f_46443_) {
                return;
            }
            int expectedAmplifier = duration > 48000 ? 3 : (duration > 24000 ? 2 : (duration > 12000 ? 1 : 0));
            if (amplifier != expectedAmplifier) {
                entity.m_21195_((MobEffect)this);
                if (expectedAmplifier == 0) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)STARVATION_1.get(), duration, expectedAmplifier));
                } else {
                    entity.m_7292_(new MobEffectInstance((MobEffect)STARVATION.get(), duration, expectedAmplifier));
                }
            }
        }

        public double m_7048_(int pAmplifier, AttributeModifier pModifier) {
            if (pModifier.m_22209_().equals(STARVATION_ENDURANCE_UUID)) {
                return super.m_7048_(pAmplifier, pModifier);
            }
            return pModifier.m_22218_() * (double)pAmplifier;
        }
    }.m_19472_(Attributes.f_22279_, "e0d13cbb-521f-4afc-b476-43b40dd051f2", -0.125, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_((Attribute)ForgeMod.SWIM_SPEED.get(), "01ed0754-2303-431d-9fc1-5a56ef6ad916", -0.125, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_((Attribute)AttributesNF.STRENGTH.get(), "c0b371d8-e9f7-418c-b6ee-4997fa9b4e9d", -2.0, AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22276_, "253f436b-cc13-4474-a4e9-3f3d534e93a9", -10.0, AttributeModifier.Operation.ADDITION).m_19472_((Attribute)AttributesNF.ENDURANCE.get(), "995a05cb-0eaf-4ec8-99e6-ecb751531794", -2.0, AttributeModifier.Operation.ADDITION));
    public static final RegistryObject<MobEffect> BLEEDING = EFFECTS.register("bleeding", () -> new DamageEffect(MobEffectCategory.HARMFUL, 0.0f, DamageTypeSource.BLEEDING){

        @Override
        public float getDamage(LivingEntity entity, int duration, int amplifier) {
            if (duration > 1800) {
                return entity.m_21233_() / 20.0f;
            }
            if (duration > 1200) {
                return entity.m_21233_() / 30.0f;
            }
            if (duration > 600) {
                return entity.m_21233_() / 40.0f;
            }
            return 0.0f;
        }
    });
    public static final RegistryObject<MobEffect> POISON = EFFECTS.register("poison", () -> new DamageEffect(MobEffectCategory.HARMFUL, 2.5f, DamageTypeSource.POISON){

        @Override
        public float getDamage(LivingEntity entity, int duration, int amplifier) {
            if (entity.m_21223_() > this.damage) {
                return this.damage;
            }
            return 0.0f;
        }
    });
    public static final RegistryObject<MobEffect> BANDAGED = EFFECTS.register("bandaged", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 0){

        public void m_6742_(LivingEntity entity, int amplifier) {
            if (entity.m_21223_() < entity.m_21233_()) {
                entity.m_5634_(1.0f);
            }
        }

        public boolean m_6584_(int duration, int amplifier) {
            return duration % 90 == 0;
        }
    });
    public static final RegistryObject<MobEffect> MOON_BLESSING = EFFECTS.register("moon_blessing", () -> new DamageEffect(MobEffectCategory.BENEFICIAL).m_19472_(Attributes.f_22279_, "07485be1-69a1-4313-9012-c54a7133957b", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_((Attribute)AttributesNF.STRENGTH.get(), "09d6a029-e15f-4731-99e8-d546f22977ed", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_((Attribute)AttributesNF.STRIKING_DEFENSE.get(), "eb96b12a-6a7e-4c33-a0a0-055e8c9380dc", 0.2, AttributeModifier.Operation.ADDITION).m_19472_((Attribute)AttributesNF.SLASHING_DEFENSE.get(), "3875dd84-b979-4752-a8e1-7cf350d1f97c", 0.2, AttributeModifier.Operation.ADDITION).m_19472_((Attribute)AttributesNF.PIERCING_DEFENSE.get(), "123d9b3a-2dfc-4faf-8d98-ec7a8e6bf655", 0.2, AttributeModifier.Operation.ADDITION).m_19472_((Attribute)AttributesNF.FIRE_DEFENSE.get(), "29130a79-b037-4bc7-8278-608e4918d707", 0.2, AttributeModifier.Operation.ADDITION).m_19472_((Attribute)AttributesNF.FROST_DEFENSE.get(), "5abe03c1-9448-48cf-aa59-10c617cbb504", 0.2, AttributeModifier.Operation.ADDITION).m_19472_((Attribute)AttributesNF.ELECTRIC_DEFENSE.get(), "cf58f418-c961-44ea-9bb2-f02b0bdb6176", 0.2, AttributeModifier.Operation.ADDITION));
    public static final RegistryObject<MobEffect> PARALYSIS = EFFECTS.register("paralysis", () -> new DamageEffect(MobEffectCategory.HARMFUL).m_19472_(Attributes.f_22279_, "5e59ad86-9311-4fbd-8e70-db765be34d30", -0.2, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_((Attribute)ForgeMod.SWIM_SPEED.get(), "728607eb-2232-457d-a9ac-f61d42fa91f3", -0.2, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_((Attribute)AttributesNF.ENDURANCE.get(), "47a84663-d865-4df0-8672-01608ce5d124", -2.0, AttributeModifier.Operation.ADDITION));
    public static final RegistryObject<MobEffect> INFESTED = EFFECTS.register("infested", () -> new MobEffect(MobEffectCategory.HARMFUL, 0){

        public void m_6742_(LivingEntity entity, int amplifier) {
            entity.m_7292_(new MobEffectInstance((MobEffect)BLEEDING.get(), 200));
        }

        public boolean m_6584_(int duration, int amplifier) {
            return duration % 20 == 0;
        }
    });
    public static final RegistryObject<MobEffect> INVIGORATING = EFFECTS.register("invigorating", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 0){

        public void m_6742_(LivingEntity entity, int amplifier) {
            if (entity.m_21223_() < entity.m_21233_()) {
                entity.m_5634_(0.5f);
            }
        }

        public boolean m_6584_(int duration, int amplifier) {
            return duration % 100 == 0;
        }
    });
    public static final RegistryObject<MobEffect> ENERGIZING = EFFECTS.register("energizing", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 0){

        public boolean m_6584_(int duration, int amplifier) {
            return false;
        }
    });

    public static void register() {
        EFFECTS.register(Nightfall.MOD_EVENT_BUS);
    }
}

