/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.registry.forge;

import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.block.GroundItemBlock;
import frostnox.nightfall.block.block.StoneBlock;
import frostnox.nightfall.block.block.crop.CropBlockNF;
import frostnox.nightfall.block.block.eggnest.DrakefowlEggNestBlock;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.world.generation.feature.AbandonedEggNestFeature;
import frostnox.nightfall.world.generation.feature.BoulderFeature;
import frostnox.nightfall.world.generation.feature.CaveRocksFeature;
import frostnox.nightfall.world.generation.feature.LoneTreeFeature;
import frostnox.nightfall.world.generation.feature.MeteoriteFeature;
import frostnox.nightfall.world.generation.feature.OreVeinFeature;
import frostnox.nightfall.world.generation.feature.RabbitBurrowFeature;
import frostnox.nightfall.world.generation.feature.RandomTreeFeature;
import frostnox.nightfall.world.generation.feature.RocksFeature;
import frostnox.nightfall.world.generation.feature.RockwormNestFeature;
import frostnox.nightfall.world.generation.feature.SingleBlockFeature;
import frostnox.nightfall.world.generation.feature.SkaraNestFeature;
import frostnox.nightfall.world.generation.feature.SpiderNestFeature;
import frostnox.nightfall.world.generation.placement.AdjacentScanPlacement;
import frostnox.nightfall.world.generation.placement.ChanceFilter;
import frostnox.nightfall.world.generation.placement.ElevationPreciseFilter;
import frostnox.nightfall.world.generation.placement.ExposureChanceFilter;
import frostnox.nightfall.world.generation.placement.ExposureCountPlacement;
import frostnox.nightfall.world.generation.placement.ForestationCountPlacement;
import frostnox.nightfall.world.generation.placement.NearSpawnFilter;
import frostnox.nightfall.world.generation.placement.RectangleClimateFilter;
import frostnox.nightfall.world.generation.placement.SurfaceHeightFilter;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FeaturesNF {
    private static final BlockPredicate CAVE_AIR_PREDICATE = BlockPredicate.m_190396_((Block)Blocks.f_50627_, (Vec3i)Vec3i.f_123288_);
    public static final RandomTreeFeature TREE_FEATURE = new RandomTreeFeature(FeaturesNF.name("tree"));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> TREE_CONFIG = FeaturesNF.register("tree", TREE_FEATURE, FeatureConfiguration.f_67737_);
    public static final Holder<PlacedFeature> TREE = FeaturesNF.register("tree", TREE_CONFIG, new PlacementModifier[]{ForestationCountPlacement.of(13.0f), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_(), AdjacentScanPlacement.of(BlockPredicate.m_204677_(TagsNF.TREE_WOOD), true)});
    public static final LoneTreeFeature LONE_TREE_FEATURE = new LoneTreeFeature(FeaturesNF.name("lone_tree"));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> LONE_TREE_CONFIG = FeaturesNF.register("lone_tree", LONE_TREE_FEATURE, FeatureConfiguration.f_67737_);
    public static final Holder<PlacedFeature> LONE_TREE = FeaturesNF.register("lone_tree", LONE_TREE_CONFIG, new PlacementModifier[]{CountPlacement.m_191628_((int)1), ChanceFilter.with(0.002f), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_(), AdjacentScanPlacement.of(BlockPredicate.m_204677_(TagsNF.TREE_WOOD), true)});
    public static final RocksFeature ROCKS_FEATURE = new RocksFeature(FeaturesNF.name("rocks"));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> ROCKS_CONFIG = FeaturesNF.register("rocks", ROCKS_FEATURE, FeatureConfiguration.f_67737_);
    public static final Holder<PlacedFeature> SURFACE_ROCKS = FeaturesNF.register("rocks", ROCKS_CONFIG, new PlacementModifier[]{ExposureCountPlacement.of(5.0f, 1), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
    public static final BoulderFeature BOULDER_FEATURE = new BoulderFeature(FeaturesNF.name("boulder"));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> BOULDER_CONFIG = FeaturesNF.register("boulder", BOULDER_FEATURE, FeatureConfiguration.f_67737_);
    public static final Holder<PlacedFeature> BOULDER = FeaturesNF.register("boulder", BOULDER_CONFIG, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, ExposureChanceFilter.with(0.62f, 0.04f), BiomeFilter.m_191561_()});
    public static final SingleBlockFeature SINGLE_BLOCK_FEATURE = new SingleBlockFeature(FeaturesNF.name("single_block"));
    public static final Holder<ConfiguredFeature<BlockStateConfiguration, ?>> SEASHELLS_CONFIG = FeaturesNF.register("seashells", SINGLE_BLOCK_FEATURE, new BlockStateConfiguration(((GroundItemBlock)BlocksNF.SEASHELL.get()).m_49966_()));
    public static final Holder<PlacedFeature> SEASHELLS = FeaturesNF.register("seashells", SEASHELLS_CONFIG, new PlacementModifier[]{ElevationPreciseFilter.with(-0.647f, 0.3f), SurfaceHeightFilter.with(386, 417), HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)386), (VerticalAnchor)VerticalAnchor.m_158922_((int)446)), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
    public static final AbandonedEggNestFeature ABANDONED_EGG_NEST_FEATURE = new AbandonedEggNestFeature(FeaturesNF.name("abandoned_egg_nest"));
    public static final Holder<ConfiguredFeature<BlockStateConfiguration, ?>> ABANDONED_DRAKEFOWL_NEST_CONFIG = FeaturesNF.register("abandoned_drakefowl_nest", ABANDONED_EGG_NEST_FEATURE, new BlockStateConfiguration(((DrakefowlEggNestBlock)BlocksNF.DRAKEFOWL_NEST.get()).m_49966_()));
    public static final Holder<PlacedFeature> ABANDONED_DRAKEFOWL_NEST = FeaturesNF.register("abandoned_drakefowl_nest", ABANDONED_DRAKEFOWL_NEST_CONFIG, new PlacementModifier[]{CountPlacement.m_191628_((int)1), ChanceFilter.with(0.004f), RectangleClimateFilter.with(0.55f, 1.0f, 0.65f, 1.0f), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
    public static final OreVeinFeature ORE_VEIN_FEATURE = new OreVeinFeature(FeaturesNF.name("ore_vein"));
    private static final List<BlockState> TIN_ORE_VALUES = BlocksNF.TIN_ORES.values().stream().map(block -> ((Block)block.get()).m_49966_()).toList();
    public static final Holder<ConfiguredFeature<OreVeinFeature.Configuration, ?>> TIN_VEIN_CONFIG = FeaturesNF.register("tin_vein", ORE_VEIN_FEATURE, new OreVeinFeature.Configuration(FeaturesNF.getOreKeys(BlocksNF.TIN_ORES.keySet()), TIN_ORE_VALUES, 0.0081, 0.6f, 0.2f, 3, 3, 3, 3, 0.026, 0.03));
    public static final Holder<PlacedFeature> TIN_VEIN = FeaturesNF.register("tin_vein", TIN_VEIN_CONFIG, FeaturesNF.orePlacement(28, 38, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)270), (VerticalAnchor)VerticalAnchor.f_158916_)));
    private static final List<BlockState> COPPER_ORE_VALUES = BlocksNF.COPPER_ORES.values().stream().map(block -> ((Block)block.get()).m_49966_()).toList();
    public static final Holder<ConfiguredFeature<OreVeinFeature.Configuration, ?>> COPPER_VEIN_CONFIG = FeaturesNF.register("copper_vein", ORE_VEIN_FEATURE, new OreVeinFeature.Configuration(FeaturesNF.getOreKeys(BlocksNF.COPPER_ORES.keySet()), COPPER_ORE_VALUES, 0.0081, 0.6f, 0.2f, 3, 3, 3, 3, 0.026, 0.03));
    public static final Holder<PlacedFeature> COPPER_VEIN = FeaturesNF.register("copper_vein", COPPER_VEIN_CONFIG, FeaturesNF.orePlacement(33, 43, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)240), (VerticalAnchor)VerticalAnchor.f_158916_)));
    private static final List<BlockState> AZURITE_ORE_VALUES = BlocksNF.AZURITE_ORES.values().stream().map(block -> ((Block)block.get()).m_49966_()).toList();
    public static final Holder<ConfiguredFeature<OreVeinFeature.Configuration, ?>> AZURITE_VEIN_CONFIG = FeaturesNF.register("azurite_vein", ORE_VEIN_FEATURE, new OreVeinFeature.Configuration(FeaturesNF.getOreKeys(BlocksNF.AZURITE_ORES.keySet()), AZURITE_ORE_VALUES, 0.005183999999999999, 0.4f, 0.2f, 8, 9, 7, 8, 0.02, 0.024));
    public static final Holder<PlacedFeature> AZURITE_VEIN = FeaturesNF.register("azurite_vein", AZURITE_VEIN_CONFIG, FeaturesNF.orePlacement(2, 7, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)350), (VerticalAnchor)VerticalAnchor.f_158916_)));
    private static final List<BlockState> HEMATITE_ORE_VALUES = BlocksNF.HEMATITE_ORES.values().stream().map(block -> ((Block)block.get()).m_49966_()).toList();
    public static final Holder<ConfiguredFeature<OreVeinFeature.Configuration, ?>> HEMATITE_VEIN_CONFIG = FeaturesNF.register("hematite_vein", ORE_VEIN_FEATURE, new OreVeinFeature.Configuration(FeaturesNF.getOreKeys(BlocksNF.HEMATITE_ORES.keySet()), HEMATITE_ORE_VALUES, 0.005183999999999999, 0.4f, 0.2f, 8, 9, 7, 8, 0.02, 0.024));
    public static final Holder<PlacedFeature> HEMATITE_VEIN = FeaturesNF.register("hematite_vein", HEMATITE_VEIN_CONFIG, FeaturesNF.orePlacement(0, 4, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-32), (VerticalAnchor)VerticalAnchor.m_158922_((int)320))));
    private static final List<BlockState> COAL_ORE_VALUES = BlocksNF.COAL_ORES.values().stream().map(block -> ((Block)block.get()).m_49966_()).toList();
    public static final Holder<ConfiguredFeature<OreVeinFeature.Configuration, ?>> COAL_VEIN_CONFIG = FeaturesNF.register("coal_vein", ORE_VEIN_FEATURE, new OreVeinFeature.Configuration(FeaturesNF.getOreKeys(BlocksNF.COAL_ORES.keySet()), COAL_ORE_VALUES, 0.005183999999999999, 0.5f, 0.25f, 8, 9, 6, 9, 0.02, 0.027));
    public static final Holder<PlacedFeature> COAL_VEIN = FeaturesNF.register("coal_vein", COAL_VEIN_CONFIG, FeaturesNF.orePlacement(0, 2, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)160), (VerticalAnchor)VerticalAnchor.m_158922_((int)440))));
    private static final List<BlockState> HALITE_ORE_VALUES = BlocksNF.HALITE_ORES.values().stream().map(block -> ((Block)block.get()).m_49966_()).toList();
    public static final Holder<ConfiguredFeature<OreVeinFeature.Configuration, ?>> HALITE_VEIN_CONFIG = FeaturesNF.register("halite_vein", ORE_VEIN_FEATURE, new OreVeinFeature.Configuration(FeaturesNF.getOreKeys(BlocksNF.HALITE_ORES.keySet()), HALITE_ORE_VALUES, 0.010000000000000002, 0.55f, 0.25f, 10, 7, 2, 3, 0.014, 0.014));
    public static final Holder<PlacedFeature> HALITE_VEIN = FeaturesNF.register("halite_vein", HALITE_VEIN_CONFIG, FeaturesNF.orePlacement(0, 2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)300), (VerticalAnchor)VerticalAnchor.m_158922_((int)800))));
    public static final RuleTest NATURAL_STONE = new TagMatchTest(TagsNF.NATURAL_STONE);
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> FIRE_CLAY_CONFIG = FeatureUtils.m_206488_((String)"fire_clay", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(NATURAL_STONE, ((Block)BlocksNF.FIRE_CLAY.get()).m_49966_(), 30));
    public static final Holder<PlacedFeature> FIRE_CLAY = FeaturesNF.register("fire_clay", FIRE_CLAY_CONFIG, FeaturesNF.orePlacement(0, 1, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)130), (VerticalAnchor)VerticalAnchor.m_158922_((int)290))));
    public static final CaveRocksFeature CAVE_ROCKS_FEATURE = new CaveRocksFeature(FeaturesNF.name("cave_rocks"));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> CAVE_ROCKS_CONFIG = FeaturesNF.register("cave_rocks", CAVE_ROCKS_FEATURE, FeatureConfiguration.f_67737_);
    public static final Holder<PlacedFeature> CAVE_ROCKS = FeaturesNF.register("cave_rocks", CAVE_ROCKS_CONFIG, new PlacementModifier[]{CountPlacement.m_191628_((int)256), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)16), (VerticalAnchor)VerticalAnchor.m_158935_((int)16)), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()});
    public static final RockwormNestFeature ROCKWORM_NEST_FEATURE = new RockwormNestFeature(FeaturesNF.name("rockworm_nest"));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> ROCKWORM_NEST_CONFIG = FeaturesNF.register("rockworm_nest", ROCKWORM_NEST_FEATURE, FeatureConfiguration.f_67737_);
    public static final Holder<PlacedFeature> ROCKWORM_NEST = FeaturesNF.register("rockworm_nest", ROCKWORM_NEST_CONFIG, new PlacementModifier[]{CountPlacement.m_191628_((int)32), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)16), (VerticalAnchor)VerticalAnchor.m_158935_((int)16)), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()});
    public static final SkaraNestFeature SKARA_NEST_FEATURE = new SkaraNestFeature(FeaturesNF.name("skara_nest"));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> SKARA_NEST_CONFIG = FeaturesNF.register("skara_nest", SKARA_NEST_FEATURE, FeatureConfiguration.f_67737_);
    public static final Holder<PlacedFeature> SKARA_NEST = FeaturesNF.register("skara_nest", SKARA_NEST_CONFIG, new PlacementModifier[]{CountPlacement.m_191628_((int)64), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)16), (VerticalAnchor)VerticalAnchor.m_158935_((int)16)), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()});
    public static final MeteoriteFeature METEORITE_FEATURE = new MeteoriteFeature(FeaturesNF.name("meteorite"));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> METEORITE_CONFIG = FeaturesNF.register("meteorite", METEORITE_FEATURE, FeatureConfiguration.f_67737_);
    public static final Holder<PlacedFeature> METEORITE = FeaturesNF.register("meteorite", METEORITE_CONFIG, new PlacementModifier[]{ChanceFilter.with(0.0135f), CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
    public static final RabbitBurrowFeature RABBIT_BURROW_FEATURE = new RabbitBurrowFeature(FeaturesNF.name("rabbit_burrow"));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> RABBIT_BURROW_CONFIG = FeaturesNF.register("rabbit_burrow", RABBIT_BURROW_FEATURE, FeatureConfiguration.f_67737_);
    public static final Holder<PlacedFeature> RABBIT_BURROW = FeaturesNF.register("rabbit_burrow", RABBIT_BURROW_CONFIG, new PlacementModifier[]{ChanceFilter.with(0.035f), CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
    public static final SpiderNestFeature SPIDER_NEST_FEATURE = new SpiderNestFeature(FeaturesNF.name("spider_nest"));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> SPIDER_NEST_CONFIG = FeaturesNF.register("spider_nest", SPIDER_NEST_FEATURE, FeatureConfiguration.f_67737_);
    public static final Holder<PlacedFeature> SPIDER_NEST_SURFACE = FeaturesNF.register("spider_nest_surface", SPIDER_NEST_CONFIG, new PlacementModifier[]{CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, NearSpawnFilter.with(50.0f), ChanceFilter.with(0.0025f), SurfaceHeightFilter.with(421, 475), RectangleClimateFilter.with(0.0f, 1.0f, 0.29f, 1.0f), BiomeFilter.m_191561_()});
    public static final Holder<PlacedFeature> SPIDER_NEST_CAVES = FeaturesNF.register("spider_nest_caves", SPIDER_NEST_CONFIG, new PlacementModifier[]{CountPlacement.m_191628_((int)34), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)30), (VerticalAnchor)VerticalAnchor.m_158935_((int)16)), BiomeFilter.m_191561_(), BlockPredicateFilter.m_191576_((BlockPredicate)CAVE_AIR_PREDICATE)});

    public static void registerEvent(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Feature[]{TREE_FEATURE, LONE_TREE_FEATURE, ROCKS_FEATURE, SINGLE_BLOCK_FEATURE, ABANDONED_EGG_NEST_FEATURE, BOULDER_FEATURE, ORE_VEIN_FEATURE, CAVE_ROCKS_FEATURE, ROCKWORM_NEST_FEATURE, SKARA_NEST_FEATURE, METEORITE_FEATURE, RABBIT_BURROW_FEATURE, SPIDER_NEST_FEATURE});
    }

    private static String name(String name) {
        return "nightfall:" + name;
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<FC, ?>> register(String name, F feature, FC config) {
        return FeatureUtils.m_206488_((String)FeaturesNF.name(name), feature, config);
    }

    private static Holder<PlacedFeature> register(String name, Holder<? extends ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placements) {
        return PlacementUtils.m_206509_((String)FeaturesNF.name(name), feature, placements);
    }

    private static Holder<PlacedFeature> register(String name, Holder<? extends ConfiguredFeature<?, ?>> feature, PlacementModifier ... placements) {
        return PlacementUtils.m_206513_((String)FeaturesNF.name(name), feature, (PlacementModifier[])placements);
    }

    private static RandomPatchConfiguration patch(BlockStateProvider stateProvider, int tries) {
        return FeatureUtils.m_206470_((int)tries, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(stateProvider)));
    }

    private static RandomPatchConfiguration patch(BlockStateProvider stateProvider, int tries, int xzSpread, int ySpread) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(stateProvider)));
    }

    private static RectangleClimateFilter cropClimateFilter(CropBlockNF crop) {
        return RectangleClimateFilter.with(crop.minTemp, crop.maxTemp, crop.minHumidity, crop.maxHumidity);
    }

    private static List<PlacementModifier> orePlacement(int minCount, int maxCount, PlacementModifier heightRange) {
        return List.of(BiomeFilter.m_191561_(), minCount == maxCount ? CountPlacement.m_191628_((int)minCount) : CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)minCount, (int)maxCount)), InSquarePlacement.m_191715_(), heightRange);
    }

    private static List<BlockState> getOreKeys(Set<Stone> oreValues) {
        BlockState[] keys = new BlockState[oreValues.size()];
        int i = 0;
        for (Stone stone : oreValues) {
            keys[i] = ((StoneBlock)((Object)BlocksNF.STONE_BLOCKS.get(stone).get())).m_49966_();
            ++i;
        }
        return List.of(keys);
    }
}

