/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.registry.forge;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import frostnox.nightfall.Nightfall;
import frostnox.nightfall.block.IMetal;
import frostnox.nightfall.block.Metal;
import frostnox.nightfall.block.fluid.LavaFluidNF;
import frostnox.nightfall.block.fluid.MetalFluid;
import frostnox.nightfall.block.fluid.WaterFluidNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.util.DataUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FluidsNF {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"nightfall");
    public static final RegistryObject<WaterFluidNF> WATER = FLUIDS.register("water", () -> new WaterFluidNF.Source(WATER_PROPERTIES));
    public static final RegistryObject<WaterFluidNF> WATER_FLOWING = FLUIDS.register("water_flowing", () -> new WaterFluidNF.Flowing(WATER_PROPERTIES));
    public static final ForgeFlowingFluid.Properties WATER_PROPERTIES = new ForgeFlowingFluid.Properties(() -> (Fluid)WATER.get(), () -> (Fluid)WATER_FLOWING.get(), FluidAttributes.Water.builder((ResourceLocation)FluidsNF.still("water"), (ResourceLocation)FluidsNF.flow("water")).color(-14207150).overlay(FluidsNF.overlay("water")).temperature(20).sound(SoundEvents.f_11781_, SoundEvents.f_11778_)).slopeFindDistance(3).levelDecreasePerBlock(1).canMultiply().block(() -> (LiquidBlock)BlocksNF.WATER.get()).explosionResistance(100.0f).tickRate(4);
    public static final RegistryObject<WaterFluidNF> SEAWATER = FLUIDS.register("seawater", () -> new WaterFluidNF.Source(SEAWATER_PROPERTIES));
    public static final RegistryObject<WaterFluidNF> SEAWATER_FLOWING = FLUIDS.register("seawater_flowing", () -> new WaterFluidNF.Flowing(SEAWATER_PROPERTIES));
    public static final ForgeFlowingFluid.Properties SEAWATER_PROPERTIES = new ForgeFlowingFluid.Properties(() -> (Fluid)SEAWATER.get(), () -> (Fluid)SEAWATER_FLOWING.get(), FluidAttributes.builder((ResourceLocation)FluidsNF.still("seawater"), (ResourceLocation)FluidsNF.flow("seawater")).overlay(FluidsNF.overlay("seawater")).temperature(20).sound(SoundEvents.f_11781_, SoundEvents.f_11778_)).slopeFindDistance(3).levelDecreasePerBlock(1).canMultiply().block(() -> (LiquidBlock)BlocksNF.SEAWATER.get()).explosionResistance(100.0f).tickRate(4);
    public static final RegistryObject<LavaFluidNF> LAVA = FLUIDS.register("lava", () -> new LavaFluidNF.Source(LAVA_PROPERTIES));
    public static final RegistryObject<LavaFluidNF> LAVA_FLOWING = FLUIDS.register("lava_flowing", () -> new LavaFluidNF.Flowing(LAVA_PROPERTIES));
    public static final ForgeFlowingFluid.Properties LAVA_PROPERTIES = new ForgeFlowingFluid.Properties(() -> (Fluid)LAVA.get(), () -> (Fluid)LAVA_FLOWING.get(), FluidAttributes.builder((ResourceLocation)FluidsNF.still("lava"), (ResourceLocation)FluidsNF.flow("lava")).overlay(null).temperature(1000).sound(SoundEvents.f_11783_, SoundEvents.f_11780_)).slopeFindDistance(2).levelDecreasePerBlock(1).block(() -> (LiquidBlock)BlocksNF.LAVA.get()).explosionResistance(100.0f).tickRate(24);
    public static final ResourceLocation METAL_STILL = FluidsNF.still("metal");
    public static final ResourceLocation METAL_FLOW = FluidsNF.flow("metal");
    public static final ResourceLocation METAL_SOLID = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"block/metal");
    public static final Map<Metal, RegistryObject<MetalFluid>> METAL = DataUtil.mapEnum(Metal.class, metal -> FLUIDS.register(metal.getName(), () -> new MetalFluid.Source(METAL_PROPERTIES.get(metal))));
    public static final Map<Metal, RegistryObject<MetalFluid>> METAL_FLOWING = DataUtil.mapEnum(Metal.class, metal -> FLUIDS.register(metal.getName() + "_flowing", () -> new MetalFluid.Flowing(METAL_PROPERTIES.get(metal))));
    public static final Map<Metal, MetalFluid.MetalProperties> METAL_PROPERTIES = DataUtil.mapEnum(Metal.class, metal -> new MetalFluid.MetalProperties((Supplier)METAL.get(metal), (Supplier)METAL_FLOWING.get(metal), (IMetal)metal, FluidAttributes.builder((ResourceLocation)METAL_STILL, (ResourceLocation)METAL_FLOW).temperature((int)metal.getMeltTemp()).color(metal.getColor().getRGB())));
    private static final Map<Pair<Item, Fluid>, Item> bucketFluids = new HashMap<Pair<Item, Fluid>, Item>(7);
    private static final BiMap<Fluid, Item> itemFluids = HashBiMap.create((int)2);

    private static ResourceLocation overlay(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("block/" + name + "_overlay"));
    }

    private static ResourceLocation still(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("block/" + name + "_still"));
    }

    private static ResourceLocation flow(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("block/" + name + "_flow"));
    }

    public static void register() {
        FLUIDS.register(Nightfall.MOD_EVENT_BUS);
    }

    public static void init() {
        FluidsNF.registerBucket((Item)ItemsNF.WOODEN_BUCKET.get(), (Fluid)WATER.get(), (Item)ItemsNF.WOODEN_WATER_BUCKET.get());
        FluidsNF.registerBucket((Item)ItemsNF.WOODEN_BUCKET.get(), (Fluid)SEAWATER.get(), (Item)ItemsNF.WOODEN_SEAWATER_BUCKET.get());
        FluidsNF.registerBucket((Item)ItemsNF.BRONZE_BUCKET.get(), (Fluid)WATER.get(), (Item)ItemsNF.BRONZE_WATER_BUCKET.get());
        FluidsNF.registerBucket((Item)ItemsNF.BRONZE_BUCKET.get(), (Fluid)SEAWATER.get(), (Item)ItemsNF.BRONZE_SEAWATER_BUCKET.get());
        FluidsNF.registerBucket((Item)ItemsNF.ALKIMIUM_BUCKET.get(), (Fluid)WATER.get(), (Item)ItemsNF.ALKIMIUM_WATER_BUCKET.get());
        FluidsNF.registerBucket((Item)ItemsNF.ALKIMIUM_BUCKET.get(), (Fluid)SEAWATER.get(), (Item)ItemsNF.ALKIMIUM_SEAWATER_BUCKET.get());
        FluidsNF.registerBucket((Item)ItemsNF.ALKIMIUM_BUCKET.get(), (Fluid)LAVA.get(), (Item)ItemsNF.ALKIMIUM_LAVA_BUCKET.get());
        FluidsNF.registerItem((Fluid)WATER.get(), (Item)ItemsNF.WATER.get());
        FluidsNF.registerItem((Fluid)SEAWATER.get(), (Item)ItemsNF.SEAWATER.get());
    }

    public static void registerBucket(Item emptyBucket, Fluid fluid, Item filledBucket) {
        bucketFluids.put((Pair<Item, Fluid>)new Pair((Object)emptyBucket, (Object)fluid), filledBucket);
    }

    public static ItemStack getFilledBucket(Item emptyBucket, Fluid fluid) {
        Pair key = new Pair((Object)emptyBucket, (Object)fluid);
        if (!bucketFluids.containsKey(key)) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)bucketFluids.get(key));
    }

    public static void registerItem(Fluid fluid, Item item) {
        itemFluids.put((Object)fluid, (Object)item);
    }

    @Nullable
    public static Item getAsItem(Fluid fluid) {
        return (Item)itemFluids.get((Object)fluid);
    }

    public static Fluid getAsFluid(Item item) {
        return (Fluid)itemFluids.inverse().getOrDefault((Object)item, (Object)Fluids.f_76191_);
    }
}

