/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.registry.forge;

import com.google.common.collect.ImmutableMultimap;
import frostnox.nightfall.Nightfall;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.player.PlayerActionSet;
import frostnox.nightfall.block.IMetal;
import frostnox.nightfall.block.Metal;
import frostnox.nightfall.block.Soil;
import frostnox.nightfall.block.SoilCover;
import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.entity.animal.DeerEntity;
import frostnox.nightfall.entity.entity.animal.RabbitEntity;
import frostnox.nightfall.entity.entity.monster.CockatriceEntity;
import frostnox.nightfall.item.Armament;
import frostnox.nightfall.item.ITieredArmorMaterial;
import frostnox.nightfall.item.ITieredItemMaterial;
import frostnox.nightfall.item.TieredArmorMaterial;
import frostnox.nightfall.item.TieredItemMaterial;
import frostnox.nightfall.item.item.ActionableItem;
import frostnox.nightfall.item.item.ArmorStandDummyItem;
import frostnox.nightfall.item.item.BlockItemNF;
import frostnox.nightfall.item.item.BoatItemNF;
import frostnox.nightfall.item.item.BowItemNF;
import frostnox.nightfall.item.item.BuildingMaterialItem;
import frostnox.nightfall.item.item.ChangeOnUseFinishItem;
import frostnox.nightfall.item.item.DyeableAttributeEquipmentItem;
import frostnox.nightfall.item.item.DyeableTieredArmorItem;
import frostnox.nightfall.item.item.DyedShieldItem;
import frostnox.nightfall.item.item.EmptyBucketItem;
import frostnox.nightfall.item.item.FilledBucketItem;
import frostnox.nightfall.item.item.FireStarterItem;
import frostnox.nightfall.item.item.FoodItem;
import frostnox.nightfall.item.item.FuelItem;
import frostnox.nightfall.item.item.IgnitableItem;
import frostnox.nightfall.item.item.LanternItem;
import frostnox.nightfall.item.item.LightItem;
import frostnox.nightfall.item.item.LimeItem;
import frostnox.nightfall.item.item.LogItem;
import frostnox.nightfall.item.item.MaskItem;
import frostnox.nightfall.item.item.MeleeWeaponItem;
import frostnox.nightfall.item.item.PairedMeleeWeaponItem;
import frostnox.nightfall.item.item.PouchItem;
import frostnox.nightfall.item.item.ProjectileItem;
import frostnox.nightfall.item.item.RopeBlockItem;
import frostnox.nightfall.item.item.SaltItem;
import frostnox.nightfall.item.item.ShieldItemNF;
import frostnox.nightfall.item.item.SlingItem;
import frostnox.nightfall.item.item.SulfurItem;
import frostnox.nightfall.item.item.TieredArmorItem;
import frostnox.nightfall.item.item.TorchItem;
import frostnox.nightfall.item.item.UnlitLanternItem;
import frostnox.nightfall.item.item.WardingCharmItem;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.EffectsNF;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.registry.forge.FluidsNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.DataUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemsNF {
    public static final CreativeModeTab NATURAL_TAB = new CreativeModeTab(0, "nightfall.natural_blocks"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)COVERED_DIRT.get((Object)SoilCover.GRASS).get());
        }
    };
    public static final CreativeModeTab FUNCTIONAL_TAB = new CreativeModeTab(1, "nightfall.functional_blocks"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)POT.get());
        }
    };
    public static final CreativeModeTab BUILDING_TAB = new CreativeModeTab(2, "nightfall.building_materials"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)PLANKS.get(Tree.OAK).get());
        }
    };
    public static final CreativeModeTab INGREDIENTS_TAB = new CreativeModeTab(3, "nightfall.ingredients"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)FLINT.get());
        }
    };
    public static final CreativeModeTab FOOD_TAB = new CreativeModeTab(6, "nightfall.food"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)MEAT_STEW.get());
        }
    };
    public static final CreativeModeTab ARMAMENTS_TAB = new CreativeModeTab(7, "nightfall.armaments"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)METAL_ARMAMENTS.get(TieredItemMaterial.STEEL).get(Armament.SWORD).get());
        }
    };
    public static final CreativeModeTab ARMOR_TAB = new CreativeModeTab(8, "nightfall.armor"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)CHESTPLATES.get(TieredArmorMaterial.STEEL_SCALE_SURVIVOR).get());
        }
    };
    public static final CreativeModeTab UTILITIES_TAB = new CreativeModeTab(9, "nightfall.utilities"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)POUCH.get());
        }
    };
    public static final CreativeModeTab CONSUMABLES_TAB = new CreativeModeTab(10, "nightfall.consumables"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)BANDAGE.get());
        }
    };
    public static final DeferredRegister<Item> ITEMS;
    private static final Random RANDOM;
    private static int ARROW_ID;
    public static final RegistryObject<FireStarterItem> FLINT;
    public static final RegistryObject<Item> BONE_SHARD;
    public static final RegistryObject<Item> OBSIDIAN_SHARD;
    public static final RegistryObject<Item> ANCHORING_RESIN;
    public static final RegistryObject<FireStarterItem> STICK;
    public static final RegistryObject<BuildingMaterialItem> PLANT_FIBERS;
    public static final RegistryObject<Item> RAWHIDE;
    public static final RegistryObject<Item> LEATHER;
    public static final RegistryObject<Item> FLAX_FIBERS;
    public static final RegistryObject<Item> LINEN;
    public static final RegistryObject<Item> YARROW;
    public static final RegistryObject<Item> YARROW_POWDER;
    public static final RegistryObject<Item> SULFUR;
    public static final RegistryObject<Item> LIME;
    public static final RegistryObject<Item> SALT;
    public static final RegistryObject<Item> TIN_CHUNK;
    public static final RegistryObject<Item> COPPER_CHUNK;
    public static final RegistryObject<BuildingMaterialItem> AZURITE_CHUNK;
    public static final RegistryObject<BuildingMaterialItem> HEMATITE_CHUNK;
    public static final RegistryObject<Item> METEORITE_CHUNK;
    public static final RegistryObject<Item> TIN_NUGGET;
    public static final RegistryObject<Item> COPPER_NUGGET;
    public static final RegistryObject<Item> AZURITE_NUGGET;
    public static final RegistryObject<Item> HEMATITE_NUGGET;
    public static final RegistryObject<Item> METEORITE_NUGGET;
    public static final RegistryObject<Item> STEEL_NUGGET;
    public static final RegistryObject<FuelItem> COKE;
    public static final RegistryObject<FuelItem> COAL;
    public static final RegistryObject<FuelItem> CHARCOAL;
    public static final RegistryObject<Item> WATER;
    public static final RegistryObject<Item> SEAWATER;
    public static final RegistryObject<Item> ROTTEN_FLESH;
    public static final RegistryObject<Item> LIVING_BONE;
    public static final RegistryObject<Item> DREG_HEART;
    public static final RegistryObject<Item> SCARLET_FEATHER;
    public static final Map<RabbitEntity.Type, RegistryObject<Item>> RABBIT_PELTS;
    public static final Map<DeerEntity.Type, RegistryObject<Item>> DEER_HIDES;
    public static final Map<CockatriceEntity.Type, RegistryObject<Item>> COCKATRICE_SKINS;
    public static final RegistryObject<MeleeWeaponItem> RUSTED_MAUL;
    public static final RegistryObject<MeleeWeaponItem> RUSTED_SPEAR;
    public static final RegistryObject<BowItemNF> TWISTED_BOW;
    public static final RegistryObject<Item> SILK;
    public static final RegistryObject<Item> ROCKY_SCALE;
    public static final RegistryObject<Item> RAW_JELLYFISH;
    public static final RegistryObject<Item> RAW_PALE_FLESH;
    public static final RegistryObject<Item> PIT_DEVIL_TOOTH;
    public static final RegistryObject<Item> BONE;
    public static final RegistryObject<Item> ECTOPLASM;
    public static final RegistryObject<Item> SKARA_SHELLS;
    public static final RegistryObject<Item> POTATO;
    public static final RegistryObject<Item> CARROT;
    public static final RegistryObject<Item> ROASTED_POTATO;
    public static final RegistryObject<Item> ROASTED_CARROT;
    public static final RegistryObject<Item> RAW_GAME;
    public static final RegistryObject<Item> RAW_VENISON;
    public static final RegistryObject<Item> RAW_POULTRY;
    public static final RegistryObject<Item> COOKED_GAME;
    public static final RegistryObject<Item> COOKED_VENISON;
    public static final RegistryObject<Item> COOKED_POULTRY;
    public static final RegistryObject<Item> COOKED_PALE_FLESH;
    public static final RegistryObject<Item> CURED_GAME;
    public static final RegistryObject<Item> CURED_VENISON;
    public static final RegistryObject<Item> CURED_POULTRY;
    public static final RegistryObject<Item> CURED_JELLYFISH;
    public static final RegistryObject<Item> CURED_PALE_FLESH;
    public static final RegistryObject<Item> BERRIES;
    public static final RegistryObject<Item> APPLE;
    public static final RegistryObject<Item> COCONUT;
    public static final RegistryObject<Item> COCONUT_HALF;
    public static final RegistryObject<Item> COCOA_POD;
    public static final RegistryObject<Item> COCOA_BEANS;
    public static final RegistryObject<Item> MEAT_STEW;
    public static final RegistryObject<Item> VEGETABLE_STEW;
    public static final RegistryObject<Item> HEARTY_STEW;
    public static final RegistryObject<Item> SUSPICIOUS_STEW;
    public static final RegistryObject<Item> BURNT_FOOD;
    public static final RegistryObject<Item> DRAKEFOWL_EGG;
    public static final RegistryObject<Item> BOILED_EGG;
    public static final RegistryObject<Item> SOUFFLE;
    public static final RegistryObject<Item> FRUIT_SOUFFLE;
    public static final RegistryObject<Item> SAVORY_SOUFFLE;
    public static final RegistryObject<Item> POTATO_SEEDS;
    public static final RegistryObject<Item> CARROT_SEEDS;
    public static final RegistryObject<Item> FLAX_SEEDS;
    public static final RegistryObject<Item> YARROW_SEEDS;
    public static final Map<Soil, RegistryObject<BuildingMaterialItem>> SOILS;
    public static final Map<Stone, RegistryObject<BuildingMaterialItem>> ROCKS;
    public static final Map<Stone, RegistryObject<BuildingMaterialItem>> STONE_BRICKS;
    public static final Map<Tree, RegistryObject<BuildingMaterialItem>> PLANKS;
    public static final RegistryObject<BuildingMaterialItem> MUD;
    public static final RegistryObject<FuelItem> FIREWOOD;
    public static final RegistryObject<BuildingMaterialItem> CLAY;
    public static final RegistryObject<BuildingMaterialItem> FIRE_CLAY;
    public static final RegistryObject<BuildingMaterialItem> TERRACOTTA_SHARD;
    public static final RegistryObject<BuildingMaterialItem> MUD_BRICK;
    public static final RegistryObject<BuildingMaterialItem> BRICK;
    public static final RegistryObject<BuildingMaterialItem> FIRE_BRICK;
    public static final RegistryObject<BuildingMaterialItem> GLASS;
    public static final RegistryObject<BuildingMaterialItem> SNOWBALL;
    public static final RegistryObject<BuildingMaterialItem> SLAG;
    public static final Map<Tree, RegistryObject<ArmorStandDummyItem>> ARMOR_STANDS;
    public static final Map<Tree, RegistryObject<BoatItemNF>> BOATS;
    public static final RegistryObject<EmptyBucketItem> WOODEN_BUCKET;
    public static final RegistryObject<FilledBucketItem> WOODEN_WATER_BUCKET;
    public static final RegistryObject<FilledBucketItem> WOODEN_SEAWATER_BUCKET;
    public static final RegistryObject<EmptyBucketItem> BRONZE_BUCKET;
    public static final RegistryObject<FilledBucketItem> BRONZE_WATER_BUCKET;
    public static final RegistryObject<FilledBucketItem> BRONZE_SEAWATER_BUCKET;
    public static final RegistryObject<EmptyBucketItem> ALKIMIUM_BUCKET;
    public static final RegistryObject<FilledBucketItem> ALKIMIUM_WATER_BUCKET;
    public static final RegistryObject<FilledBucketItem> ALKIMIUM_SEAWATER_BUCKET;
    public static final RegistryObject<FilledBucketItem> ALKIMIUM_LAVA_BUCKET;
    public static final RegistryObject<SnowballItem> SNOWBALL_THROWABLE;
    private static final int BEAST_COLOR = 8806705;
    private static final int UNDEAD_COLOR = 0x88B5B8;
    public static final RegistryObject<SpawnEggItem> RABBIT_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> DEER_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> DRAKEFOWL_ROOSTER_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> DRAKEFOWL_HEN_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> DRAKEFOWL_CHICK_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> HUSK_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> SKELETON_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> DREG_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> CREEPER_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> COCKATRICE_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> SPIDER_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> ROCKWORM_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> PIT_DEVIL_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> ECTOPLASM_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> SKARA_SWARM_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> JELLYFISH_SPAWN_EGG;
    public static final Map<TieredItemMaterial, Map<Armament, RegistryObject<MeleeWeaponItem>>> METAL_ARMAMENTS;
    public static final Map<TieredArmorMaterial, RegistryObject<TieredArmorItem>> HELMETS;
    public static final Map<TieredArmorMaterial, RegistryObject<TieredArmorItem>> CHESTPLATES;
    public static final Map<TieredArmorMaterial, RegistryObject<TieredArmorItem>> LEGGINGS;
    public static final Map<TieredArmorMaterial, RegistryObject<TieredArmorItem>> BOOTS;
    public static final Map<SoilCover, RegistryObject<BlockItemNF>> COVERED_SILT;
    public static final Map<SoilCover, RegistryObject<BlockItemNF>> COVERED_DIRT;
    public static final Map<SoilCover, RegistryObject<BlockItemNF>> COVERED_LOAM;
    public static final RegistryObject<BlockItemNF> SILT;
    public static final RegistryObject<BlockItemNF> DIRT;
    public static final RegistryObject<BlockItemNF> LOAM;
    public static final RegistryObject<BlockItemNF> ASH;
    public static final RegistryObject<BlockItemNF> GRAVEL;
    public static final RegistryObject<BlockItemNF> BLUE_GRAVEL;
    public static final RegistryObject<BlockItemNF> BLACK_GRAVEL;
    public static final RegistryObject<BlockItemNF> SAND;
    public static final RegistryObject<BlockItemNF> RED_SAND;
    public static final RegistryObject<BlockItemNF> WHITE_SAND;
    public static final Map<Soil, RegistryObject<BlockItemNF>> STRANGE_SOILS;
    public static final RegistryObject<BlockItemNF> SNOW;
    public static final RegistryObject<BlockItemNF> PACKED_SNOW;
    public static final RegistryObject<BlockItemNF> MUD_BLOCK;
    public static final RegistryObject<BlockItemNF> CLAY_BLOCK;
    public static final RegistryObject<BlockItemNF> FIRE_CLAY_BLOCK;
    public static final RegistryObject<BlockItemNF> ICE;
    public static final RegistryObject<BlockItemNF> SEA_ICE;
    public static final RegistryObject<BlockItemNF> SEASHELL;
    public static final RegistryObject<BlockItemNF> BEDROCK;
    public static final RegistryObject<BlockItemNF> SHORT_GRASS;
    public static final RegistryObject<BlockItemNF> GRASS;
    public static final RegistryObject<BlockItemNF> TALL_GRASS;
    public static final RegistryObject<BlockItemNF> SMALL_FERN;
    public static final RegistryObject<BlockItemNF> FERN;
    public static final RegistryObject<BlockItemNF> LARGE_FERN;
    public static final RegistryObject<BlockItemNF> VINES;
    public static final RegistryObject<BlockItemNF> DEAD_BUSH;
    public static final RegistryObject<BlockItemNF> DEAD_PLANT;
    public static final RegistryObject<BlockItemNF> DEAD_CROP;
    public static final RegistryObject<BlockItemNF> BERRY_BUSH;
    public static final Map<Stone, RegistryObject<BlockItemNF>> STONE_BLOCKS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> ROCK_CLUSTERS;
    public static final RegistryObject<BlockItemNF> FLINT_CLUSTER;
    public static final Map<Stone, RegistryObject<BlockItemNF>> TIN_ORES;
    public static final Map<Stone, RegistryObject<BlockItemNF>> COPPER_ORES;
    public static final Map<Stone, RegistryObject<BlockItemNF>> AZURITE_ORES;
    public static final Map<Stone, RegistryObject<BlockItemNF>> HEMATITE_ORES;
    public static final Map<Stone, RegistryObject<BlockItemNF>> COAL_ORES;
    public static final Map<Stone, RegistryObject<BlockItemNF>> HALITE_ORES;
    public static final RegistryObject<BlockItemNF> METEORITE_ORE;
    public static final RegistryObject<BlockItemNF> OBSIDIAN;
    public static final Map<Tree, RegistryObject<LogItem>> LOGS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> STRIPPED_LOGS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> LEAVES;
    public static final Map<Tree, RegistryObject<BlockItemNF>> FRUIT_LEAVES;
    public static final Map<Tree, RegistryObject<BlockItemNF>> BRANCHES;
    public static final Map<Tree, RegistryObject<BlockItemNF>> TREE_SEEDS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> PLANK_BLOCKS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> PLANK_STAIRS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> PLANK_SLABS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> PLANK_SIDINGS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> PLANK_FENCES;
    public static final Map<Tree, RegistryObject<BlockItemNF>> PLANK_FENCE_GATES;
    public static final Map<Tree, RegistryObject<BlockItemNF>> PLANK_DOORS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> PLANK_TRAPDOORS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> PLANK_HATCHES;
    public static final Map<Tree, RegistryObject<BlockItemNF>> PLANK_LADDERS;
    public static final Map<Tree, RegistryObject<SignItem>> PLANK_SIGNS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> WOODEN_ITEM_FRAMES;
    public static final Map<Stone, RegistryObject<BlockItemNF>> TILED_STONE;
    public static final Map<Stone, RegistryObject<BlockItemNF>> POLISHED_STONE;
    public static final Map<Stone, RegistryObject<BlockItemNF>> POLISHED_STONE_STAIRS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> POLISHED_STONE_SLABS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> POLISHED_STONE_SIDINGS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> STACKED_STONE;
    public static final Map<Stone, RegistryObject<BlockItemNF>> STACKED_STONE_STAIRS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> STACKED_STONE_SLABS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> STACKED_STONE_SIDINGS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> COBBLED_STONE;
    public static final Map<Stone, RegistryObject<BlockItemNF>> COBBLED_STONE_STAIRS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> COBBLED_STONE_SLABS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> COBBLED_STONE_SIDINGS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> STONE_BRICK_BLOCKS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> STONE_BRICK_STAIRS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> STONE_BRICK_SLABS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> STONE_BRICK_SIDINGS;
    public static final RegistryObject<BlockItemNF> TERRACOTTA;
    public static final RegistryObject<BlockItemNF> TERRACOTTA_TILES;
    public static final RegistryObject<BlockItemNF> TERRACOTTA_TILE_STAIRS;
    public static final RegistryObject<BlockItemNF> TERRACOTTA_TILE_SLAB;
    public static final RegistryObject<BlockItemNF> TERRACOTTA_TILE_SIDING;
    public static final RegistryObject<BlockItemNF> TERRACOTTA_MOSAIC;
    public static final RegistryObject<BlockItemNF> TERRACOTTA_MOSAIC_STAIRS;
    public static final RegistryObject<BlockItemNF> TERRACOTTA_MOSAIC_SLAB;
    public static final RegistryObject<BlockItemNF> TERRACOTTA_MOSAIC_SIDING;
    public static final RegistryObject<BlockItemNF> MUD_BRICKS;
    public static final RegistryObject<BlockItemNF> MUD_BRICK_STAIRS;
    public static final RegistryObject<BlockItemNF> MUD_BRICK_SLAB;
    public static final RegistryObject<BlockItemNF> MUD_BRICK_SIDING;
    public static final RegistryObject<BlockItemNF> BRICKS;
    public static final RegistryObject<BlockItemNF> BRICK_STAIRS;
    public static final RegistryObject<BlockItemNF> BRICK_SLAB;
    public static final RegistryObject<BlockItemNF> BRICK_SIDING;
    public static final RegistryObject<BlockItemNF> FIRE_BRICKS;
    public static final RegistryObject<BlockItemNF> FIRE_BRICK_STAIRS;
    public static final RegistryObject<BlockItemNF> FIRE_BRICK_SLAB;
    public static final RegistryObject<BlockItemNF> FIRE_BRICK_SIDING;
    public static final RegistryObject<BlockItemNF> THATCH;
    public static final RegistryObject<BlockItemNF> THATCH_STAIRS;
    public static final RegistryObject<BlockItemNF> THATCH_SLAB;
    public static final RegistryObject<BlockItemNF> THATCH_SIDING;
    public static final RegistryObject<BlockItemNF> GLASS_BLOCK;
    public static final RegistryObject<BlockItemNF> GLASS_SLAB;
    public static final RegistryObject<BlockItemNF> GLASS_SIDING;
    public static final RegistryObject<BlockItemNF> WET_MUD_BRICKS;
    public static final RegistryObject<BlockItemNF> CLAY_BRICKS;
    public static final RegistryObject<BlockItemNF> FIRE_CLAY_BRICKS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> BARRELS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> CHESTS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> RACKS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> SHELVES;
    public static final Map<Tree, RegistryObject<BlockItemNF>> CHAIRS;
    public static final Map<Tree, RegistryObject<BlockItemNF>> TROUGHS;
    public static final RegistryObject<TorchItem> TORCH;
    public static final RegistryObject<IgnitableItem> TORCH_UNLIT;
    public static final RegistryObject<RopeBlockItem> ROPE;
    public static final RegistryObject<BlockItemNF> WOODEN_BOWL;
    public static final RegistryObject<BlockItemNF> CAMPFIRE;
    public static final RegistryObject<BlockItemNF> CAULDRON;
    public static final RegistryObject<BlockItemNF> UNFIRED_CAULDRON;
    public static final RegistryObject<BlockItemNF> POT;
    public static final RegistryObject<BlockItemNF> UNFIRED_POT;
    public static final RegistryObject<BlockItemNF> WARDING_EFFIGY;
    public static final RegistryObject<MeleeWeaponItem> WOODEN_CLUB;
    public static final RegistryObject<MeleeWeaponItem> FLINT_ADZE;
    public static final RegistryObject<MeleeWeaponItem> FLINT_AXE;
    public static final RegistryObject<MeleeWeaponItem> FLINT_DAGGER;
    public static final RegistryObject<PairedMeleeWeaponItem> FLINT_CHISEL;
    public static final RegistryObject<MeleeWeaponItem> FLINT_HAMMER;
    public static final RegistryObject<MeleeWeaponItem> FLINT_SHOVEL;
    public static final RegistryObject<MeleeWeaponItem> FLINT_SPEAR;
    public static final RegistryObject<SlingItem> SLING;
    public static final RegistryObject<SlingItem> SLING_REINFORCED;
    public static final Map<Tree, RegistryObject<BowItemNF>> BOWS;
    public static final RegistryObject<ProjectileItem> FLINT_ARROW;
    public static final RegistryObject<ProjectileItem> BONE_ARROW;
    public static final RegistryObject<ProjectileItem> RUSTED_ARROW;
    public static final RegistryObject<DyeableAttributeEquipmentItem> BACKPACK;
    public static final RegistryObject<PouchItem> POUCH;
    public static final RegistryObject<MaskItem> MASK;
    public static final RegistryObject<ActionableItem> FIBER_BANDAGE;
    public static final RegistryObject<ActionableItem> BANDAGE;
    public static final RegistryObject<ActionableItem> MEDICINAL_BANDAGE;
    private static final float[] SHIELD_DEFENSES;
    public static final RegistryObject<ShieldItemNF> IRONWOOD_SHIELD;
    public static final RegistryObject<DyedShieldItem> IRONWOOD_SHIELD_DYED;
    public static final RegistryObject<WardingCharmItem> WARDING_CHARM;
    public static final Map<Metal, RegistryObject<BuildingMaterialItem>> INGOTS;
    public static final Map<Metal, RegistryObject<Item>> BILLETS;
    public static final Map<Metal, RegistryObject<Item>> WIRES;
    public static final Map<Metal, RegistryObject<Item>> PLATES;
    public static final Map<Metal, RegistryObject<Item>> CHAINMAIL;
    public static final Map<Metal, RegistryObject<Item>> SCALES;
    public static final Map<TieredItemMaterial, Map<Armament, RegistryObject<Item>>> ARMAMENT_HEADS;
    public static final Map<TieredItemMaterial, RegistryObject<Item>> METAL_ARROWHEADS;
    public static final Map<Metal, RegistryObject<ShieldItemNF>> METAL_SHIELDS;
    public static final Map<Metal, RegistryObject<DyedShieldItem>> METAL_SHIELDS_DYED;
    public static final Map<TieredItemMaterial, RegistryObject<ProjectileItem>> METAL_ARROWS;
    public static final RegistryObject<LightItem> IRON_BLOOM;
    public static final Map<Metal, RegistryObject<BlockItemNF>> METAL_BLOCKS;
    public static final Map<Metal, RegistryObject<BlockItemNF>> INGOT_PILES;
    public static final RegistryObject<BlockItemNF> STEEL_INGOT_PILE_POOR;
    public static final RegistryObject<BlockItemNF> STEEL_INGOT_PILE_FAIR;
    public static final Map<Metal, RegistryObject<LanternItem>> LANTERNS;
    public static final Map<Metal, RegistryObject<UnlitLanternItem>> LANTERNS_UNLIT;
    public static final Map<Tree, RegistryObject<BlockItemNF>> ANVILS_LOG;
    public static final Map<Stone, RegistryObject<BlockItemNF>> ANVILS_STONE;
    public static final Map<Metal, RegistryObject<BlockItemNF>> ANVILS_METAL;
    public static final Map<Armament, RegistryObject<BlockItemNF>> ARMAMENT_MOLDS;
    public static final RegistryObject<BlockItemNF> INGOT_MOLD;
    public static final RegistryObject<BlockItemNF> ARROWHEAD_MOLD;
    public static final Map<Armament, RegistryObject<BlockItemNF>> UNFIRED_ARMAMENT_MOLDS;
    public static final RegistryObject<BlockItemNF> UNFIRED_INGOT_MOLD;
    public static final RegistryObject<BlockItemNF> UNFIRED_ARROWHEAD_MOLD;
    public static final RegistryObject<BlockItemNF> COKE_BLOCK;
    public static final RegistryObject<BlockItemNF> COAL_BLOCK;
    public static final RegistryObject<BlockItemNF> CHARCOAL_BLOCK;
    public static final RegistryObject<BlockItemNF> FIREWOOD_BLOCK;
    public static final RegistryObject<BlockItemNF> SLAG_BLOCK;
    public static final RegistryObject<BlockItemNF> AZURITE_BLOCK;
    public static final RegistryObject<BlockItemNF> HEMATITE_BLOCK;
    public static final RegistryObject<BlockItemNF> SMELTED_AZURITE;
    public static final RegistryObject<BlockItemNF> SMELTED_HEMATITE;
    public static final RegistryObject<BlockItemNF> UNFIRED_CRUCIBLE;
    public static final RegistryObject<BlockItemNF> CRUCIBLE;
    public static final RegistryObject<BlockItemNF> SPIDER_WEB;
    public static final RegistryObject<BlockItemNF> SPIDER_NEST;
    public static final RegistryObject<BlockItemNF> ANCHORING_RESIN_BLOCK;
    public static final Map<Stone, RegistryObject<BlockItemNF>> STONE_TUNNELS;
    public static final Map<Stone, RegistryObject<BlockItemNF>> SKARA_ROCK_CLUSTERS;
    public static final RegistryObject<BlockItemNF> DRAKEFOWL_NEST;

    private static float[] getShieldDefenses(Metal metal) {
        float[] defenses = new float[6];
        for (int i = 0; i < defenses.length; ++i) {
            defenses[i] = 0.3f + metal.getBaseDefenses().get(i).floatValue();
        }
        return defenses;
    }

    public static void register() {
        ITEMS.register(Nightfall.MOD_EVENT_BUS);
    }

    public static Set<RegistryObject<TieredArmorItem>> getTieredArmors() {
        return Stream.of(HELMETS.values(), CHESTPLATES.values(), LEGGINGS.values(), BOOTS.values()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    private static RegistryObject<Item> register(String name) {
        return ITEMS.register(name, () -> new Item(new Item.Properties()));
    }

    private static RegistryObject<Item> register(String name, int stackSize) {
        return ITEMS.register(name, () -> new Item(new Item.Properties().m_41487_(stackSize)));
    }

    private static RegistryObject<Item> register(String name, CreativeModeTab tab) {
        return ITEMS.register(name, () -> new Item(new Item.Properties().m_41491_(tab)));
    }

    private static RegistryObject<Item> register(String name, int stackSize, CreativeModeTab tab) {
        return ITEMS.register(name, () -> new Item(new Item.Properties().m_41487_(stackSize).m_41491_(tab)));
    }

    private static RegistryObject<BlockItemNF> register(RegistryObject<? extends Block> block, int stackSize, CreativeModeTab tab) {
        return ITEMS.register(block.getId().m_135815_(), () -> new BlockItemNF((Block)block.get(), new Item.Properties().m_41487_(stackSize).m_41491_(tab)));
    }

    private static RegistryObject<BlockItemNF> register(RegistryObject<? extends Block> block, CreativeModeTab tab) {
        return ItemsNF.register(block, 16, tab);
    }

    private static RegistryObject<BlockItemNF> register(RegistryObject<? extends Block> block, int stackSize) {
        return ItemsNF.register(block, stackSize, null);
    }

    private static RegistryObject<BlockItemNF> register(RegistryObject<? extends Block> block) {
        return ItemsNF.register(block, 16, null);
    }

    private static Item.Properties armament() {
        return new Item.Properties().m_41491_(ARMAMENTS_TAB);
    }

    private static Item.Properties ingredient() {
        return new Item.Properties().m_41491_(INGREDIENTS_TAB);
    }

    private static Item.Properties building() {
        return new Item.Properties().m_41491_(BUILDING_TAB);
    }

    private static Item.Properties utility() {
        return new Item.Properties().m_41491_(UTILITIES_TAB);
    }

    private static Item.Properties food() {
        return new Item.Properties().m_41491_(FOOD_TAB);
    }

    private static FoodProperties food(int hunger, float saturation) {
        return new FoodProperties.Builder().m_38760_(hunger).m_38758_(saturation).m_38767_();
    }

    private static FoodProperties meat(int hunger, float saturation) {
        return new FoodProperties.Builder().m_38760_(hunger).m_38758_(saturation).m_38757_().m_38767_();
    }

    private static FoodProperties.Builder foodBuilder(int hunger, float saturation) {
        return new FoodProperties.Builder().m_38760_(hunger).m_38758_(saturation);
    }

    static {
        CreativeModeTab.f_40760_ = new CreativeModeTab(4, "hotbar"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)Blocks.f_50078_);
            }

            public void m_6151_(NonNullList<ItemStack> p_40820_) {
                throw new RuntimeException("Implement exception client-side.");
            }

            public boolean m_6563_() {
                return true;
            }
        };
        CreativeModeTab.f_40754_ = new CreativeModeTab(5, "search"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)Items.f_42522_);
            }
        }.m_40779_("item_search.png");
        CreativeModeTab.f_40761_ = new CreativeModeTab(11, "inventory"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)CHESTS.get(Tree.OAK).get());
            }
        }.m_40779_("inventory.png").m_40792_().m_40790_();
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"nightfall");
        RANDOM = new Random(94814035L);
        ARROW_ID = 0;
        FLINT = ITEMS.register("flint", () -> new FireStarterItem(Map.of(TagsNF.FLINT_FIRE_STARTER_WEAK, 10, TagsNF.FLINT_FIRE_STARTER_STRONG, 0), () -> SoundEvents.f_11942_, 0.03125f, ItemsNF.ingredient()));
        BONE_SHARD = ItemsNF.register("bone_shard", INGREDIENTS_TAB);
        OBSIDIAN_SHARD = ITEMS.register("obsidian_shard", () -> new Item(ItemsNF.ingredient()));
        ANCHORING_RESIN = ITEMS.register("anchoring_resin", () -> new Item(ItemsNF.ingredient()));
        STICK = ITEMS.register("stick", () -> new FireStarterItem(Map.of(TagsNF.STICK_FIRE_STARTER, 20), (Supplier<SoundEvent>)SoundsNF.STICK_FIRE_STRIKE, 0.0625f, ItemsNF.ingredient()));
        PLANT_FIBERS = ITEMS.register("plant_fibers", () -> new BuildingMaterialItem(ItemsNF.building()));
        RAWHIDE = ITEMS.register("rawhide", () -> new Item(ItemsNF.ingredient()));
        LEATHER = ITEMS.register("leather", () -> new Item(ItemsNF.ingredient()));
        FLAX_FIBERS = ITEMS.register("flax_fibers", () -> new Item(ItemsNF.ingredient()));
        LINEN = ITEMS.register("linen", () -> new Item(ItemsNF.ingredient()));
        YARROW = ITEMS.register("yarrow", () -> new Item(ItemsNF.ingredient()));
        YARROW_POWDER = ITEMS.register("yarrow_powder", () -> new Item(ItemsNF.ingredient()));
        SULFUR = ItemsNF.register("sulfur", () -> new SulfurItem(ItemsNF.ingredient()));
        LIME = ItemsNF.register("lime", () -> new LimeItem(ItemsNF.ingredient()));
        SALT = ITEMS.register("salt", () -> new SaltItem(ItemsNF.ingredient()));
        TIN_CHUNK = ITEMS.register("tin_chunk", () -> new Item(ItemsNF.ingredient().m_41487_(16)));
        COPPER_CHUNK = ITEMS.register("copper_chunk", () -> new Item(ItemsNF.ingredient().m_41487_(16)));
        AZURITE_CHUNK = ITEMS.register("azurite_chunk", () -> new BuildingMaterialItem(ItemsNF.ingredient().m_41487_(16)));
        HEMATITE_CHUNK = ITEMS.register("hematite_chunk", () -> new BuildingMaterialItem(ItemsNF.ingredient().m_41487_(16)));
        METEORITE_CHUNK = ITEMS.register("meteorite_chunk", () -> new Item(ItemsNF.ingredient().m_41487_(16)));
        TIN_NUGGET = ITEMS.register("tin_nugget", () -> new Item(ItemsNF.ingredient()));
        COPPER_NUGGET = ITEMS.register("copper_nugget", () -> new Item(ItemsNF.ingredient()));
        AZURITE_NUGGET = ITEMS.register("azurite_nugget", () -> new Item(ItemsNF.ingredient()));
        HEMATITE_NUGGET = ITEMS.register("hematite_nugget", () -> new Item(ItemsNF.ingredient()));
        METEORITE_NUGGET = ITEMS.register("meteorite_nugget", () -> new Item(ItemsNF.ingredient()));
        STEEL_NUGGET = ITEMS.register("steel_nugget", () -> new Item(ItemsNF.ingredient()));
        COKE = ItemsNF.register("coke", () -> new FuelItem(2700, 1200.0f, ItemsNF.ingredient()));
        COAL = ITEMS.register("coal", () -> new FuelItem(3000, 1000.0f, ItemsNF.ingredient()));
        CHARCOAL = ItemsNF.register("charcoal", () -> new FuelItem(3000, 1000.0f, ItemsNF.ingredient()));
        WATER = ITEMS.register("water", () -> new Item(new Item.Properties()));
        SEAWATER = ITEMS.register("seawater", () -> new Item(new Item.Properties()));
        ROTTEN_FLESH = ItemsNF.register("rotten_flesh", INGREDIENTS_TAB);
        LIVING_BONE = ItemsNF.register("living_bone", INGREDIENTS_TAB);
        DREG_HEART = ItemsNF.register("dreg_heart", INGREDIENTS_TAB);
        SCARLET_FEATHER = ItemsNF.register("scarlet_feather", INGREDIENTS_TAB);
        RABBIT_PELTS = DataUtil.mapEnum(RabbitEntity.Type.class, type -> ItemsNF.register(type.name().toLowerCase(Locale.ROOT) + "_rabbit_pelt", () -> new Item(ItemsNF.ingredient().m_41487_(32))));
        DEER_HIDES = DataUtil.mapEnum(DeerEntity.Type.class, type -> ItemsNF.register(type.name().toLowerCase(Locale.ROOT) + "_deer_hide", () -> new Item(ItemsNF.ingredient().m_41487_(16))));
        COCKATRICE_SKINS = DataUtil.mapEnum(CockatriceEntity.Type.class, type -> ItemsNF.register(type.name().toLowerCase(Locale.ROOT) + "_cockatrice_skin", () -> new Item(ItemsNF.ingredient().m_41487_(16))));
        RUSTED_MAUL = ItemsNF.register("rusted_maul", () -> new MeleeWeaponItem((ITieredItemMaterial)TieredItemMaterial.METEORITE, PlayerActionSet.MAUL, HurtSphere.MAUL, (HurtSphere)HurtSphere.WEAPONS_TP.get((Object)HurtSphere.MAUL), true, ItemsNF.armament(), List.of(), DamageType.STRIKING, DamageType.SLASHING));
        RUSTED_SPEAR = ITEMS.register("rusted_spear", () -> new MeleeWeaponItem((ITieredItemMaterial)TieredItemMaterial.METEORITE, PlayerActionSet.SPEAR, HurtSphere.SPEAR, (HurtSphere)HurtSphere.WEAPONS_TP.get((Object)HurtSphere.SPEAR), false, ItemsNF.armament(), Armament.SPEAR.getToolActions(), DamageType.PIERCING));
        TWISTED_BOW = ItemsNF.register("twisted_bow", () -> new BowItemNF(ActionsNF.TWISTED_BOW_SHOOT, (TagKey<Item>)ItemTags.f_13161_, ItemsNF.armament().m_41503_(240)));
        SILK = ITEMS.register("silk", () -> new Item(ItemsNF.ingredient()));
        ROCKY_SCALE = ITEMS.register("rocky_scale", () -> new Item(ItemsNF.ingredient()));
        RAW_JELLYFISH = ITEMS.register("raw_jellyfish", () -> new Item(ItemsNF.ingredient().m_41487_(4)));
        RAW_PALE_FLESH = ITEMS.register("raw_pale_flesh", () -> new Item(ItemsNF.ingredient().m_41487_(4)));
        PIT_DEVIL_TOOTH = ITEMS.register("pit_devil_tooth", () -> new Item(ItemsNF.ingredient()));
        BONE = ITEMS.register("bone", () -> new Item(ItemsNF.ingredient()));
        ECTOPLASM = ITEMS.register("ectoplasm", () -> new Item(ItemsNF.ingredient()));
        SKARA_SHELLS = ITEMS.register("skara_shells", () -> new Item(ItemsNF.ingredient()));
        POTATO = ITEMS.register("potato", () -> new Item(new Item.Properties().m_41489_(ItemsNF.food(2, 0.0f)).m_41491_(FOOD_TAB).m_41487_(4)));
        CARROT = ITEMS.register("carrot", () -> new Item(new Item.Properties().m_41489_(ItemsNF.food(2, 0.0f)).m_41491_(FOOD_TAB).m_41487_(4)));
        ROASTED_POTATO = ITEMS.register("roasted_potato", () -> new Item(new Item.Properties().m_41489_(ItemsNF.food(3, 0.2f)).m_41491_(FOOD_TAB).m_41487_(4)));
        ROASTED_CARROT = ITEMS.register("roasted_carrot", () -> new Item(new Item.Properties().m_41489_(ItemsNF.food(3, 0.2f)).m_41491_(FOOD_TAB).m_41487_(4)));
        RAW_GAME = ITEMS.register("raw_game", () -> new FoodItem(48, new Item.Properties().m_41489_(ItemsNF.meat(3, 0.2f)).m_41491_(FOOD_TAB).m_41487_(4)));
        RAW_VENISON = ITEMS.register("raw_venison", () -> new FoodItem(48, new Item.Properties().m_41489_(ItemsNF.meat(4, 0.25f)).m_41491_(FOOD_TAB).m_41487_(4)));
        RAW_POULTRY = ITEMS.register("raw_poultry", () -> new FoodItem(48, new Item.Properties().m_41489_(ItemsNF.meat(4, 0.25f)).m_41491_(FOOD_TAB).m_41487_(4)));
        COOKED_GAME = ITEMS.register("cooked_game", () -> new Item(new Item.Properties().m_41489_(ItemsNF.meat(4, 0.3f)).m_41491_(FOOD_TAB).m_41487_(4)));
        COOKED_VENISON = ITEMS.register("cooked_venison", () -> new Item(new Item.Properties().m_41489_(ItemsNF.meat(5, 0.35f)).m_41491_(FOOD_TAB).m_41487_(4)));
        COOKED_POULTRY = ITEMS.register("cooked_poultry", () -> new Item(new Item.Properties().m_41489_(ItemsNF.meat(5, 0.35f)).m_41491_(FOOD_TAB).m_41487_(4)));
        COOKED_PALE_FLESH = ITEMS.register("cooked_pale_flesh", () -> new FoodItem(48, new Item.Properties().m_41489_(ItemsNF.meat(3, 0.2f)).m_41491_(FOOD_TAB).m_41487_(4)));
        CURED_GAME = ITEMS.register("cured_game", () -> new Item(new Item.Properties().m_41489_(ItemsNF.meat(4, 0.3f)).m_41491_(FOOD_TAB).m_41487_(8)));
        CURED_VENISON = ITEMS.register("cured_venison", () -> new Item(new Item.Properties().m_41489_(ItemsNF.meat(5, 0.35f)).m_41491_(FOOD_TAB).m_41487_(8)));
        CURED_POULTRY = ITEMS.register("cured_poultry", () -> new Item(new Item.Properties().m_41489_(ItemsNF.meat(5, 0.35f)).m_41491_(FOOD_TAB).m_41487_(8)));
        CURED_JELLYFISH = ITEMS.register("cured_jellyfish", () -> new FoodItem(48, new Item.Properties().m_41489_(ItemsNF.meat(1, 0.0f)).m_41491_(FOOD_TAB).m_41487_(8)));
        CURED_PALE_FLESH = ITEMS.register("cured_pale_flesh", () -> new FoodItem(48, new Item.Properties().m_41489_(ItemsNF.meat(3, 0.2f)).m_41491_(FOOD_TAB).m_41487_(8)));
        BERRIES = ITEMS.register("berries", () -> new Item(new Item.Properties().m_41489_(ItemsNF.foodBuilder(1, 0.0f).m_38767_()).m_41491_(FOOD_TAB).m_41487_(8)));
        APPLE = ITEMS.register("apple", () -> new Item(new Item.Properties().m_41489_(ItemsNF.foodBuilder(4, 0.1f).m_38767_()).m_41491_(FOOD_TAB).m_41487_(4)));
        COCONUT = ITEMS.register("coconut", () -> new Item(new Item.Properties().m_41487_(4).m_41491_(INGREDIENTS_TAB)));
        COCONUT_HALF = ITEMS.register("coconut_half", () -> new Item(new Item.Properties().m_41489_(ItemsNF.foodBuilder(2, 0.25f).m_38767_()).m_41491_(FOOD_TAB).m_41487_(4)));
        COCOA_POD = ITEMS.register("cocoa_pod", () -> new ChangeOnUseFinishItem((Supplier<? extends Item>)COCOA_BEANS, new Item.Properties().m_41489_(ItemsNF.foodBuilder(2, 0.0f).m_38767_()).m_41491_(FOOD_TAB).m_41487_(4)));
        COCOA_BEANS = ItemsNF.register("cocoa_beans", INGREDIENTS_TAB);
        MEAT_STEW = ITEMS.register("meat_stew", () -> new ChangeOnUseFinishItem((Supplier<? extends Item>)WOODEN_BOWL, new Item.Properties().m_41489_(ItemsNF.food(7, 0.4f)).m_41491_(FOOD_TAB).m_41487_(1)));
        VEGETABLE_STEW = ITEMS.register("vegetable_stew", () -> new ChangeOnUseFinishItem((Supplier<? extends Item>)WOODEN_BOWL, new Item.Properties().m_41489_(ItemsNF.food(5, 0.35f)).m_41491_(FOOD_TAB).m_41487_(1)));
        HEARTY_STEW = ITEMS.register("hearty_stew", () -> new ChangeOnUseFinishItem((Supplier<? extends Item>)WOODEN_BOWL, new Item.Properties().m_41489_(ItemsNF.foodBuilder(6, 0.4f).effect(() -> new MobEffectInstance((MobEffect)EffectsNF.INVIGORATING.get(), 6000, 0), 1.0f).m_38767_()).m_41491_(FOOD_TAB).m_41487_(1)));
        SUSPICIOUS_STEW = ITEMS.register("suspicious_stew", () -> new ChangeOnUseFinishItem((Supplier<? extends Item>)WOODEN_BOWL, new Item.Properties().m_41489_(ItemsNF.foodBuilder(3, 0.1f).effect(() -> new MobEffectInstance((MobEffect)EffectsNF.POISON.get(), 600, 0), 0.5f).m_38767_()).m_41491_(FOOD_TAB).m_41487_(1)));
        BURNT_FOOD = ITEMS.register("burnt_food", () -> new Item(new Item.Properties().m_41489_(ItemsNF.food(1, 0.0f)).m_41491_(FOOD_TAB).m_41487_(4)));
        DRAKEFOWL_EGG = ITEMS.register("drakefowl_egg", () -> new Item(ItemsNF.food().m_41489_(ItemsNF.food(2, 0.2f)).m_41487_(4)));
        BOILED_EGG = ITEMS.register("boiled_egg", () -> new Item(ItemsNF.food().m_41489_(ItemsNF.food(4, 0.25f)).m_41487_(4)));
        SOUFFLE = ITEMS.register("souffle", () -> new Item(ItemsNF.food().m_41489_(ItemsNF.food(5, 0.3f)).m_41487_(4)));
        FRUIT_SOUFFLE = ITEMS.register("fruit_souffle", () -> new Item(ItemsNF.food().m_41489_(ItemsNF.foodBuilder(5, 0.3f).effect(() -> new MobEffectInstance((MobEffect)EffectsNF.ENERGIZING.get(), 6000, 0), 1.0f).m_38767_()).m_41487_(4)));
        SAVORY_SOUFFLE = ITEMS.register("savory_souffle", () -> new Item(ItemsNF.food().m_41489_(ItemsNF.foodBuilder(5, 0.5f).effect(() -> new MobEffectInstance((MobEffect)EffectsNF.INVIGORATING.get(), 6000, 0), 1.0f).m_38767_()).m_41487_(4)));
        POTATO_SEEDS = ITEMS.register("potato_seeds", () -> new ItemNameBlockItem((Block)BlocksNF.POTATOES.get(), ItemsNF.ingredient()));
        CARROT_SEEDS = ITEMS.register("carrot_seeds", () -> new ItemNameBlockItem((Block)BlocksNF.CARROTS.get(), ItemsNF.ingredient()));
        FLAX_SEEDS = ITEMS.register("flax_seeds", () -> new ItemNameBlockItem((Block)BlocksNF.FLAX.get(), ItemsNF.ingredient()));
        YARROW_SEEDS = ITEMS.register("yarrow_seeds", () -> new ItemNameBlockItem((Block)BlocksNF.YARROW.get(), ItemsNF.ingredient()));
        SOILS = DataUtil.mapEnum(Soil.class, soil -> ItemsNF.register(soil.getName(), () -> new BuildingMaterialItem(ItemsNF.building())));
        ROCKS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(stone.getName() + "_rock", () -> new BuildingMaterialItem(ItemsNF.building())));
        STONE_BRICKS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(stone.getName() + "_brick", () -> new BuildingMaterialItem(ItemsNF.building())));
        PLANKS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(tree.getName() + "_plank", () -> new BuildingMaterialItem(ItemsNF.building())));
        MUD = ItemsNF.register("mud", () -> new BuildingMaterialItem(ItemsNF.building()));
        FIREWOOD = ItemsNF.register("firewood", () -> new FuelItem(3000, 800.0f, ItemsNF.building()));
        CLAY = ItemsNF.register("clay", () -> new BuildingMaterialItem(ItemsNF.building()));
        FIRE_CLAY = ItemsNF.register("fire_clay", () -> new BuildingMaterialItem(ItemsNF.building()));
        TERRACOTTA_SHARD = ItemsNF.register("terracotta_shard", () -> new BuildingMaterialItem(ItemsNF.building()));
        MUD_BRICK = ItemsNF.register("mud_brick", () -> new BuildingMaterialItem(ItemsNF.building()));
        BRICK = ItemsNF.register("brick", () -> new BuildingMaterialItem(ItemsNF.building()));
        FIRE_BRICK = ItemsNF.register("fire_brick", () -> new BuildingMaterialItem(ItemsNF.building()));
        GLASS = ItemsNF.register("glass", () -> new BuildingMaterialItem(ItemsNF.building()));
        SNOWBALL = ItemsNF.register("snowball", () -> new BuildingMaterialItem(ItemsNF.building()));
        SLAG = ItemsNF.register("slag", () -> new BuildingMaterialItem(ItemsNF.building().m_41487_(32)));
        ARMOR_STANDS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(tree.getName() + "_armor_stand", () -> new ArmorStandDummyItem(PLANKS.get(tree).getId(), new Item.Properties().m_41487_(1))));
        BOATS = DataUtil.mapEnum(Tree.class, tree -> tree.getHardness() > Tree.OAK.getHardness(), tree -> ItemsNF.register(tree.getName() + "_boat", () -> new BoatItemNF(PLANKS.get(tree).getId(), new Item.Properties().m_41487_(1))));
        WOODEN_BUCKET = ITEMS.register("wooden_bucket", () -> new EmptyBucketItem(new Item.Properties().m_41487_(16).m_41491_(UTILITIES_TAB)));
        WOODEN_WATER_BUCKET = ITEMS.register("wooden_water_bucket", () -> new FilledBucketItem(false, (Supplier<? extends FlowingFluid>)FluidsNF.WATER, new Item.Properties().m_41495_((Item)WOODEN_BUCKET.get()).m_41487_(1).m_41491_(UTILITIES_TAB)));
        WOODEN_SEAWATER_BUCKET = ITEMS.register("wooden_seawater_bucket", () -> new FilledBucketItem(false, (Supplier<? extends FlowingFluid>)FluidsNF.SEAWATER, new Item.Properties().m_41495_((Item)WOODEN_BUCKET.get()).m_41487_(1).m_41491_(UTILITIES_TAB)));
        BRONZE_BUCKET = ITEMS.register("bronze_bucket", () -> new EmptyBucketItem(new Item.Properties().m_41487_(16).m_41491_(UTILITIES_TAB)));
        BRONZE_WATER_BUCKET = ITEMS.register("bronze_water_bucket", () -> new FilledBucketItem(true, (Supplier<? extends FlowingFluid>)FluidsNF.WATER, new Item.Properties().m_41495_((Item)BRONZE_BUCKET.get()).m_41487_(1).m_41491_(UTILITIES_TAB)));
        BRONZE_SEAWATER_BUCKET = ITEMS.register("bronze_seawater_bucket", () -> new FilledBucketItem(true, (Supplier<? extends FlowingFluid>)FluidsNF.SEAWATER, new Item.Properties().m_41495_((Item)BRONZE_BUCKET.get()).m_41487_(1).m_41491_(UTILITIES_TAB)));
        ALKIMIUM_BUCKET = ITEMS.register("alkimium_bucket", () -> new EmptyBucketItem(new Item.Properties().m_41487_(16)));
        ALKIMIUM_WATER_BUCKET = ITEMS.register("alkimium_water_bucket", () -> new FilledBucketItem(true, (Supplier<? extends FlowingFluid>)FluidsNF.WATER, new Item.Properties().m_41495_((Item)ALKIMIUM_BUCKET.get()).m_41487_(1)));
        ALKIMIUM_SEAWATER_BUCKET = ITEMS.register("alkimium_seawater_bucket", () -> new FilledBucketItem(true, (Supplier<? extends FlowingFluid>)FluidsNF.SEAWATER, new Item.Properties().m_41495_((Item)ALKIMIUM_BUCKET.get()).m_41487_(1)));
        ALKIMIUM_LAVA_BUCKET = ITEMS.register("alkimium_lava_bucket", () -> new FilledBucketItem(true, (Supplier<? extends FlowingFluid>)FluidsNF.LAVA, new Item.Properties().m_41495_((Item)ALKIMIUM_BUCKET.get()).m_41487_(1)));
        SNOWBALL_THROWABLE = ITEMS.register("snowball_throwable", () -> new SnowballItem(new Item.Properties()));
        RABBIT_SPAWN_EGG = ItemsNF.register(EntitiesNF.RABBIT.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.RABBIT, 14138257, 8806705, ItemsNF.utility()));
        DEER_SPAWN_EGG = ItemsNF.register(EntitiesNF.DEER.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.DEER, 14077633, 8806705, ItemsNF.utility()));
        DRAKEFOWL_ROOSTER_SPAWN_EGG = ItemsNF.register(EntitiesNF.DRAKEFOWL_ROOSTER.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.DRAKEFOWL_ROOSTER, 11147560, 12734999, ItemsNF.utility()));
        DRAKEFOWL_HEN_SPAWN_EGG = ItemsNF.register(EntitiesNF.DRAKEFOWL_HEN.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.DRAKEFOWL_HEN, 16031537, 12734999, ItemsNF.utility()));
        DRAKEFOWL_CHICK_SPAWN_EGG = ItemsNF.register(EntitiesNF.DRAKEFOWL_CHICK.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.DRAKEFOWL_CHICK, 15514951, 12734999, ItemsNF.utility()));
        HUSK_SPAWN_EGG = ItemsNF.register(EntitiesNF.HUSK.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.HUSK, 7172734, 0x88B5B8, ItemsNF.utility()));
        SKELETON_SPAWN_EGG = ItemsNF.register(EntitiesNF.SKELETON.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.SKELETON, 11844554, 0x88B5B8, ItemsNF.utility()));
        DREG_SPAWN_EGG = ItemsNF.register(EntitiesNF.DREG.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.DREG, 8951485, 0x88B5B8, ItemsNF.utility()));
        CREEPER_SPAWN_EGG = ItemsNF.register(EntitiesNF.CREEPER.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.CREEPER, 2124313, 6530865, ItemsNF.utility()));
        COCKATRICE_SPAWN_EGG = ItemsNF.register(EntitiesNF.COCKATRICE.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.COCKATRICE, 5401631, 12734999, ItemsNF.utility()));
        SPIDER_SPAWN_EGG = ItemsNF.register(EntitiesNF.SPIDER.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.SPIDER, 9770253, 0x2C2622, ItemsNF.utility()));
        ROCKWORM_SPAWN_EGG = ItemsNF.register(EntitiesNF.ROCKWORM.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.ROCKWORM, 13353655, 5200227, ItemsNF.utility()));
        PIT_DEVIL_SPAWN_EGG = ItemsNF.register(EntitiesNF.PIT_DEVIL.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.PIT_DEVIL, 5388598, 5792364, ItemsNF.utility()));
        ECTOPLASM_SPAWN_EGG = ItemsNF.register("ectoplasm_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.ECTOPLASM_LARGE, 15196358, 12171725, ItemsNF.utility()));
        SKARA_SWARM_SPAWN_EGG = ItemsNF.register(EntitiesNF.SKARA_SWARM.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.SKARA_SWARM, 10179096, 1781322, ItemsNF.utility()));
        JELLYFISH_SPAWN_EGG = ItemsNF.register(EntitiesNF.JELLYFISH.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(EntitiesNF.JELLYFISH, 15490179, 16103375, ItemsNF.utility()));
        METAL_ARMAMENTS = DataUtil.mapEnum(TieredItemMaterial.class, material -> material.getMetal() == null, material -> DataUtil.mapEnum(Armament.class, armament -> {
            if (armament == Armament.CHISEL) {
                return ItemsNF.register(material.getName() + "_" + armament.getName(), () -> new PairedMeleeWeaponItem((ITieredItemMaterial)material, armament.getActionSet(), PlayerActionSet.HAMMER, PlayerActionSet.CHISEL_AND_HAMMER, armament.getHurtSpheres(), (HurtSphere)HurtSphere.WEAPONS_TP.get((Object)armament.getHurtSpheres()), armament.canDig(), new Item.Properties().m_41491_(ARMAMENTS_TAB), armament.getToolActions(), armament.getDefaultDamageType()));
            }
            return ItemsNF.register(material.getName() + "_" + armament.getName(), () -> new MeleeWeaponItem((ITieredItemMaterial)material, armament.getActionSet(), armament.getHurtSpheres(), (HurtSphere)HurtSphere.WEAPONS_TP.get((Object)armament.getHurtSpheres()), armament.canDig(), new Item.Properties().m_41491_(ARMAMENTS_TAB), armament.getToolActions(), armament.getDefaultDamageType()));
        }));
        HELMETS = DataUtil.mapEnum(TieredArmorMaterial.class, material -> ItemsNF.register(material.getName() + "_helmet", () -> new DyeableTieredArmorItem((ITieredArmorMaterial)material, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ARMOR_TAB))));
        CHESTPLATES = DataUtil.mapEnum(TieredArmorMaterial.class, material -> ItemsNF.register(material.getName() + "_chestplate", () -> new DyeableTieredArmorItem((ITieredArmorMaterial)material, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ARMOR_TAB))));
        LEGGINGS = DataUtil.mapEnum(TieredArmorMaterial.class, material -> ItemsNF.register(material.getName() + "_leggings", () -> new DyeableTieredArmorItem((ITieredArmorMaterial)material, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ARMOR_TAB))));
        BOOTS = DataUtil.mapEnum(TieredArmorMaterial.class, material -> ItemsNF.register(material.getName() + "_boots", () -> new DyeableTieredArmorItem((ITieredArmorMaterial)material, EquipmentSlot.FEET, new Item.Properties().m_41491_(ARMOR_TAB))));
        COVERED_SILT = DataUtil.mapEnum(SoilCover.class, cover -> ItemsNF.register(BlocksNF.COVERED_SILT.get(cover), NATURAL_TAB));
        COVERED_DIRT = DataUtil.mapEnum(SoilCover.class, cover -> ItemsNF.register(BlocksNF.COVERED_DIRT.get(cover), NATURAL_TAB));
        COVERED_LOAM = DataUtil.mapEnum(SoilCover.class, cover -> ItemsNF.register(BlocksNF.COVERED_LOAM.get(cover), NATURAL_TAB));
        SILT = ItemsNF.register(BlocksNF.SILT);
        DIRT = ItemsNF.register(BlocksNF.DIRT);
        LOAM = ItemsNF.register(BlocksNF.LOAM);
        ASH = ItemsNF.register(BlocksNF.ASH);
        GRAVEL = ItemsNF.register(BlocksNF.GRAVEL);
        BLUE_GRAVEL = ItemsNF.register(BlocksNF.BLUE_GRAVEL);
        BLACK_GRAVEL = ItemsNF.register(BlocksNF.BLACK_GRAVEL);
        SAND = ItemsNF.register(BlocksNF.SAND);
        RED_SAND = ItemsNF.register(BlocksNF.RED_SAND);
        WHITE_SAND = ItemsNF.register(BlocksNF.WHITE_SAND);
        STRANGE_SOILS = DataUtil.mapEnum(Soil.class, soil -> ItemsNF.register(BlocksNF.STRANGE_SOILS.get(soil), NATURAL_TAB));
        SNOW = ItemsNF.register(BlocksNF.SNOW);
        PACKED_SNOW = ItemsNF.register(BlocksNF.PACKED_SNOW);
        MUD_BLOCK = ItemsNF.register(BlocksNF.MUD);
        CLAY_BLOCK = ItemsNF.register(BlocksNF.CLAY);
        FIRE_CLAY_BLOCK = ItemsNF.register(BlocksNF.FIRE_CLAY);
        ICE = ItemsNF.register(BlocksNF.ICE, NATURAL_TAB);
        SEA_ICE = ItemsNF.register(BlocksNF.SEA_ICE, NATURAL_TAB);
        SEASHELL = ItemsNF.register(BlocksNF.SEASHELL, NATURAL_TAB);
        BEDROCK = ItemsNF.register(BlocksNF.BEDROCK, NATURAL_TAB);
        SHORT_GRASS = ItemsNF.register(BlocksNF.SHORT_GRASS, NATURAL_TAB);
        GRASS = ItemsNF.register(BlocksNF.GRASS, NATURAL_TAB);
        TALL_GRASS = ItemsNF.register(BlocksNF.TALL_GRASS, NATURAL_TAB);
        SMALL_FERN = ItemsNF.register(BlocksNF.SMALL_FERN, NATURAL_TAB);
        FERN = ItemsNF.register(BlocksNF.FERN, NATURAL_TAB);
        LARGE_FERN = ItemsNF.register(BlocksNF.LARGE_FERN, NATURAL_TAB);
        VINES = ItemsNF.register(BlocksNF.VINES, NATURAL_TAB);
        DEAD_BUSH = ItemsNF.register(BlocksNF.DEAD_BUSH, NATURAL_TAB);
        DEAD_PLANT = ItemsNF.register(BlocksNF.DEAD_PLANT, NATURAL_TAB);
        DEAD_CROP = ItemsNF.register(BlocksNF.DEAD_CROP, NATURAL_TAB);
        BERRY_BUSH = ItemsNF.register(BlocksNF.BERRY_BUSH, NATURAL_TAB);
        STONE_BLOCKS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.STONE_BLOCKS.get(stone), NATURAL_TAB));
        ROCK_CLUSTERS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.ROCK_CLUSTERS.get(stone), NATURAL_TAB));
        FLINT_CLUSTER = ItemsNF.register(BlocksNF.FLINT_CLUSTER, NATURAL_TAB);
        TIN_ORES = DataUtil.mapEnum(Stone.class, stone -> !BlocksNF.TIN_ORES.containsKey(stone), stone -> ItemsNF.register(BlocksNF.TIN_ORES.get(stone), NATURAL_TAB));
        COPPER_ORES = DataUtil.mapEnum(Stone.class, stone -> !BlocksNF.COPPER_ORES.containsKey(stone), stone -> ItemsNF.register(BlocksNF.COPPER_ORES.get(stone), NATURAL_TAB));
        AZURITE_ORES = DataUtil.mapEnum(Stone.class, stone -> !BlocksNF.AZURITE_ORES.containsKey(stone), stone -> ItemsNF.register(BlocksNF.AZURITE_ORES.get(stone), NATURAL_TAB));
        HEMATITE_ORES = DataUtil.mapEnum(Stone.class, stone -> !BlocksNF.HEMATITE_ORES.containsKey(stone), stone -> ItemsNF.register(BlocksNF.HEMATITE_ORES.get(stone), NATURAL_TAB));
        COAL_ORES = DataUtil.mapEnum(Stone.class, stone -> !BlocksNF.COAL_ORES.containsKey(stone), stone -> ItemsNF.register(BlocksNF.COAL_ORES.get(stone), NATURAL_TAB));
        HALITE_ORES = DataUtil.mapEnum(Stone.class, stone -> !BlocksNF.HALITE_ORES.containsKey(stone), stone -> ItemsNF.register(BlocksNF.HALITE_ORES.get(stone), NATURAL_TAB));
        METEORITE_ORE = ItemsNF.register(BlocksNF.METEORITE_ORE, NATURAL_TAB);
        OBSIDIAN = ItemsNF.register(BlocksNF.OBSIDIAN, NATURAL_TAB);
        LOGS = DataUtil.mapEnum(Tree.class, tree -> ITEMS.register(BlocksNF.LOGS.get(tree).getId().m_135815_(), () -> new LogItem((Block)BlocksNF.LOGS.get(tree).get(), ItemsNF.building().m_41487_(16))));
        STRIPPED_LOGS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.STRIPPED_LOGS.get(tree), BUILDING_TAB));
        LEAVES = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.LEAVES.get(tree), NATURAL_TAB));
        FRUIT_LEAVES = DataUtil.mapEnum(Tree.class, tree -> !BlocksNF.FRUIT_LEAVES.containsKey(tree), tree -> ItemsNF.register(BlocksNF.FRUIT_LEAVES.get(tree), NATURAL_TAB));
        BRANCHES = DataUtil.mapEnum(Tree.class, tree -> !BlocksNF.BRANCHES.containsKey(tree), tree -> ItemsNF.register(BlocksNF.BRANCHES.get(tree), NATURAL_TAB));
        TREE_SEEDS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.TREE_SEEDS.get(tree), INGREDIENTS_TAB));
        PLANK_BLOCKS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.PLANK_BLOCKS.get(tree)));
        PLANK_STAIRS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.PLANK_STAIRS.get(tree)));
        PLANK_SLABS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.PLANK_SLABS.get(tree)));
        PLANK_SIDINGS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.PLANK_SIDINGS.get(tree)));
        PLANK_FENCES = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.PLANK_FENCES.get(tree)));
        PLANK_FENCE_GATES = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.PLANK_FENCE_GATES.get(tree)));
        PLANK_DOORS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.PLANK_DOORS.get(tree)));
        PLANK_TRAPDOORS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.PLANK_TRAPDOORS.get(tree)));
        PLANK_HATCHES = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.PLANK_HATCHES.get(tree)));
        PLANK_LADDERS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.PLANK_LADDERS.get(tree)));
        PLANK_SIGNS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(tree.getName() + "_sign", () -> new SignItem(new Item.Properties().m_41487_(1), (Block)BlocksNF.PLANK_STANDING_SIGNS.get(tree).get(), (Block)BlocksNF.PLANK_WALL_SIGNS.get(tree).get())));
        WOODEN_ITEM_FRAMES = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.WOODEN_ITEM_FRAMES.get(tree)));
        TILED_STONE = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.TILED_STONE.get(stone)));
        POLISHED_STONE = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.POLISHED_STONE.get(stone)));
        POLISHED_STONE_STAIRS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.POLISHED_STONE_STAIRS.get(stone)));
        POLISHED_STONE_SLABS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.POLISHED_STONE_SLABS.get(stone)));
        POLISHED_STONE_SIDINGS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.POLISHED_STONE_SIDINGS.get(stone)));
        STACKED_STONE = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.STACKED_STONE.get(stone)));
        STACKED_STONE_STAIRS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.STACKED_STONE_STAIRS.get(stone)));
        STACKED_STONE_SLABS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.STACKED_STONE_SLABS.get(stone)));
        STACKED_STONE_SIDINGS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.STACKED_STONE_SIDINGS.get(stone)));
        COBBLED_STONE = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.COBBLED_STONE.get(stone)));
        COBBLED_STONE_STAIRS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.COBBLED_STONE_STAIRS.get(stone)));
        COBBLED_STONE_SLABS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.COBBLED_STONE_SLABS.get(stone)));
        COBBLED_STONE_SIDINGS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.COBBLED_STONE_SIDINGS.get(stone)));
        STONE_BRICK_BLOCKS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.STONE_BRICK_BLOCKS.get(stone)));
        STONE_BRICK_STAIRS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.STONE_BRICK_STAIRS.get(stone)));
        STONE_BRICK_SLABS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.STONE_BRICK_SLABS.get(stone)));
        STONE_BRICK_SIDINGS = DataUtil.mapEnum(Stone.class, stone -> ItemsNF.register(BlocksNF.STONE_BRICK_SIDINGS.get(stone)));
        TERRACOTTA = ItemsNF.register(BlocksNF.TERRACOTTA, NATURAL_TAB);
        TERRACOTTA_TILES = ItemsNF.register(BlocksNF.TERRACOTTA_TILES);
        TERRACOTTA_TILE_STAIRS = ItemsNF.register(BlocksNF.TERRACOTTA_TILE_STAIRS);
        TERRACOTTA_TILE_SLAB = ItemsNF.register(BlocksNF.TERRACOTTA_TILE_SLAB);
        TERRACOTTA_TILE_SIDING = ItemsNF.register(BlocksNF.TERRACOTTA_TILE_SIDING);
        TERRACOTTA_MOSAIC = ItemsNF.register(BlocksNF.TERRACOTTA_MOSAIC);
        TERRACOTTA_MOSAIC_STAIRS = ItemsNF.register(BlocksNF.TERRACOTTA_MOSAIC_STAIRS);
        TERRACOTTA_MOSAIC_SLAB = ItemsNF.register(BlocksNF.TERRACOTTA_MOSAIC_SLAB);
        TERRACOTTA_MOSAIC_SIDING = ItemsNF.register(BlocksNF.TERRACOTTA_MOSAIC_SIDING);
        MUD_BRICKS = ItemsNF.register(BlocksNF.MUD_BRICKS);
        MUD_BRICK_STAIRS = ItemsNF.register(BlocksNF.MUD_BRICK_STAIRS);
        MUD_BRICK_SLAB = ItemsNF.register(BlocksNF.MUD_BRICK_SLAB);
        MUD_BRICK_SIDING = ItemsNF.register(BlocksNF.MUD_BRICK_SIDING);
        BRICKS = ItemsNF.register(BlocksNF.BRICKS);
        BRICK_STAIRS = ItemsNF.register(BlocksNF.BRICK_STAIRS);
        BRICK_SLAB = ItemsNF.register(BlocksNF.BRICK_SLAB);
        BRICK_SIDING = ItemsNF.register(BlocksNF.BRICK_SIDING);
        FIRE_BRICKS = ItemsNF.register(BlocksNF.FIRE_BRICKS);
        FIRE_BRICK_STAIRS = ItemsNF.register(BlocksNF.FIRE_BRICK_STAIRS);
        FIRE_BRICK_SLAB = ItemsNF.register(BlocksNF.FIRE_BRICK_SLAB);
        FIRE_BRICK_SIDING = ItemsNF.register(BlocksNF.FIRE_BRICK_SIDING);
        THATCH = ItemsNF.register(BlocksNF.THATCH);
        THATCH_STAIRS = ItemsNF.register(BlocksNF.THATCH_STAIRS);
        THATCH_SLAB = ItemsNF.register(BlocksNF.THATCH_SLAB);
        THATCH_SIDING = ItemsNF.register(BlocksNF.THATCH_SIDING);
        GLASS_BLOCK = ItemsNF.register(BlocksNF.GLASS_BLOCK);
        GLASS_SLAB = ItemsNF.register(BlocksNF.GLASS_SLAB);
        GLASS_SIDING = ItemsNF.register(BlocksNF.GLASS_SIDING);
        WET_MUD_BRICKS = ItemsNF.register(BlocksNF.WET_MUD_BRICKS);
        CLAY_BRICKS = ItemsNF.register(BlocksNF.CLAY_BRICKS);
        FIRE_CLAY_BRICKS = ItemsNF.register(BlocksNF.FIRE_CLAY_BRICKS);
        BARRELS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.BARRELS.get(tree), 8));
        CHESTS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.CHESTS.get(tree), 8));
        RACKS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.RACKS.get(tree)));
        SHELVES = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.SHELVES.get(tree)));
        CHAIRS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.CHAIRS.get(tree)));
        TROUGHS = DataUtil.mapEnum(Tree.class, tree -> ItemsNF.register(BlocksNF.TROUGHS.get(tree)));
        TORCH = ITEMS.register("torch", () -> new TorchItem((Block)BlocksNF.TORCH.get(), (Block)BlocksNF.WALL_TORCH.get(), (Supplier<? extends Item>)TORCH_UNLIT, new Item.Properties().m_41491_(UTILITIES_TAB)));
        TORCH_UNLIT = ItemsNF.register("torch_unlit", () -> new IgnitableItem((Supplier<? extends Item>)TORCH, ItemsNF.utility()));
        ROPE = ITEMS.register("rope", () -> new RopeBlockItem((Block)BlocksNF.ROPE.get(), new Item.Properties().m_41491_(UTILITIES_TAB)));
        WOODEN_BOWL = ItemsNF.register(BlocksNF.WOODEN_BOWL, FUNCTIONAL_TAB);
        CAMPFIRE = ItemsNF.register(BlocksNF.CAMPFIRE, 8);
        CAULDRON = ItemsNF.register(BlocksNF.CAULDRON, 8, FUNCTIONAL_TAB);
        UNFIRED_CAULDRON = ItemsNF.register(BlocksNF.UNFIRED_CAULDRON, 8);
        POT = ItemsNF.register(BlocksNF.POT, 8, FUNCTIONAL_TAB);
        UNFIRED_POT = ItemsNF.register(BlocksNF.UNFIRED_POT, 8);
        WARDING_EFFIGY = ItemsNF.register(BlocksNF.WARDING_EFFIGY, FUNCTIONAL_TAB);
        WOODEN_CLUB = ITEMS.register("wooden_club", () -> new MeleeWeaponItem((ITieredItemMaterial)TieredItemMaterial.WOOD, PlayerActionSet.CLUB, HurtSphere.CLUB, (HurtSphere)HurtSphere.WEAPONS_TP.get((Object)HurtSphere.CLUB), false, new Item.Properties().m_41491_(ARMAMENTS_TAB), List.of(), DamageType.STRIKING));
        FLINT_ADZE = ITEMS.register("flint_adze", () -> new MeleeWeaponItem((ITieredItemMaterial)TieredItemMaterial.FLINT, PlayerActionSet.ADZE, HurtSphere.ADZE, (HurtSphere)HurtSphere.WEAPONS_TP.get((Object)HurtSphere.ADZE), true, new Item.Properties().m_41491_(ARMAMENTS_TAB), Armament.ADZE.getToolActions(), DamageType.SLASHING));
        FLINT_AXE = ITEMS.register("flint_axe", () -> new MeleeWeaponItem((ITieredItemMaterial)TieredItemMaterial.FLINT, PlayerActionSet.AXE, HurtSphere.AXE, (HurtSphere)HurtSphere.WEAPONS_TP.get((Object)HurtSphere.AXE), true, new Item.Properties().m_41491_(ARMAMENTS_TAB), Armament.AXE.getToolActions(), DamageType.SLASHING));
        FLINT_DAGGER = ITEMS.register("flint_dagger", () -> new MeleeWeaponItem((ITieredItemMaterial)TieredItemMaterial.FLINT, PlayerActionSet.DAGGER, HurtSphere.FLINT_DAGGER, (HurtSphere)HurtSphere.WEAPONS_TP.get((Object)HurtSphere.FLINT_DAGGER), true, new Item.Properties().m_41491_(ARMAMENTS_TAB), Armament.DAGGER.getToolActions(), DamageType.SLASHING));
        FLINT_CHISEL = ITEMS.register("flint_chisel", () -> new PairedMeleeWeaponItem((ITieredItemMaterial)TieredItemMaterial.FLINT, PlayerActionSet.CHISEL, PlayerActionSet.HAMMER, PlayerActionSet.FLINT_CHISEL_AND_HAMMER, HurtSphere.CHISEL, (HurtSphere)HurtSphere.WEAPONS_TP.get((Object)HurtSphere.CHISEL), true, new Item.Properties().m_41491_(ARMAMENTS_TAB), Armament.CHISEL.getToolActions(), DamageType.PIERCING));
        FLINT_HAMMER = ITEMS.register("flint_hammer", () -> new MeleeWeaponItem((ITieredItemMaterial)TieredItemMaterial.FLINT, PlayerActionSet.HAMMER, HurtSphere.HAMMER, (HurtSphere)HurtSphere.WEAPONS_TP.get((Object)HurtSphere.HAMMER), true, new Item.Properties().m_41491_(ARMAMENTS_TAB), Armament.HAMMER.getToolActions(), DamageType.STRIKING));
        FLINT_SHOVEL = ITEMS.register("flint_shovel", () -> new MeleeWeaponItem((ITieredItemMaterial)TieredItemMaterial.FLINT, PlayerActionSet.SHOVEL, HurtSphere.SHOVEL, (HurtSphere)HurtSphere.WEAPONS_TP.get((Object)HurtSphere.SHOVEL), true, new Item.Properties().m_41491_(ARMAMENTS_TAB), Armament.SHOVEL.getToolActions(), DamageType.STRIKING));
        FLINT_SPEAR = ITEMS.register("flint_spear", () -> new MeleeWeaponItem((ITieredItemMaterial)TieredItemMaterial.FLINT, PlayerActionSet.SPEAR, HurtSphere.SPEAR, (HurtSphere)HurtSphere.WEAPONS_TP.get((Object)HurtSphere.SPEAR), false, new Item.Properties().m_41491_(ARMAMENTS_TAB), Armament.SPEAR.getToolActions(), DamageType.PIERCING));
        SLING = ITEMS.register("sling", () -> new SlingItem(ActionsNF.SLING_THROW, TagsNF.SLING_AMMO, 2.0f, new Item.Properties().m_41503_(120).m_41491_(ARMAMENTS_TAB)));
        SLING_REINFORCED = ITEMS.register("reinforced_sling", () -> new SlingItem(ActionsNF.SLING_THROW, TagsNF.SLING_AMMO, 1.0f, new Item.Properties().m_41503_(440).m_41491_(ARMAMENTS_TAB)));
        BOWS = DataUtil.mapEnum(Tree.class, tree -> tree.getHardness() < 1.4f || tree.getHardness() > 2.0f, tree -> ITEMS.register(tree.getName() + "_bow", () -> new BowItemNF(ActionsNF.BOW_SHOOT, (TagKey<Item>)ItemTags.f_13161_, new Item.Properties().m_41503_((int)(tree.getHardness() * 120.0f)).m_41491_(ARMAMENTS_TAB))));
        FLINT_ARROW = ItemsNF.register("flint_arrow", () -> new ProjectileItem(15.0f, 1.0f, 0.5f, new DamageType[]{DamageType.PIERCING}, ARROW_ID++, new Item.Properties().m_41491_(ARMAMENTS_TAB)));
        BONE_ARROW = ItemsNF.register("bone_arrow", () -> new ProjectileItem(15.0f, 1.0f, 0.5f, new DamageType[]{DamageType.PIERCING}, ARROW_ID++, new Item.Properties().m_41491_(ARMAMENTS_TAB)));
        RUSTED_ARROW = ItemsNF.register("rusted_arrow", () -> new ProjectileItem(20.0f, 0.95f, 0.7f, new DamageType[]{DamageType.PIERCING}, ARROW_ID++, new Item.Properties().m_41491_(ARMAMENTS_TAB)));
        BACKPACK = ITEMS.register("backpack", () -> new DyeableAttributeEquipmentItem(EquipmentSlot.CHEST, 13336911, (ImmutableMultimap<Supplier<Attribute>, AttributeModifier>)ImmutableMultimap.of(AttributesNF.INVENTORY_CAPACITY, (Object)new AttributeModifier(new UUID(RANDOM.nextLong(), RANDOM.nextLong()), "inventory_capacity", 12.0, AttributeModifier.Operation.ADDITION)), new Item.Properties().m_41491_(UTILITIES_TAB).m_41487_(1)));
        POUCH = ITEMS.register("pouch", () -> new PouchItem((ImmutableMultimap<Supplier<Attribute>, AttributeModifier>)ImmutableMultimap.of(AttributesNF.INVENTORY_CAPACITY, (Object)new AttributeModifier(new UUID(RANDOM.nextLong(), RANDOM.nextLong()), "inventory_capacity", 4.0, AttributeModifier.Operation.ADDITION)), new Item.Properties().m_41491_(UTILITIES_TAB).m_41487_(1)));
        MASK = ITEMS.register("mask", () -> new MaskItem((ImmutableMultimap<Supplier<Attribute>, AttributeModifier>)ImmutableMultimap.of(AttributesNF.POISON_RESISTANCE, (Object)new AttributeModifier(new UUID(RANDOM.nextLong(), RANDOM.nextLong()), "mask_poison_resistance", 0.2, AttributeModifier.Operation.ADDITION)), new Item.Properties().m_41491_(UTILITIES_TAB).m_41487_(1)));
        FIBER_BANDAGE = ITEMS.register("fiber_bandage", () -> new ActionableItem(ActionsNF.FIBER_BANDAGE_USE, new Item.Properties().m_41491_(CONSUMABLES_TAB).m_41487_(16)));
        BANDAGE = ITEMS.register("bandage", () -> new ActionableItem(ActionsNF.BANDAGE_USE, new Item.Properties().m_41491_(CONSUMABLES_TAB).m_41487_(16)));
        MEDICINAL_BANDAGE = ITEMS.register("medicinal_bandage", () -> new ActionableItem(ActionsNF.MEDICINAL_BANDAGE_USE, new Item.Properties().m_41491_(CONSUMABLES_TAB).m_41487_(16)));
        SHIELD_DEFENSES = new float[]{0.5f, 0.5f, 0.5f, 0.3f, 0.4f, 0.4f};
        IRONWOOD_SHIELD = ITEMS.register("ironwood_shield", () -> new ShieldItemNF(SHIELD_DEFENSES, ActionsNF.SHIELD_GUARD, new Item.Properties().m_41503_((int)(Tree.IRONWOOD.getHardness() * 150.0f)).m_41491_(ARMAMENTS_TAB)));
        IRONWOOD_SHIELD_DYED = ITEMS.register("ironwood_shield_dyed", () -> new DyedShieldItem(SHIELD_DEFENSES, ActionsNF.SHIELD_GUARD, new Item.Properties().m_41503_((int)(Tree.IRONWOOD.getHardness() * 150.0f))));
        WARDING_CHARM = ITEMS.register("warding_charm", () -> new WardingCharmItem(ItemsNF.utility().m_41487_(1)));
        INGOTS = DataUtil.mapEnum(Metal.class, metal -> ItemsNF.register(metal.getName() + "_ingot", () -> new BuildingMaterialItem(ItemsNF.ingredient().m_41487_(32))));
        BILLETS = DataUtil.mapEnum(Metal.class, metal -> ItemsNF.register(metal.getName() + "_billet", 16, INGREDIENTS_TAB));
        WIRES = DataUtil.mapEnum(Metal.class, metal -> ItemsNF.register(metal.getName() + "_wire", INGREDIENTS_TAB));
        PLATES = DataUtil.mapEnum(Metal.class, metal -> ItemsNF.register(metal.getName() + "_plate", 32, INGREDIENTS_TAB));
        CHAINMAIL = DataUtil.mapEnum(Metal.class, metal -> metal.getCategory() == IMetal.Category.NOBLE, metal -> ItemsNF.register(metal.getName() + "_chainmail", INGREDIENTS_TAB));
        SCALES = DataUtil.mapEnum(Metal.class, metal -> metal.getCategory() == IMetal.Category.NOBLE, metal -> ItemsNF.register(metal.getName() + "_scales", INGREDIENTS_TAB));
        ARMAMENT_HEADS = DataUtil.mapEnum(TieredItemMaterial.class, material -> material.getMetal() == null || material.getMetal().getCategory() == IMetal.Category.NOBLE, material -> DataUtil.mapEnum(Armament.class, armament -> armament == Armament.HAMMER, armament -> ItemsNF.register(material.getName() + "_" + armament.getName() + "_head", 1)));
        METAL_ARROWHEADS = DataUtil.mapEnum(TieredItemMaterial.class, material -> material.getMetal() == null || material.getMetal().getCategory() == IMetal.Category.NOBLE, material -> ItemsNF.register(material.getName() + "_arrowhead"));
        METAL_SHIELDS = DataUtil.mapEnum(Metal.class, metal -> metal.getCategory() == IMetal.Category.NOBLE, metal -> ItemsNF.register(metal.getName() + "_shield", () -> new ShieldItemNF(ItemsNF.getShieldDefenses(metal), ActionsNF.SHIELD_GUARD, new Item.Properties().m_41503_((int)(metal.getStrength() * 70.0f)).m_41491_(ARMAMENTS_TAB))));
        METAL_SHIELDS_DYED = DataUtil.mapEnum(Metal.class, metal -> metal.getCategory() == IMetal.Category.NOBLE, metal -> ItemsNF.register(metal.getName() + "_shield_dyed", () -> new DyedShieldItem(ItemsNF.getShieldDefenses(metal), ActionsNF.SHIELD_GUARD, new Item.Properties().m_41503_((int)(metal.getStrength() * 70.0f)))));
        METAL_ARROWS = DataUtil.mapEnum(TieredItemMaterial.class, material -> material.getMetal() == null || material.getMetal().getCategory() == IMetal.Category.NOBLE, material -> ItemsNF.register(material.getName() + "_arrow", () -> new ProjectileItem(30.0f * material.getDamageMultiplier(), 1.0f, 0.5f, DamageType.PIERCING.asArray(), ARROW_ID++, ItemsNF.armament())));
        IRON_BLOOM = ITEMS.register("iron_bloom", () -> new LightItem(1.15, 13, 5.0, (Supplier<? extends Item>)SLAG, ItemsNF.ingredient().m_41487_(16)));
        METAL_BLOCKS = DataUtil.mapEnum(Metal.class, metal -> !BlocksNF.METAL_BLOCKS.containsKey(metal), metal -> ItemsNF.register(BlocksNF.METAL_BLOCKS.get(metal)));
        INGOT_PILES = DataUtil.mapEnum(Metal.class, metal -> !BlocksNF.INGOT_PILES.containsKey(metal), metal -> ItemsNF.register(BlocksNF.INGOT_PILES.get(metal)));
        STEEL_INGOT_PILE_POOR = ItemsNF.register(BlocksNF.STEEL_INGOT_PILE_POOR, NATURAL_TAB);
        STEEL_INGOT_PILE_FAIR = ItemsNF.register(BlocksNF.STEEL_INGOT_PILE_FAIR, NATURAL_TAB);
        LANTERNS = DataUtil.mapEnum(Metal.class, metal -> ItemsNF.register(BlocksNF.LANTERNS.get(metal).getId().m_135815_(), () -> new LanternItem((Block)BlocksNF.LANTERNS.get(metal).get(), (Supplier)LANTERNS_UNLIT.get(metal), new Item.Properties().m_41487_(16).m_41491_(UTILITIES_TAB))));
        LANTERNS_UNLIT = DataUtil.mapEnum(Metal.class, metal -> ItemsNF.register(BlocksNF.LANTERNS_UNLIT.get(metal).getId().m_135815_(), () -> new UnlitLanternItem((Supplier)LANTERNS.get(metal), (Block)BlocksNF.LANTERNS_UNLIT.get(metal).get(), ItemsNF.utility().m_41487_(16))));
        ANVILS_LOG = DataUtil.mapEnum(Tree.class, tree -> !BlocksNF.ANVILS_LOG.containsKey(tree), tree -> ItemsNF.register(BlocksNF.ANVILS_LOG.get(tree), 1, FUNCTIONAL_TAB));
        ANVILS_STONE = DataUtil.mapEnum(Stone.class, stone -> !BlocksNF.ANVILS_STONE.containsKey(stone), stone -> ItemsNF.register(BlocksNF.ANVILS_STONE.get(stone), 1, FUNCTIONAL_TAB));
        ANVILS_METAL = DataUtil.mapEnum(Metal.class, metal -> !BlocksNF.ANVILS_METAL.containsKey(metal), metal -> ItemsNF.register(BlocksNF.ANVILS_METAL.get(metal), 1, FUNCTIONAL_TAB));
        ARMAMENT_MOLDS = DataUtil.mapEnum(Armament.class, a -> !BlocksNF.ARMAMENT_MOLDS.containsKey(a), armament -> ItemsNF.register(BlocksNF.ARMAMENT_MOLDS.get(armament), FUNCTIONAL_TAB));
        INGOT_MOLD = ItemsNF.register(BlocksNF.INGOT_MOLD, FUNCTIONAL_TAB);
        ARROWHEAD_MOLD = ItemsNF.register(BlocksNF.ARROWHEAD_MOLD, FUNCTIONAL_TAB);
        UNFIRED_ARMAMENT_MOLDS = DataUtil.mapEnum(Armament.class, a -> !BlocksNF.UNFIRED_ARMAMENT_MOLDS.containsKey(a), armament -> ItemsNF.register(BlocksNF.UNFIRED_ARMAMENT_MOLDS.get(armament)));
        UNFIRED_INGOT_MOLD = ItemsNF.register(BlocksNF.UNFIRED_INGOT_MOLD);
        UNFIRED_ARROWHEAD_MOLD = ItemsNF.register(BlocksNF.UNFIRED_ARROWHEAD_MOLD);
        COKE_BLOCK = ItemsNF.register(BlocksNF.COKE);
        COAL_BLOCK = ItemsNF.register(BlocksNF.COAL);
        CHARCOAL_BLOCK = ItemsNF.register(BlocksNF.CHARCOAL);
        FIREWOOD_BLOCK = ItemsNF.register(BlocksNF.FIREWOOD);
        SLAG_BLOCK = ItemsNF.register(BlocksNF.SLAG);
        AZURITE_BLOCK = ItemsNF.register(BlocksNF.AZURITE);
        HEMATITE_BLOCK = ItemsNF.register(BlocksNF.HEMATITE);
        SMELTED_AZURITE = ItemsNF.register(BlocksNF.SMELTED_AZURITE, NATURAL_TAB);
        SMELTED_HEMATITE = ItemsNF.register(BlocksNF.SMELTED_HEMATITE, NATURAL_TAB);
        UNFIRED_CRUCIBLE = ItemsNF.register(BlocksNF.UNFIRED_CRUCIBLE, 8);
        CRUCIBLE = ItemsNF.register(BlocksNF.CRUCIBLE, 8, FUNCTIONAL_TAB);
        SPIDER_WEB = ItemsNF.register(BlocksNF.SPIDER_WEB, 16, NATURAL_TAB);
        SPIDER_NEST = ItemsNF.register(BlocksNF.SPIDER_NEST, NATURAL_TAB);
        ANCHORING_RESIN_BLOCK = ItemsNF.register(BlocksNF.ANCHORING_RESIN, NATURAL_TAB);
        STONE_TUNNELS = DataUtil.mapEnum(Stone.class, stone -> !BlocksNF.STONE_TUNNELS.containsKey(stone), stone -> ItemsNF.register(BlocksNF.STONE_TUNNELS.get(stone), NATURAL_TAB));
        SKARA_ROCK_CLUSTERS = DataUtil.mapEnum(Stone.class, stone -> !BlocksNF.SKARA_ROCK_CLUSTERS.containsKey(stone), stone -> ItemsNF.register(BlocksNF.SKARA_ROCK_CLUSTERS.get(stone), NATURAL_TAB));
        DRAKEFOWL_NEST = ItemsNF.register(BlocksNF.DRAKEFOWL_NEST, NATURAL_TAB);
    }
}

