/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.registry.forge;

import com.mojang.serialization.Codec;
import frostnox.nightfall.Nightfall;
import frostnox.nightfall.world.generation.feature.CottageRuinsFeature;
import frostnox.nightfall.world.generation.feature.DesertedCampFeature;
import frostnox.nightfall.world.generation.feature.ExplorerRuinsFeature;
import frostnox.nightfall.world.generation.feature.SlayerRuinsFeature;
import frostnox.nightfall.world.generation.structure.CottageRuinsPiece;
import frostnox.nightfall.world.generation.structure.DesertedCampPiece;
import frostnox.nightfall.world.generation.structure.ExplorerRuinsPiece;
import frostnox.nightfall.world.generation.structure.SlayerRuinsPiece;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class StructuresNF {
    public static final DeferredRegister<StructureFeature<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"nightfall");
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> COTTAGE_RUINS = STRUCTURES.register("cottage_ruins", () -> new CottageRuinsFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static StructurePieceType COTTAGE_RUINS_PIECE;
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> SLAYER_RUINS;
    public static StructurePieceType SLAYER_RUINS_PIECE;
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> EXPLORER_RUINS;
    public static StructurePieceType EXPLORER_RUINS_PIECE;
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> DESERTED_CAMP;
    public static StructurePieceType DESERTED_CAMP_PIECE;

    public static void register() {
        STRUCTURES.register(Nightfall.MOD_EVENT_BUS);
    }

    public static void registerEvent() {
        COTTAGE_RUINS_PIECE = StructuresNF.createPiece(CottageRuinsPiece::new, COTTAGE_RUINS.getId());
        SLAYER_RUINS_PIECE = StructuresNF.createPiece(SlayerRuinsPiece::new, SLAYER_RUINS.getId());
        EXPLORER_RUINS_PIECE = StructuresNF.createPiece(ExplorerRuinsPiece::new, EXPLORER_RUINS.getId());
        DESERTED_CAMP_PIECE = StructuresNF.createPiece(DesertedCampPiece::new, DESERTED_CAMP.getId());
    }

    public static <C extends FeatureConfiguration> boolean checkSurfaceLocation(PieceGeneratorSupplier.Context<C> context, int xSize, int zSize, int maxHeightDiff) {
        if (!context.m_197380_(Heightmap.Types.WORLD_SURFACE_WG)) {
            return false;
        }
        int[] corners = context.m_197375_(context.f_197355_().m_45604_(), xSize, context.f_197355_().m_45605_(), zSize);
        int min = Math.min(Math.min(corners[0], corners[1]), Math.min(corners[2], corners[3]));
        if (min <= context.f_197352_().m_6337_()) {
            return false;
        }
        int max = Math.max(Math.max(corners[0], corners[1]), Math.max(corners[2], corners[3]));
        return max - min < maxHeightDiff;
    }

    private static StructurePieceType createFullContextPiece(StructurePieceType type, ResourceLocation location) {
        return (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)location, (Object)type);
    }

    private static StructurePieceType createPiece(StructurePieceType.ContextlessType type, ResourceLocation location) {
        return StructuresNF.createFullContextPiece((StructurePieceType)type, location);
    }

    private static StructurePieceType createTemplatePiece(StructurePieceType.StructureTemplateType type, ResourceLocation location) {
        return StructuresNF.createFullContextPiece((StructurePieceType)type, location);
    }

    static {
        SLAYER_RUINS = STRUCTURES.register("slayer_ruins", () -> new SlayerRuinsFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        EXPLORER_RUINS = STRUCTURES.register("explorer_ruins", () -> new ExplorerRuinsFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        DESERTED_CAMP = STRUCTURES.register("deserted_camp", () -> new DesertedCampFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    }
}

