/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util;

import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public class AnimationUtil {
    public static void createDodgeParticles(Player p) {
        int z;
        int y;
        int x = Mth.m_14107_((double)p.m_20185_());
        BlockPos blockpos = new BlockPos(x, y = Mth.m_14107_((double)(p.m_20186_() - (double)0.2f)), z = Mth.m_14107_((double)p.m_20189_()));
        BlockState blockstate = p.f_19853_.m_8055_(blockpos);
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            IPlayerData capP = PlayerData.get(p);
            float xAmount = CombatUtil.DodgeDirection.get(capP.getDodgeDirection()).getZAmount();
            float zAmount = CombatUtil.DodgeDirection.get(capP.getDodgeDirection()).getXAmount();
            float yRot = MathUtil.toRadians(p.m_6080_());
            float xSpeed = xAmount * Mth.m_14089_((float)yRot) - zAmount * Mth.m_14031_((float)yRot);
            float zSpeed = xAmount * Mth.m_14031_((float)yRot) + zAmount * Mth.m_14089_((float)yRot);
            float count = p.m_6113_() >= 0.0f && (double)p.m_6113_() < 0.02 ? 25.000002f : 8.0f / (p.m_6113_() * 10.0f);
            for (int i = 0; i < (int)count; ++i) {
                p.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(blockpos), p.m_20185_() + ((double)p.f_19853_.f_46441_.nextFloat() - 0.5) * (double)p.m_20205_(), p.m_20186_() + 0.1, p.m_20189_() + ((double)p.f_19853_.f_46441_.nextFloat() - 0.5) * (double)p.m_20205_(), (double)xSpeed * -8.0, 1.5, (double)zSpeed * -8.0);
            }
        }
    }

    public static void stunPart(ModelPart part, int frame, int duration, float partialTicks, float degrees, int dir) {
        AnimationCalculator calc = new AnimationCalculator(duration / 2, frame, partialTicks, Easing.outQuart);
        int offset = duration / 2;
        part.f_104203_ += MathUtil.toRadians(-degrees * (float)dir) * calc.getProgress();
        if (frame > offset) {
            calc.setEasing(Easing.inOutSine);
            calc.offset = offset;
            calc.length = duration;
            part.f_104203_ += MathUtil.toRadians(degrees * (float)dir) * calc.getProgress();
        }
    }

    public static void stunPartToDefault(ModelPart part, AnimationData data, int frame, int duration, float partialTicks) {
        AnimationData newData = new AnimationData(data);
        newData.update(frame, duration, partialTicks);
        newData.tCalc.setStaticVector(data.tCalc.getTransformations());
        newData.rCalc.setStaticVector(data.rCalc.getTransformations());
        newData.rCalc.setEasing(Easing.outQuart);
        newData.sCalc.setEasing(Easing.outQuart);
        newData.tCalc.extend(data.dTranslation);
        newData.rCalc.extend(data.dRotation);
        newData.sCalc.extend(data.dScale);
        newData.writeToModelPart(part);
    }

    public static void stunPartToDefaultWithPause(ModelPart part, AnimationData data, int frame, int duration, float partialTicks, float degrees, int dir) {
        AnimationData newData = new AnimationData(data);
        newData.update(frame, duration, partialTicks);
        int offset = duration / 2;
        newData.tCalc.setStaticVector(data.tCalc.getTransformations());
        newData.tCalc.length = offset;
        newData.tCalc.setEasing(Easing.outQuart);
        newData.rCalc.setStaticVector(data.rCalc.getTransformations());
        newData.rCalc.add(-degrees * (float)dir, 0.0f, 0.0f);
        newData.rCalc.length = offset;
        newData.rCalc.setEasing(Easing.outQuart);
        newData.sCalc.setStaticVector(data.sCalc.getTransformations());
        newData.sCalc.length = offset;
        newData.sCalc.setEasing(Easing.outQuart);
        if (frame > offset) {
            newData.resetLengths(duration, Easing.inOutSine);
            newData.tCalc.offset = offset;
            newData.tCalc.extend(data.dTranslation);
            newData.rCalc.offset = offset;
            newData.rCalc.extend(data.dRotation);
            newData.sCalc.offset = offset;
            newData.sCalc.extend(data.dScale);
        }
        newData.writeToModelPart(part);
    }

    public static int getOverlayCoords(LivingEntity pLivingEntity, float pU) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)pU), (int)OverlayTexture.m_118096_((pLivingEntity.f_20916_ > 0 ? 1 : 0) != 0));
    }

    public static int getActiveSideModifier(Player player) {
        return PlayerData.get(player).getActiveHand() == InteractionHand.OFF_HAND ? -1 : 1;
    }

    public static float getBlockRecoilProgress(Player player, float partialTicks) {
        IPlayerData capP = PlayerData.get(player);
        float ticks = player.f_19797_ - capP.getLastBlockTick();
        float block = ticks <= 3.0f ? AnimationUtil.applyEasing(AnimationUtil.interpolate(Math.max(0.0f, ticks - 1.0f), ticks, partialTicks) / 3.0f, Easing.none) : (ticks <= 5.0f ? 1.0f : (ticks <= 8.0f ? AnimationUtil.applyEasing(1.0f - AnimationUtil.interpolate(Math.max(ticks - 6.0f, 0.0f), ticks - 5.0f, partialTicks) / 3.0f, Easing.none) : 0.0f));
        return block;
    }

    public static float getClimbProgress(Player player, float partial) {
        IPlayerData capP = PlayerData.get(player);
        return Math.min(1.0f, Mth.m_14179_((float)partial, (float)(capP.isClimbing() ? (float)Math.max(0, capP.getClimbTicks() - 1) : (float)Math.min(3, capP.getClimbTicks() + 1)), (float)capP.getClimbTicks()) / 3.0f);
    }

    public static boolean isPlayerFacingClimbable(Player player) {
        if (player.m_6147_() && player.f_19853_.m_8055_(player.m_20097_().m_7494_()).isLadder((LevelReader)player.f_19853_, player.m_20097_().m_7494_(), (LivingEntity)player)) {
            float angle = CombatUtil.getRelativeHorizontalAngle(player.m_20318_(1.0f), player.m_146900_().m_60808_((BlockGetter)player.f_19853_, player.m_142538_()).m_83215_().m_82338_(player.m_142538_()).m_82399_(), player.m_5675_(1.0f));
            return angle >= -75.0f && angle <= 75.0f;
        }
        return false;
    }

    public static float getAirborneProgress(Player player, float partial) {
        IPlayerData capP = PlayerData.get(player);
        return Math.min(1.0f, Mth.m_14179_((float)partial, (float)(!player.m_20096_() && !player.m_20159_() && !player.m_6147_() && !capP.isClimbing() && !player.m_21255_() ? (float)Math.max(0, capP.getAirTicks() - 1) : (float)Math.min(8, capP.getAirTicks() + 1)), (float)capP.getAirTicks()) / 8.0f);
    }

    public static float getCrouchProgress(Player player, float partial) {
        IPlayerData capP = PlayerData.get(player);
        return Mth.m_14036_((float)(Mth.m_14179_((float)partial, (float)(player.m_6047_() ? (float)Math.max(0, capP.getCrouchTicks() - 1) : (float)Math.min(3, capP.getCrouchTicks() + 1)), (float)capP.getCrouchTicks()) / 3.0f), (float)0.0f, (float)1.0f);
    }

    public static float getHoldProgress(Player player, float partial) {
        IPlayerData capP = PlayerData.get(player);
        return Math.min(1.0f, Mth.m_14179_((float)partial, (float)(!capP.getHeldContents().m_128456_() ? (float)Math.max(0, capP.getHoldTicks() - 1) : (float)Math.min(3, capP.getHoldTicks() + 1)), (float)capP.getHoldTicks()) / 3.0f);
    }

    public static float getStunProgress(int stunFrame, int stunDuration, float partial) {
        if (stunFrame == stunDuration) {
            return 0.0f;
        }
        int halfDuration = stunDuration / 2;
        if (stunFrame < halfDuration) {
            return ((float)stunFrame + partial) / (float)halfDuration;
        }
        return 1.0f - ((float)(stunFrame - halfDuration) + partial) / (float)halfDuration;
    }

    public static float interpolate(float prevProgress, float currentProgress, float partialTicks) {
        if (prevProgress < 0.0f) {
            prevProgress = 0.0f;
        }
        return prevProgress + (currentProgress - prevProgress) * partialTicks;
    }

    public static double interpolate(double prevProgress, double currentProgress, float partialTicks) {
        if (prevProgress < 0.0) {
            prevProgress = 0.0;
        }
        return prevProgress + (currentProgress - prevProgress) * (double)partialTicks;
    }

    public static float getLinearProgress(float rawAmount, float slow) {
        if (slow <= 0.0f) {
            return 0.0f;
        }
        int iteration = Mth.m_14143_((float)(rawAmount / slow));
        float amount = (rawAmount - slow * (float)iteration) / slow;
        if (iteration % 2 == 0) {
            return amount;
        }
        return 1.0f - amount;
    }

    public static float getSymmetricProgress(float rawAmount, float slow) {
        if (slow <= 0.0f) {
            return 0.0f;
        }
        int iteration = Mth.m_14143_((float)(rawAmount / slow));
        float amount = (rawAmount - slow * (float)iteration) * 2.0f / slow;
        if (iteration % 2 == 0) {
            return amount - 1.0f;
        }
        return 1.0f - amount;
    }

    public static float getProgress(float rawAmount, float slow, Easing easing, boolean symmetric) {
        float p;
        float f = p = symmetric ? AnimationUtil.getSymmetricProgress(rawAmount, slow) : AnimationUtil.getLinearProgress(rawAmount, slow);
        if (!symmetric) {
            return easing.apply(p);
        }
        return switch (easing) {
            case Easing.inSine, Easing.outSine, Easing.inOutSine -> {
                if (p < 0.0f) {
                    yield -Easing.outSine.apply(Math.abs(p));
                }
                yield Easing.outSine.apply(p);
            }
            case Easing.inQuart, Easing.outQuart, Easing.inOutQuart -> {
                if (p < 0.0f) {
                    yield -Easing.outQuart.apply(Math.abs(p));
                }
                yield Easing.outQuart.apply(p);
            }
            case Easing.inQuad, Easing.outQuad, Easing.inOutQuad -> {
                if (p < 0.0f) {
                    yield -Easing.outQuad.apply(Math.abs(p));
                }
                yield Easing.outQuad.apply(p);
            }
            case Easing.inCubic, Easing.outCubic, Easing.inOutCubic -> {
                if (p < 0.0f) {
                    yield -Easing.outCubic.apply(Math.abs(p));
                }
                yield Easing.outCubic.apply(p);
            }
            case Easing.inBack, Easing.outBack, Easing.inOutBack -> {
                if (p < 0.0f) {
                    yield -Easing.outBack.apply(Math.abs(p));
                }
                yield Easing.outBack.apply(p);
            }
            default -> p;
        };
    }

    public static float applyEasing(float p, Easing easing) {
        return easing.apply(p);
    }

    public static HumanoidArm getSideFromHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
    }

    public static float getSideModifier(InteractionHand hand) {
        return AnimationUtil.getSideFromHand(hand) == HumanoidArm.RIGHT ? 1.0f : -1.0f;
    }

    public static AnimationData[] copyAnimationDataArray(AnimationData[] data) {
        AnimationData[] newData = new AnimationData[data.length];
        for (int i = 0; i < data.length; ++i) {
            newData[i] = data[i].copy();
        }
        return newData;
    }
}

