/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util;

import com.mojang.math.Vector3d;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.ArmorStandDummyEntity;
import frostnox.nightfall.item.item.TieredArmorItem;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.data.Vec3f;
import frostnox.nightfall.util.data.Wrapper;
import frostnox.nightfall.util.math.Easing;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CombatUtil {
    public static final UUID BLOCK_SLOW_ID = UUID.fromString("c59cdce7-9656-4f59-add3-09be735e32b3");
    public static final UUID BLOCK_POISE_ID = UUID.fromString("3f84ae45-448a-488c-9815-8475a621cb47");
    public static final UUID STUN_SLOW_ID = UUID.fromString("06dbd56c-1fe0-4183-81a2-15fada3c0f8b");
    public static final UUID ACTION_SLOW_ID = UUID.fromString("cecd39e8-0308-4403-ac3c-faa9463acf9f");
    public static final UUID ACTION_SPEED_ID = UUID.fromString("f543633f-f272-4504-9940-a2fe3aee3698");
    public static final int STUN_SHORT = 8;
    public static final int STUN_MEDIUM = 12;
    public static final int STUN_LONG = 16;
    public static final int STUN_VERY_LONG = 20;
    public static final int STUN_MAX = 24;
    public static final double DODGE_STAMINA_COST = -25.0;
    public static final int DODGE_PENALTY_TICK = 10;

    public static float getRelativeHorizontalAngle(Vec3 startVec, Vec3 endVec, float userYaw) {
        return CombatUtil.getRelativeHorizontalAngle(endVec.f_82479_ - startVec.f_82479_, endVec.f_82481_ - startVec.f_82481_, userYaw);
    }

    public static float getRelativeHorizontalAngle(double dX, double dZ, float userYaw) {
        float angle = MathUtil.getAngleDegrees(dZ, dX) - userYaw % 360.0f;
        if (angle > 180.0f) {
            angle -= 360.0f;
        } else if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static void addMovementTowardsTarget(double max, double scale, Mob entity) {
        double dist;
        LivingEntity target = entity.m_5448_();
        if (target != null) {
            AABB box1 = entity.m_142469_();
            AABB box2 = target.m_142469_();
            double x1 = Math.max(0.0, box1.f_82288_ - box2.f_82291_);
            double z1 = Math.max(0.0, box1.f_82290_ - box2.f_82293_);
            double x2 = Math.max(0.0, box2.f_82288_ - box1.f_82291_);
            double z2 = Math.max(0.0, box2.f_82290_ - box1.f_82293_);
            dist = Math.sqrt(x1 * x1 + z1 * z1 + x2 * x2 + z2 * z2);
        } else {
            dist = 0.0;
        }
        CombatUtil.addFacingMovement(Math.min(max, dist * scale), (LivingEntity)entity);
    }

    public static void addFacingMovement(double magnitude, LivingEntity entity) {
        Vec3 vec = entity.m_20184_();
        float cos = Mth.m_14089_((float)MathUtil.toRadians(entity.m_6080_()));
        float sin = Mth.m_14031_((float)MathUtil.toRadians(entity.m_6080_()));
        double xMove = -magnitude * (double)sin;
        double zMove = magnitude * (double)cos;
        double scalar = entity.m_20072_() ? 0.5 : 1.0;
        entity.m_20334_(vec.m_7096_() + xMove * scalar, vec.m_7098_(), vec.m_7094_() + zMove * scalar);
    }

    public static double getShortestDistanceSqr(Entity attacker, Entity target) {
        double xzDistAdjusted;
        double bestZ;
        double dZ;
        AABB box = target.m_142469_();
        double x = attacker.m_20185_();
        double y = attacker.m_20188_();
        double z = attacker.m_20189_();
        float radius = attacker.m_20205_() / 2.0f;
        float radiusSqr = radius * radius;
        double bestX = Mth.m_14008_((double)x, (double)box.f_82288_, (double)box.f_82291_);
        double dX = x - bestX;
        double xzDistSqr = dX * dX + (dZ = z - (bestZ = Mth.m_14008_((double)z, (double)box.f_82290_, (double)box.f_82293_))) * dZ;
        double d = xzDistAdjusted = xzDistSqr <= (double)radiusSqr ? 0.0 : Math.sqrt(xzDistSqr) - (double)radius;
        double yDist = y < box.f_82289_ ? box.f_82289_ - y : (y > box.f_82292_ ? y - box.f_82292_ : 0.0);
        return xzDistAdjusted * xzDistAdjusted + yDist * yDist;
    }

    public static void damageAllInRadius(Entity source, Vec3 center, double radius, float damage, float knockback, float blockedDamageMultiplier, DamageSource damageSource) {
        boolean notExplosion = !damageSource.m_19372_();
        for (Entity entity : source.f_19853_.m_45933_(source, new AABB(center.f_82479_ - radius, center.f_82480_ - radius, center.f_82481_ - radius, center.f_82479_ + radius, center.f_82480_ + radius, center.f_82481_ + radius))) {
            if (!notExplosion && entity.m_6128_()) continue;
            Vector3d hitPoint = MathUtil.getShortestPointFromPointToBox(center.f_82479_, center.f_82480_, center.f_82481_, entity.m_142469_());
            double dX = hitPoint.f_86214_ - center.f_82479_;
            double dY = hitPoint.f_86215_ - center.f_82480_;
            double dZ = hitPoint.f_86216_ - center.f_82481_;
            double dist = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
            if (!(dist <= radius)) continue;
            dX /= dist;
            dY /= dist;
            dZ /= dist;
            float modifier = Easing.outCubic.apply((float)(1.0 - dist / radius));
            float adjustedDamage = damage * modifier;
            if (source.f_19853_.m_45547_(new ClipContext(center, new Vec3(hitPoint.f_86214_, hitPoint.f_86215_, hitPoint.f_86216_), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.BLOCK) {
                adjustedDamage *= blockedDamageMultiplier;
            }
            entity.m_6469_(damageSource, adjustedDamage);
            float adjustedKnockback = knockback * modifier;
            entity.m_5997_(dX * (double)adjustedKnockback, dY * (double)adjustedKnockback, dZ * (double)adjustedKnockback);
        }
    }

    public static void alignBodyRotWithHead(LivingEntity entity, IActionTracker capA) {
        if (capA.getState() == 0) {
            Action action = capA.getAction();
            AnimationCalculator calc = new AnimationCalculator(capA.isCharging() ? action.getRequiredCharge(entity) : capA.getDuration(), capA.getFrame(), 1.0f, Easing.inOutSine);
            float f = 0.0f;
            if (Math.abs(entity.f_20884_ % 360.0f - entity.f_20885_ % 360.0f) > 180.0f) {
                f = entity.f_20884_ % 360.0f < entity.f_20885_ % 360.0f ? 360.0f : -360.0f;
            }
            calc.setVectors(entity.f_20884_ % 360.0f + f, 0.0f, 0.0f, entity.f_20885_ % 360.0f, 0.0f, 0.0f);
            entity.f_20883_ = calc.getTransformations().m_122239_();
        } else if (capA.getState() < capA.getAction().getTotalStates() - 1) {
            entity.f_20883_ = entity.f_20885_;
        }
    }

    public static void alignBodyRotWithHead(LivingEntity entity, IPlayerData capP) {
        AnimationCalculator calc = new AnimationCalculator(3, capP.getClimbTicks(), 1.0f, Easing.inOutSine);
        float f = 0.0f;
        if (Math.abs(entity.f_20884_ % 360.0f - entity.f_20885_ % 360.0f) > 180.0f) {
            f = entity.f_20884_ % 360.0f < entity.f_20885_ % 360.0f ? 360.0f : -360.0f;
        }
        calc.setVectors(entity.f_20884_ % 360.0f + f, 0.0f, 0.0f, entity.f_20885_ % 360.0f, 0.0f, 0.0f);
        entity.f_20883_ = calc.getTransformations().m_122239_();
    }

    public static void addTransientMultiplier(LivingEntity entity, AttributeInstance attribute, double amount, UUID id, String name) {
        CombatUtil.addTransientModifier(entity, attribute, amount, id, name, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public static void addTransientModifier(LivingEntity entity, AttributeInstance attribute, double amount, UUID id, String name, AttributeModifier.Operation op) {
        if (!entity.f_19853_.m_5776_() && attribute != null) {
            if (attribute.m_22111_(id) != null) {
                attribute.m_22120_(id);
            }
            attribute.m_22118_(new AttributeModifier(id, name, amount, op));
        }
    }

    public static void removeTransientModifier(LivingEntity entity, AttributeInstance attribute, UUID id) {
        if (!entity.f_19853_.m_5776_() && attribute != null && attribute.m_22111_(id) != null) {
            attribute.m_22120_(id);
        }
    }

    public static List<Entity> getAttackableEntitiesNearby(AABB box, LivingEntity user, Level world) {
        List list = world.m_45933_((Entity)user, box);
        if (user instanceof Player) {
            return list.stream().filter(e -> {
                LivingEntity le;
                return (e instanceof HangingEntity || e instanceof Boat || e instanceof LivingEntity && !(le = (LivingEntity)e).m_21224_() && !(e instanceof ArmorStandDummyEntity) || e instanceof Fireball || e instanceof ShulkerBullet) && !e.m_20363_((Entity)user);
            }).collect(Collectors.toCollection(ArrayList::new));
        }
        return list.stream().filter(e -> {
            LivingEntity le;
            return (e instanceof Boat || e instanceof LivingEntity && !(le = (LivingEntity)e).m_21224_()) && !e.m_20363_((Entity)user);
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    public static float applyDamageReduction(float damage, float defense) {
        return Math.max(0.0f, damage * (1.0f - defense));
    }

    public static float getArmorDefenseDurabilityPenalty(float durability, float maxDurability) {
        float halfDurability = maxDurability / 2.0f;
        return durability > halfDurability ? 1.0f : 1.0f - (0.5f - durability / halfDurability * 0.5f);
    }

    public static float applyArmorDamageReduction(float damage, float durability, float maxDurability, float defense) {
        return Math.max(0.0f, damage * (1.0f - defense) * CombatUtil.getArmorDefenseDurabilityPenalty(durability, maxDurability));
    }

    public static float applyAccessoryDamageCalculations(LivingEntity hitEntity, DamageTypeSource source, float damage) {
        return damage;
    }

    public static float applyAttributeDamageCalculations(LivingEntity hitEntity, DamageTypeSource source, float damage) {
        if (!source.isDoT() && hitEntity.m_21051_((Attribute)AttributesNF.STRIKING_DEFENSE.get()) != null) {
            float defense = 0.0f;
            block9: for (DamageType type : source.types) {
                switch (type) {
                    case STRIKING: {
                        defense += (float)hitEntity.m_21051_((Attribute)AttributesNF.STRIKING_DEFENSE.get()).m_22135_();
                        continue block9;
                    }
                    case SLASHING: {
                        defense += (float)hitEntity.m_21051_((Attribute)AttributesNF.SLASHING_DEFENSE.get()).m_22135_();
                        continue block9;
                    }
                    case PIERCING: {
                        defense += (float)hitEntity.m_21051_((Attribute)AttributesNF.PIERCING_DEFENSE.get()).m_22135_();
                        continue block9;
                    }
                    case FIRE: {
                        defense += (float)hitEntity.m_21051_((Attribute)AttributesNF.FIRE_DEFENSE.get()).m_22135_();
                        continue block9;
                    }
                    case FROST: {
                        defense += (float)hitEntity.m_21051_((Attribute)AttributesNF.FROST_DEFENSE.get()).m_22135_();
                        continue block9;
                    }
                    case ELECTRIC: {
                        defense += (float)hitEntity.m_21051_((Attribute)AttributesNF.ELECTRIC_DEFENSE.get()).m_22135_();
                        continue block9;
                    }
                    case WITHER: {
                        defense += (float)hitEntity.m_21051_((Attribute)AttributesNF.WITHER_DEFENSE.get()).m_22135_();
                    }
                }
            }
            return CombatUtil.applyDamageReduction(damage, defense /= (float)source.types.length);
        }
        return damage;
    }

    public static float applyBodyDamageCalculations(LivingEntity hitEntity, DamageTypeSource source, float damage, Wrapper<Poise> poise) {
        if (!source.isDoT()) {
            if (hitEntity instanceof Player) {
                Player player = (Player)hitEntity;
                if (source.hasHitCoords() && !player.m_20143_()) {
                    ItemStack stack;
                    Item item;
                    float durabilityDmg = Math.max(1.0f, damage / 5.0f);
                    int armorIndex = 0;
                    double y = source.getHitCoords().f_86215_;
                    if (!player.m_6047_()) {
                        if (y > 0.29296875 && y <= 0.703125) {
                            armorIndex = 1;
                        } else if (y > 0.703125 && y <= 1.40625) {
                            armorIndex = 2;
                        } else if (y > 1.40625) {
                            armorIndex = 3;
                        }
                    } else if (y > 0.234375 && y <= 0.5859375) {
                        armorIndex = 1;
                    } else if (y > 0.5859375 && y <= 1.0546875) {
                        armorIndex = 2;
                    } else if (y > 1.0546875) {
                        armorIndex = 3;
                    }
                    if (armorIndex == 3) {
                        damage *= 1.2f;
                    }
                    if ((item = (stack = (ItemStack)player.m_150109_().f_35975_.get(armorIndex)).m_41720_()) instanceof TieredArmorItem) {
                        TieredArmorItem armor = (TieredArmorItem)item;
                        if (((Poise)((Object)poise.val)).ordinal() < armor.material.getPoise().ordinal()) {
                            poise.val = armor.material.getPoise();
                        }
                        if (!source.isOnlyType(DamageType.ABSOLUTE)) {
                            if (armor.material.isMetal()) {
                                source.tryArmorSoundConversion();
                            }
                            damage = armor.material.getFinalDamage(armor.slot, source.types, stack.m_41776_() - stack.m_41773_(), damage, false);
                            int index = armorIndex;
                            stack.m_41622_((int)durabilityDmg, hitEntity, p_214023_1_ -> p_214023_1_.m_21166_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)index)));
                        }
                    }
                } else if (!source.isOnlyType(DamageType.ABSOLUTE)) {
                    float durabilityDmg = Math.max(1.0f, damage / 20.0f);
                    boolean isMetal = false;
                    int totalPoise = 0;
                    for (int i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
                        ItemStack stack = (ItemStack)player.m_150109_().f_35975_.get(i);
                        Item index = stack.m_41720_();
                        if (!(index instanceof TieredArmorItem)) continue;
                        TieredArmorItem armor = (TieredArmorItem)index;
                        totalPoise += armor.material.getPoise().ordinal();
                        if (!isMetal && armor.material.isMetal()) {
                            isMetal = true;
                        }
                        damage = armor.material.getFinalDamage(armor.slot, source.types, stack.m_41773_(), damage, true);
                        int index2 = i;
                        stack.m_41622_((int)durabilityDmg, hitEntity, p_214023_1_ -> p_214023_1_.m_21166_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)index2)));
                    }
                    if (((Poise)((Object)poise.val)).ordinal() < (totalPoise /= 4)) {
                        poise.val = Poise.values()[totalPoise];
                    }
                    if (isMetal) {
                        source.tryArmorSoundConversion();
                    }
                }
            } else if (hitEntity instanceof ActionableEntity) {
                ActionableEntity entity = (ActionableEntity)hitEntity;
                damage = entity.modifyIncomingDamage(source, damage, poise);
            }
        }
        return damage;
    }

    public static float applyEffectDamageCalculations(LivingEntity e, DamageTypeSource source, float damage) {
        int i;
        int j;
        float f;
        float f1;
        float f2;
        if (source.isDoT()) {
            return damage;
        }
        if (e.m_21023_(MobEffects.f_19606_) && (f2 = (f1 = damage) - (damage = Math.max((f = damage * (float)(j = 25 - (i = (e.m_21124_(MobEffects.f_19606_).m_19564_() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
            if (e instanceof ServerPlayer) {
                ((ServerPlayer)e).m_36222_(Stats.f_12934_, Math.round(f2 * 10.0f));
            } else if (source.m_7640_() instanceof ServerPlayer) {
                ((ServerPlayer)source.m_7640_()).m_36222_(Stats.f_12930_, Math.round(f2 * 10.0f));
            }
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        int k = EnchantmentHelper.m_44856_((Iterable)e.m_6168_(), (DamageSource)source);
        if (k > 0) {
            damage = CombatRules.m_19269_((float)damage, (float)k);
        }
        return damage;
    }

    public static void knockbackEntity(Entity target, Vec3f knockbackVec) {
        if ((double)knockbackVec.lengthSqr() > 0.0) {
            if (target.m_20096_()) {
                target.m_5997_((double)knockbackVec.x(), (double)knockbackVec.y(), (double)knockbackVec.z());
            } else {
                target.m_5997_((double)(knockbackVec.x() * 1.3f), (double)knockbackVec.y(), (double)(knockbackVec.z() * 1.3f));
            }
            target.f_19864_ = true;
        }
    }

    public static void knockbackEntity(Entity target, Entity attacker, double magnitude) {
        if (magnitude > 0.0) {
            double xRatio = attacker.m_20185_() - target.m_20185_();
            double zRatio = attacker.m_20189_() - target.m_20189_();
            while (xRatio * xRatio + zRatio * zRatio < 1.0E-4) {
                xRatio = (Math.random() - Math.random()) * 0.01;
                zRatio = (Math.random() - Math.random()) * 0.01;
            }
            Vec3 knockbackVec = new Vec3(xRatio, 0.0, zRatio).m_82541_().m_82490_(-magnitude);
            if (target.m_20096_()) {
                target.m_5997_(knockbackVec.f_82479_, 0.25, knockbackVec.f_82481_);
            } else {
                target.m_5997_(knockbackVec.f_82479_ / 2.0, 0.0, knockbackVec.f_82481_ / 2.0);
            }
            target.f_19864_ = true;
        }
    }

    public static enum DodgeDirection {
        NORTH(1.0f, 0.0f),
        SOUTH(-1.0f, 0.0f),
        WEST(0.0f, 1.0f),
        EAST(0.0f, -1.0f),
        NORTHWEST(0.7071f, 0.7071f),
        NORTHEAST(0.7071f, -0.7071f),
        SOUTHWEST(-0.7071f, 0.7071f),
        SOUTHEAST(-0.7071f, -0.7071f);

        private final float x;
        private final float z;

        private DodgeDirection(float x, float z) {
            this.x = x;
            this.z = z;
        }

        public float getXAmount() {
            return this.x;
        }

        public float getZAmount() {
            return this.z;
        }

        public static DodgeDirection get(int value) {
            return switch (value) {
                case 1 -> NORTHWEST;
                case 2 -> WEST;
                case 3 -> SOUTHWEST;
                case 4 -> SOUTH;
                case 5 -> SOUTHEAST;
                case 6 -> EAST;
                case 7 -> NORTHEAST;
                default -> NORTH;
            };
        }
    }
}

