/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.world.Season;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.text.WordUtils;

public class DataUtil {
    public static final Direction[] DIRECTIONS_EXCEPT_UP = new Direction[]{Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] DIRECTIONS_EXCEPT_DOWN = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] DIRECTIONS_EXCEPT_NORTH = new Direction[]{Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] DIRECTIONS_EXCEPT_SOUTH = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.WEST, Direction.EAST};
    public static final Direction[] DIRECTIONS_EXCEPT_WEST = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST};
    public static final Direction[] DIRECTIONS_EXCEPT_EAST = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST};
    private static final Set<String> MINOR_WORDS = new HashSet<String>(Arrays.asList("a", "an", "and", "as", "at", "but", "by", "for", "if", "in", "nor", "of", "on", "or", "per", "the", "to", "vs", "via", "with", "from", "over", "into", "onto"));
    private static final Pattern FORCE_CAP_AFTER = Pattern.compile("[:!?.\\u2014\\u2013]$");
    private static final Pattern LEADING_PUNCT = Pattern.compile("^[^\\p{L}\\p{N}]+");
    private static final Pattern TRAILING_PUNCT = Pattern.compile("[^\\p{L}\\p{N}]+$");

    public static int hashPos(int x, int y, int z) {
        return (x & 0x3FF) << 22 | (z & 0x3FF) << 12 | y & 0xFFF;
    }

    public static int hashPos(BlockPos pos) {
        return DataUtil.hashPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static BlockPos fromPosHash(int hash) {
        return new BlockPos(hash >>> 22, hash & 0xFFF, hash >>> 12 & 0x3FF);
    }

    public static float[] toArray(List<Float> floatList) {
        float[] array = new float[floatList.size()];
        for (int i = 0; i < floatList.size(); ++i) {
            array[i] = floatList.get(i).floatValue();
        }
        return array;
    }

    public static int packChunkPos(int worldX, int worldY, int worldZ) {
        return (worldX & 0xF) << 16 | (worldZ & 0xF) << 12 | worldY & 0xFFF;
    }

    public static int packChunkPos(BlockPos pos) {
        return DataUtil.packChunkPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static BlockPos unpackChunkPos(int minX, int minZ, int packedPos) {
        return new BlockPos(minX + (packedPos >>> 16 & 0xF), packedPos & 0xFFF, minZ + (packedPos >>> 12 & 0xF));
    }

    public static Direction[] getDirectionsExcept(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> DIRECTIONS_EXCEPT_UP;
            case Direction.DOWN -> DIRECTIONS_EXCEPT_DOWN;
            case Direction.NORTH -> DIRECTIONS_EXCEPT_NORTH;
            case Direction.SOUTH -> DIRECTIONS_EXCEPT_SOUTH;
            case Direction.WEST -> DIRECTIONS_EXCEPT_WEST;
            case Direction.EAST -> DIRECTIONS_EXCEPT_EAST;
        };
    }

    public static CompoundTag writeFluids(List<FluidStack> list, CompoundTag tag) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < list.size(); ++i) {
            FluidStack fluid = list.get(i);
            if (fluid.isEmpty()) continue;
            CompoundTag fluidTag = new CompoundTag();
            fluid.writeToNBT(fluidTag);
            listTag.add((Object)fluidTag);
        }
        tag.m_128365_("Fluids", (Tag)listTag);
        return tag;
    }

    public static void loadFluids(List<FluidStack> list, CompoundTag tag) {
        ListTag listTag = tag.m_128437_("Fluids", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag fluidTag = listTag.m_128728_(i);
            list.add(FluidStack.loadFluidStackFromNBT((CompoundTag)fluidTag));
        }
    }

    public static <T> ListTag writeSlottedData(List<T> data, BiConsumer<CompoundTag, T> writer, Predicate<T> filter) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < data.size(); ++i) {
            T object = data.get(i);
            if (object == null || filter.test(object)) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("Slot", (byte)i);
            writer.accept(tag, (CompoundTag)object);
            listTag.add((Object)tag);
        }
        return listTag;
    }

    public static <T> ListTag writeSlottedData(List<T> data, BiConsumer<CompoundTag, T> writer) {
        return DataUtil.writeSlottedData(data, writer, t -> false);
    }

    public static <T> void loadSlottedData(ListTag listTag, List<T> data, Function<CompoundTag, T> reader) {
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag tag = listTag.m_128728_(i);
            int slot = tag.m_128445_("Slot") & 0xFF;
            if (slot >= data.size()) continue;
            data.set(slot, reader.apply(tag));
        }
    }

    public static void writeSlottedFluids(CompoundTag tag, NonNullList<FluidStack> fluids) {
        ListTag listtag = new ListTag();
        for (int i = 0; i < fluids.size(); ++i) {
            FluidStack fluidStack = (FluidStack)fluids.get(i);
            if (fluidStack.isEmpty()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            fluidStack.writeToNBT(compoundtag);
            listtag.add((Object)compoundtag);
        }
        tag.m_128365_("Fluids", (Tag)listtag);
    }

    public static void loadSlottedFluids(CompoundTag tag, NonNullList<FluidStack> fluids) {
        ListTag listtag = tag.m_128437_("Fluids", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j >= fluids.size()) continue;
            fluids.set(j, (Object)FluidStack.loadFluidStackFromNBT((CompoundTag)compoundtag));
        }
    }

    public static FluidStack fluidStackFromJson(JsonObject json) {
        String name = GsonHelper.m_13906_((JsonObject)json, (String)"fluid");
        ResourceLocation location = ResourceLocation.parse((String)name);
        if (!ForgeRegistries.FLUIDS.containsKey(location)) {
            throw new JsonSyntaxException("Unknown fluid '" + name + "'");
        }
        return new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(location)), GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
    }

    public static JsonObject itemStackToJson(ItemStack item) {
        JsonObject json = new JsonObject();
        json.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item.m_41720_()).toString());
        if (item.m_41613_() > 1) {
            json.addProperty("count", (Number)item.m_41613_());
        }
        return json;
    }

    public static JsonObject fluidStackToJson(FluidStack fluid) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)fluid.getFluid()).toString());
        if (fluid.getAmount() > 1) {
            json.addProperty("count", (Number)fluid.getAmount());
        }
        return json;
    }

    public static <T extends Enum<T>, V> Map<T, V> mapEnum(Class<T> enumClass, Predicate<T> filter, Function<T, V> valueMapper) {
        EnumMap<T, V> enumMap = new EnumMap<T, V>(enumClass);
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            if (filter.test(enumValue)) continue;
            V mappedValue = valueMapper.apply(enumValue);
            enumMap.put((T)enumValue, mappedValue);
        }
        return Collections.unmodifiableMap(enumMap);
    }

    public static <T extends Enum<T>, V> Map<T, V> mapEnum(Class<T> enumClass, Function<T, V> valueMapper) {
        return DataUtil.mapEnum(enumClass, clazz -> false, valueMapper);
    }

    public static <T, V> Map<T, V> map(Iterable<T> values, Predicate<T> filter, Function<T, V> valueMapper) {
        HashMap<T, V> map = new HashMap<T, V>();
        for (T value : values) {
            if (filter.test(value)) continue;
            V mappedValue = valueMapper.apply(value);
            map.put(value, mappedValue);
        }
        return Collections.unmodifiableMap(map);
    }

    public static <T, V> Map<T, V> map(Iterable<T> values, Function<T, V> valueMapper) {
        return DataUtil.map(values, clazz -> false, valueMapper);
    }

    public static <T> List<T> concat(Collection<T> ... collections) {
        int size = 0;
        for (Collection<T> collection : collections) {
            size += collection.size();
        }
        ObjectArrayList list = new ObjectArrayList(size);
        for (Collection<T> collection : collections) {
            list.addAll(collection);
        }
        return list;
    }

    public static String getName(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> "helmet";
            case EquipmentSlot.CHEST -> "chestplate";
            case EquipmentSlot.LEGS -> "leggings";
            case EquipmentSlot.FEET -> "boots";
            default -> "";
        };
    }

    public static String getLocalName(EquipmentSlot slot) {
        return WordUtils.capitalize((String)DataUtil.getName(slot));
    }

    public static String getLocalName(String name) {
        return WordUtils.capitalize((String)name.replace("_", " "));
    }

    public static double getSimulatedWeatherPercentageAboveIntensity(int simulations, double intensity) {
        Random random = new Random();
        float weatherIntensity = 0.0f;
        double totalDuration = 0.0;
        double targetDuration = 0.0;
        for (int i = 0; i < simulations; ++i) {
            float lastWeatherIntensity = weatherIntensity;
            weatherIntensity = (float)MathUtil.gammaSample(1.2, random) / 4.0f;
            Season season = Season.values()[random.nextInt(Season.values().length)];
            float f = random.nextFloat();
            float f2 = season == Season.FALL ? 0.5f : 0.3f;
            if (f < f2) {
                weatherIntensity = -Math.min(weatherIntensity, 1.0f);
            } else {
                if (season == Season.SUMMER) {
                    weatherIntensity *= 0.8f;
                } else if (season == Season.SPRING) {
                    weatherIntensity *= 1.2f;
                }
                weatherIntensity = Math.min(weatherIntensity, 1.0f);
            }
            int weatherDuration = 9600 + random.nextInt(14400);
            totalDuration += (double)weatherDuration;
            if (!(intensity >= (double)lastWeatherIntensity && intensity <= (double)weatherIntensity) && (!(intensity >= (double)weatherIntensity) || !(intensity <= (double)lastWeatherIntensity))) continue;
            double timeAtIntensity = (intensity - (double)lastWeatherIntensity) / (double)(weatherIntensity - lastWeatherIntensity) * (double)weatherDuration;
            targetDuration += totalDuration - timeAtIntensity;
        }
        return targetDuration / totalDuration * 100.0;
    }

    public static String toTitleCase(String input) {
        return DataUtil.toTitleCase(input, Locale.getDefault());
    }

    public static String toTitleCase(String input, Locale locale) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String[] tokens = input.trim().split("\\s+");
        if (tokens.length == 0) {
            return input;
        }
        StringBuilder out = new StringBuilder(input.length() + 16);
        boolean prevForcesCapital = false;
        for (int i = 0; i < tokens.length; ++i) {
            boolean isLast;
            String token = tokens[i];
            boolean isFirst = i == 0;
            boolean bl = isLast = i == tokens.length - 1;
            if (i > 0) {
                String prev = tokens[i - 1];
                prevForcesCapital = FORCE_CAP_AFTER.matcher(prev).find();
            } else {
                prevForcesCapital = false;
            }
            String processed = DataUtil.processToken(token, isFirst, isLast, prevForcesCapital, locale);
            out.append(processed);
            if (i >= tokens.length - 1) continue;
            out.append(' ');
        }
        return out.toString();
    }

    private static String processToken(String token, boolean isFirst, boolean isLast, boolean prevForcesCapital, Locale locale) {
        Matcher leadM = LEADING_PUNCT.matcher(token);
        int leadEnd = 0;
        if (leadM.find()) {
            leadEnd = leadM.end();
        }
        Matcher trailM = TRAILING_PUNCT.matcher(token);
        int trailStart = token.length();
        if (trailM.find()) {
            trailStart = trailM.start();
        }
        String leading = token.substring(0, leadEnd);
        String trailing = token.substring(trailStart);
        String core = token.substring(leadEnd, trailStart);
        if (core.isEmpty()) {
            return token;
        }
        if (core.contains("/")) {
            CharSequence[] parts = core.split("/", -1);
            for (int p = 0; p < parts.length; ++p) {
                parts[p] = DataUtil.processWordPart((String)parts[p], isFirst, isLast, prevForcesCapital, locale);
            }
            core = String.join((CharSequence)"/", parts);
            return leading + core + trailing;
        }
        if (core.contains("-")) {
            CharSequence[] parts = core.split("(?<=-)|(?=-)");
            for (int p = 0; p < parts.length; ++p) {
                String part = parts[p];
                if (part.equals("-")) continue;
                boolean partIsEdge = p == 0 || p == parts.length - 1;
                parts[p] = DataUtil.processWordPart(part, isFirst && partIsEdge, isLast && partIsEdge, prevForcesCapital, locale);
            }
            core = String.join((CharSequence)"", parts);
            return leading + core + trailing;
        }
        core = DataUtil.processWordPart(core, isFirst, isLast, prevForcesCapital, locale);
        return leading + core + trailing;
    }

    private static String processWordPart(String word, boolean isFirst, boolean isLast, boolean prevForcesCapital, Locale locale) {
        if (word.isEmpty()) {
            return word;
        }
        if (DataUtil.hasInternalUppercase(word)) {
            return word;
        }
        if (DataUtil.isAllCaps(word)) {
            return word;
        }
        String lower = word.toLowerCase(locale);
        boolean isMinor = MINOR_WORDS.contains(lower);
        if (isFirst || isLast || prevForcesCapital) {
            return DataUtil.capitalizeFirstLetterPreserveApostrophes(lower, locale);
        }
        if (isMinor) {
            return lower;
        }
        return DataUtil.capitalizeFirstLetterPreserveApostrophes(lower, locale);
    }

    private static String capitalizeFirstLetterPreserveApostrophes(String lower, Locale locale) {
        int len = lower.length();
        for (int i = 0; i < len; ++i) {
            char c = lower.charAt(i);
            if (!Character.isLetter(c)) continue;
            String head = lower.substring(0, i);
            String first = String.valueOf(lower.charAt(i)).toUpperCase(locale);
            String tail = lower.substring(i + 1);
            return head + first + tail;
        }
        return lower;
    }

    private static boolean hasInternalUppercase(String s) {
        for (int i = 1; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isAllCaps(String s) {
        int letters = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isLetter(c)) continue;
            ++letters;
            if (Character.isUpperCase(c)) continue;
            return false;
        }
        return letters > 0;
    }
}

