/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util;

import com.mojang.authlib.GameProfile;
import com.mojang.math.Vector3d;
import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.IHeatSource;
import frostnox.nightfall.block.IHeatable;
import frostnox.nightfall.block.IIgnitable;
import frostnox.nightfall.block.IMetal;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.recipe.BuildingRecipe;
import frostnox.nightfall.entity.IOrientedHitBoxes;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.network.message.world.DestroyBlockNoSoundToClient;
import frostnox.nightfall.registry.KnowledgeNF;
import frostnox.nightfall.registry.RegistriesNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.DataUtil;
import frostnox.nightfall.util.data.WrappedInt;
import frostnox.nightfall.util.math.OBB;
import frostnox.nightfall.world.OrientedEntityHitResult;
import frostnox.nightfall.world.inventory.AccessorySlot;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class LevelUtil {
    public static final Predicate<Entity> ALIVE_ACTION_TRACKER_ENTITY = entity -> {
        if (!entity.m_6084_()) return false;
        if (entity instanceof ActionableEntity) return true;
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (player.m_150110_().f_35934_) return false;
        return true;
    };
    public static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final Direction[] PHYSICS_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP};
    public static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final Direction[] HORIZONTAL_DOWN_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN};
    public static final BlockPos NULL_POS = new BlockPos(0, Short.MIN_VALUE, 0);
    public static final GameProfile FAKE_PROFILE = new GameProfile(UUID.fromString("f8e91fce-7ddd-47d3-a0fe-d4992193510f"), "fakeNightfallPlayer");
    public static final double UNDEAD_MIN_SPAWN_DIST_SQR = 576.0;
    public static final double UNDEAD_MAX_SPAWN_DIST_SQR = 16384.0;
    public static final long MORNING_TIME = 0L;
    public static final long DAY_TIME = 2000L;
    public static final long NOON_TIME = 12000L;
    public static final long SUNSET_TIME = 24000L;
    public static final long NIGHT_TIME = 26000L;
    public static final long MIDNIGHT_TIME = 36000L;
    public static final long SUNRISE_TIME = 46000L;
    public static final long UNDEAD_START_TIME = 27000L;
    private static final int MAX_FURNACE_AREA = 9;
    private static final int MAX_BLAST_FURNACE_AREA = 16;
    public static final float PLAYER_PUSH = 2.0f;

    public static long getDayLength(Level level) {
        return LevelData.isPresent(level) ? 48000L : 24000L;
    }

    public static boolean isDay(LevelAccessor level) {
        return LevelUtil.isDay(level.m_8044_(), level);
    }

    public static boolean isDay(long dayTime, LevelAccessor level) {
        float time = level.m_6042_().m_63904_(dayTime);
        return time > 0.75f || time < 0.25f;
    }

    public static boolean isNight(LevelAccessor level) {
        return !LevelUtil.isDay(level);
    }

    public static boolean isNight(long dayTime, LevelAccessor level) {
        return !LevelUtil.isDay(dayTime, level);
    }

    public static boolean hasPassedNight(long lastLoadDayTime, Level level) {
        long dayLength = LevelUtil.getDayLength(level);
        long time = level.m_8044_() - lastLoadDayTime;
        return time > dayLength / 2L || LevelUtil.isDay(lastLoadDayTime, (LevelAccessor)level) != LevelUtil.isDay((LevelAccessor)level);
    }

    public static boolean isDayTimeExactly(Level level, long time) {
        return Math.floorMod(level.m_46468_(), LevelUtil.getDayLength(level)) == time;
    }

    public static boolean isDayTimeWithin(Level level, long startTime, long endTime) {
        return LevelUtil.isDayTimeWithin(level, level.m_46468_(), startTime, endTime);
    }

    public static boolean isDayTimeWithin(Level level, long dayTime, long startTime, long endTime) {
        long time = Math.floorMod(dayTime, LevelUtil.getDayLength(level));
        if (endTime < startTime) {
            return time <= endTime || time >= startTime;
        }
        return time >= startTime && time <= endTime;
    }

    public static long getDayTimePassed(Level level, long elapsedTime) {
        return LevelUtil.getDayTimePassedWithin(level, level.m_46468_(), elapsedTime, 46000L, 26000L);
    }

    public static long getDayTimePassed(Level level, long dayTime, long elapsedTime) {
        return LevelUtil.getDayTimePassedWithin(level, dayTime, elapsedTime, 46000L, 26000L);
    }

    public static long getDayTimePassedWithin(Level level, long elapsedTime, long startTime, long endTime) {
        return LevelUtil.getDayTimePassedWithin(level, level.m_46468_(), elapsedTime, startTime, endTime);
    }

    public static long getDayTimePassedWithin(Level level, long dayTime, long elapsedTime, long startTime, long endTime) {
        long pastPartialTime;
        if (elapsedTime <= 0L) {
            return 0L;
        }
        long dayLength = LevelUtil.getDayLength(level);
        long fullDays = elapsedTime / dayLength;
        long activeTime = endTime - startTime;
        if (activeTime != dayLength) {
            activeTime = Math.floorMod(activeTime, dayLength);
        }
        long timePassed = activeTime * fullDays;
        long currentPartialTime = Math.floorMod(dayTime, dayLength);
        if (currentPartialTime == (pastPartialTime = currentPartialTime - elapsedTime % dayLength)) {
            return timePassed;
        }
        if (endTime < startTime) {
            if (pastPartialTime < endTime) {
                timePassed += Math.min(endTime, currentPartialTime) - pastPartialTime;
            }
            if (currentPartialTime > startTime) {
                timePassed += currentPartialTime - Math.max(pastPartialTime, startTime);
            }
        } else if (currentPartialTime > startTime && pastPartialTime < endTime) {
            timePassed += Math.min(currentPartialTime, endTime) - Math.max(pastPartialTime, startTime);
        }
        return timePassed;
    }

    public static BlockPos getRandomSurfacePos(Level level, LevelChunk chunk) {
        ChunkPos chunkpos = chunk.m_7697_();
        int x = chunkpos.m_45604_() + level.f_46441_.nextInt(16);
        int z = chunkpos.m_45605_() + level.f_46441_.nextInt(16);
        int y = chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) + 1;
        return new BlockPos(x, y, z);
    }

    @Nullable
    public static BlockPos getRandomWaterPos(Level level, LevelChunk chunk) {
        int maxY;
        int z;
        ChunkPos chunkpos = chunk.m_7697_();
        int x = chunkpos.m_45604_() + level.f_46441_.nextInt(16);
        int minY = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR, x, z = chunkpos.m_45605_() + level.f_46441_.nextInt(16));
        if (minY >= (maxY = chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z))) {
            return null;
        }
        return new BlockPos(x, minY + level.f_46441_.nextInt(maxY - minY + 1), z);
    }

    public static BlockPos getRandomPos(Level level, LevelChunk chunk) {
        ChunkPos chunkpos = chunk.m_7697_();
        int x = chunkpos.m_45604_() + level.f_46441_.nextInt(16);
        int z = chunkpos.m_45605_() + level.f_46441_.nextInt(16);
        return new BlockPos(x, level.m_141937_() + level.f_46441_.nextInt(level.m_151558_()), z);
    }

    public static boolean canFallThrough(BlockState state) {
        Material material = state.m_60767_();
        return state.m_60795_() || state.m_204336_(TagsNF.FALLING_DESTROYABLE) || material.m_76332_() || material.m_76336_();
    }

    public static void uncheckedDropDestroyBlockNoSound(Level level, BlockPos pos, BlockState state, BlockState replaceState, @Nullable Entity entity, int flags) {
        NetworkHandler.toAllTrackingChunk(level.m_46745_(pos), new DestroyBlockNoSoundToClient(pos, Block.m_49956_((BlockState)state)));
        Block.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)entity, (ItemStack)ItemStack.f_41583_);
        level.m_7731_(pos, replaceState, flags);
    }

    public static boolean destroyBlockNoSound(LevelAccessor level, BlockPos pos, boolean dropBlock) {
        return LevelUtil.destroyBlockNoSound(level, pos, dropBlock, null);
    }

    public static boolean destroyBlockNoSound(LevelAccessor level, BlockPos pos, boolean dropBlock, @Nullable Entity entity) {
        boolean success;
        BlockState block = level.m_8055_(pos);
        if (block.m_60795_()) {
            return false;
        }
        FluidState fluid = level.m_6425_(pos);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!(block.m_60734_() instanceof BaseFireBlock)) {
                NetworkHandler.toAllTrackingChunk(serverLevel.m_46745_(pos), new DestroyBlockNoSoundToClient(pos, Block.m_49956_((BlockState)block)));
            }
            if (dropBlock) {
                BlockEntity blockentity = block.m_155947_() ? serverLevel.m_7702_(pos) : null;
                Block.m_49881_((BlockState)block, (Level)serverLevel, (BlockPos)pos, (BlockEntity)blockentity, (Entity)entity, (ItemStack)ItemStack.f_41583_);
            }
        }
        if (success = level.m_6933_(pos, fluid.m_76188_(), 3, 512)) {
            level.m_142346_(entity, GameEvent.f_157794_, pos);
        }
        return success;
    }

    public static boolean isPointVisuallyInBlock(Level level, BlockPos blockPos, Vec3 pos) {
        VoxelShape shape = level.m_8055_(blockPos).m_60771_((BlockGetter)level, blockPos, CollisionContext.m_82749_()).m_83216_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        if (!shape.m_83281_()) {
            for (AABB box : shape.m_83299_()) {
                if (!box.m_82390_(pos)) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockPos getFirstBlockInDirection(TagKey<Block> blockTag, Level level, BlockPos startPos, Direction direction, int distance) {
        for (int i = 0; i < distance; ++i) {
            BlockPos pos = startPos.m_5484_(direction, i + 1);
            if (!level.m_8055_(pos).m_204336_(blockTag)) continue;
            return pos;
        }
        return startPos;
    }

    public static int getBlockHeatResistanceTier(BlockState state) {
        if (state.m_204336_(TagsNF.HEAT_RESISTANT_4)) {
            return 4;
        }
        if (state.m_204336_(TagsNF.HEAT_RESISTANT_3)) {
            return 3;
        }
        if (state.m_204336_(TagsNF.HEAT_RESISTANT_2)) {
            return 2;
        }
        if (state.m_204336_(TagsNF.HEAT_RESISTANT_1)) {
            return 1;
        }
        return 0;
    }

    public static int getNearbySmelterTier(Level level, BlockPos pos) {
        return Math.max(LevelUtil.getNearbyKilnBaseTier(level, pos), LevelUtil.getNearbyFurnaceTier(level, pos));
    }

    public static int getNearbyKilnBaseTier(Level level, BlockPos pos) {
        int i = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState state = level.m_8055_(pos.m_142300_(direction));
            if (state.m_204336_(TagsNF.HEAT_RESISTANT_1) && state.m_60783_((BlockGetter)level, pos, direction.m_122424_()) || ++i <= 1) continue;
            return 0;
        }
        return 1;
    }

    public static int getNearbyKilnTier(Level level, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState state = level.m_8055_(pos.m_142300_(direction));
            if (state.m_204336_(TagsNF.HEAT_RESISTANT_1) && state.m_60783_((BlockGetter)level, pos, direction.m_122424_())) continue;
            return 0;
        }
        return 1;
    }

    public static int getNearbyFurnaceTier(Level level, BlockPos pos) {
        WrappedInt area = new WrappedInt(1);
        WrappedInt lowestTier = new WrappedInt(4);
        IntOpenHashSet visited = new IntOpenHashSet(9);
        visited.add(DataUtil.hashPos(pos));
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos dirPos = pos.m_142300_(dir);
            LevelUtil.checkFurnaceArea(level, dirPos, DataUtil.hashPos(dirPos), (IntSet)visited, area, lowestTier);
        }
        if (area.val <= 9) {
            return lowestTier.val;
        }
        return 0;
    }

    private static void checkFurnaceArea(Level level, BlockPos pos, int hash, IntSet visited, WrappedInt area, WrappedInt lowestTier) {
        if (visited.contains(hash)) {
            return;
        }
        visited.add(hash);
        if (area.val > 9) {
            return;
        }
        int heatResistance = LevelUtil.getBlockHeatResistanceTier(level.m_8055_(pos));
        if (heatResistance > 0) {
            if (lowestTier.val > heatResistance) {
                lowestTier.val = heatResistance;
            }
            return;
        }
        ++area.val;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos dirPos = pos.m_142300_(dir);
            LevelUtil.checkFurnaceArea(level, dirPos, DataUtil.hashPos(dirPos), visited, area, lowestTier);
        }
    }

    public static boolean isBlockBurningCarbon(BlockState state) {
        return state.m_60713_((Block)BlocksNF.CHARCOAL_BURNING.get()) || state.m_60713_((Block)BlocksNF.COAL_BURNING.get());
    }

    public static boolean isBlockCovered(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (level.m_8055_(pos.m_142300_(direction)).m_60783_((BlockGetter)level, pos, direction.m_122424_())) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlockSmothered(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockState state = level.m_8055_(pos.m_142300_(direction));
            if ((state.m_60734_() instanceof IHeatSource || !(state.m_60734_() instanceof IIgnitable)) && state.m_60783_((BlockGetter)level, pos, direction.m_122424_())) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlockFullySupportedHorizontally(AABB blockBox, LevelReader level, BlockPos supportPos, Direction supportDir) {
        double minXZ;
        BlockState supportState = level.m_8055_(supportPos);
        if (supportState.m_204336_(TagsNF.UNSTABLE_SUPPORT_HORIZONTAL)) {
            return false;
        }
        VoxelShape supportShape = supportState.m_60812_((BlockGetter)level, supportPos);
        if (supportShape == Shapes.m_83144_()) {
            return true;
        }
        if (supportShape.m_83281_()) {
            return false;
        }
        if ((supportShape = supportShape.m_83263_(supportDir)).m_83281_()) {
            return false;
        }
        double minXZBest = 1.0;
        double minY = 1.0;
        double maxY = 0.0;
        if (supportDir.m_122434_() == Direction.Axis.X) {
            minXZ = blockBox.f_82290_;
            for (AABB sBox : supportShape.m_83299_()) {
                if (!(sBox.f_82290_ <= blockBox.f_82290_) || !(sBox.f_82293_ >= blockBox.f_82293_)) continue;
                if (sBox.f_82290_ < minXZBest) {
                    minXZBest = sBox.f_82290_;
                }
                if (sBox.f_82289_ < minY) {
                    minY = sBox.f_82289_;
                }
                if (!(sBox.f_82292_ > maxY)) continue;
                maxY = sBox.f_82292_;
            }
        } else {
            minXZ = blockBox.f_82288_;
            for (AABB sBox : supportShape.m_83299_()) {
                if (!(sBox.f_82288_ <= blockBox.f_82288_) || !(sBox.f_82291_ >= blockBox.f_82291_)) continue;
                if (sBox.f_82288_ < minXZBest) {
                    minXZBest = sBox.f_82288_;
                }
                if (sBox.f_82289_ < minY) {
                    minY = sBox.f_82289_;
                }
                if (!(sBox.f_82292_ > maxY)) continue;
                maxY = sBox.f_82292_;
            }
        }
        return minY <= blockBox.f_82289_ && maxY >= blockBox.f_82292_ && minXZBest <= minXZ;
    }

    public static void preventBlockLowerHalfDrop(Level level, BlockPos pos, BlockState state, Player pPlayer) {
        BlockPos lowerPos;
        BlockState lowerState;
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)BlockStateProperties.f_61401_);
        if (half == DoubleBlockHalf.UPPER && (lowerState = level.m_8055_(lowerPos = pos.m_7495_())).m_60713_(state.m_60734_()) && lowerState.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            int waterLevel;
            BlockState newState = Blocks.f_50016_.m_49966_();
            if (lowerState.m_61138_((Property)BlockStatePropertiesNF.WATER_LEVEL) && (waterLevel = ((Integer)lowerState.m_61143_((Property)BlockStatePropertiesNF.WATER_LEVEL)).intValue()) > 0) {
                newState = ((IWaterloggedBlock.WaterlogType)((Object)lowerState.m_61143_(BlockStatePropertiesNF.WATERLOG_TYPE))).fluid.get().m_76145_().m_76188_();
                if (waterLevel < 7) {
                    newState = (BlockState)newState.m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(waterLevel));
                }
            }
            level.m_7731_(lowerPos, newState, 35);
            level.m_5898_(pPlayer, 2001, lowerPos, Block.m_49956_((BlockState)lowerState));
        }
    }

    public static void breakItem(ItemStack item, Player player, InteractionHand hand) {
        if (!player.f_19853_.f_46443_ && !player.m_150110_().f_35937_) {
            player.m_21190_(hand);
            item.m_41774_(1);
        }
    }

    public static boolean isTouchingWater(Level level, BlockPos pos) {
        boolean touching = false;
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN) continue;
            BlockPos touchPos = pos.m_142300_(direction);
            if (level.m_6425_(touchPos).m_192917_((Fluid)Fluids.f_76193_)) {
                touching = true;
            }
            if (!touching) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static OrientedEntityHitResult getHitEntity(Level level, Entity projectile, Vec3 start, Vec3 end, AABB box, Predicate<Entity> filter) {
        double minDistSqr = Double.MAX_VALUE;
        Entity closestEntity = null;
        Vec3 collisionVec = null;
        double inflation = Math.max((double)projectile.m_20205_() * 0.5, (double)projectile.m_20206_() * 0.5);
        int boxIndex = -1;
        block0: for (Entity entity : level.m_6249_(projectile, box.m_82400_(1.0), filter)) {
            double distSqr;
            AABB aabb;
            Optional point;
            IOrientedHitBoxes hitBoxesEntity;
            if ((!(entity instanceof IOrientedHitBoxes) || (hitBoxesEntity = (IOrientedHitBoxes)entity).includeAABB()) && (point = (aabb = entity.m_142469_().m_82400_(inflation)).m_82371_(start, end)).isPresent() && (distSqr = start.m_82557_((Vec3)point.get())) < minDistSqr) {
                closestEntity = entity;
                minDistSqr = distSqr;
                collisionVec = (Vec3)point.get();
                continue;
            }
            if (!(entity instanceof IOrientedHitBoxes)) continue;
            hitBoxesEntity = (IOrientedHitBoxes)entity;
            Vec3 startOrigin = start.m_82546_(entity.m_20182_());
            Vec3 endOrigin = end.m_82546_(entity.m_20182_());
            OBB[] obbs = hitBoxesEntity.getOBBs(1.0f);
            for (int i = 0; i < obbs.length; ++i) {
                OBB obb = obbs[i];
                obb.extents = obb.extents.m_82490_(1.0 + inflation);
                Optional<Vec3> obbPoint = obb.rayCast(startOrigin, endOrigin);
                if (!obbPoint.isPresent() || !box.m_82390_(obbPoint.get().m_82549_(entity.m_20182_()))) continue;
                double distSqr2 = startOrigin.m_82557_(obbPoint.get());
                if (!(distSqr2 < minDistSqr)) continue block0;
                closestEntity = entity;
                minDistSqr = distSqr2;
                collisionVec = obbPoint.get().m_82549_(entity.m_20182_());
                boxIndex = i;
                continue block0;
            }
        }
        return closestEntity == null ? null : new OrientedEntityHitResult(closestEntity, collisionVec, boxIndex);
    }

    public static HitResult getHitResult(Entity entity, Predicate<Entity> filter) {
        OrientedEntityHitResult entityHit;
        Vec3 end;
        Level level = entity.f_19853_;
        Vec3 start = entity.m_20182_();
        BlockHitResult blockHit = level.m_45547_(new ClipContext(start, end = start.m_82549_(entity.m_20184_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            end = blockHit.m_82450_();
        }
        return (entityHit = LevelUtil.getHitEntity(level, entity, start, end, entity.m_142469_().m_82369_(entity.m_20184_()).m_82400_(1.0), filter)) != null ? entityHit : blockHit;
    }

    public static VoxelShape getBlockClimbingShape(LivingEntity user, BlockPos pos) {
        BlockState state = user.f_19853_.m_8055_(pos);
        if (state.m_60795_() || state.m_204336_(TagsNF.UNCLIMBABLE) || state.m_204336_(BlockTags.f_13082_)) {
            return Shapes.m_83040_();
        }
        return state.m_60812_((BlockGetter)user.f_19853_, pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static boolean isPositionFullyClimbable(LivingEntity user, Vector3d position) {
        BlockPos abovePos = new BlockPos(position.f_86214_, Math.ceil(position.f_86215_) + 0.0625, position.f_86216_);
        BlockState state = user.f_19853_.m_8055_(abovePos);
        return state.m_204336_(TagsNF.FULLY_CLIMBABLE);
    }

    public static boolean disallowPlayerSprint(Player player) {
        IActionTracker capA = ActionTracker.get((Entity)player);
        IPlayerData capP = PlayerData.get(player);
        return capP.getStamina() <= 0.0 || !capA.isInactive() && !capA.getAction().allowSprinting() || player.m_6117_();
    }

    public static void extinguishItemEntity(ItemEntity entity, Item extinguishedItem, boolean smoke) {
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            entity.m_32045_(new ItemStack((ItemLike)extinguishedItem, entity.m_32055_().m_41613_()));
            NetworkHandler.toAllTracking((Entity)entity, new GenericEntityToClient(NetworkHandler.Type.REMOVE_LIGHT_SOURCE_CLIENT, entity.m_142049_()));
            serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.2f + entity.f_19853_.f_46441_.nextFloat());
            if (smoke) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spreadHeat(Level level, BlockPos spreadPos, BlockState spreadState, TieredHeat heat, Direction fromDir) {
        Block block = spreadState.m_60734_();
        if (block instanceof IHeatable) {
            IHeatable heatable = (IHeatable)block;
            heatable.applyHeat(level, spreadPos, spreadState, heat, fromDir);
        }
        if (heat != TieredHeat.NONE && (block = spreadState.m_60734_()) instanceof IIgnitable) {
            IIgnitable ignitable = (IIgnitable)block;
            ignitable.tryToIgnite(level, spreadPos, spreadState, ItemStack.f_41583_, heat);
        }
    }

    public static int getModifiableItemIndex(Level level, Player player, InteractionHand hand) {
        return level.f_46443_ ? (hand == InteractionHand.MAIN_HAND ? ClientEngine.get().getModifiableIndexMain() : ClientEngine.get().getModifiableIndexOff()) : PlayerData.get(player).getCachedModifiableIndex();
    }

    public static ItemStack pickCloneItem(Block block, Player player) {
        if (player.m_7500_() && ClientEngine.get().isCtrlHeld()) {
            return new ItemStack((ItemLike)block);
        }
        for (BuildingRecipe recipe : player.f_19853_.m_7465_().m_44013_(BuildingRecipe.TYPE)) {
            BlockItem blockItem;
            Item item = recipe.output;
            if (!(item instanceof BlockItem) || (blockItem = (BlockItem)item).m_40614_() != block) continue;
            return new ItemStack((ItemLike)recipe.baseItem);
        }
        return new ItemStack((ItemLike)block);
    }

    public static List<ItemStack> getUnlockedIngredients(Ingredient ingredient, @Nullable Player player) {
        if (player == null) {
            return List.of(ingredient.m_43908_());
        }
        ObjectArrayList items = new ObjectArrayList(ingredient.m_43908_().length);
        IPlayerData capP = PlayerData.get(player);
        for (ItemStack item : ingredient.m_43908_()) {
            ResourceLocation id = ResourceLocation.parse((String)(item.m_41720_().getRegistryName().toString() + "_item"));
            if (KnowledgeNF.contains(id) && !capP.hasKnowledge(id)) continue;
            items.add(item);
        }
        return List.copyOf(items);
    }

    public static ItemStack chooseUnlockedIngredient(Ingredient ingredient, @Nullable Player player) {
        List<ItemStack> items = LevelUtil.getUnlockedIngredients(ingredient, player);
        if (items.isEmpty()) {
            return ItemStack.f_41583_;
        }
        if (player == null) {
            return items.get(0);
        }
        return items.get(player.f_19797_ / 24 % items.size());
    }

    public static double getShortestDistanceSqrUndeadMinToPlayer(Level level, double x, double y, double z, boolean checkCharm) {
        double closestDist = Double.MAX_VALUE;
        for (Player player : level.m_6907_()) {
            if (!player.m_6084_() || !EntitySelector.f_20408_.test(player)) continue;
            double dist = player.m_20275_(x, y, z);
            if (checkCharm && PlayerData.get(player).getAccessoryInventory().getItem(AccessorySlot.NECK).m_150930_((Item)ItemsNF.WARDING_CHARM.get())) {
                dist = Math.max(0.0, dist - 36.0);
            }
            if (!(dist < closestDist)) continue;
            closestDist = dist;
        }
        return closestDist;
    }

    public static double getShortestDistanceSqrUndeadMaxToPlayer(Level level, double x, double y, double z, boolean checkKills) {
        double closestDist = Double.MAX_VALUE;
        for (Player player : level.m_6907_()) {
            double dist;
            if (!player.m_6084_() || !EntitySelector.f_20408_.test(player) || checkKills && PlayerData.get(player).getUndeadKilledThisNight() >= 40 || !((dist = player.m_20275_(x, y, z)) < closestDist)) continue;
            closestDist = dist;
        }
        return closestDist;
    }

    public static double getShortestDistanceSqrToPlayer(Level level, double x, double y, double z) {
        double closestDist = Double.MAX_VALUE;
        for (Player player : level.m_6907_()) {
            double dist;
            if (!player.m_6084_() || !EntitySelector.f_20408_.test(player) || !((dist = player.m_20275_(x, y, z)) < closestDist)) continue;
            closestDist = dist;
        }
        return closestDist;
    }

    public static void warpClientPlayer(Player player, boolean playToSelf) {
        if (playToSelf || ClientEngine.get().getPlayer() != player) {
            player.f_19853_.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundsNF.ENTITY_WARP.get(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
        float height = player.m_6084_() ? player.m_20206_() : 0.25f;
        for (int i = 0; i < 10 + player.m_21187_().nextInt(6); ++i) {
            player.f_19853_.m_7106_((ParticleOptions)ParticleTypesNF.ESSENCE.get(), player.m_20208_(1.0), player.m_20186_() + (double)(player.m_21187_().nextFloat() * height), player.m_20262_(1.0), 0.0, 0.0, 0.0);
        }
    }

    public static void warpServerPlayer(Player player, boolean playToSelf) {
        Level level = player.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            player.f_19853_.m_6263_(playToSelf ? null : player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundsNF.ENTITY_WARP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            float height = player.m_6084_() ? player.m_20206_() : 0.25f;
            level2.m_8767_((ParticleOptions)((SimpleParticleType)ParticleTypesNF.ESSENCE.get()), player.m_20185_(), player.m_20186_(), player.m_20189_(), 10 + player.m_21187_().nextInt(6), (double)player.m_20205_() * 0.5, (double)height * 0.5, (double)player.m_20205_() * 0.5, 0.0);
        }
    }

    public static Color getMetalColor(ItemStack item) {
        for (IMetal.Entry entry : RegistriesNF.getMetals()) {
            IMetal metal = entry.value;
            if (!item.m_204117_(metal.getTag())) continue;
            return metal.getColor();
        }
        return Color.WHITE;
    }

    public static void giveItemToPlayer(ItemStack item, Player player, boolean pickupSound) {
        int count = item.m_41613_();
        if (!player.m_150109_().m_36054_(item)) {
            player.m_7197_(item, false, true);
        }
        if (pickupSound && item.m_41613_() != count) {
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_21187_().nextFloat() - player.m_21187_().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    public static Set<Item> getAllLootItems(ResourceLocation tableLoc, ServerLevel level) {
        LootTable table = level.m_142572_().m_129898_().m_79217_(tableLoc);
        ObjectArraySet items = new ObjectArraySet();
        for (LootPool pool : (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String)"f_79109_")) {
            for (LootPoolEntryContainer entry : pool.f_79023_) {
                if (entry instanceof LootItem) {
                    LootItem lootItem = (LootItem)entry;
                    items.add(lootItem.f_79564_);
                    continue;
                }
                if (entry instanceof TagEntry) {
                    TagEntry tagEntry = (TagEntry)entry;
                    for (Item item : ForgeRegistries.ITEMS.tags().getTag(tagEntry.f_79821_)) {
                        items.add(item);
                    }
                    continue;
                }
                if (!(entry instanceof LootTableReference)) continue;
                LootTableReference ref = (LootTableReference)entry;
                items.addAll(LevelUtil.getAllLootItems(ref.f_79754_, level));
            }
        }
        return items;
    }

    public static List<BlockEntity> getBlockEntities(Level level, BlockPos centerPos, int range, Predicate<BlockEntity> filter) {
        if (range < 0 || range > 16) {
            throw new IllegalArgumentException("Range must be between 0 and 16.");
        }
        int centerX = SectionPos.m_123171_((int)centerPos.m_123341_());
        int centerZ = SectionPos.m_123171_((int)centerPos.m_123343_());
        int minX = SectionPos.m_123171_((int)(centerPos.m_123341_() - range));
        int maxX = SectionPos.m_123171_((int)(centerPos.m_123341_() + range));
        int minZ = SectionPos.m_123171_((int)(centerPos.m_123343_() - range));
        int maxZ = SectionPos.m_123171_((int)(centerPos.m_123343_() + range));
        ObjectArraySet chunks = new ObjectArraySet(9 * (1 + range / 16));
        ChunkSource source = level.m_7726_();
        chunks.add(source.m_62227_(centerX, centerZ, true));
        if (minX != centerX) {
            chunks.add(source.m_62227_(minX, centerZ, true));
        }
        if (minZ != centerZ) {
            chunks.add(source.m_62227_(centerX, minZ, true));
        }
        if (maxX != centerX) {
            chunks.add(source.m_62227_(maxX, centerZ, true));
        }
        if (maxZ != centerZ) {
            chunks.add(source.m_62227_(centerX, maxZ, true));
        }
        chunks.add(source.m_62227_(minX, minZ, true));
        if (maxX != minX) {
            chunks.add(source.m_62227_(maxX, minZ, true));
        }
        if (maxZ != minZ) {
            chunks.add(source.m_62227_(minX, maxZ, true));
        }
        chunks.add(source.m_62227_(maxX, maxZ, true));
        ArrayList<BlockEntity> nearbyBlocks = new ArrayList<BlockEntity>(16);
        for (LevelChunk chunk : chunks) {
            for (BlockEntity entity : chunk.m_62954_().values()) {
                BlockPos pos = entity.m_58899_();
                if (Math.abs(centerPos.m_123341_() - pos.m_123341_()) > range || Math.abs(centerPos.m_123342_() - pos.m_123342_()) > range || Math.abs(centerPos.m_123343_() - pos.m_123343_()) > range || !filter.test(entity)) continue;
                nearbyBlocks.add(entity);
            }
        }
        return nearbyBlocks;
    }

    public static boolean isSkyUnobstructed(Level level, BlockPos pos) {
        return level.m_45527_(pos) && level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() - 1 < pos.m_123342_();
    }
}

