/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Mat4f;
import frostnox.nightfall.util.math.Quat;
import it.unimi.dsi.fastutil.ints.IntLongImmutablePair;
import it.unimi.dsi.fastutil.ints.IntLongPair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MathUtil {
    public static final float PI = (float)Math.PI;
    public static final float PI_SQRT = (float)Math.sqrt(3.1415927410125732);
    public static final float SQRT_2 = (float)Math.sqrt(2.0);
    public static final double IDEAL_OPENSIMPLEX2_PAIR_VERTICAL_SAMPLING_OFFSET = 0.4330127018922193;
    private static final double[] LOG_FACTORIALS = new double[]{0.0, 0.0, Math.log(2.0), Math.log(6.0), Math.log(24.0), Math.log(120.0), Math.log(720.0), Math.log(5040.0), Math.log(40320.0), Math.log(362880.0)};
    private static final double LOG_SQRT_2_PI = Math.log(Math.sqrt(Math.PI * 2));

    public static float toRadians(float degrees) {
        return degrees / 180.0f * (float)Math.PI;
    }

    public static double toRadians(double degrees) {
        return degrees / 180.0 * Math.PI;
    }

    public static Vector3f toRadians(Vector3f vec) {
        return new Vector3f(MathUtil.toRadians(vec.m_122239_()), MathUtil.toRadians(vec.m_122260_()), MathUtil.toRadians(vec.m_122269_()));
    }

    public static float toDegrees(float radians) {
        return radians / (float)Math.PI * 180.0f;
    }

    public static double toDegrees(double radians) {
        return radians / Math.PI * 180.0;
    }

    public static Vector3f toDegrees(Vector3f vec) {
        return new Vector3f(MathUtil.toDegrees(vec.m_122239_()), MathUtil.toDegrees(vec.m_122260_()), MathUtil.toDegrees(vec.m_122269_()));
    }

    public static float getAngleDegrees(double z, double x) {
        return (float)(Mth.m_14136_((double)z, (double)x) * 180.0 / Math.PI + 270.0) % 360.0f;
    }

    public static float lerp2D(float xAmount, float yAmount, float minXMinY, float maxXMinY, float minXMaxY, float maxXMaxY) {
        return Mth.m_14179_((float)yAmount, (float)Mth.m_14179_((float)xAmount, (float)minXMinY, (float)maxXMinY), (float)Mth.m_14179_((float)xAmount, (float)minXMaxY, (float)maxXMaxY));
    }

    public static int distManhattanXZ(Vec3i pos1, Vec3i pos2) {
        return Math.abs(pos1.m_123341_() - pos2.m_123341_()) + Math.abs(pos1.m_123343_() - pos2.m_123343_());
    }

    public static void rotateVector3dByYaw(Vector3d point, float yawDegrees) {
        if (yawDegrees == 0.0f) {
            return;
        }
        float cos = Mth.m_14089_((float)MathUtil.toRadians(yawDegrees));
        float sin = Mth.m_14031_((float)MathUtil.toRadians(yawDegrees));
        point.m_176285_(point.f_86214_ * (double)cos - point.f_86216_ * (double)sin, point.f_86215_, point.f_86214_ * (double)sin + point.f_86216_ * (double)cos);
    }

    public static Vector3f rotatePointByYaw(Vector3f point, float yawDegrees, @Nullable Vec2 offset) {
        if (yawDegrees == 0.0f) {
            return point.m_122281_();
        }
        if (offset != null) {
            point.m_122272_(offset.f_82470_, 0.0f, offset.f_82471_);
        }
        float cos = Mth.m_14089_((float)MathUtil.toRadians(yawDegrees));
        float sin = Mth.m_14031_((float)MathUtil.toRadians(yawDegrees));
        Vector3f vec = new Vector3f(point.m_122239_() * cos - point.m_122269_() * sin, point.m_122260_(), point.m_122239_() * sin + point.m_122269_() * cos);
        if (offset != null) {
            vec.m_122272_(-offset.f_82470_, 0.0f, -offset.f_82471_);
        }
        return vec;
    }

    public static Vector3f rotatePointByYaw(Vector3f point, float yawDegrees) {
        return MathUtil.rotatePointByYaw(point, yawDegrees, null);
    }

    public static Vector3f getShortestPointFromPointToBox(float xPos, float yPos, float zPos, AABB box) {
        float x = (float)Mth.m_14008_((double)xPos, (double)(box.f_82288_ + 1.0E-4), (double)(box.f_82291_ - 1.0E-4));
        float y = (float)Mth.m_14008_((double)yPos, (double)(box.f_82289_ + 1.0E-4), (double)(box.f_82292_ - 1.0E-4));
        float z = (float)Mth.m_14008_((double)zPos, (double)(box.f_82290_ + 1.0E-4), (double)(box.f_82293_ - 1.0E-4));
        return new Vector3f(x, y, z);
    }

    public static Vector3d getShortestPointFromPointToBox(double xPos, double yPos, double zPos, AABB box) {
        double x = Mth.m_14008_((double)xPos, (double)(box.f_82288_ + 1.0E-4), (double)(box.f_82291_ - 1.0E-4));
        double y = Mth.m_14008_((double)yPos, (double)(box.f_82289_ + 1.0E-4), (double)(box.f_82292_ - 1.0E-4));
        double z = Mth.m_14008_((double)zPos, (double)(box.f_82290_ + 1.0E-4), (double)(box.f_82293_ - 1.0E-4));
        return new Vector3d(x, y, z);
    }

    public static float getShortestDistanceSqrPointToBox(float xPos, float yPos, float zPos, AABB box) {
        Vector3f vec = MathUtil.getShortestPointFromPointToBox(xPos, yPos, zPos, box);
        return (vec.m_122239_() - xPos) * (vec.m_122239_() - xPos) + (vec.m_122260_() - yPos) * (vec.m_122260_() - yPos) + (vec.m_122269_() - zPos) * (vec.m_122269_() - zPos);
    }

    public static double getShortestDistanceSqrPointToBox(double xPos, double yPos, double zPos, AABB box) {
        Vector3d vec = MathUtil.getShortestPointFromPointToBox(xPos, yPos, zPos, box);
        return (vec.f_86214_ - xPos) * (vec.f_86214_ - xPos) + (vec.f_86215_ - yPos) * (vec.f_86215_ - yPos) + (vec.f_86216_ - zPos) * (vec.f_86216_ - zPos);
    }

    public static double getShortestDistanceSqrBoxToBox(AABB box1, AABB box2) {
        double x1 = Math.max(0.0, box1.f_82288_ - box2.f_82291_);
        double y1 = Math.max(0.0, box1.f_82289_ - box2.f_82292_);
        double z1 = Math.max(0.0, box1.f_82290_ - box2.f_82293_);
        double x2 = Math.max(0.0, box2.f_82288_ - box1.f_82291_);
        double y2 = Math.max(0.0, box2.f_82289_ - box1.f_82292_);
        double z2 = Math.max(0.0, box2.f_82290_ - box1.f_82293_);
        return x1 * x1 + y1 * y1 + z1 * z1 + x2 * x2 + y2 * y2 + z2 * z2;
    }

    public static double getCaveClosingValue(Vector3d dir1, Vector3d dir2) {
        double noiseDeltaMagSq1 = dir1.f_86214_ * dir1.f_86214_ + dir1.f_86215_ * dir1.f_86215_ + dir1.f_86216_ * dir1.f_86216_;
        double noiseDeltaMagSq2 = dir2.f_86214_ * dir2.f_86214_ + dir2.f_86215_ * dir2.f_86215_ + dir2.f_86216_ * dir2.f_86216_;
        double noiseDeltaDot = dir1.f_86214_ * dir2.f_86214_ + dir1.f_86215_ * dir2.f_86215_ + dir1.f_86216_ * dir2.f_86216_;
        double squaredNormalizedDotProduct = noiseDeltaDot * noiseDeltaDot / (noiseDeltaMagSq1 * noiseDeltaMagSq2);
        return squaredNormalizedDotProduct * squaredNormalizedDotProduct;
    }

    public static float lerp3D(float xm_ym_zm, float xp_ym_zm, float xm_yp_zm, float xp_yp_zm, float xm_ym_zp, float xp_ym_zp, float xm_yp_zp, float xp_yp_zp, float x, float y, float z) {
        return xm_ym_zm * (1.0f - x) * (1.0f - y) * (1.0f - z) + xp_ym_zm * x * (1.0f - y) * (1.0f - z) + xm_yp_zm * (1.0f - x) * y * (1.0f - z) + xp_yp_zm * x * y * (1.0f - z) + xm_ym_zp * (1.0f - x) * (1.0f - y) * z + xp_ym_zp * x * (1.0f - y) * z + xm_yp_zp * (1.0f - x) * y * z + xp_yp_zp * x * y * z;
    }

    public static long comb(long n, long k) {
        long c = 1L;
        int i = 0;
        while ((long)i < Math.min(n - k, k)) {
            c = c * (n - (long)i) / (long)(i + 1);
            ++i;
        }
        return c;
    }

    public static double gammaSample(double shape, Random random) {
        double xSqr;
        double u;
        double x;
        double v;
        if (shape < 1.0) {
            return 0.0;
        }
        double d = shape - 0.3333333333333333;
        double c = 1.0 / (3.0 * Math.sqrt(d));
        while (!((v = Math.pow(1.0 + c * (x = random.nextGaussian()), 3.0)) > 0.0) || !((u = random.nextDouble()) < 1.0 - 0.0331 * (xSqr = x * x) * xSqr) && !(Math.log(u) < 0.5 * xSqr + d * (1.0 - v + Math.log(v)))) {
        }
        return d * v;
    }

    public static long poissonSample(double mean, Random random) {
        int k;
        if (mean < 30.0) {
            double a = Math.exp(-mean);
            double r = 1.0;
            long x = -1L;
            while (r > a) {
                double u = random.nextDouble();
                r *= u;
                ++x;
            }
            return x;
        }
        double c = mean + 0.445;
        double smu = Math.sqrt(mean);
        double b = 0.931 + 2.53 * smu;
        double a = -0.059 + 0.02483 * b;
        double a2 = a * 2.0;
        double invA = 1.1239 + 1.1328 / (b - 3.4);
        double ur = 0.43;
        double vr = 0.9277 - 3.6224 / (b - 2.0);
        double vr086 = vr * 0.86;
        double logMean = Math.log(mean);
        while (true) {
            double u;
            double v;
            if ((v = random.nextDouble()) <= vr086) {
                u = v / vr - ur;
                return (long)Math.floor((2.0 * a / (0.5 - Math.abs(u)) + b) * u + c);
            }
            if (v >= vr) {
                u = random.nextDouble() - 0.5;
            } else {
                u = v / vr - 0.93;
                u = Math.signum(u) * 0.5 - u;
                v = random.nextDouble() * vr;
            }
            double us = 0.5 - Math.abs(u);
            if (us < 0.013 && v > us) continue;
            k = (int)Math.floor((a2 / us + b) * u + c);
            v = v * invA / (a / (us * us) + b);
            if (k >= 10 && Math.log(v * smu) <= ((double)k + 0.5) * Math.log(mean / (double)k) - mean - LOG_SQRT_2_PI + (double)k - (0.08333333333333333 - 1.0 / (360.0 * (double)k * (double)k)) / (double)k) {
                return k;
            }
            if (k >= 0 && k <= 9 && Math.log(v) <= (double)k * logMean - mean - LOG_FACTORIALS[k]) break;
        }
        return k;
    }

    public static long gammaPoissonSample(int shape, double gammaScale, Random random) {
        return MathUtil.poissonSample(MathUtil.gammaSample(shape, random) * gammaScale, random);
    }

    public static int getRandomSuccesses(double p, long trials, int maxSuccesses, Random random) {
        int limit = (int)Math.min(trials, (long)maxSuccesses);
        if (limit <= 0 || p <= 0.0) {
            return 0;
        }
        if (p >= 1.0) {
            return limit;
        }
        double d = random.nextDouble();
        double q = 1.0 - p;
        double c = 1.0;
        double pPow = 1.0;
        double qPow = Math.pow(q, trials);
        if (d < qPow) {
            return 0;
        }
        double pSum = qPow;
        for (int s = 1; s < limit; ++s) {
            if (!(d < (pSum += (c *= (double)(trials - (long)(s - 1)) / (double)s) * (pPow *= p) * (qPow /= q)))) continue;
            return s;
        }
        return limit;
    }

    public static int getRandomSuccesses(double p, long trials, int maxSuccesses, int spacing, Random random) {
        int limit = (int)Math.min(trials, (long)maxSuccesses);
        if (limit <= 0 || p <= 0.0) {
            return 0;
        }
        if (p >= 1.0) {
            return limit;
        }
        double q = 1.0 - p;
        double[] rawPs = new double[limit + 1];
        double totalP = 0.0;
        double pPow = 1.0;
        double qPow = Math.max(Double.MIN_VALUE, Math.pow(q, trials));
        for (int s = 0; s <= limit; ++s) {
            double rawP;
            long spacedTrials;
            long l = spacedTrials = s == 0 ? 0L : ((long)s - 1L) * (long)spacing;
            if (trials < (long)s + spacedTrials) break;
            long availableTrials = trials - spacedTrials;
            double c = 1.0;
            for (int i = 0; i < s; ++i) {
                c *= (double)(availableTrials - (long)i) / (double)(i + 1);
            }
            rawPs[s] = rawP = c * (pPow *= p) * (qPow /= q);
            totalP += rawP;
        }
        double[] normalPs = new double[limit + 1];
        double pSum = 0.0;
        for (int s = 0; s <= limit; ++s) {
            if (rawPs[s] > 0.0) {
                pSum += rawPs[s] / totalP;
            }
            normalPs[s] = pSum;
        }
        double d = random.nextDouble();
        for (int s = 0; s <= limit; ++s) {
            if (!(d < normalPs[s])) continue;
            return s;
        }
        return 0;
    }

    public static IntLongPair getRandomSuccessesAndRemainingTrials(double p, long trials, int maxSuccesses, Random random) {
        int successes = MathUtil.getRandomSuccesses(p, trials, maxSuccesses, random);
        if (successes == maxSuccesses && (long)successes < trials) {
            long failures;
            double scale = (1.0 - p) / p;
            long maxRemaining = trials - (long)successes;
            while ((failures = MathUtil.gammaPoissonSample(successes, scale, random)) > maxRemaining) {
            }
            return new IntLongImmutablePair(successes, maxRemaining - failures);
        }
        return new IntLongImmutablePair(successes, 0L);
    }

    public static Vector3f transformPoint(Vector3f point, AnimationData[] transforms, Mat4f userMatrix, Mat4f localMatrix, Vector3f translation, Vector3f offset) {
        point.m_122253_(offset);
        localMatrix.transformVector3f(point);
        if (transforms.length == 1) {
            Mat4f mat = new Mat4f();
            Vector3f rVec = transforms[0].rCalc.getTransformations();
            if (rVec.m_122239_() != 0.0f) {
                mat.multiply(new Quat(rVec.m_122239_(), Vector3f.f_122222_, true));
            }
            if (rVec.m_122260_() != 0.0f) {
                mat.multiply(new Quat(rVec.m_122260_(), Vector3f.f_122225_, true));
            }
            if (rVec.m_122269_() != 0.0f) {
                mat.multiply(new Quat(rVec.m_122269_(), Vector3f.f_122227_, true));
            }
            mat.transformVector3f(point);
            Vector3f tVec = transforms[0].tCalc.getTransformations();
            tVec.m_122261_(0.0625f);
            tVec.m_122263_(1.0f, -1.0f, -1.0f);
            point.m_122253_(tVec);
        } else if (transforms.length > 1) {
            Vector3f rVec;
            int i;
            Stack<Vector3f> offsets = new Stack<Vector3f>();
            Stack<Vector3f> translations = new Stack<Vector3f>();
            for (i = transforms.length - 1; i > -1; --i) {
                offsets.push(transforms[i].offset.m_122281_());
                Vector3f tVec = transforms[i].tCalc.getTransformations();
                tVec.m_122261_(0.0625f);
                tVec.m_122263_(1.0f, -1.0f, -1.0f);
                translations.push(tVec);
            }
            for (i = 0; i < transforms.length - 1; ++i) {
                Vector3f temp;
                Vector3f tVec2;
                int j;
                Mat4f locMat = new Mat4f();
                rVec = transforms[i].rCalc.getTransformations();
                if (rVec.m_122239_() != 0.0f) {
                    locMat.multiply(new Quat(rVec.m_122239_(), Vector3f.f_122222_, true));
                }
                if (rVec.m_122260_() != 0.0f) {
                    locMat.multiply(new Quat(rVec.m_122260_(), Vector3f.f_122225_, true));
                }
                if (rVec.m_122269_() != 0.0f) {
                    locMat.multiply(new Quat(rVec.m_122269_(), Vector3f.f_122227_, true));
                }
                Vector3f tVec = (Vector3f)offsets.pop();
                for (j = 0; j < offsets.size(); ++j) {
                    tVec2 = (Vector3f)offsets.get(j);
                    tVec2.m_122267_(tVec);
                    temp = new Vector3f(tVec2.m_122239_(), tVec2.m_122260_(), tVec2.m_122269_());
                    locMat.transformVector3f(temp);
                    tVec2.m_122245_(temp.m_122239_(), temp.m_122260_(), temp.m_122269_());
                    tVec2.m_122253_(tVec);
                }
                for (j = translations.size() - 2 - i; j > -1; --j) {
                    tVec2 = (Vector3f)translations.get(j);
                    temp = new Vector3f(tVec2.m_122239_(), tVec2.m_122260_(), tVec2.m_122269_());
                    locMat.transformVector3f(temp);
                    tVec2.m_122245_(temp.m_122239_(), temp.m_122260_(), temp.m_122269_());
                }
            }
            Mat4f rotMat = new Mat4f();
            for (int i2 = transforms.length - 1; i2 > -1; --i2) {
                rVec = transforms[i2].rCalc.getTransformations();
                if (rVec.m_122239_() != 0.0f) {
                    rotMat.multiply(new Quat(rVec.m_122239_(), Vector3f.f_122222_, true));
                }
                if (rVec.m_122260_() != 0.0f) {
                    rotMat.multiply(new Quat(rVec.m_122260_(), Vector3f.f_122225_, true));
                }
                if (rVec.m_122269_() == 0.0f) continue;
                rotMat.multiply(new Quat(rVec.m_122269_(), Vector3f.f_122227_, true));
            }
            Vector3f tVec = (Vector3f)offsets.pop();
            Vector3f tVecO = transforms[transforms.length - 1].offset.m_122281_();
            Vector3f temp = point.m_122281_();
            temp.m_122267_(tVecO);
            point = tVec.m_122281_();
            point.m_122253_(temp);
            Vector3f temp2 = point.m_122281_();
            temp2.m_122267_(temp);
            rotMat.transformVector3f(temp);
            point.m_122245_(temp.m_122239_(), temp.m_122260_(), temp.m_122269_());
            point.m_122253_(temp2);
            for (Vector3f vec : translations) {
                point.m_122253_(vec);
            }
        }
        point.m_122253_(translation);
        userMatrix.transformVector3f(point);
        return point;
    }

    public static Vector3f transformPoint(Vector3f point, AnimationData[] transforms, Mat4f userMatrix, Mat4f localMatrix) {
        return MathUtil.transformPoint(point, transforms, userMatrix, localMatrix, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public static Vector3f transformPoint(Vector3f point, AnimationData[] transforms, Mat4f userMatrix, Vector3f translation, Vector3f offset) {
        return MathUtil.transformPoint(point, transforms, userMatrix, new Mat4f(), translation, offset);
    }

    public static Vector3f transformPoint(Vector3f point, AnimationData[] transforms, Mat4f userMatrix, Vector3f offset) {
        return MathUtil.transformPoint(point, transforms, userMatrix, new Mat4f(), new Vector3f(0.0f, 0.0f, 0.0f), offset);
    }

    public static Vector3f transformPoint(Vector3f point, AnimationData[] transforms, Mat4f userMatrix) {
        return MathUtil.transformPoint(point, transforms, userMatrix, new Mat4f(), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public static AABB rotateAabb(AABB box, Rotation rot) {
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> box;
            case Rotation.CLOCKWISE_90 -> new AABB(-box.f_82290_, box.f_82289_, box.f_82288_, -box.f_82293_, box.f_82292_, box.f_82291_);
            case Rotation.CLOCKWISE_180 -> new AABB(-box.f_82288_, box.f_82289_, -box.f_82290_, -box.f_82291_, box.f_82292_, -box.f_82293_);
            case Rotation.COUNTERCLOCKWISE_90 -> new AABB(box.f_82290_, box.f_82289_, -box.f_82288_, box.f_82293_, box.f_82292_, -box.f_82291_);
        };
    }

    public static VoxelShape rotate(VoxelShape shape, Rotation rotation) {
        List boxes = shape.m_83299_();
        ObjectArrayList shapes = new ObjectArrayList();
        for (AABB box : boxes) {
            shapes.add(Shapes.m_83064_((AABB)MathUtil.rotateAabb(box.m_82386_(-0.5, -0.5, -0.5), rotation).m_82386_(0.5, 0.5, 0.5)));
        }
        VoxelShape finalShape = (VoxelShape)shapes.get(0);
        for (int i = 1; i < shapes.size(); ++i) {
            finalShape = Shapes.m_83148_((VoxelShape)finalShape, (VoxelShape)((VoxelShape)shapes.get(i)), (BooleanOp)BooleanOp.f_82695_);
        }
        return finalShape.m_83296_();
    }

    public static int getPassedIntervals(int start, int end, int spacing) {
        int firstInterval = (start + spacing - 1) / spacing * spacing;
        if (firstInterval > end) {
            return 0;
        }
        return (end - firstInterval) / spacing + 1;
    }
}

