/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.render.RenderTypeNF;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.recipe.IEncyclopediaRecipe;
import frostnox.nightfall.data.recipe.IRenderableRecipe;
import frostnox.nightfall.encyclopedia.knowledge.IItemKnowledge;
import frostnox.nightfall.encyclopedia.knowledge.Knowledge;
import frostnox.nightfall.entity.PlayerAttribute;
import frostnox.nightfall.registry.KnowledgeNF;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.FluidStack;

public class RenderUtil {
    public static final int COLOR_WHITE = 0xFFFFFF;
    public static final int COLOR_BLACK = 3420462;
    public static final int COLOR_LEATHER = 13336911;
    public static final int COLOR_LINEN = 0xFFDFAF;
    public static final int COLOR_UNDEAD_CLOTH = 11846077;
    public static final int COLOR_SLOT_HIGHLIGHT = Integer.MAX_VALUE;
    public static final int COLOR_SLOT_DARKEN = 0x7F000000;
    public static final TranslatableComponent ATTRIBUTES_TEXT = new TranslatableComponent("screen.attributes");
    public static final TranslatableComponent RESISTANCES_TEXT = new TranslatableComponent("screen.resistances");
    public static final TranslatableComponent EFFECT_DEFENSE_TEXT = new TranslatableComponent("screen.defense.effect");
    public static final TranslatableComponent ARMOR_DEFENSE_TEXT = new TranslatableComponent("screen.defense.armor");
    public static final TranslatableComponent FREE_POINTS_TEXT = new TranslatableComponent("screen.free_points");
    public static final List<TranslatableComponent> FOOD_GROUPS_TEXT = TagsNF.FOOD_GROUPS.stream().map(tag -> new TranslatableComponent(tag.f_203868_().toString().replace(":", ".").replace("/", "."))).toList();

    public static TranslatableComponent getAttributeText(PlayerAttribute attribute) {
        return new TranslatableComponent("screen." + attribute.toString());
    }

    public static TranslatableComponent getDamageTypeText(DamageType type) {
        return new TranslatableComponent("screen." + type.toString());
    }

    public static int getItemBarColor(ItemStack stack) {
        float stackMaxDamage = stack.m_41720_().getMaxDamage(stack);
        float hue = Math.max(0.0f, (stackMaxDamage - (float)stack.m_41773_()) / stackMaxDamage);
        return Mth.m_14169_((float)(hue / 3.0f - 0.08f), (float)0.8f, (float)0.8f);
    }

    public static Color getFireColor(float temperature) {
        if (temperature < 500.0f) {
            return new Color(128, 16, 1, 255);
        }
        if (temperature < 1000.0f) {
            float p = (temperature - 500.0f) / 500.0f;
            return new Color(128 + (int)(122.0f * p), 16 + (int)(60.0f * p), 1, 255);
        }
        if (temperature < 1200.0f) {
            float p = (temperature - 1000.0f) / 200.0f;
            return new Color(250, 76 + (int)(55.0f * p), 1, 255);
        }
        if (temperature < 1350.0f) {
            float p = (temperature - 1200.0f) / 150.0f;
            return new Color(250 + (int)(5.0f * p), 131 + (int)(85.0f * p), 1 + (int)(122.0f * p), 255);
        }
        if (temperature < 1550.0f) {
            float p = (temperature - 1350.0f) / 200.0f;
            return new Color(255, 216 + (int)(34.0f * p), 123 + (int)(117.0f * p), 255);
        }
        if (temperature < 1700.0f) {
            float p = (temperature - 1500.0f) / 200.0f;
            return new Color(255 - (int)(69.0f * p), 250 - (int)(21.0f * p), 240 + (int)(3.0f * p), 255);
        }
        return new Color(186, 229, 243, 255);
    }

    public static void renderGradient(PoseStack pPoseStack, int x, int pY, int xSize, int ySize, int pBlitOffset, int slotColor) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GuiComponent.m_168740_((PoseStack)pPoseStack, (int)x, (int)pY, (int)(x + xSize), (int)(pY + ySize), (int)slotColor, (int)slotColor, (int)pBlitOffset);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    public static void renderFluidScreen(PoseStack poseStack, FluidStack fluidStack, AbstractContainerScreen<?> screen, int x, int y, double mouseX, double mouseY) {
        if (fluidStack.isEmpty()) {
            return;
        }
        int color = fluidStack.getFluid().getAttributes().getColor();
        if (color != -1) {
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157429_((float)((float)((color & 0xFF0000) >> 16) / 255.0f), (float)((float)((color & 0xFF00) >> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)((color & 0xFF000000) >> 24) / 255.0f));
        } else {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStack.getFluid().getAttributes().getStillTexture());
        RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.m_118414_().m_118330_());
        int width = ClientEngine.get().atlasWidth;
        int height = ClientEngine.get().atlasHeight;
        AbstractContainerScreen.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)(sprite.m_118409_() * (float)width), (float)(sprite.m_118411_() * (float)height), (int)16, (int)16, (int)width, (int)height);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (mouseX >= (double)x && mouseX < (double)(x + 16) && mouseY >= (double)y && mouseY < (double)(y + 16)) {
            screen.m_96602_(poseStack, (Component)new TextComponent(fluidStack.getAmount() + " ").m_7220_(fluidStack.getDisplayName()), Mth.m_14107_((double)mouseX), Mth.m_14107_((double)mouseY));
        }
    }

    public static void drawCenteredFont(PoseStack poseStack, Font font, Component text, int x, int y, int color, boolean shadow) {
        font.m_92889_(poseStack, text, (float)(x - Math.round((float)font.m_92724_(text.m_7532_()) / 2.0f)), (float)y, color);
    }

    public static void drawCenteredText(PoseStack poseStack, Font font, String text, int x, int y, int color, boolean dropShadow, int light) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_92811_(text, (float)x - (float)font.m_92895_(text) / 2.0f, (float)y, color, dropShadow, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, light);
        buffer.m_109911_();
    }

    public static void drawRightFont(PoseStack poseStack, Font font, Component text, int x, int y, int color) {
        font.m_92889_(poseStack, text, (float)(x - font.m_92724_(text.m_7532_())), (float)y, color);
    }

    public static void drawRightText(PoseStack poseStack, Font font, String text, int x, int y, int color, boolean dropShadow, int light) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_92811_(text, (float)(x - font.m_92895_(text)), (float)y, color, dropShadow, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, light);
        buffer.m_109911_();
    }

    public static void drawCubeOutlineWorld(PoseStack stack, MultiBufferSource.BufferSource buffer, Color color, VoxelShape cube) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110504_());
        Matrix4f matrix = stack.m_85850_().m_85861_();
        Matrix3f normal = stack.m_85850_().m_85864_();
        cube.m_83224_((xMin, yMin, zMin, xMax, yMax, zMax) -> {
            float xSize = (float)(xMax - xMin);
            float ySize = (float)(yMax - yMin);
            float zSize = (float)(zMax - zMin);
            float dist = Mth.m_14116_((float)(xSize * xSize + ySize * ySize + zSize * zSize));
            builder.m_85982_(matrix, (float)xMin, (float)yMin, (float)zMin).m_6122_(color.getRed(), color.getBlue(), color.getGreen(), color.getAlpha()).m_85977_(normal, xSize /= dist, ySize /= dist, zSize /= dist).m_5752_();
            builder.m_85982_(matrix, (float)xMax, (float)yMax, (float)zMax).m_6122_(color.getRed(), color.getBlue(), color.getGreen(), color.getAlpha()).m_85977_(normal, xSize, ySize, zSize).m_5752_();
        });
        buffer.m_109912_(RenderType.m_110504_());
    }

    public static void drawMicroGridCubeOutline(PoseStack stack, MultiBufferSource buffer, Color color, VoxelShape cube, boolean skipHitBox) {
        VertexConsumer builder = buffer.m_6299_(RenderTypeNF.LINES_DEPTH);
        Matrix4f matrix = stack.m_85850_().m_85861_();
        Matrix3f normal = stack.m_85850_().m_85864_();
        cube.m_83224_((xMin, yMin, zMin, xMax, yMax, zMax) -> {
            float xSize = (float)(xMax - xMin);
            float ySize = (float)(yMax - yMin);
            float zSize = (float)(zMax - zMin);
            float dist = Mth.m_14116_((float)(xSize * xSize + ySize * ySize + zSize * zSize));
            xSize /= dist;
            ySize /= dist;
            zSize /= dist;
            if (skipHitBox || !ClientEngine.get().microHitBox.m_82393_(xMin, yMin, zMin) || !ClientEngine.get().microHitBox.m_82393_(xMax, yMax, zMax)) {
                builder.m_85982_(matrix, (float)xMin, (float)yMin, (float)zMin).m_6122_(color.getRed(), color.getBlue(), color.getGreen(), color.getAlpha()).m_85977_(normal, xSize, ySize, zSize).m_5752_();
                builder.m_85982_(matrix, (float)xMax, (float)yMax, (float)zMax).m_6122_(color.getRed(), color.getBlue(), color.getGreen(), color.getAlpha()).m_85977_(normal, xSize, ySize, zSize).m_5752_();
            }
        });
    }

    public static void drawMicroGridCube(PoseStack stack, MultiBufferSource buffer, Color color, int combinedLight, float size, boolean[][][] grid, int x, int y, int z, TextureAtlasSprite sprite) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)sprite.m_118414_().m_118330_()));
        Vec2 UV = new Vec2(sprite.m_118409_(), sprite.m_118411_());
        Vec3 translation = new Vec3((double)x / 16.0, (double)y / 16.0, (double)z / 16.0);
        int maxX = grid.length - 1;
        int maxY = grid[0].length - 1;
        int maxZ = grid[0][0].length - 1;
        Matrix4f matrix = stack.m_85850_().m_85861_();
        Matrix3f normal = stack.m_85850_().m_85864_();
        if (z == 0 || !grid[x][y][z - 1]) {
            RenderUtil.drawFace(Direction.NORTH, matrix, normal, builder, color, translation.m_82520_((double)size / 2.0, (double)size / 2.0, 0.0), size, size, UV, 1.0f / (float)ClientEngine.get().atlasWidth, 1.0f / (float)ClientEngine.get().atlasHeight, combinedLight);
        }
        if (z == maxZ || !grid[x][y][z + 1]) {
            RenderUtil.drawFace(Direction.SOUTH, matrix, normal, builder, color, translation.m_82520_((double)size / 2.0, (double)size / 2.0, (double)size), size, size, UV, 1.0f / (float)ClientEngine.get().atlasWidth, 1.0f / (float)ClientEngine.get().atlasHeight, combinedLight);
        }
        if (x == 0 || !grid[x - 1][y][z]) {
            RenderUtil.drawFace(Direction.WEST, matrix, normal, builder, color, translation.m_82520_(0.0, (double)size / 2.0, (double)size / 2.0), size, size, UV, 1.0f / (float)ClientEngine.get().atlasWidth, 1.0f / (float)ClientEngine.get().atlasHeight, combinedLight);
        }
        if (x == maxX || !grid[x + 1][y][z]) {
            RenderUtil.drawFace(Direction.EAST, matrix, normal, builder, color, translation.m_82520_((double)size, (double)size / 2.0, (double)size / 2.0), size, size, UV, 1.0f / (float)ClientEngine.get().atlasWidth, 1.0f / (float)ClientEngine.get().atlasHeight, combinedLight);
        }
        if (y == maxY || !grid[x][y + 1][z]) {
            RenderUtil.drawFace(Direction.UP, matrix, normal, builder, color, translation.m_82520_((double)size / 2.0, (double)size, (double)size / 2.0), size, size, UV, 1.0f / (float)ClientEngine.get().atlasWidth, 1.0f / (float)ClientEngine.get().atlasHeight, combinedLight);
        }
        if (y != 0 && !grid[x][y - 1][z]) {
            RenderUtil.drawFace(Direction.DOWN, matrix, normal, builder, color, translation.m_82520_((double)size / 2.0, 0.0, (double)size / 2.0), size, size, UV, 1.0f / (float)ClientEngine.get().atlasWidth, 1.0f / (float)ClientEngine.get().atlasHeight, combinedLight);
        }
    }

    public static void drawFace(Direction face, Matrix4f matrix, Matrix3f normal, VertexConsumer builder, Color color, Vec3 center, float width, float height, Vec2 UV, float UVwidth, float UVheight, int combinedLight) {
        Vector3f rightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f topDirection = new Vector3f(0.0f, 1.0f, 0.0f);
        switch (face) {
            case NORTH: {
                rightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                topDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case SOUTH: {
                rightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                topDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case EAST: {
                rightDirection = new Vector3f(0.0f, 0.0f, -1.0f);
                topDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case WEST: {
                rightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                topDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case UP: {
                rightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                topDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                break;
            }
            case DOWN: {
                rightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                topDirection = new Vector3f(0.0f, 0.0f, 1.0f);
            }
        }
        rightDirection.m_122261_(0.5f * width);
        topDirection.m_122261_(0.5f * height);
        Vector3f BLPos = new Vector3f(center);
        BLPos.m_122267_(rightDirection);
        BLPos.m_122267_(topDirection);
        Vector3f BRPos = new Vector3f(center);
        BRPos.m_122253_(rightDirection);
        BRPos.m_122267_(topDirection);
        Vector3f TLPos = new Vector3f(center);
        TLPos.m_122267_(rightDirection);
        TLPos.m_122253_(topDirection);
        Vector3f TRPos = new Vector3f(center);
        TRPos.m_122253_(rightDirection);
        TRPos.m_122253_(topDirection);
        Vec2 BRUV = new Vec2(UV.f_82470_ + UVwidth, UV.f_82471_);
        Vec2 TLUV = new Vec2(UV.f_82470_, UV.f_82471_ + UVheight);
        Vec2 TRUV = new Vec2(UV.f_82470_ + UVwidth, UV.f_82471_ + UVheight);
        Vector3f faceNormal = face.m_122432_();
        RenderUtil.drawVertex(matrix, normal, builder, BLPos, UV, faceNormal, color, combinedLight);
        RenderUtil.drawVertex(matrix, normal, builder, BRPos, BRUV, faceNormal, color, combinedLight);
        RenderUtil.drawVertex(matrix, normal, builder, TRPos, TRUV, faceNormal, color, combinedLight);
        RenderUtil.drawVertex(matrix, normal, builder, TLPos, TLUV, faceNormal, color, combinedLight);
    }

    private static void drawVertex(Matrix4f matrix, Matrix3f normal, VertexConsumer builder, Vector3f pos, Vec2 UV, Vector3f faceNormal, Color color, int combinedLight) {
        builder.m_85982_(matrix, pos.m_122239_(), pos.m_122260_(), pos.m_122269_()).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_(UV.f_82470_, UV.f_82471_).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_85977_(normal, faceNormal.m_122239_(), faceNormal.m_122260_(), faceNormal.m_122269_()).m_5752_();
    }

    public static void renderSprite(PoseStack stack, int x, int y, ResourceLocation tex) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(tex);
        GuiComponent.m_93133_((PoseStack)stack, (int)x, (int)y, (float)sprite.m_174743_(), (float)sprite.m_174744_(), (int)sprite.m_118405_(), (int)sprite.m_118408_(), (int)ClientEngine.get().atlasWidth, (int)ClientEngine.get().atlasHeight);
    }

    public static void renderKnowledge(PoseStack stack, int xPos, int yPos, int xOff, int yOff, Knowledge knowledge) {
        if (knowledge instanceof IItemKnowledge) {
            IItemKnowledge itemKnowledge = (IItemKnowledge)((Object)knowledge);
            Minecraft.m_91087_().m_91291_().m_115203_(new ItemStack((ItemLike)itemKnowledge.getItem()), xPos + xOff, yPos + yOff);
        } else {
            RenderUtil.renderSprite(stack, xPos, yPos, KnowledgeNF.KNOWLEDGE_TEXTURE);
        }
    }

    public static void renderItem(PoseStack poseStack, ItemStack item, int xOff, int yOff, int blitOff, boolean darken) {
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        PoseStack viewStack = RenderSystem.m_157191_();
        viewStack.m_85836_();
        viewStack.m_85837_((double)xOff, (double)yOff, (double)(blitOff + 16));
        viewStack.m_85837_(8.0, 8.0, 0.0);
        viewStack.m_85841_(1.0f, -1.0f, 1.0f);
        viewStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        BakedModel model = mc.m_91291_().m_174264_(item, null, null, 0);
        Lighting.m_84930_();
        poseStack.m_85836_();
        model = ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemTransforms.TransformType)ItemTransforms.TransformType.GUI, (boolean)false);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        RenderType rendertype = ItemBlockRenderTypes.m_109279_((ItemStack)item, (boolean)true);
        Random random = new Random();
        random.setSeed(42L);
        PoseStack.Pose pose = poseStack.m_85850_();
        VertexConsumer builder = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)item.m_41790_());
        for (Direction dir : Direction.values()) {
            random.setSeed(42L);
            for (BakedQuad quad : model.m_6840_(null, dir, random)) {
                if (darken) {
                    builder.putBulkData(pose, quad, 0.0f, 0.0f, 0.0f, 0xF000F0, OverlayTexture.f_118083_, true);
                    continue;
                }
                int rgb = -1;
                if (quad.m_111304_()) {
                    rgb = mc.getItemColors().m_92676_(item, quad.m_111305_());
                }
                float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                float b = (float)(rgb & 0xFF) / 255.0f;
                builder.putBulkData(pose, quad, r, g, b, 0xF000F0, OverlayTexture.f_118083_, true);
            }
        }
        for (BakedQuad quad : model.m_6840_(null, null, random)) {
            if (darken) {
                builder.putBulkData(pose, quad, 0.0f, 0.0f, 0.0f, 0xF000F0, OverlayTexture.f_118083_, true);
                continue;
            }
            int rgb = -1;
            if (quad.m_111304_()) {
                rgb = mc.getItemColors().m_92676_(item, quad.m_111305_());
            }
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            builder.putBulkData(pose, quad, r, g, b, 0xF000F0, OverlayTexture.f_118083_, true);
        }
        poseStack.m_85849_();
        buffer.m_109911_();
        RenderSystem.m_69482_();
        Lighting.m_84931_();
        viewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static List<Recipe<?>> getSearchableRecipes(Player player) {
        return player.f_19853_.m_7465_().m_44051_().stream().sorted((r1, r2) -> {
            String r1Name = r1.m_8043_().m_41720_().m_41466_().getString();
            String r2Name = r2.m_8043_().m_41720_().m_41466_().getString();
            return r1Name.compareTo(r2Name);
        }).filter(recipe -> {
            IRenderableRecipe renderableRecipe;
            return !recipe.m_8043_().m_41619_() && recipe instanceof IRenderableRecipe && (renderableRecipe = (IRenderableRecipe)recipe).showInRecipeViewer();
        }).toList();
    }

    public static List<Recipe<?>> getUnlockedRecipes(Player player) {
        return player.f_19853_.m_7465_().m_44051_().stream().sorted((r1, r2) -> {
            String r1Name = r1.m_8043_().m_41720_().m_41466_().getString();
            String r2Name = r2.m_8043_().m_41720_().m_41466_().getString();
            return r1Name.compareTo(r2Name);
        }).filter(recipe -> {
            IRenderableRecipe renderableRecipe;
            if (!recipe.m_8043_().m_41619_() && recipe instanceof IRenderableRecipe && (renderableRecipe = (IRenderableRecipe)recipe).showInRecipeViewer()) {
                if (recipe instanceof IEncyclopediaRecipe) {
                    IEncyclopediaRecipe encyclopediaRecipe = (IEncyclopediaRecipe)recipe;
                    return encyclopediaRecipe.isUnlocked(player);
                }
                return true;
            }
            return false;
        }).toList();
    }
}

