/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.animation;

import com.mojang.math.Vector3f;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.math.Easing;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class AnimationCalculator {
    private boolean looping = false;
    private Easing easing = Easing.none;
    public Vector3f startVec = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f endVec = new Vector3f(0.0f, 0.0f, 0.0f);
    public int length = 1;
    public int frame = 0;
    public int offset = 0;
    public float partialTicks = 1.0f;

    public AnimationCalculator() {
    }

    public AnimationCalculator(int length, int frame, float partialTicks) {
        this.length = length;
        this.frame = frame;
        this.partialTicks = partialTicks;
    }

    public AnimationCalculator(int length, int frame, float partialTicks, Easing easing) {
        this.length = length;
        this.frame = frame;
        this.partialTicks = partialTicks;
        this.easing = easing;
    }

    public AnimationCalculator(int length, int frame, float partialTicks, Vector3f startVec, Vector3f endVec) {
        this.length = length;
        this.frame = frame;
        this.partialTicks = partialTicks;
        this.startVec = startVec.m_122281_();
        this.endVec = endVec.m_122281_();
    }

    public AnimationCalculator(int length, int frame, float partialTicks, Vector3f startVec, Vector3f endVec, Easing easing) {
        this.length = length;
        this.frame = frame;
        this.partialTicks = partialTicks;
        this.startVec = startVec.m_122281_();
        this.endVec = endVec.m_122281_();
        this.easing = easing;
    }

    public AnimationCalculator copy() {
        AnimationCalculator calc = new AnimationCalculator();
        calc.length = this.length;
        calc.frame = this.frame;
        calc.partialTicks = this.partialTicks;
        calc.startVec = this.startVec.m_122281_();
        calc.endVec = this.endVec.m_122281_();
        calc.easing = this.easing;
        calc.offset = this.offset;
        return calc;
    }

    public void scale(float x, float y, float z) {
        this.startVec.m_122263_(x, y, z);
        this.endVec.m_122263_(x, y, z);
    }

    public Vector3f getTransformations() {
        Vector3f vec1 = this.endVec.m_122281_();
        vec1.m_122267_(this.startVec);
        vec1.m_122261_(this.getProgress());
        Vector3f vec2 = this.startVec.m_122281_();
        vec2.m_122253_(vec1);
        return vec2;
    }

    public float getProgress() {
        if (!this.looping && this.frame > this.length) {
            return 1.0f;
        }
        float progress = AnimationUtil.interpolate((float)Math.max(0, this.frame - 1 - this.offset) / (float)(this.length - this.offset), (float)(this.frame - this.offset) / (float)(this.length - this.offset), this.partialTicks);
        if (this.looping && progress % 1.0f != 0.0f) {
            progress %= 1.0f;
        }
        return AnimationUtil.applyEasing(progress, this.easing);
    }

    public void setEasing(Easing easing) {
        this.easing = easing;
    }

    public void extend(float x, float y, float z) {
        this.startVec = this.endVec.m_122281_();
        this.endVec = new Vector3f(x, y, z);
    }

    public void extend(float x, float y, float z, Easing easing) {
        this.setEasing(easing);
        this.extend(x, y, z);
    }

    public void extend(Vector3f endVec) {
        this.startVec = this.endVec.m_122281_();
        this.endVec = endVec.m_122281_();
    }

    public void extend(Vector3f endVec, Easing easing) {
        this.setEasing(easing);
        this.extend(endVec);
    }

    public void extendWithCharge(Vector3f vec, float multiplier) {
        this.extendWithCharge(vec.m_122239_(), vec.m_122260_(), vec.m_122269_(), multiplier);
    }

    public void extendWithCharge(Vector3f vec, float multiplier, Easing easing) {
        this.extendWithCharge(vec.m_122239_(), vec.m_122260_(), vec.m_122269_(), multiplier, easing);
    }

    public void extendWithCharge(float x, float y, float z, float multiplier) {
        float charge = AnimationUtil.applyEasing(multiplier, this.easing);
        if (charge > 0.0f) {
            this.startVec = this.endVec.m_122281_();
            Vector3f vec = new Vector3f(x, y, z);
            vec.m_122267_(this.startVec);
            vec.m_122261_(charge);
            this.endVec.m_122253_(vec);
        } else {
            this.extend(x, y, z);
        }
    }

    public void extendWithCharge(float x, float y, float z, float multiplier, Easing easing) {
        this.setEasing(easing);
        this.extendWithCharge(x, y, z, multiplier);
    }

    public void addWithCharge(float x, float y, float z, float multiplier) {
        float charge = AnimationUtil.applyEasing(multiplier, this.easing);
        if (charge > 0.0f) {
            this.startVec = this.endVec.m_122281_();
            this.endVec.m_122272_(x * charge, y * charge, z * charge);
        } else {
            this.add(x, y, z);
        }
    }

    public void addWithCharge(float x, float y, float z, float multiplier, Easing easing) {
        this.setEasing(easing);
        this.addWithCharge(x, y, z, multiplier);
    }

    public void extendWithHitStop(LivingEntity user, int stopStateDuration, float x, float y, float z) {
        this.extendWithHitStop(user, stopStateDuration, x, y, z, this.easing);
    }

    public void extendWithHitStop(LivingEntity user, int stopStateDuration, float x, float y, float z, Easing easing) {
        if (!(user instanceof Player)) {
            this.extend(x, y, z, easing);
        } else {
            Player player = (Player)user;
            IPlayerData capP = PlayerData.get(player);
            int frame = capP.getHitStopFrame();
            if (frame == -1) {
                this.extend(x, y, z, easing);
            } else {
                AnimationCalculator calc = this.copy();
                calc.length = stopStateDuration;
                calc.frame = frame;
                calc.partialTicks = capP.getHitStopPartial();
                calc.extend(x, y, z, easing);
                this.setStaticVector(calc.getTransformations());
            }
        }
    }

    public void addWithHitStop(LivingEntity user, int stopStateDuration, float x, float y, float z) {
        this.addWithHitStop(user, stopStateDuration, x, y, z, this.easing);
    }

    public void addWithHitStop(LivingEntity user, int stopStateDuration, float x, float y, float z, Easing easing) {
        if (!(user instanceof Player)) {
            this.add(x, y, z, easing);
        } else {
            Player player = (Player)user;
            IPlayerData capP = PlayerData.get(player);
            int frame = capP.getHitStopFrame();
            if (frame == -1) {
                this.add(x, y, z, easing);
            } else {
                AnimationCalculator calc = this.copy();
                calc.length = stopStateDuration;
                calc.frame = frame;
                calc.partialTicks = capP.getHitStopPartial();
                calc.add(x, y, z, easing);
                this.setStaticVector(calc.getTransformations());
            }
        }
    }

    public void add(float x, float y, float z) {
        this.startVec = this.endVec.m_122281_();
        this.endVec.m_122272_(x, y, z);
    }

    public void add(float x, float y, float z, Easing easing) {
        this.add(x, y, z);
        this.setEasing(easing);
    }

    public void add(Vector3f vec) {
        this.startVec = this.endVec.m_122281_();
        this.endVec.m_122253_(vec);
    }

    public void mulEnd(float xMul, float yMul, float zMul) {
        this.endVec.m_122263_(xMul, yMul, zMul);
    }

    public void setVectors(Vector3f startVec, Vector3f endVec) {
        this.startVec = startVec.m_122281_();
        this.endVec = endVec.m_122281_();
    }

    public void setVectors(Vector3f startVec, Vector3f endVec, Easing easing) {
        this.setVectors(startVec, endVec);
        this.easing = easing;
    }

    public void setVectors(Vector3f startVec, float x, float y, float z) {
        this.startVec = startVec.m_122281_();
        this.endVec = new Vector3f(x, y, z);
    }

    public void setVectors(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.startVec = new Vector3f(x1, y1, z1);
        this.endVec = new Vector3f(x2, y2, z2);
    }

    public void setVectors(float x1, float y1, float z1, float x2, float y2, float z2, Easing easing) {
        this.setVectors(x1, y1, z1, x2, y2, z2);
        this.easing = easing;
    }

    public void setVectorsWithHitStop(LivingEntity user, int stopStateDuration, float x1, float y1, float z1, float x2, float y2, float z2) {
        this.setVectorsWithHitStop(user, stopStateDuration, x1, y1, z1, x2, y2, z2, this.easing);
    }

    public void setVectorsWithHitStop(LivingEntity user, int stopStateDuration, float x1, float y1, float z1, float x2, float y2, float z2, Easing easing) {
        if (!(user instanceof Player)) {
            this.setVectors(x1, y1, z1, x2, y2, z2, easing);
        } else {
            Player player = (Player)user;
            IPlayerData capP = PlayerData.get(player);
            int frame = capP.getHitStopFrame();
            if (frame == -1) {
                this.setVectors(x1, y1, z1, x2, y2, z2, easing);
            } else {
                AnimationCalculator calc = this.copy();
                calc.length = stopStateDuration;
                calc.frame = frame;
                calc.partialTicks = capP.getHitStopPartial();
                calc.setVectors(x1, y1, z1, x2, y2, z2, easing);
                this.setStaticVector(calc.getTransformations());
            }
        }
    }

    public void addFrom(Vector3f startVec, float x, float y, float z) {
        this.startVec = this.endVec.m_122281_();
        this.endVec = startVec.m_122281_();
        this.endVec.m_122272_(x, y, z);
    }

    public void addFrom(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.startVec = new Vector3f(x1, y1, z1);
        this.endVec = this.startVec.m_122281_();
        this.endVec.m_122272_(x2, y2, z2);
    }

    public void setStaticVector(Vector3f vector) {
        this.startVec = vector.m_122281_();
        this.endVec = vector.m_122281_();
    }

    public void setStaticVector(float x, float y, float z) {
        Vector3f vec = new Vector3f(x, y, z);
        this.startVec = vec.m_122281_();
        this.endVec = vec.m_122281_();
    }

    public void freeze() {
        this.startVec = this.endVec.m_122281_();
    }

    public void update(int frame, int length) {
        this.frame = frame;
        this.length = length;
        this.offset = 0;
        this.looping = false;
    }

    public void update(int frame, int length, Easing easing) {
        this.frame = frame;
        this.length = length;
        this.offset = 0;
        this.easing = easing;
        this.looping = false;
    }

    public void update(int frame, int length, float partialTicks) {
        this.frame = frame;
        this.length = length;
        this.offset = 0;
        this.partialTicks = partialTicks;
        this.looping = false;
    }

    public void update(int frame, int length, float partialTicks, Easing easing) {
        this.frame = frame;
        this.length = length;
        this.offset = 0;
        this.partialTicks = partialTicks;
        this.easing = easing;
        this.looping = false;
    }

    public void resetLength(int length) {
        this.resetLength(length, Easing.none);
    }

    public void resetLength(int length, Easing easing) {
        this.length = length;
        this.offset = 0;
        this.setEasing(easing);
        this.looping = false;
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    public void wrapRotation() {
        this.startVec.m_122245_(this.startVec.m_122239_() % 360.0f, this.startVec.m_122260_() % 360.0f, this.startVec.m_122269_() % 360.0f);
        this.endVec.m_122245_(this.endVec.m_122239_() % 360.0f, this.endVec.m_122260_() % 360.0f, this.endVec.m_122269_() % 360.0f);
    }
}

