/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.animation;

import com.mojang.math.Vector3f;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.math.Easing;
import net.minecraft.client.model.geom.ModelPart;

public class AnimationData {
    public AnimationCalculator tCalc;
    public AnimationCalculator rCalc;
    public AnimationCalculator sCalc;
    public final Vector3f dTranslation;
    public final Vector3f dRotation;
    public final Vector3f dScale;
    public final Vector3f offset;

    public AnimationData() {
        this(new Vector3f(), new Vector3f(), new Vector3f(), new Vector3f());
    }

    public AnimationData(Vector3f offset) {
        this(new Vector3f(), new Vector3f(), new Vector3f(), offset);
    }

    public AnimationData(Vector3f offset, Vector3f dRotation) {
        this(new Vector3f(), dRotation, new Vector3f(), offset);
    }

    public AnimationData(Vector3f offset, Vector3f dRotation, Vector3f dTranslation) {
        this(dTranslation, dRotation, new Vector3f(), offset);
    }

    public AnimationData(Vector3f dTranslation, Vector3f dRotation, Vector3f dScale, Vector3f offset) {
        this.dTranslation = dTranslation;
        this.dRotation = dRotation;
        this.dScale = dScale;
        this.setDefaults(dTranslation, dRotation, dScale);
        this.tCalc = new AnimationCalculator();
        this.tCalc.setStaticVector(dTranslation);
        this.rCalc = new AnimationCalculator();
        this.rCalc.setStaticVector(dRotation);
        this.sCalc = new AnimationCalculator();
        this.sCalc.setStaticVector(dScale);
        this.offset = offset;
    }

    public AnimationData(AnimationData data) {
        this.tCalc = data.tCalc.copy();
        this.rCalc = data.rCalc.copy();
        this.sCalc = data.sCalc.copy();
        this.dRotation = data.dRotation.m_122281_();
        this.dTranslation = data.dTranslation.m_122281_();
        this.dScale = data.dScale.m_122281_();
        this.offset = data.offset.m_122281_();
    }

    public void setDefaults(Vector3f translation, Vector3f rotation, Vector3f scale) {
        this.setDefaults(translation.m_122239_(), translation.m_122260_(), translation.m_122269_(), rotation.m_122239_(), rotation.m_122260_(), rotation.m_122269_(), scale.m_122239_(), scale.m_122260_(), scale.m_122269_());
    }

    public void setDefaults(float x, float y, float z, float xRot, float yRot, float zRot, float xScale, float yScale, float zScale) {
        this.dTranslation.m_122245_(AnimationData.offsetValue(x), AnimationData.offsetValue(y), AnimationData.offsetValue(z));
        this.dRotation.m_122245_(AnimationData.offsetValue(xRot), AnimationData.offsetValue(yRot), AnimationData.offsetValue(zRot));
        this.dScale.m_122245_(AnimationData.offsetScale(xScale), AnimationData.offsetScale(yScale), AnimationData.offsetScale(zScale));
    }

    private static float offsetScale(float scale) {
        return scale % 1.0f != 0.0f ? scale + 1.0E-5f : scale;
    }

    private static float offsetValue(float value) {
        return value == 0.0f ? value : value + 1.0E-5f;
    }

    public AnimationData copy() {
        return new AnimationData(this);
    }

    public void update(float partialTicks) {
        this.tCalc.partialTicks = partialTicks;
        this.rCalc.partialTicks = partialTicks;
        this.sCalc.partialTicks = partialTicks;
    }

    public void update(int frame, int length, float partialTicks) {
        this.tCalc.update(frame, length, partialTicks);
        this.rCalc.update(frame, length, partialTicks);
        this.sCalc.update(frame, length, partialTicks);
    }

    public void update(int frame, int length, Easing easing) {
        this.tCalc.update(frame, length, easing);
        this.rCalc.update(frame, length, easing);
        this.sCalc.update(frame, length, easing);
    }

    public void update(int frame, int length, float partialTicks, Easing easing) {
        this.tCalc.update(frame, length, partialTicks, easing);
        this.rCalc.update(frame, length, partialTicks, easing);
        this.sCalc.update(frame, length, partialTicks, easing);
    }

    public void resetLengths(int length) {
        this.resetLengths(length, Easing.none);
    }

    public void resetLengths(int length, Easing easing) {
        this.tCalc.resetLength(length, easing);
        this.rCalc.resetLength(length, easing);
        this.sCalc.resetLength(length, easing);
    }

    public void reset() {
        this.resetRotation();
        this.resetTranslation();
        this.resetScale();
    }

    public void resetRotation() {
        this.rCalc.setStaticVector(this.dRotation);
    }

    public void resetTranslation() {
        this.tCalc.setStaticVector(this.dTranslation);
    }

    public void resetScale() {
        this.sCalc.setStaticVector(this.dScale);
    }

    public void toDefault() {
        this.toDefaultRotation();
        this.toDefaultTranslation();
        this.toDefaultScale();
    }

    public void toDefaultRotation() {
        this.rCalc.extend(this.dRotation);
    }

    public void toDefaultTranslation() {
        this.tCalc.extend(this.dTranslation);
    }

    public void toDefaultScale() {
        this.sCalc.extend(this.dScale);
    }

    public void writeToModelPart(ModelPart part) {
        Vector3f rVec = MathUtil.toRadians(this.rCalc.getTransformations());
        Vector3f tVec = this.tCalc.getTransformations();
        part.f_104203_ = rVec.m_122239_();
        part.f_104204_ = rVec.m_122260_();
        part.f_104205_ = rVec.m_122269_();
        part.f_104200_ = tVec.m_122239_();
        part.f_104201_ = tVec.m_122260_();
        part.f_104202_ = tVec.m_122269_();
    }

    public void readFromModelPart(ModelPart part) {
        this.setDefaults(part.f_104200_, part.f_104201_, part.f_104202_, MathUtil.toDegrees(part.f_104203_), MathUtil.toDegrees(part.f_104204_), MathUtil.toDegrees(part.f_104205_), 1.0f, 1.0f, 1.0f);
        this.tCalc.setStaticVector(this.dTranslation);
        this.rCalc.setStaticVector(this.dRotation);
        this.sCalc.setStaticVector(this.dScale);
    }

    public void mirrorAcrossY() {
        if (this.rCalc.startVec.m_122260_() != this.dRotation.m_122260_()) {
            this.rCalc.startVec.setY(-this.rCalc.startVec.m_122260_());
        }
        if (this.rCalc.startVec.m_122269_() != this.dRotation.m_122269_()) {
            this.rCalc.startVec.setZ(-this.rCalc.startVec.m_122269_());
        }
        if (this.rCalc.endVec.m_122260_() != this.dRotation.m_122260_()) {
            this.rCalc.endVec.setY(-this.rCalc.endVec.m_122260_());
        }
        if (this.rCalc.endVec.m_122269_() != this.dRotation.m_122269_()) {
            this.rCalc.endVec.setZ(-this.rCalc.endVec.m_122269_());
        }
    }
}

