/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.data;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.SortedSet;

public class SingleSortedSet<E>
extends AbstractSet<E>
implements SortedSet<E> {
    private E element;

    public SingleSortedSet(E element) {
        this.element = Objects.requireNonNull(element);
    }

    @Override
    public boolean add(E e) {
        this.element = e;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.singleton(this.element).iterator();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Comparator<? super E> comparator() {
        return null;
    }

    @Override
    public E first() {
        return this.element;
    }

    @Override
    public E last() {
        return this.element;
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return !this.element.equals(toElement) ? this : Collections.emptySortedSet();
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.element.equals(fromElement) ? this : Collections.emptySortedSet();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.element.equals(fromElement) && !this.element.equals(toElement) ? this : Collections.emptySortedSet();
    }
}

