/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.data;

public class TimedValue<T> {
    private T value;
    private final T resetValue;
    private int counter;
    public final int timeLimit;

    public TimedValue(T resetValue, int timeLimit) {
        this.resetValue = resetValue;
        this.timeLimit = timeLimit;
        this.reset();
    }

    public T getValue() {
        return this.value;
    }

    public int getCounter() {
        return this.counter;
    }

    public void tick() {
        if (this.isActive()) {
            ++this.counter;
        }
        if (this.counter > this.timeLimit) {
            this.reset();
        }
    }

    public void set(T value, int counter) {
        this.value = value;
        this.counter = counter;
    }

    public void set(T value) {
        this.set(value, 0);
    }

    public void reset() {
        this.value = this.resetValue;
        this.counter = this.timeLimit + 1;
    }

    public boolean isActive() {
        return this.counter <= this.timeLimit;
    }
}

