/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.data;

public record Vec2d(double x, double y) {
    public static Vec2d ZERO = new Vec2d(0.0, 0.0);

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Vec2d) {
            Vec2d vec = (Vec2d)obj;
            return this.x == vec.x && this.y == vec.y;
        }
        return false;
    }

    @Override
    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public Vec2d add(Vec2d vec) {
        return this.add(vec.x, vec.y);
    }

    public Vec2d add(double x, double y) {
        return new Vec2d(this.x + x, this.y + y);
    }

    public Vec2d subtract(Vec2d vec) {
        return this.subtract(vec.x, vec.y);
    }

    public Vec2d subtract(double x, double y) {
        return this.add(-x, -y);
    }

    public Vec2d multiply(Vec2d vec) {
        return this.multiply(vec.x, vec.y);
    }

    public Vec2d multiply(double xMag, double yMag) {
        return new Vec2d(this.x * xMag, this.y * yMag);
    }

    public Vec2d scale(double mag) {
        return this.multiply(mag, mag);
    }

    public double dot(Vec2d vec) {
        return this.x * vec.x + this.y * this.y;
    }

    public double cross(Vec2d vec) {
        return this.x * vec.y - this.y * vec.x;
    }

    public double lengthSqr() {
        return this.x * this.x + this.y * this.y;
    }

    public double length() {
        return Math.sqrt(this.lengthSqr());
    }

    public Vec2d normalize() {
        double length = this.length();
        return length < 1.0E-4 ? ZERO : new Vec2d(this.x / length, this.y / length);
    }

    public Vec2d reverse() {
        return new Vec2d(-this.x, -this.y);
    }

    public double distSqr(Vec2d vec) {
        return this.distSqr(vec.x, vec.y);
    }

    public double distSqr(double x, double y) {
        double xDist = x - this.x;
        double yDist = y - this.y;
        return xDist * xDist + yDist * yDist;
    }

    public double dist(Vec2d vec) {
        return this.dist(vec.x, vec.y);
    }

    public double dist(double x, double y) {
        return Math.sqrt(this.distSqr(x, y));
    }
}

