/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.data;

public record Vec2f(float x, float y) {
    public static Vec2f ZERO = new Vec2f(0.0f, 0.0f);

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Vec2f) {
            Vec2f vec = (Vec2f)obj;
            return this.x == vec.x && this.y == vec.y;
        }
        return false;
    }

    @Override
    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public Vec2f add(Vec2f vec) {
        return this.add(vec.x, vec.y);
    }

    public Vec2f add(float x, float y) {
        return new Vec2f(this.x + x, this.y + y);
    }

    public Vec2f subtract(Vec2f vec) {
        return this.subtract(vec.x, vec.y);
    }

    public Vec2f subtract(float x, float y) {
        return this.add(-x, -y);
    }

    public Vec2f multiply(Vec2f vec) {
        return this.multiply(vec.x, vec.y);
    }

    public Vec2f multiply(float xMag, float yMag) {
        return new Vec2f(this.x * xMag, this.y * yMag);
    }

    public Vec2f scale(float mag) {
        return this.multiply(mag, mag);
    }

    public float dot(Vec2f vec) {
        return this.x * vec.x + this.y * this.y;
    }

    public float cross(Vec2f vec) {
        return this.x * vec.y - this.y * vec.x;
    }

    public float lengthSqr() {
        return this.x * this.x + this.y * this.y;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSqr());
    }

    public Vec2f normalize() {
        float length = this.length();
        return length < 1.0E-4f ? ZERO : new Vec2f(this.x / length, this.y / length);
    }

    public Vec2f reverse() {
        return new Vec2f(-this.x, -this.y);
    }

    public float distSqr(Vec2f vec) {
        return this.distSqr(vec.x, vec.y);
    }

    public float distSqr(float x, float y) {
        float xDist = x - this.x;
        float yDist = y - this.y;
        return xDist * xDist + yDist * yDist;
    }

    public float dist(Vec2f vec) {
        return this.dist(vec.x, vec.y);
    }

    public float dist(float x, float y) {
        return (float)Math.sqrt(this.distSqr(x, y));
    }
}

