/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.data;

public record Vec3f(float x, float y, float z) {
    public static Vec3f ZERO = new Vec3f(0.0f, 0.0f, 0.0f);

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Vec3f) {
            Vec3f vec = (Vec3f)obj;
            return this.x == vec.x && this.y == vec.y && this.z == vec.z;
        }
        return false;
    }

    @Override
    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Vec3f add(Vec3f vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public Vec3f add(float x, float y, float z) {
        return new Vec3f(this.x + x, this.y + y, this.z + z);
    }

    public Vec3f subtract(Vec3f vec) {
        return this.subtract(vec.x, vec.y, vec.z);
    }

    public Vec3f subtract(float x, float y, float z) {
        return this.add(-x, -y, -z);
    }

    public Vec3f multiply(Vec3f vec) {
        return this.multiply(vec.x, vec.y, vec.z);
    }

    public Vec3f multiply(float xMag, float yMag, float zMag) {
        return new Vec3f(this.x * xMag, this.y * yMag, this.z * zMag);
    }

    public Vec3f cross(Vec3f vec) {
        float vX = vec.x();
        float vY = vec.y();
        float vZ = vec.z();
        return new Vec3f(this.y * vZ - this.z * vY, this.z * vX - this.x * vZ, this.x * vY - this.y * vX);
    }

    public Vec3f scale(float mag) {
        return this.multiply(mag, mag, mag);
    }

    public float lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSqr());
    }

    public Vec3f normalize() {
        float length = this.length();
        return length < 1.0E-4f ? ZERO : new Vec3f(this.x / length, this.y / length, this.z / length);
    }

    public float distSqr(Vec3f vec) {
        return this.distSqr(vec.x, vec.y, vec.z);
    }

    public float distSqr(float x, float y, float z) {
        float xDist = x - this.x;
        float yDist = y - this.y;
        float zDist = z - this.z;
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    public float dist(Vec3f vec) {
        return this.dist(vec.x, vec.y, vec.z);
    }

    public float dist(float x, float y, float z) {
        return (float)Math.sqrt(this.distSqr(x, y, z));
    }
}

