/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.math;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.HitData;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.entity.IOrientedHitBoxes;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Mat4f;
import frostnox.nightfall.util.math.OBB;
import frostnox.nightfall.util.math.Quat;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BoundingSphere {
    public double xPos;
    public double yPos;
    public double zPos;
    public double radius;

    public BoundingSphere(double radius) {
        this.radius = radius;
    }

    public BoundingSphere(double xPos, double yPos, double zPos, double radius) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.zPos = zPos;
        this.radius = radius;
    }

    public BoundingSphere(BoundingSphere sphere) {
        this.xPos = sphere.xPos;
        this.yPos = sphere.yPos;
        this.zPos = sphere.zPos;
        this.radius = sphere.radius;
    }

    public void translate(Vec3 vec) {
        this.translate(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public void translate(double x, double y, double z) {
        this.xPos += x;
        this.yPos += y;
        this.zPos += z;
    }

    public void scalePos(double x, double y, double z) {
        this.xPos *= x;
        this.yPos *= y;
        this.zPos *= z;
    }

    public void scale(double scalar) {
        this.xPos *= scalar;
        this.yPos *= scalar;
        this.zPos *= scalar;
        this.radius *= scalar;
    }

    public AABB toAABB() {
        return new AABB(this.xPos - this.radius, this.yPos - this.radius, this.zPos - this.radius, this.xPos + this.radius, this.yPos + this.radius, this.zPos + this.radius);
    }

    public void transform(Mat4f matrix) {
        Vec3 center = new Vec3(this.xPos, this.yPos, this.zPos);
        center = matrix.transformVector3d(center);
        this.xPos = center.f_82479_;
        this.yPos = center.f_82480_;
        this.zPos = center.f_82481_;
    }

    public Vec3 getXZRotation(Mat4f matrix, double yOff) {
        Vec3 center = new Vec3(this.xPos, yOff, this.zPos);
        Vec3 rotCenter = matrix.transformVector3d(center);
        return rotCenter.m_82546_(center);
    }

    public void rotateAtOffset(Mat4f matrix, double offX, double offY, double offZ) {
        this.xPos += offX;
        this.yPos += offY;
        this.zPos += offZ;
        this.transform(matrix);
        this.xPos -= offX;
        this.yPos -= offY;
        this.zPos -= offZ;
    }

    public void transformFP(AnimationData transforms, Mat4f userMatrix, Vector3f translation, Vector3f offset, boolean leftHand) {
        Vector3f center = new Vector3f((float)this.xPos, (float)this.yPos, (float)this.zPos);
        center.m_122253_(offset);
        Mat4f mat = new Mat4f();
        Vector3f rVec = transforms.rCalc.getTransformations();
        if (rVec.m_122269_() != 0.0f) {
            mat.multiply(new Quat(rVec.m_122269_(), Vector3f.f_122227_, true));
        }
        if (rVec.m_122260_() != 0.0f) {
            mat.multiply(new Quat(rVec.m_122260_(), Vector3f.f_122224_, true));
        }
        if (rVec.m_122239_() != 0.0f) {
            mat.multiply(new Quat(rVec.m_122239_(), Vector3f.f_122223_, true));
        }
        mat.transformVector3f(center);
        Vector3f tVec = transforms.tCalc.getTransformations();
        tVec.m_122263_(-1.0f, 1.0f, -1.0f);
        center.m_122253_(tVec);
        center.m_122253_(translation);
        if (leftHand) {
            center.setX(-center.m_122239_());
        }
        userMatrix.transformVector3f(center);
        this.xPos = center.m_122239_();
        this.yPos = center.m_122260_();
        this.zPos = center.m_122269_();
    }

    public void transform(AnimationData[] transforms, Mat4f userMatrix, Mat4f localMatrix, Vector3f translation, Vector3f offset) {
        Vector3f center = MathUtil.transformPoint(new Vector3f((float)this.xPos, (float)this.yPos, (float)this.zPos), transforms, userMatrix, localMatrix, translation, offset);
        this.xPos = center.m_122239_();
        this.yPos = center.m_122260_();
        this.zPos = center.m_122269_();
    }

    public void transform(AnimationData[] transforms, Mat4f userMatrix, Mat4f localMatrix) {
        this.transform(transforms, userMatrix, localMatrix, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public void transform(AnimationData[] transforms, Mat4f userMatrix, Vector3f translation, Vector3f offset) {
        this.transform(transforms, userMatrix, new Mat4f(), translation, offset);
    }

    public void transform(AnimationData[] transforms, Mat4f userMatrix, Vector3f offset) {
        this.transform(transforms, userMatrix, new Mat4f(), new Vector3f(0.0f, 0.0f, 0.0f), offset);
    }

    public void transform(AnimationData[] transforms, Mat4f userMatrix) {
        this.transform(transforms, userMatrix, new Mat4f(), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public boolean intersectsAABB(AABB box) {
        return MathUtil.getShortestDistanceSqrPointToBox(this.xPos, this.yPos, this.zPos, box) <= this.radius * this.radius;
    }

    public boolean intersectsAndSeesEntity(LivingEntity user, Entity entity, HitData hitData) {
        if (entity instanceof IOrientedHitBoxes) {
            IOrientedHitBoxes hitBoxesEntity = (IOrientedHitBoxes)entity;
            if (hitBoxesEntity.includeAABB() && this.intersectsAndSeesAABB(user, entity.m_142469_(), hitData)) {
                return true;
            }
            OBB[] obbs = hitBoxesEntity.getOBBs(1.0f);
            for (int i = 0; i < obbs.length; ++i) {
                if (!this.intersectsAndSeesOBB(user, obbs[i], entity.m_20182_(), hitData)) continue;
                hitData.boxIndex = i;
                return true;
            }
        } else {
            return this.intersectsAndSeesAABB(user, entity.m_142469_(), hitData);
        }
        return false;
    }

    public boolean intersectsAndSeesOBB(LivingEntity user, OBB box, Vec3 entityPos, HitData hitData) {
        box.rotate();
        Vec3 dir = new Vec3(this.xPos - entityPos.f_82479_, this.yPos - entityPos.f_82480_, this.zPos - entityPos.f_82481_).m_82492_((double)box.center.m_122239_(), (double)box.center.m_122260_(), (double)box.center.m_122269_()).m_82546_(box.translation);
        double rotCenterX = dir.m_82526_(box.localX);
        double rotCenterY = dir.m_82526_(box.localY);
        double rotCenterZ = dir.m_82526_(box.localZ);
        double xC = Mth.m_14008_((double)rotCenterX, (double)(-box.extents.f_82479_ + 1.0E-4), (double)(box.extents.f_82479_ - 1.0E-4));
        double yC = Mth.m_14008_((double)rotCenterY, (double)(-box.extents.f_82480_ + 1.0E-4), (double)(box.extents.f_82480_ - 1.0E-4));
        double zC = Mth.m_14008_((double)rotCenterZ, (double)(-box.extents.f_82481_ + 1.0E-4), (double)(box.extents.f_82481_ - 1.0E-4));
        double x = xC * box.localX.f_82479_ + yC * box.localY.f_82479_ + zC * box.localZ.f_82479_;
        double y = xC * box.localX.f_82480_ + yC * box.localY.f_82480_ + zC * box.localZ.f_82480_;
        double z = xC * box.localX.f_82481_ + yC * box.localY.f_82481_ + zC * box.localZ.f_82481_;
        Vec3 hitPos = entityPos.m_82520_((double)box.center.m_122239_(), (double)box.center.m_122260_(), (double)box.center.m_122269_()).m_82520_(x, y, z).m_82549_(box.translation);
        if (hitPos.m_82531_(this.xPos, this.yPos, this.zPos) <= this.radius * this.radius && user.f_19853_.m_45547_(new ClipContext(user.m_20299_(1.0f), hitPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)user)).m_6662_() == HitResult.Type.MISS) {
            hitData.x = (float)hitPos.f_82479_;
            hitData.y = (float)hitPos.f_82480_;
            hitData.z = (float)hitPos.f_82481_;
            return true;
        }
        return false;
    }

    public boolean intersectsAndSeesAABB(LivingEntity user, AABB box, HitData hitData) {
        double z;
        double zDist;
        double y;
        double yDist;
        double x = Mth.m_14008_((double)this.xPos, (double)(box.f_82288_ + 1.0E-4), (double)(box.f_82291_ - 1.0E-4));
        double xDist = this.xPos - x;
        if (xDist * xDist + (yDist = this.yPos - (y = Mth.m_14008_((double)this.yPos, (double)(box.f_82289_ + 1.0E-4), (double)(box.f_82292_ - 1.0E-4)))) * yDist + (zDist = this.zPos - (z = Mth.m_14008_((double)this.zPos, (double)(box.f_82290_ + 1.0E-4), (double)(box.f_82293_ - 1.0E-4)))) * zDist <= this.radius * this.radius && user.f_19853_.m_45547_(new ClipContext(user.m_20299_(1.0f), new Vec3(x, y, z), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)user)).m_6662_() == HitResult.Type.MISS) {
            hitData.x = (float)x;
            hitData.y = (float)y;
            hitData.z = (float)z;
            return true;
        }
        return false;
    }

    public boolean isSpaceObstructed(LivingEntity user, BlockPos climbPos) {
        VoxelShape shape = user.f_19853_.m_8055_(climbPos).m_60742_((BlockGetter)user.f_19853_, climbPos, CollisionContext.m_82750_((Entity)user));
        if (shape.m_83281_()) {
            return false;
        }
        BoundingSphere sphere = new BoundingSphere(this);
        sphere.radius /= 2.0;
        AABB box = sphere.toAABB();
        for (AABB climbBox : shape.m_83216_((double)climbPos.m_123341_(), (double)climbPos.m_123342_(), (double)climbPos.m_123343_()).m_83299_()) {
            if (!climbBox.m_82381_(box)) continue;
            return true;
        }
        return false;
    }

    public boolean isSpaceClimbable(LivingEntity user) {
        return this.isSpaceClimbable(user, new Vector3d(0.0, 0.0, 0.0));
    }

    public boolean isSpaceClimbable(LivingEntity user, Vector3d hitCoords) {
        AABB box = this.toAABB();
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        positions.add(new BlockPos(box.f_82291_, box.f_82292_, box.f_82293_));
        positions.add(new BlockPos(box.f_82291_, box.f_82292_, box.f_82290_));
        positions.add(new BlockPos(box.f_82288_, box.f_82292_, box.f_82293_));
        positions.add(new BlockPos(box.f_82288_, box.f_82292_, box.f_82290_));
        positions.add(new BlockPos(box.f_82291_, box.f_82289_, box.f_82293_));
        positions.add(new BlockPos(box.f_82291_, box.f_82289_, box.f_82290_));
        positions.add(new BlockPos(box.f_82288_, box.f_82289_, box.f_82293_));
        positions.add(new BlockPos(box.f_82288_, box.f_82289_, box.f_82290_));
        for (BlockPos pos : positions) {
            VoxelShape shape = LevelUtil.getBlockClimbingShape(user, pos);
            if (shape.m_83281_() || !this.intersectsAABB(shape.m_83215_())) continue;
            for (AABB shapeBox : shape.m_83299_()) {
                if (!this.isAABBClimbable(user, shapeBox, hitCoords)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAABBClimbable(LivingEntity user, AABB box) {
        return this.isAABBClimbable(user, box, new Vector3d(0.0, 0.0, 0.0));
    }

    public boolean isAABBClimbable(LivingEntity user, AABB box, Vector3d hitCoords) {
        double x = Mth.m_14008_((double)this.xPos, (double)(box.f_82288_ + 1.0E-5), (double)(box.f_82291_ - 1.0E-5));
        double y = box.f_82292_ + (box.f_82292_ % 1.0 == 0.0 ? 0.0 : 1.0E-5);
        double z = Mth.m_14008_((double)this.zPos, (double)(box.f_82290_ + 1.0E-5), (double)(box.f_82293_ - 1.0E-5));
        float lookAngle = CombatUtil.getRelativeHorizontalAngle(user.m_146892_(), new Vec3(x, y, z), user.m_6080_());
        if ((x - this.xPos) * (x - this.xPos) + (y - this.yPos) * (y - this.yPos) + (z - this.zPos) * (z - this.zPos) <= this.radius * this.radius && y > user.m_20186_() && lookAngle <= 25.0f && lookAngle >= -25.0f && user.f_19853_.m_45547_(new ClipContext(new Vec3(user.m_20185_(), y, user.m_20189_()), new Vec3(x, y, z), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)user)).m_6662_() != HitResult.Type.BLOCK) {
            hitCoords.m_176285_(x, y, z);
            if (x - (double)Mth.m_14107_((double)x) > z - (double)Mth.m_14107_((double)z)) {
                z = Mth.m_14008_((double)Math.round(z), (double)(box.f_82290_ + 1.0E-5), (double)(box.f_82293_ - 1.0E-5));
            } else {
                x = Mth.m_14008_((double)Math.round(x), (double)(box.f_82288_ + 1.0E-5), (double)(box.f_82291_ - 1.0E-5));
            }
            BlockPos posA = new BlockPos(x, y + 0.0625, z);
            BlockState stateA = user.f_19853_.m_8055_(posA);
            AABB boxA = AABB.m_165882_((Vec3)new Vec3(x, y + 0.0625, z), (double)1.0E-5, (double)1.0E-5, (double)1.0E-5);
            boolean emptyFlag = true;
            if (!stateA.m_60795_() && !stateA.m_60812_((BlockGetter)user.f_19853_, posA).m_83281_()) {
                boolean bl = emptyFlag = !Shapes.m_83157_((VoxelShape)stateA.m_60812_((BlockGetter)user.f_19853_, posA).m_83216_((double)posA.m_123341_(), (double)posA.m_123342_(), (double)posA.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)boxA), (BooleanOp)BooleanOp.f_82689_);
            }
            if (y + 0.0625 > user.m_20186_() + (double)user.m_20206_() && emptyFlag) {
                BlockPos posB = new BlockPos(user.m_20185_(), y + 0.0625, user.m_20189_());
                BlockState stateB = user.f_19853_.m_8055_(posB);
                AABB boxB = AABB.m_165882_((Vec3)new Vec3(user.m_20185_(), y + 0.0625, user.m_20189_()), (double)1.0E-5, (double)1.0E-5, (double)1.0E-5);
                if (!stateB.m_60795_() && !stateB.m_60812_((BlockGetter)user.f_19853_, posB).m_83281_() && Shapes.m_83157_((VoxelShape)stateB.m_60812_((BlockGetter)user.f_19853_, posB).m_83216_((double)posB.m_123341_(), (double)posB.m_123342_(), (double)posB.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)boxB), (BooleanOp)BooleanOp.f_82689_)) {
                    return false;
                }
            }
            if (emptyFlag && user instanceof Player) {
                Player player = (Player)user;
                IPlayerData capP = PlayerData.get(player);
                return capP.getClimbPosition().f_86215_ == -1.0 || Math.abs(capP.getClimbPosition().f_86215_ - hitCoords.f_86215_) < 0.5001 || LevelUtil.isPositionFullyClimbable(user, hitCoords) || LevelUtil.isPositionFullyClimbable(user, capP.getClimbPosition());
            }
            return emptyFlag;
        }
        return false;
    }
}

