/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.math;

import net.minecraft.util.Mth;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Easing {
    none{

        @Override
        public float apply(float p) {
            return p;
        }
    }
    ,
    inSine{

        @Override
        public float apply(float p) {
            return 1.0f - Mth.m_14089_((float)(p * (float)Math.PI / 2.0f));
        }
    }
    ,
    outSine{

        @Override
        public float apply(float p) {
            return Mth.m_14031_((float)(p * (float)Math.PI / 2.0f));
        }
    }
    ,
    inOutSine{

        @Override
        public float apply(float p) {
            return -(Mth.m_14089_((float)((float)Math.PI * p)) - 1.0f) / 2.0f;
        }
    }
    ,
    inQuart{

        @Override
        public float apply(float p) {
            return p * p * p * p;
        }
    }
    ,
    outQuart{

        @Override
        public float apply(float p) {
            return 1.0f - (float)Math.pow(1.0f - p, 4.0);
        }
    }
    ,
    inOutQuart{

        @Override
        public float apply(float p) {
            return p < 0.5f ? 8.0f * p * p * p * p : 1.0f - (float)Math.pow(-2.0f * p + 2.0f, 4.0) / 2.0f;
        }
    }
    ,
    inQuad{

        @Override
        public float apply(float p) {
            return p * p;
        }
    }
    ,
    outQuad{

        @Override
        public float apply(float p) {
            return 1.0f - (1.0f - p) * (1.0f - p);
        }
    }
    ,
    inOutQuad{

        @Override
        public float apply(float p) {
            return p < 0.5f ? 2.0f * p * p : 1.0f - (float)Math.pow(-2.0f * p + 2.0f, 2.0) / 2.0f;
        }
    }
    ,
    inCubic{

        @Override
        public float apply(float p) {
            return p * p * p;
        }
    }
    ,
    outCubic{

        @Override
        public float apply(float p) {
            return 1.0f - (float)Math.pow(1.0f - p, 3.0);
        }
    }
    ,
    inOutCubic{

        @Override
        public float apply(float p) {
            return p < 0.5f ? 4.0f * p * p * p : 1.0f - (float)Math.pow(-2.0f * p + 2.0f, 3.0) / 2.0f;
        }
    }
    ,
    inBack{

        @Override
        public float apply(float p) {
            return 2.70158f * p * p * p - 1.70158f * p * p;
        }
    }
    ,
    outBack{

        @Override
        public float apply(float p) {
            return 1.0f + 2.70158f * (float)Math.pow(p - 1.0f, 3.0) + 1.70158f * (float)Math.pow(p - 1.0f, 2.0);
        }
    }
    ,
    inOutBack{

        @Override
        public float apply(float p) {
            return p < 0.5f ? (float)Math.pow(2.0f * p, 2.0) * (7.189819f * p - 2.5949094f) / 2.0f : ((float)Math.pow(2.0f * p - 2.0f, 2.0) * (3.5949094f * (p * 2.0f - 2.0f) + 2.5949094f) + 2.0f) / 2.0f;
        }
    };

    private static final float a = 1.70158f;
    private static final float b = 2.70158f;
    private static final float c = 2.5949094f;

    public double apply(double p) {
        return this.apply((float)p);
    }

    public abstract float apply(float var1);
}

