/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.math;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Optional;
import net.minecraft.world.phys.Vec3;

public class OBB {
    public Vector3f center;
    public Vec3 extents;
    public Vec3 translation;
    public Quaternion rotation;
    public Vec3 localX;
    public Vec3 localY;
    public Vec3 localZ;
    private boolean rotated;

    public OBB(double xSize, double ySize, double zSize, double xCenter, double yCenter, double zCenter) {
        this(xSize, ySize, zSize, xCenter, yCenter, zCenter, new Quaternion(0.0f, 0.0f, 0.0f, 1.0f));
    }

    public OBB(double xSize, double ySize, double zSize, double xCenter, double yCenter, double zCenter, Quaternion rotation) {
        this(xSize, ySize, zSize, xCenter, yCenter, zCenter, 0.0, 0.0, 0.0, rotation);
    }

    public OBB(double xSize, double ySize, double zSize, double xCenter, double yCenter, double zCenter, double x, double y, double z) {
        this(xSize, ySize, zSize, xCenter, yCenter, zCenter, x, y, z, new Quaternion(0.0f, 0.0f, 0.0f, 1.0f));
    }

    public OBB(double xSize, double ySize, double zSize, double xCenter, double yCenter, double zCenter, double x, double y, double z, Quaternion rotation) {
        this.center = new Vector3f((float)xCenter, (float)yCenter, (float)zCenter);
        this.extents = new Vec3(xSize / 2.0, ySize / 2.0, zSize / 2.0);
        this.translation = new Vec3(x, y, z);
        this.rotation = rotation;
    }

    public void setRotation(Quaternion rotation) {
        this.rotation = rotation;
        this.rotated = false;
    }

    public void rotate() {
        if (!this.rotated) {
            this.center.m_122251_(this.rotation);
            float i = -this.rotation.m_80140_();
            float j = -this.rotation.m_80150_();
            float k = -this.rotation.m_80153_();
            float r = this.rotation.m_80156_();
            float iSqr2 = 2.0f * i * i;
            float jSqr2 = 2.0f * j * j;
            float kSqr2 = 2.0f * k * k;
            float ij = i * j;
            float jk = j * k;
            float ki = k * i;
            float ir = i * r;
            float jr = j * r;
            float kr = k * r;
            this.localX = new Vec3((double)(1.0f - jSqr2 - kSqr2), (double)(2.0f * (ij - kr)), (double)(2.0f * (ki + jr)));
            this.localY = new Vec3((double)(2.0f * (ij + kr)), (double)(1.0f - kSqr2 - iSqr2), (double)(2.0f * (jk - ir)));
            this.localZ = new Vec3((double)(2.0f * (ki - jr)), (double)(2.0f * (jk + ir)), (double)(1.0f - iSqr2 - jSqr2));
            this.rotated = true;
        }
    }

    public boolean contains(Vec3 point) {
        this.rotate();
        point = point.m_82546_(this.translation);
        double dist = point.m_82526_(this.localX);
        if (dist < -this.extents.f_82479_ || dist > this.extents.f_82479_) {
            return false;
        }
        dist = point.m_82526_(this.localY);
        if (dist < -this.extents.f_82480_ || dist > this.extents.f_82480_) {
            return false;
        }
        dist = point.m_82526_(this.localZ);
        return !(dist < -this.extents.f_82481_) && !(dist > this.extents.f_82481_);
    }

    public Optional<Vec3> rayCast(Vec3 start, Vec3 end) {
        this.rotate();
        Vec3 rayDir = end.m_82546_(start).m_82541_();
        double rayDirX = this.localX.m_82526_(rayDir);
        double rayDirY = this.localY.m_82526_(rayDir);
        double rayDirZ = this.localZ.m_82526_(rayDir);
        Vec3 boxDir = new Vec3((double)this.center.m_122239_() + this.translation.f_82479_ - start.f_82479_, (double)this.center.m_122260_() + this.translation.f_82480_ - start.f_82480_, (double)this.center.m_122269_() + this.translation.f_82481_ - start.f_82481_);
        double boxDirX = this.localX.m_82526_(boxDir);
        double boxDirY = this.localY.m_82526_(boxDir);
        double boxDirZ = this.localZ.m_82526_(boxDir);
        if (rayDirX == 0.0) {
            if (-boxDirX - this.extents.f_82479_ > 0.0 || -boxDirX + this.extents.f_82479_ < 0.0) {
                return Optional.empty();
            }
            rayDirX = 1.0E-5;
        } else if (rayDirY == 0.0) {
            if (-boxDirY - this.extents.f_82480_ > 0.0 || -boxDirY + this.extents.f_82480_ < 0.0) {
                return Optional.empty();
            }
            rayDirY = 1.0E-5;
        } else if (rayDirZ == 0.0) {
            if (-boxDirZ - this.extents.f_82481_ > 0.0 || -boxDirZ + this.extents.f_82481_ < 0.0) {
                return Optional.empty();
            }
            rayDirZ = 1.0E-5;
        }
        double t1 = (boxDirX + this.extents.f_82479_) / rayDirX;
        double t2 = (boxDirX - this.extents.f_82479_) / rayDirX;
        double t3 = (boxDirY + this.extents.f_82480_) / rayDirY;
        double t4 = (boxDirY - this.extents.f_82480_) / rayDirY;
        double t5 = (boxDirZ + this.extents.f_82481_) / rayDirZ;
        double t6 = (boxDirZ - this.extents.f_82481_) / rayDirZ;
        double tMax = Math.min(Math.min(Math.max(t1, t2), Math.max(t3, t4)), Math.max(t5, t6));
        if (tMax < 0.0) {
            return Optional.empty();
        }
        double tMin = Math.max(Math.max(Math.min(t1, t2), Math.min(t3, t4)), Math.min(t5, t6));
        if (tMin > tMax) {
            return Optional.empty();
        }
        double t = tMin < 0.0 ? tMax : tMin;
        return Optional.of(start.m_82549_(rayDir.m_82490_(t)));
    }
}

